/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.common;

import com.ibm.ws.dcs.common.DCSTraceable;
import com.ibm.ws.dcs.common.exception.DCSInvalidOptionException;
import com.ibm.ws.dcs.common.exception.DCSUnsupportedQoSException;

public class QoS
implements DCSTraceable {
    private GuaranteeType gt;
    private OrderType ot;
    private RealSyncType at;
    private SecurityType st;
    private ChannelType ct;
    private SelfDeliveryType sdt;
    private int cast;
    private static final int CASTTYPE = 0;
    private static final int GUARANTEETYPE = 1;
    private static final int ORDERTYPE = 2;
    private static final int SYNCTYPE = 3;
    private static final int SECURITYTYPE = 4;
    private static final int CHANNELTYPE = 5;
    private static final int SELFDELIVERYTYPE = 6;
    private static final int NUM_OF_TYPES = 7;
    private static int[] maxOfType = new int[]{2, 6, 4, 5, 2, 3, 2};
    private static final int UNICAST = 0;
    private static final int MULTICAST = 1;
    public static final OrderType UNORDERED = new OrderType(0);
    public static final OrderType FIFO = new OrderType(1);
    public static final OrderType CAUSALORDER = new OrderType(2);
    public static final OrderType TOTALORDER = new OrderType(3);
    public static final GuaranteeType UNRELIABLE = new GuaranteeType(0);
    public static final GuaranteeType RELIABLE = new GuaranteeType(1);
    public static final GuaranteeType VS_ANY = new GuaranteeType(2);
    public static final GuaranteeType VS_CURRENT = new GuaranteeType(3);
    public static final GuaranteeType REAL_SYNC = new GuaranteeType(4);
    public static final GuaranteeType AGREED = new GuaranteeType(5);
    public static final RealSyncType NO_REAL_SYNC = new RealSyncType(0);
    public static final RealSyncType LOCAL = new RealSyncType(1);
    public static final RealSyncType ONE_REMOTE = new RealSyncType(2);
    public static final RealSyncType PRIMARY_PARTITION = new RealSyncType(3);
    public static final RealSyncType ALL_CURRENT = new RealSyncType(4);
    public static final SecurityType UNSECURE = new SecurityType(0);
    public static final SecurityType SECURE = new SecurityType(1);
    public static final ChannelType UNSPECIFIED = new ChannelType(0);
    public static final ChannelType CONNECTED = new ChannelType(1);
    public static final ChannelType VIEW = new ChannelType(2);
    public static final SelfDeliveryType WITH_SELF_DELIVERY = new SelfDeliveryType(0);
    public static final SelfDeliveryType WITHOUT_SELF_DELIVERY = new SelfDeliveryType(1);
    private static final QOSUnicast UFIFO = new QOSUnicast(RELIABLE, FIFO);
    private static final QOSUnicast UVSCFIFO = new QOSUnicast(VS_CURRENT, FIFO);
    private static final QOSMulticast MVSAFIFO = new QOSMulticast(VS_ANY, FIFO);
    private static final QOSMulticast MVSCFIFO = new QOSMulticast(VS_CURRENT, FIFO);
    private static final QOSMulticast MFIFO = new QOSMulticast(RELIABLE, FIFO);
    private static final QOSMulticast MFIFONSD = new QOSMulticast(RELIABLE, FIFO, WITHOUT_SELF_DELIVERY);
    private static QoS[][][][][][][] QoSTable = new QoS[maxOfType[0]][maxOfType[1]][maxOfType[2]][maxOfType[3]][maxOfType[4]][maxOfType[5]][maxOfType[6]];

    private QoS(int n, GuaranteeType guaranteeType, OrderType orderType, RealSyncType realSyncType) {
        this(n, guaranteeType, orderType);
        this.at = realSyncType;
    }

    private QoS(int n, GuaranteeType guaranteeType, OrderType orderType, ChannelType channelType) {
        this(n, guaranteeType, orderType);
        this.ct = channelType;
    }

    private QoS(int n, GuaranteeType guaranteeType, OrderType orderType) {
        this.cast = n;
        this.ot = orderType;
        this.gt = guaranteeType;
        this.at = NO_REAL_SYNC;
        this.st = UNSECURE;
        this.ct = VIEW;
        this.sdt = WITH_SELF_DELIVERY;
    }

    private QoS(int n, GuaranteeType guaranteeType, OrderType orderType, SelfDeliveryType selfDeliveryType) {
        this(n, guaranteeType, orderType);
        this.sdt = selfDeliveryType;
    }

    public GuaranteeType getGuaranteeType() {
        return this.gt;
    }

    public OrderType getOrderType() {
        return this.ot;
    }

    public RealSyncType getSyncType() {
        return this.at;
    }

    public SecurityType getSecurityType() {
        return this.st;
    }

    public ChannelType getChannelType() {
        return this.ct;
    }

    public SelfDeliveryType getSelfDeliveryType() {
        return this.sdt;
    }

    private static final QoS getQoSFromTable(int[] nArray) {
        return QoSTable[nArray[0]][nArray[1]][nArray[2]][nArray[3]][nArray[4]][nArray[5]][nArray[6]];
    }

    private static final int[] getQoSIndicies(QoS qoS) {
        int[] nArray = new int[]{qoS instanceof QOSUnicast ? 0 : 1, qoS.getGuaranteeType().getValue(), qoS.getOrderType().getValue(), qoS.getSyncType().getValue(), qoS.getSecurityType().getValue(), qoS.getChannelType().getValue(), qoS.getSelfDeliveryType().getValue()};
        return nArray;
    }

    public static final QOSMulticast getMulticastQoS(GuaranteeType guaranteeType, OrderType orderType) throws DCSUnsupportedQoSException {
        int[] nArray = new int[]{1, guaranteeType.getValue(), orderType.getValue(), NO_REAL_SYNC.getValue(), UNSECURE.getValue(), VIEW.getValue(), WITH_SELF_DELIVERY.getValue()};
        QoS qoS = QoS.getQoSFromTable(nArray);
        if (qoS == null) {
            throw new DCSUnsupportedQoSException("QoS unsupported: 1 " + guaranteeType.getValue() + " " + orderType.getValue() + " " + NO_REAL_SYNC.getValue() + " " + UNSECURE.getValue() + " " + VIEW.getValue() + " " + WITH_SELF_DELIVERY.getValue());
        }
        return (QOSMulticast)qoS;
    }

    public static final QOSMulticast getMulticastQoS(GuaranteeType guaranteeType, OrderType orderType, SelfDeliveryType selfDeliveryType) throws DCSUnsupportedQoSException {
        int[] nArray = new int[]{1, guaranteeType.getValue(), orderType.getValue(), NO_REAL_SYNC.getValue(), UNSECURE.getValue(), VIEW.getValue(), selfDeliveryType.getValue()};
        QoS qoS = QoS.getQoSFromTable(nArray);
        if (qoS == null) {
            throw new DCSUnsupportedQoSException("QoS unsupported: 1 " + guaranteeType.getValue() + " " + orderType.getValue() + " " + NO_REAL_SYNC.getValue() + " " + UNSECURE.getValue() + " " + VIEW.getValue() + " " + selfDeliveryType.getValue());
        }
        return (QOSMulticast)qoS;
    }

    public static final QOSUnicast getUnicastQoS(GuaranteeType guaranteeType, OrderType orderType) throws DCSUnsupportedQoSException {
        int[] nArray = new int[]{0, guaranteeType.getValue(), orderType.getValue(), NO_REAL_SYNC.getValue(), UNSECURE.getValue(), VIEW.getValue(), WITH_SELF_DELIVERY.getValue()};
        QoS qoS = QoS.getQoSFromTable(nArray);
        if (qoS == null) {
            throw new DCSUnsupportedQoSException("QoS unsupported: 0 " + guaranteeType.getValue() + " " + orderType.getValue() + " " + NO_REAL_SYNC.getValue() + " " + UNSECURE.getValue() + " " + VIEW.getValue() + " " + WITH_SELF_DELIVERY.getValue());
        }
        return (QOSUnicast)qoS;
    }

    public QoS updateType(QoSPropertyType qoSPropertyType) throws DCSUnsupportedQoSException {
        int[] nArray = QoS.getQoSIndicies(this);
        nArray[qoSPropertyType.getPropertyType()] = qoSPropertyType.getValue();
        QoS qoS = QoS.getQoSFromTable(nArray);
        if (qoS == null) {
            throw new DCSUnsupportedQoSException("QoS unsupported: 0 " + this.gt.getValue() + " " + this.ot.getValue() + " " + NO_REAL_SYNC.getValue() + " " + UNSECURE.getValue() + " " + VIEW.getValue() + " " + this.sdt.getValue());
        }
        return qoS;
    }

    private static void setQoSTable(QoS qoS) {
        int[] nArray = QoS.getQoSIndicies(qoS);
        QoS.QoSTable[nArray[0]][nArray[1]][nArray[2]][nArray[3]][nArray[4]][nArray[5]][nArray[6]] = qoS;
    }

    public final boolean isVS() {
        return this.gt == VS_ANY || this.gt == VS_CURRENT;
    }

    public final boolean isSelfDelivered() {
        return this.sdt == WITH_SELF_DELIVERY;
    }

    public String toString() {
        String string = "Unknown";
        if (this.cast == 0) {
            string = "UNICAST";
        }
        if (this.cast == 1) {
            string = "MULTICAST";
        }
        String string2 = "QoS_" + string + " " + this.gt.toString() + " " + this.ot.toString() + " " + this.st.toString() + " " + this.at.toString() + " " + this.ct.toString() + " " + this.sdt.getValue();
        return string2;
    }

    public String getTraceName() {
        return "QoS";
    }

    static {
        QoS.setQoSTable(UFIFO);
        QoS.setQoSTable(UVSCFIFO);
        QoS.setQoSTable(MVSAFIFO);
        QoS.setQoSTable(MVSCFIFO);
        QoS.setQoSTable(MFIFO);
        QoS.setQoSTable(MFIFONSD);
        QoS.setQoSTable(new QOSMulticast(RELIABLE, FIFO, CONNECTED));
    }

    public static final class QOSMulticast
    extends QoS {
        QOSMulticast(GuaranteeType guaranteeType, OrderType orderType, RealSyncType realSyncType) throws DCSInvalidOptionException {
            super(1, guaranteeType, orderType, realSyncType);
        }

        QOSMulticast(GuaranteeType guaranteeType, OrderType orderType, ChannelType channelType) {
            super(1, guaranteeType, orderType, channelType);
        }

        QOSMulticast(GuaranteeType guaranteeType, OrderType orderType, SelfDeliveryType selfDeliveryType) {
            super(1, guaranteeType, orderType, selfDeliveryType);
        }

        private QOSMulticast(GuaranteeType guaranteeType, OrderType orderType) {
            super(1, guaranteeType, orderType);
        }
    }

    public static final class QOSUnicast
    extends QoS {
        QOSUnicast(GuaranteeType guaranteeType, OrderType orderType, RealSyncType realSyncType) throws DCSInvalidOptionException {
            super(0, guaranteeType, orderType, realSyncType);
            if (orderType != UNORDERED || orderType != FIFO) {
                throw new DCSInvalidOptionException("Invalid Order option for Unicast");
            }
            if (realSyncType != NO_REAL_SYNC || realSyncType != ONE_REMOTE) {
                throw new DCSInvalidOptionException("Invalid ACK option for Unicast");
            }
            if (guaranteeType != UNRELIABLE || guaranteeType != RELIABLE || guaranteeType != VS_ANY) {
                throw new DCSInvalidOptionException("Invalid Delivery Guarantee option for Unicast");
            }
        }

        QOSUnicast(GuaranteeType guaranteeType, OrderType orderType, ChannelType channelType) {
            super(0, guaranteeType, orderType, channelType);
        }

        private QOSUnicast(GuaranteeType guaranteeType, OrderType orderType) {
            super(0, guaranteeType, orderType);
        }
    }

    public static final class SecurityType
    extends QoSPropertyType {
        SecurityType(int n) {
            super(n, 4);
        }
    }

    public static final class SelfDeliveryType
    extends QoSPropertyType {
        SelfDeliveryType(int n) {
            super(n, 6);
        }
    }

    public static final class ChannelType
    extends QoSPropertyType {
        ChannelType(int n) {
            super(n, 5);
        }

        public String getValueName() {
            switch (this.value) {
                case 1: {
                    return "CONNECTED";
                }
                case 2: {
                    return "VIEW";
                }
            }
            return super.getValueName();
        }
    }

    public static final class RealSyncType
    extends QoSPropertyType {
        RealSyncType(int n) {
            super(n, 3);
        }
    }

    public static final class GuaranteeType
    extends QoSPropertyType {
        GuaranteeType(int n) {
            super(n, 1);
        }

        public String getValueName() {
            switch (this.value) {
                case 0: {
                    return "UNRELIABLE";
                }
                case 1: {
                    return "RELIABLE";
                }
                case 2: {
                    return "VS_ANY";
                }
                case 3: {
                    return "VS_CURRENT";
                }
                case 4: {
                    return "REAL_SYNC";
                }
                case 5: {
                    return "AGREED";
                }
            }
            return super.getValueName();
        }
    }

    public static final class OrderType
    extends QoSPropertyType {
        OrderType(int n) {
            super(n, 2);
        }

        public String getValueName() {
            switch (this.value) {
                case 0: {
                    return "UNORDERED";
                }
                case 1: {
                    return "FIFO";
                }
                case 2: {
                    return "CAUSAL";
                }
                case 3: {
                    return "TOTAL";
                }
            }
            return super.getValueName();
        }
    }

    public static class QoSPropertyType
    implements Comparable {
        protected int value = -1;
        protected int propertyType = -1;

        int getValue() {
            return this.value;
        }

        protected int getPropertyType() {
            return this.propertyType;
        }

        protected int getMaxIndex() {
            return maxOfType[this.propertyType] - 1;
        }

        private QoSPropertyType(int n, int n2) {
            this.value = n;
            this.propertyType = n2;
        }

        public int compareTo(Object object) {
            if (object instanceof QoSPropertyType) {
                QoSPropertyType qoSPropertyType = (QoSPropertyType)object;
                if (this.value < qoSPropertyType.value) {
                    return -1;
                }
                if (this.value > qoSPropertyType.value) {
                    return 1;
                }
                return 0;
            }
            throw new ClassCastException();
        }

        public String toString() {
            return this.getClass().getName() + ": " + this.getValueName();
        }

        public String getValueName() {
            return "value = " + String.valueOf(this.value);
        }
    }
}

