/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.common.config;

import com.ibm.ws.dcs.common.config.DCSConfigNullPointerException;
import com.ibm.ws.dcs.common.config.DCSMandatoryParamsNotSpecifiedException;
import com.ibm.ws.dcs.common.config.DCSWrongConfigParamValueException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public abstract class DCSConfigMap
implements Map {
    private HashMap _config = new HashMap();
    protected final Map _minMaxParams;
    protected final Map _enumParams;
    protected final Map _mandatoryParams = new HashMap();
    protected final Map _defaultParams = new HashMap();
    protected final Map _requiredClassForParams;
    public static final String TR_CONFIG_LAYER_NAME = "CONFIG";

    public DCSConfigMap(Map map, boolean bl) {
        this();
        Set set;
        this.putAll(map);
        if (bl && !(set = this.getUnspecifiedMandatoryParams()).isEmpty()) {
            throw new DCSMandatoryParamsNotSpecifiedException("Configuration parameters of " + this.getClass() + " did not include the following mandatory parameters - " + set);
        }
    }

    public DCSConfigMap(Map map) {
        this(map, false);
    }

    public DCSConfigMap() {
        this._minMaxParams = new HashMap();
        this._enumParams = new HashMap();
        this._requiredClassForParams = new HashMap();
        this.initParams();
    }

    protected abstract void initParams();

    public int size() {
        return this._config.size();
    }

    public boolean isEmpty() {
        return this._config.isEmpty();
    }

    public boolean containsKey(Object object) {
        return this._config.containsKey(object);
    }

    public boolean containsValue(Object object) {
        return this._config.containsValue(object);
    }

    public Object get(Object object) {
        return this._config.get(object);
    }

    public Object put(Object object, Object object2) {
        if (object == null) {
            throw new DCSConfigNullPointerException("Param is null");
        }
        Class<?> clazz = null;
        if (this._mandatoryParams.containsKey(object)) {
            clazz = (Class<?>)this._mandatoryParams.get(object);
        } else if (this._requiredClassForParams.containsKey(object)) {
            clazz = (Class)this._requiredClassForParams.get(object);
        } else if (this._defaultParams.containsKey(object)) {
            clazz = this._defaultParams.get(object).getClass();
        } else {
            this.warn();
            return this._config.put(object, object2);
        }
        if (object2 == null) {
            throw new DCSConfigNullPointerException("Value for param " + object + " is null");
        }
        if (!clazz.isInstance(object2)) {
            throw new DCSWrongConfigParamValueException("Parameter " + object + " value is of type " + object2.getClass() + ", whereas the required type of the value is " + clazz);
        }
        this.doEnumTest(object, object2);
        this.doMinMaxTest(object, object2);
        this.doTailoredTest(object, object2);
        return this._config.put(object, object2);
    }

    private void warn() {
    }

    private void doMinMaxTest(Object object, Object object2) {
        if (this._minMaxParams.containsKey(object)) {
            int n = (Integer)object2;
            Integer[] integerArray = (Integer[])this._minMaxParams.get(object);
            Integer n2 = integerArray[0];
            Integer n3 = integerArray[1];
            if (n2 != null && n < n2) {
                throw new DCSWrongConfigParamValueException("The value of parameter " + object + " is " + object2 + ", whereas the minimum of this parameter is " + n2);
            }
            if (n3 != null && n > n3) {
                throw new DCSWrongConfigParamValueException("The value of parameter " + object + " is " + object2 + ", whereas the maximum of this parameter is " + n3);
            }
        }
    }

    private void doEnumTest(Object object, Object object2) {
        Object[] objectArray = null;
        if (this._enumParams.containsKey(object)) {
            objectArray = (Object[])this._enumParams.get(object);
            for (int i = 0; i < objectArray.length; ++i) {
                Object object3 = objectArray[i];
                if (!object3.equals(object2)) continue;
                return;
            }
            throw new DCSWrongConfigParamValueException("The value of " + object + " should be one of the following - " + DCSConfigMap.toString(objectArray));
        }
    }

    protected abstract void doTailoredTest(Object var1, Object var2);

    public Object remove(Object object) {
        return this._config.remove(object);
    }

    public void putAll(Map map) {
        if (map != null) {
            Iterator iterator = map.keySet().iterator();
            while (iterator.hasNext()) {
                Object k = iterator.next();
                this.put(k, map.get(k));
            }
        }
    }

    public void clear() {
        this._config.clear();
    }

    public Set keySet() {
        return this._config.keySet();
    }

    public Collection values() {
        return this._config.values();
    }

    public Set entrySet() {
        return this._config.entrySet();
    }

    public Set getUnspecifiedMandatoryParams() {
        HashSet hashSet = new HashSet(this._mandatoryParams.keySet());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (!this._config.containsKey(k)) continue;
            iterator.remove();
        }
        return hashSet;
    }

    public String toString() {
        return this._config.toString();
    }

    public Map setOptionalParams() {
        HashMap hashMap = new HashMap(this._config);
        this.preManualSetOptionalParams(hashMap);
        this.autoSetOptionalParams(hashMap);
        this.postManualSetOptionalParams(hashMap);
        return hashMap;
    }

    private void autoSetOptionalParams(Map map) {
        Iterator iterator = this._defaultParams.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (map.containsKey(k)) continue;
            map.put(k, this._defaultParams.get(k));
        }
    }

    protected abstract void preManualSetOptionalParams(Map var1);

    protected abstract void postManualSetOptionalParams(Map var1);

    public static String toString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(objectArray[i]);
            stringBuffer.append(' ');
        }
        if (objectArray.length > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public String getLayerName() {
        return TR_CONFIG_LAYER_NAME;
    }

    public String getMemberName() {
        return null;
    }

    public String getStackName() {
        return null;
    }

    public Map get_defaultParams() {
        return this._defaultParams;
    }

    public Map get_enumParams() {
        return this._enumParams;
    }

    public Map get_mandatoryParams() {
        return this._mandatoryParams;
    }

    public Map get_minMaxParams() {
        return this._minMaxParams;
    }
}

