/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.common.config;

import com.ibm.ws.dcs.common.AddressResolver;
import com.ibm.ws.dcs.common.StateBlob;
import com.ibm.ws.dcs.common.config.DCSStackConfigMap;
import com.ibm.ws.dcs.common.config.DCSWrongConfigParamValueException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DCSCoreStackConfigMap
extends DCSStackConfigMap {
    public static final String THIS_MEMBER_NAME = "ThisMemberName";
    public static final String DEFINED_SET = "DefinedSet";
    public static final String TRANSPORT_TYPE = "TransportType";
    public static final String TRANSPORT_CONFIGURATION = "TransportConfiguration";
    public static final String DCS_THREADS_NUM = "DcsThreadsNum";
    public static final Integer UNLIMITED_THREADS_NUM = new Integer(-1);
    public static final String INET_ADDRESS_KEY = "IpAddress";
    public static final String PORT_KEY = "Port";
    public static final String DISCOVERY_PASSIVE_KEY = "DiscoveryPassive";
    public static final String ADDRESS_RESOLVER = "AddressResolver";
    public static final String STATEBLOB_INITIAL_CONFIGURATION = "StateBlobInitialConfiguration";
    public static final String MEMBER_STARTUP_TIMEOUT_SEC = "MEMBER_STARTUP_TIMEOUT";

    public DCSCoreStackConfigMap(Map map) {
        super(map);
    }

    public DCSCoreStackConfigMap() {
    }

    protected void doTailoredTest(Object object, Object object2) {
        super.doTailoredTest(object, object2);
        if (object.equals(DEFINED_SET)) {
            this.checkDefinedSet(object2);
        }
    }

    private void checkDefinedSet(Object object) {
        Map map = (Map)object;
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            if (k instanceof String) continue;
            throw new DCSWrongConfigParamValueException("In the defined set Map, a member name " + k + ", is of type " + k.getClass() + ", when it suppose to be String");
        }
    }

    protected void initParams() {
        super.initParams();
        this._mandatoryParams.put(THIS_MEMBER_NAME, String.class);
        this._mandatoryParams.put(DEFINED_SET, Map.class);
        this._defaultParams.put(TRANSPORT_TYPE, "RealMulticast");
        this._enumParams.put(TRANSPORT_TYPE, new Object[]{"RealMulticast", "MulticastByUnicast", "ChannelFramework"});
        this._defaultParams.put(TRANSPORT_CONFIGURATION, new HashMap());
        this._defaultParams.put(DCS_THREADS_NUM, UNLIMITED_THREADS_NUM);
        this._mandatoryParams.put(ADDRESS_RESOLVER, AddressResolver.class);
        this._defaultParams.put("CheckConfiguration", true);
        this._requiredClassForParams.put(STATEBLOB_INITIAL_CONFIGURATION, StateBlob.class);
        this._defaultParams.put(STATEBLOB_INITIAL_CONFIGURATION, null);
        this._defaultParams.put(MEMBER_STARTUP_TIMEOUT_SEC, new Integer(120));
    }

    protected void postManualSetOptionalParams(Map map) {
        super.postManualSetOptionalParams(map);
    }
}

