/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.common.config;

import com.ibm.ws.dcs.common.config.DCSConfigMap;
import com.ibm.ws.dcs.common.config.DCSFDConfigMap;
import com.ibm.ws.dcs.common.config.DCSStackConstructionConfigMap;
import java.util.HashMap;
import java.util.Map;

public abstract class DCSStackConfigMap
extends DCSConfigMap {
    public static final String DCS_CONFIGURATION_VERSION = "DCSConfigurationVersion";
    public static final String ENABLE_VERIFICATION_MODE = "enableVerificationMode";
    public static final String USE_VIRTUAL_SYNCHRONY_MESSAGING = "useVirtualSynchronyMessaging";
    public static final String STACK_CONSTRUCTION = "StackConstruction";
    public static final String USE_BUFFER_POOL = "UseBufferPool";
    public static final String EXPECTED_MESSAGE_PAYLOAD_SIZE_BYTES = "ExpectedMessagePayloadSizeBytes";
    public static final String FAILURE_DETECTOR_TYPE = "FailureDetectorType";
    public static final String FAILURE_DETECTOR_PARAMETERS = "FailureDetectorParameters";
    public static final String MAX_STACK_MEMORY_MB = "MaxStackMemoryMB";
    public static final String MESSAGING_DIRECTION = "MessagingDirection";
    public static final String EXPECTED_BRINGUP_TIME_SEC = "ExpectedBringupTimeSec";
    public static final String COMPLETENESS_VS_SPEED = "CompletenessVsSpeed";
    public static final String HBT_TRANSMISSION_INTERVAL_MSEC = "HBTTransmissionIntervalMilliSec";
    public static final String HBT_TIMEOUT_PERIOD = "HBTTimeoutPeriod";
    public static final String DCS_PROTOCOL_VERSION = "DCSProtocolVersion";
    public static final String CHECK_CONFIGURATION = "CheckConfiguration";
    public static final String VS_LEADER_POLICY = "VSLeaderPolicy";
    public static final String DCS_INTERNAL_PMI = "DCSInternalPMI";

    public DCSStackConfigMap(Map map) {
        super(map);
    }

    public DCSStackConfigMap() {
    }

    protected void preManualSetOptionalParams(Map map) {
        this.tailorLivenessParamsAndDependencies(map);
    }

    protected void postManualSetOptionalParams(Map map) {
        this.tailorStackConstructionMap(map);
    }

    private void tailorStackConstructionMap(Map map) {
        DCSStackConstructionConfigMap dCSStackConstructionConfigMap = new DCSStackConstructionConfigMap((Map)map.get(STACK_CONSTRUCTION));
        map.put(STACK_CONSTRUCTION, dCSStackConstructionConfigMap.setOptionalParams());
    }

    private void tailorLivenessParamsAndDependencies(Map map) {
        DCSFDConfigMap dCSFDConfigMap = new DCSFDConfigMap((Map)map.get(FAILURE_DETECTOR_PARAMETERS));
        map.put(FAILURE_DETECTOR_PARAMETERS, dCSFDConfigMap.setOptionalParams());
    }

    protected void initParams() {
        this._defaultParams.put(CHECK_CONFIGURATION, true);
        this._defaultParams.put(DCS_CONFIGURATION_VERSION, "1.0");
        this._defaultParams.put(VS_LEADER_POLICY, "FIRST");
        this._defaultParams.put(DCS_PROTOCOL_VERSION, new Integer(51001));
        this._defaultParams.put(DCS_INTERNAL_PMI, false);
        this._enumParams.put(DCS_CONFIGURATION_VERSION, new Object[]{"1.0"});
        this._enumParams.put(DCS_PROTOCOL_VERSION, new Object[]{new Integer(51001), new Integer(61002)});
        this._enumParams.put(VS_LEADER_POLICY, new Object[]{"FIRST", "LAST"});
        HashMap<String, Boolean> hashMap = new HashMap<String, Boolean>();
        hashMap.put(ENABLE_VERIFICATION_MODE, false);
        hashMap.put(USE_VIRTUAL_SYNCHRONY_MESSAGING, true);
        this._defaultParams.put(STACK_CONSTRUCTION, hashMap);
        this._defaultParams.put(USE_BUFFER_POOL, false);
        this._defaultParams.put(EXPECTED_MESSAGE_PAYLOAD_SIZE_BYTES, new Integer(1024));
        this._defaultParams.put(FAILURE_DETECTOR_TYPE, "BasicHBT");
        this._enumParams.put(FAILURE_DETECTOR_TYPE, new Object[]{"BasicHBT"});
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        hashMap2.put(HBT_TRANSMISSION_INTERVAL_MSEC, new Integer(1000));
        hashMap2.put(HBT_TIMEOUT_PERIOD, new Integer(15));
        this._defaultParams.put(FAILURE_DETECTOR_PARAMETERS, hashMap2);
        this._defaultParams.put(MAX_STACK_MEMORY_MB, new Integer(50));
        int n = (int)(Runtime.getRuntime().maxMemory() / 0x100000L);
        this._minMaxParams.put(MAX_STACK_MEMORY_MB, new Integer[]{new Integer(1), new Integer(n)});
        this._defaultParams.put(MESSAGING_DIRECTION, "Both");
        this._enumParams.put(MESSAGING_DIRECTION, new Object[]{"Out", "In", "Both"});
        this._defaultParams.put(EXPECTED_BRINGUP_TIME_SEC, new Integer(6));
        this._defaultParams.put(COMPLETENESS_VS_SPEED, new Integer(4));
        this._minMaxParams.put(COMPLETENESS_VS_SPEED, new Integer[]{new Integer(1), new Integer(5)});
    }

    protected void doTailoredTest(Object object, Object object2) {
    }
}

