/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.common.config.rmm;

import com.ibm.ws.dcs.common.config.DCSConfigMap;
import com.ibm.ws.dcs.common.config.DCSIllegalConfigurationException;
import java.util.Map;
import java.util.Properties;

public abstract class RMMConfigMap
extends DCSConfigMap {
    public static final String NOMINAL_INSTANCE_MEMORY_MBYTES = "NominalInstanceMemoryMbytes";
    public static final String MAX_INSTANCE_MEMORY_MBYTES = "MaxInstanceMemoryMbytes";
    public static final String TRANSPORT_DIRECTION = "TransportDirection";
    public static final String MESSAGE_ANNOUNCER_THREADS_NUM = "MessageAnnouncerThreadsNumber";
    public static final Integer UNLIMITED_THREADS_NUM = new Integer(-1);
    public static final Integer UNLIMITED_MAX_MEMORY = new Integer(0);
    public static final String REAL_MULTICAST = "RealMulticast";
    public static final String MULTICAST_BY_UNICAST = "MulticastByUnicast";
    public static final String CHANNEL_FRAMEWORK = "ChannelFramework";
    public static final String SOCKET_BUFFER_SIZE = "SocketBufferSize";
    public static final Integer NONE = new Integer(0);
    public static final Integer SMALL = new Integer(1);
    public static final Integer MEDIUM = new Integer(2);
    public static final Integer LARGE = new Integer(3);

    public RMMConfigMap(Map map) {
        super(map, true);
    }

    public RMMConfigMap() {
    }

    protected void initParams() {
        this._defaultParams.put(NOMINAL_INSTANCE_MEMORY_MBYTES, new Integer(50));
        int n = (int)(Runtime.getRuntime().maxMemory() / 0x100000L);
        this._minMaxParams.put(NOMINAL_INSTANCE_MEMORY_MBYTES, new Integer[]{new Integer(10), new Integer(n)});
        this._defaultParams.put(MAX_INSTANCE_MEMORY_MBYTES, UNLIMITED_MAX_MEMORY);
        this._defaultParams.put(TRANSPORT_DIRECTION, "Both");
        this._enumParams.put(TRANSPORT_DIRECTION, new Object[]{"Out", "In", "Both"});
        this._defaultParams.put(MESSAGE_ANNOUNCER_THREADS_NUM, UNLIMITED_THREADS_NUM);
        this._defaultParams.put(SOCKET_BUFFER_SIZE, MEDIUM);
        this._minMaxParams.put(SOCKET_BUFFER_SIZE, new Integer[]{NONE, LARGE});
    }

    public void addConfigToProp(Properties properties) {
        Map map = this.setOptionalParams();
        properties.setProperty(NOMINAL_INSTANCE_MEMORY_MBYTES, ((Integer)map.get(NOMINAL_INSTANCE_MEMORY_MBYTES)).toString());
        properties.setProperty(MAX_INSTANCE_MEMORY_MBYTES, ((Integer)map.get(MAX_INSTANCE_MEMORY_MBYTES)).toString());
        properties.setProperty(TRANSPORT_DIRECTION, (String)map.get(TRANSPORT_DIRECTION));
        properties.setProperty(MESSAGE_ANNOUNCER_THREADS_NUM, ((Integer)map.get(MESSAGE_ANNOUNCER_THREADS_NUM)).toString());
        this.setBufferSizes(properties, (Integer)map.get(SOCKET_BUFFER_SIZE));
    }

    private void setBufferSizes(Properties properties, Integer n) {
        int n2;
        int n3;
        int n4;
        if (n.equals(NONE)) {
            n4 = 0;
            n3 = 0;
            n2 = 0;
        } else if (n.equals(SMALL)) {
            n4 = 512;
            n3 = 64;
            n2 = 0;
        } else if (n.equals(MEDIUM)) {
            n4 = 1024;
            n3 = 256;
            n2 = 64;
        } else if (n.equals(LARGE)) {
            n4 = 3072;
            n3 = 1024;
            n2 = 128;
        } else {
            throw new DCSIllegalConfigurationException("Socket buffer size is set to unknown param " + n);
        }
        properties.setProperty("MulticastSocketReceptionBufferSizeKBytes", String.valueOf(n4));
        properties.setProperty("UnicastSocketReceptionBufferSizeKBytes", String.valueOf(n3));
        properties.setProperty("UnicastSocketTransmissionBufferSizeKBytes", String.valueOf(n2));
    }

    public void addConfigToMap(Map map) {
    }

    protected void postManualSetOptionalParams(Map map) {
        Integer n = (Integer)map.get(MAX_INSTANCE_MEMORY_MBYTES);
        Integer n2 = (Integer)map.get(NOMINAL_INSTANCE_MEMORY_MBYTES);
        if (!n.equals(UNLIMITED_MAX_MEMORY) && n2.compareTo(n) > 0) {
            throw new DCSIllegalConfigurationException("RMM Nominal Value " + n2 + " is bigger than RMM Maximal Value " + n);
        }
    }
}

