/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.common.config.rmm;

import com.ibm.ws.dcs.common.config.DCSIllegalConfigurationException;
import com.ibm.ws.dcs.common.config.rmm.RMMConfigMap;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;

public class RMMMulticastConfigMap
extends RMMConfigMap {
    public static final String MULTICAST_TRANSPORT_PROTOCOL = "MulticastTransportProtocol";
    public static final String MULTICAST_DATA_PORT = "MulticastDataPort";
    public static final String MULTICAST_TTL = "MulticastTTL";
    public static final String MULTICAST_GROUP_RANGE_START = "MulticastGroupRangeStart";
    public static final String MULTICAST_GROUP_RANGE_END = "MulticastGroupRangeEnd";

    public RMMMulticastConfigMap(Map map) {
        super(map);
    }

    public RMMMulticastConfigMap() {
    }

    protected void doTailoredTest(Object object, Object object2) {
        if (object.equals(MULTICAST_GROUP_RANGE_START) || object.equals(MULTICAST_GROUP_RANGE_END)) {
            String string = (String)object2;
            InetAddress inetAddress = null;
            try {
                inetAddress = InetAddress.getByName(string);
            }
            catch (UnknownHostException unknownHostException) {
                throw new DCSIllegalConfigurationException("Illegal adderss for " + object + "parameter: " + unknownHostException);
            }
            if (!inetAddress.isMulticastAddress()) {
                throw new DCSIllegalConfigurationException("Address " + string + " for " + object + " is not a multicast address");
            }
        }
    }

    protected void initParams() {
        super.initParams();
        this._defaultParams.put(MULTICAST_DATA_PORT, new Integer(23445));
        this._minMaxParams.put(MULTICAST_DATA_PORT, new Integer[]{new Integer(1), new Integer(65536)});
        this._defaultParams.put(MULTICAST_TRANSPORT_PROTOCOL, "PTL");
        this._enumParams.put(MULTICAST_TRANSPORT_PROTOCOL, new Object[]{"PTL"});
        this._defaultParams.put(MULTICAST_TTL, new Integer(1));
        this._minMaxParams.put(MULTICAST_TTL, new Integer[]{new Integer(0), new Integer(255)});
        this._mandatoryParams.put(MULTICAST_GROUP_RANGE_START, String.class);
        this._mandatoryParams.put(MULTICAST_GROUP_RANGE_END, String.class);
    }

    public void addConfigToProp(Properties properties) {
        super.addConfigToProp(properties);
        Map map = this.setOptionalParams();
        properties.setProperty(MULTICAST_DATA_PORT, ((Integer)map.get(MULTICAST_DATA_PORT)).toString());
        properties.setProperty(MULTICAST_TTL, ((Integer)map.get(MULTICAST_TTL)).toString());
        properties.setProperty(MULTICAST_TRANSPORT_PROTOCOL, (String)map.get(MULTICAST_TRANSPORT_PROTOCOL));
    }

    protected void preManualSetOptionalParams(Map map) {
    }
}

