/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.drsmodule.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.DCSMessage;
import com.ibm.ws.dcs.common.QoS;
import com.ibm.ws.dcs.common.exception.DCSException;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.common.exception.DCSMemberIsNotInViewException;
import com.ibm.ws.dcs.common.exception.DCSRuntimeException;
import com.ibm.ws.dcs.common.exception.DCSUnsupportedQoSException;
import com.ibm.ws.dcs.drsmodule.impl.DRSDataStackImpl;
import com.ibm.ws.dcs.drsmodule.impl.DataRequest;
import com.ibm.ws.dcs.drsmodule.impl.DataRequestHeader;
import com.ibm.ws.dcs.vri.common.DCSConstants;
import com.ibm.ws.dcs.vri.common.Globals;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMembersMGR;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.impl.ApplicationModuleImpl;
import com.ibm.ws.dcs.vri.common.impl.DCSOutgoingMessage;
import com.ibm.ws.dcs.vri.common.nls.SuspectUnreadableMessageEvent;
import com.ibm.ws.dcs.vri.common.nls.TerminationEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class DRHandler {
    private static final TraceComponent TC = Tr.register(DRHandler.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private static final String LAYER_NAME = DCSConstants.TRACE_LAYER_NAMES[8];
    private final DRSDataStackImpl _stack;
    private final Object _mutex;
    private final ApplicationModuleImpl _appModule;
    private final VRIMembersMGR _mgr;
    private final Hashtable _requests = new Hashtable(32768);
    private VRIMemberDescription[] _validMembers = new VRIMemberDescription[0];
    private final VRIMemberDescription _thisMember;
    private final QoS.QOSMulticast _mcastQoS;
    private final QoS.QOSUnicast _ucastQoS;
    private final boolean _use2Phase;
    private final byte _reqMessageType;
    private final DCSTraceContext _traceContext;

    DRHandler(Globals globals, DRSDataStackImpl dRSDataStackImpl, ApplicationModuleImpl applicationModuleImpl, boolean bl) {
        try {
            this._mutex = globals.getMutex();
            this._mgr = globals.getVRIMembersMgr();
            this._thisMember = this._mgr.getThisMember();
            this._appModule = applicationModuleImpl;
            this._stack = dRSDataStackImpl;
            this._mcastQoS = QoS.getMulticastQoS(QoS.RELIABLE, QoS.FIFO, QoS.WITHOUT_SELF_DELIVERY);
            this._ucastQoS = QoS.getUnicastQoS(QoS.RELIABLE, QoS.FIFO);
            this._use2Phase = bl;
            this._reqMessageType = (byte)(this._use2Phase ? 104 : 103);
            this._traceContext = new DCSTraceContextImpl(TC, this._mgr.getThisStackName(), this._thisMember.getName(), LAYER_NAME);
        }
        catch (DCSUnsupportedQoSException dCSUnsupportedQoSException) {
            DCSRuntimeException dCSRuntimeException = new DCSRuntimeException("Failed to create DRHandler", dCSUnsupportedQoSException);
            throw dCSRuntimeException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    DCSMessage dataRequest(String string, DCSMessage dCSMessage, long l) throws DCSException {
        String string2;
        DCSTraceBuffer dCSTraceBuffer;
        DataRequest dataRequest;
        Object object;
        DCSMessage dCSMessage2 = null;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this._traceContext, "dataRequest", "");
            ((DCSTraceBuffer)object).addProperty("memberName", string);
            ((DCSTraceBuffer)object).addProperty("Message", dCSMessage);
            ((DCSTraceBuffer)object).addProperty("Timeout", l);
            ((DCSTraceBuffer)object).invoke();
        }
        if (this._validMembers.length == 0) {
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                object = DCSTraceBuffer.exit(this._traceContext, "dataRequest", "no members to ask");
                ((DCSTraceBuffer)object).addProperty("ReturnCode", dCSMessage2);
                ((DCSTraceBuffer)object).invoke();
            }
            return dCSMessage2;
        }
        object = this._mutex;
        synchronized (object) {
            VRIMemberDescription vRIMemberDescription = null;
            if (string != null) {
                vRIMemberDescription = this._mgr.getDefinedMember(string);
                if (vRIMemberDescription == null) {
                    throw new DCSInvalidParametersException("Member " + string + "is not defined");
                }
                if (!vRIMemberDescription.isInView()) {
                    return null;
                }
                if (!vRIMemberDescription.isInView()) {
                    throw new DCSMemberIsNotInViewException(string, VRIMemberUtils.getMemberNames(this._mgr.getViewMembers()));
                }
            }
            dataRequest = this.prepareRequestMessage(string, (DCSOutgoingMessage)dCSMessage, this._reqMessageType);
            if (DCSTraceBuffer.isDebugEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.debug(this._traceContext, "dataRequest", "");
                dCSTraceBuffer.addProperty("RequestId", dataRequest.reqID);
                dCSTraceBuffer.invoke();
            }
            if (string == null) {
                this._appModule.mcastMessage(dataRequest.requestMsg, this._mcastQoS, null);
            } else {
                this._appModule.sendMessage(dataRequest.requestMsg, vRIMemberDescription, this._ucastQoS, null);
            }
            string2 = dataRequest.key;
            this._requests.put(dataRequest.key, dataRequest);
        }
        object = dataRequest;
        synchronized (object) {
            if (!dataRequest.answerIsReady) {
                block20: {
                    try {
                        dataRequest.wait(l);
                    }
                    catch (InterruptedException interruptedException) {
                        if (!TC.isDebugEnabled() || !DCSTraceBuffer.isDebugEnabled(TC)) break block20;
                        dCSTraceBuffer = DCSTraceBuffer.debug(this._traceContext, "dataRequest", "dataRequest was interrupted");
                        dCSTraceBuffer.addProperty("RequestId", dataRequest.reqID);
                        dCSTraceBuffer.invoke();
                    }
                }
                dataRequest.answerIsReady = true;
            }
            dCSMessage2 = dataRequest.answer;
        }
        this._requests.remove(string2);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            object = DCSTraceBuffer.exit(this._traceContext, "dataRequest", "");
            ((DCSTraceBuffer)object).addProperty("ReturnCode", dCSMessage2);
            ((DCSTraceBuffer)object).invoke();
        }
        return dCSMessage2;
    }

    private DataRequest prepareRequestMessage(String string, DCSOutgoingMessage dCSOutgoingMessage, byte by) throws DCSException {
        VRIMessage vRIMessage = dCSOutgoingMessage.toVRIMessage();
        DataRequest dataRequest = new DataRequest();
        DataRequestHeader dataRequestHeader = new DataRequestHeader(dataRequest.reqID);
        if (string == null) {
            for (int i = 0; i < this._validMembers.length; ++i) {
                dataRequest.membersToWait.add(this._validMembers[i].getName());
            }
        } else {
            dataRequest.membersToWait.add(string);
            dataRequestHeader.isUcastRequest(true);
        }
        dataRequest.header = dataRequestHeader;
        vRIMessage.addHeader(dataRequestHeader);
        vRIMessage.setMessageType(by);
        dataRequest.requestMsg = vRIMessage.copy(false);
        return dataRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleDataReply(VRIMessage vRIMessage) {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this._traceContext, "handleDataReply", "");
            ((DCSTraceBuffer)object).addProperty("Message", vRIMessage);
            ((DCSTraceBuffer)object).invoke();
        }
        if ((object = this.getDRHeader(vRIMessage)) == null) {
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "handleDataReply", "");
                dCSTraceBuffer.invoke();
            }
            return;
        }
        DataRequest dataRequest = (DataRequest)this._requests.get("DRSDataRequest." + ((DataRequestHeader)object).getReqID());
        if (dataRequest == null) {
            DCSTraceBuffer dCSTraceBuffer;
            if (DCSTraceBuffer.isDebugEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.debug(this._traceContext, "handleDataReply", "got answer for non existing request");
                dCSTraceBuffer.addProperty("RequestId", dataRequest.reqID);
                dCSTraceBuffer.invoke();
            }
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "handleDataReply", "");
                dCSTraceBuffer.invoke();
            }
            return;
        }
        Object object2 = dataRequest;
        synchronized (object2) {
            boolean bl;
            if (dataRequest.answerIsReady) {
                DCSTraceBuffer dCSTraceBuffer;
                if (DCSTraceBuffer.isDebugEnabled(TC)) {
                    dCSTraceBuffer = DCSTraceBuffer.debug(this._traceContext, "handleDataReply", "Request was answered already ");
                    dCSTraceBuffer.addProperty("RequestId", dataRequest.reqID);
                    dCSTraceBuffer.invoke();
                }
                if (DCSTraceBuffer.isExitEnabled(TC)) {
                    dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "handleDataReply", "");
                    dCSTraceBuffer.invoke();
                }
                return;
            }
            String string = vRIMessage.getSender();
            if (!this._use2Phase) {
                bl = dataRequest.membersToWait.remove(string);
            } else {
                boolean bl2 = bl = string.equals(dataRequest.primary.getName()) || string.equals(dataRequest.backup.getName());
            }
            if (bl) {
                if (((DataRequestHeader)object).hasAnswer()) {
                    dataRequest.answer = (DCSMessage)((Object)vRIMessage);
                    dataRequest.answerIsReady = true;
                } else if (dataRequest.membersToWait.isEmpty()) {
                    dataRequest.answerIsReady = true;
                }
                if (dataRequest.answerIsReady) {
                    dataRequest.notify();
                }
            } else if (DCSTraceBuffer.isDebugEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.debug(this._traceContext, "handleDataReply", "got unswer from unexpected member");
                dCSTraceBuffer.addProperty("RequestId", dataRequest.reqID);
                dCSTraceBuffer.addProperty("Sender", string);
                dCSTraceBuffer.invoke();
            }
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            object2 = DCSTraceBuffer.exit(this._traceContext, "handleDataReply", "");
            ((DCSTraceBuffer)object2).invoke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleSearchReply(VRIMessage vRIMessage) {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this._traceContext, "handleSearchReply", "");
            ((DCSTraceBuffer)object).addProperty("Message", vRIMessage);
            ((DCSTraceBuffer)object).invoke();
        }
        if ((object = this.getDRHeader(vRIMessage)) == null) {
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "handleSearchReply", "");
                dCSTraceBuffer.invoke();
            }
            return;
        }
        DataRequest dataRequest = (DataRequest)this._requests.get("DRSDataRequest." + ((DataRequestHeader)object).getReqID());
        if (dataRequest == null) {
            DCSTraceBuffer dCSTraceBuffer;
            if (TC.isDebugEnabled() && DCSTraceBuffer.isDebugEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.debug(this._traceContext, "handleSearchReply", "got answer for non existing request");
                dCSTraceBuffer.addProperty("RequestId", dataRequest.reqID);
                dCSTraceBuffer.invoke();
            }
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "handleSearchReply", "");
                dCSTraceBuffer.invoke();
            }
            return;
        }
        Object object2 = this._mutex;
        synchronized (object2) {
            DataRequest dataRequest2 = dataRequest;
            synchronized (dataRequest2) {
                if (dataRequest.answerIsReady) {
                    DCSTraceBuffer dCSTraceBuffer;
                    if (DCSTraceBuffer.isDebugEnabled(TC)) {
                        dCSTraceBuffer = DCSTraceBuffer.debug(this._traceContext, "handleDataReply", "Request was answered already ");
                        dCSTraceBuffer.addProperty("RequestId", dataRequest.reqID);
                        dCSTraceBuffer.invoke();
                    }
                    if (DCSTraceBuffer.isExitEnabled(TC)) {
                        dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "handleSearchReply", "");
                        dCSTraceBuffer.invoke();
                    }
                    return;
                }
                String string = vRIMessage.getSender();
                if (!dataRequest.membersToWait.remove(string)) {
                    if (DCSTraceBuffer.isDebugEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.debug(this._traceContext, "handleSearchReply", "got unswer from unexpected member");
                        dCSTraceBuffer.addProperty("RequestId", dataRequest.reqID);
                        dCSTraceBuffer.addProperty("Sender", string);
                        dCSTraceBuffer.invoke();
                    }
                    return;
                }
                VRIMemberDescription vRIMemberDescription = this._mgr.getDefinedMember(string);
                if (vRIMemberDescription == null || vRIMemberDescription.isDenied() || !vRIMemberDescription.isInView()) {
                    ((DataRequestHeader)object).hasAnswer(false);
                }
                if (((DataRequestHeader)object).hasAnswer()) {
                    int n = 0;
                    if (dataRequest.primary == null) {
                        dataRequest.primary = vRIMemberDescription;
                        n = 1;
                    } else if (dataRequest.backup == null) {
                        dataRequest.backup = vRIMemberDescription;
                        n = 2;
                    }
                    if (n != 0) {
                        VRIMessage vRIMessage2 = dataRequest.requestMsg.copy(true);
                        if (DCSTraceBuffer.isDebugEnabled(TC)) {
                            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.debug(this._traceContext, "handleSearchReply", "Sending data request");
                            dCSTraceBuffer.addProperty("Target", "memberName", string);
                            dCSTraceBuffer.addProperty("RequestId", dataRequest.reqID);
                            dCSTraceBuffer.invoke();
                        }
                        vRIMessage2.setMessageType((byte)103);
                        try {
                            this._appModule.sendMessage(vRIMessage2, vRIMemberDescription, this._ucastQoS, null);
                        }
                        catch (DCSException dCSException) {
                            TerminationEvent terminationEvent = new TerminationEvent(this._traceContext, "handleSearchReply", dCSException);
                            this._appModule.requestTermination(terminationEvent);
                        }
                    }
                } else if (dataRequest.primary == null && dataRequest.membersToWait.isEmpty()) {
                    dataRequest.answerIsReady = true;
                    if (DCSTraceBuffer.isDebugEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.debug(this._traceContext, "handleSearchReply", "Sender has no data and there are no members to wait for");
                        dCSTraceBuffer.addProperty("RequestId", dataRequest.reqID);
                        dCSTraceBuffer.addProperty("Saved", string);
                        dCSTraceBuffer.invoke();
                    }
                    dataRequest.notify();
                }
            }
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            object2 = DCSTraceBuffer.exit(this._traceContext, "handleSearchReply", "");
            ((DCSTraceBuffer)object2).invoke();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void clearFailedMembers() {
        Object object;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this._traceContext, "clearFailedMembers", "");
            ((DCSTraceBuffer)object).invoke();
        }
        object = this._mgr.getDeniedMembers(false);
        Hashtable hashtable = this._requests;
        synchronized (hashtable) {
            Set set = this._requests.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                DataRequest dataRequest;
                Map.Entry entry = iterator.next();
                DataRequest dataRequest2 = dataRequest = (DataRequest)entry.getValue();
                synchronized (dataRequest2) {
                    dataRequest.removeFailedMembers((VRIMemberDescription[])object);
                    if (dataRequest.answerIsReady) {
                        dataRequest.notify();
                        iterator.remove();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void terminate() {
        Object object;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this._traceContext, "terminate", "");
            ((DCSTraceBuffer)object).invoke();
        }
        object = this._requests;
        synchronized (object) {
            Set set = this._requests.entrySet();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                DataRequest dataRequest;
                Map.Entry entry = iterator.next();
                DataRequest dataRequest2 = dataRequest = (DataRequest)entry.getValue();
                synchronized (dataRequest2) {
                    dataRequest.answerIsReady = true;
                    dataRequest.notify();
                }
                iterator.remove();
            }
        }
    }

    void updateValidMembers() {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "updateValidMembers", "");
            dCSTraceBuffer.invoke();
        }
        this._validMembers = this._mgr.getViewMinusDenied();
        this._validMembers = VRIMemberUtils.minus(this._validMembers, this._thisMember);
    }

    private final DataRequestHeader getDRHeader(VRIMessage vRIMessage) {
        DataRequestHeader dataRequestHeader = new DataRequestHeader();
        if ((dataRequestHeader = (DataRequestHeader)vRIMessage.extractHeader(dataRequestHeader)) == null) {
            SuspectUnreadableMessageEvent suspectUnreadableMessageEvent = SuspectUnreadableMessageEvent.badHeader(this._traceContext, vRIMessage.getSender());
            suspectUnreadableMessageEvent.invokeNLSTrace();
            this._stack.suspectMember(suspectUnreadableMessageEvent, 2, "Failed to read data request header");
        }
        return dataRequestHeader;
    }
}

