/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.drsmodule.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.DCSMessage;
import com.ibm.ws.dcs.common.DCSTraceable;
import com.ibm.ws.dcs.common.MemberInfoManager;
import com.ibm.ws.dcs.common.QoS;
import com.ibm.ws.dcs.common.event.DCSTerminationEvent;
import com.ibm.ws.dcs.common.exception.DCSException;
import com.ibm.ws.dcs.common.exception.DCSRuntimeException;
import com.ibm.ws.dcs.common.exception.DCSUnsupportedQoSException;
import com.ibm.ws.dcs.drsmodule.DRSDataStack;
import com.ibm.ws.dcs.drsmodule.DataRequestListener;
import com.ibm.ws.dcs.drsmodule.impl.DRHandler;
import com.ibm.ws.dcs.drsmodule.impl.DataRequestHeader;
import com.ibm.ws.dcs.vri.common.CCVersion;
import com.ibm.ws.dcs.vri.common.JobsProcessorThread;
import com.ibm.ws.dcs.vri.common.ThreadManager;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.impl.BaseVRIMessageFactory;
import com.ibm.ws.dcs.vri.common.impl.DCSConfig;
import com.ibm.ws.dcs.vri.common.impl.DCSDataStackImpl;
import com.ibm.ws.dcs.vri.common.impl.DCSIncomingMessage;
import com.ibm.ws.dcs.vri.common.impl.DCSOutgoingMessage;
import com.ibm.ws.dcs.vri.common.impl.DCSStackImpl;
import com.ibm.ws.dcs.vri.common.nls.CallbackFailedEvent;
import com.ibm.ws.dcs.vri.common.nls.SuspectUnreadableMessageEvent;
import com.ibm.ws.dcs.vri.common.nls.TerminationEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import java.net.UnknownHostException;
import java.util.Map;

public final class DRSDataStackImpl
extends DCSDataStackImpl
implements DRSDataStack {
    private static final TraceComponent TC = Tr.register(DRSDataStackImpl.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    protected static final int VERSION = 0x1000000;
    protected static final byte DRS_MSG = 102;
    protected static final byte DRS_DATA_REQUEST = 103;
    protected static final byte DRS_DATA_SEARCH = 104;
    protected static final byte DRS_DATA_REQUEST_REPLY = 105;
    protected static final byte DRS_DATA_SEARCH_REPLY = 106;
    public static final String USE_2_PHASE_DATA_REQUEST = "USE_2_PHASE_DATA_REQUEST";
    private final DCSTraceContext _traceContext;
    private final DRHandler _drHandler;
    private DataRequestListener _drListener;
    private final QoS.QOSUnicast _ucastQoS;
    private final BaseVRIMessageFactory _baseMsgFactory;
    private final JobsProcessorThread _drThread;
    private final String _drThreadOwner;

    public static DCSDataStackImpl getInstance(String string, DCSConfig dCSConfig, MemberInfoManager memberInfoManager) throws UnknownHostException, DCSException {
        return new DRSDataStackImpl(string, dCSConfig, memberInfoManager);
    }

    protected DRSDataStackImpl(String string, DCSConfig dCSConfig, MemberInfoManager memberInfoManager) throws UnknownHostException, DCSException {
        super(string, dCSConfig, memberInfoManager);
        this._traceContext = new DCSTraceContextImpl(TC, this._stackName, this._thisMemberName, LAYER_NAME);
        try {
            this._ucastQoS = QoS.getUnicastQoS(QoS.RELIABLE, QoS.FIFO);
        }
        catch (DCSUnsupportedQoSException dCSUnsupportedQoSException) {
            throw new DCSRuntimeException("Failed to create DRSDataStack", dCSUnsupportedQoSException);
        }
        this._baseMsgFactory = BaseVRIMessageFactory.getInstance(this._globals);
        Map map = (Map)this._globals.getConfigParam("SPECIFIC_DATA_STACK_CONFIGURATION");
        Boolean bl = (Boolean)map.get(USE_2_PHASE_DATA_REQUEST);
        if (bl == null) {
            bl = Boolean.FALSE;
        }
        this._drHandler = new DRHandler(this._globals, this, this._appModule, bl);
        this._drThreadOwner = this._stackName + "." + "DRThread";
        this._drThread = ThreadManager.getThread(this._drThreadOwner, ThreadManager.INTERNAL_THREAD, 1);
        if (this._drThread == null) {
            throw new DCSRuntimeException("Failed to create thread: " + this._drThreadOwner);
        }
    }

    public DCSMessage dataRequest(String string, DCSMessage dCSMessage, long l) throws DCSException {
        return this._drHandler.dataRequest(string, dCSMessage, l);
    }

    public DCSMessage dataRequest(DCSMessage dCSMessage, long l) throws DCSException {
        return this._drHandler.dataRequest(null, dCSMessage, l);
    }

    public void setDataRequestListener(DataRequestListener dataRequestListener) {
        this._drListener = dataRequestListener;
    }

    protected void currentOK(CCVersion cCVersion) {
        this._drHandler.clearFailedMembers();
        super.currentOK(cCVersion);
    }

    protected void newViewOK(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, Map map) {
        this._drHandler.updateValidMembers();
        super.newViewOK(vRIMemberDescriptionArray, viewIdImpl, map);
    }

    protected void terminate() {
        ThreadManager.releaseThread(this._drThreadOwner);
        this._drHandler.terminate();
        this._drListener = null;
        super.terminate();
    }

    protected void handleApplicationMessage(VRIMessage vRIMessage) {
        byte by = vRIMessage.getMessageType();
        switch (by) {
            case 103: {
                DataRequestJob dataRequestJob = new DataRequestJob(this._drListener, (DCSIncomingMessage)vRIMessage, this._baseMsgFactory);
                this._applicationModuleThread.enqueueJob(dataRequestJob);
                break;
            }
            case 105: {
                DRReplyJob dRReplyJob = new DRReplyJob(this._drHandler, vRIMessage);
                this._drThread.enqueueJob(dRReplyJob);
                break;
            }
            case 104: {
                DataSearchJob dataSearchJob = new DataSearchJob(this._drListener, (DCSIncomingMessage)vRIMessage, this._baseMsgFactory);
                this._applicationModuleThread.enqueueJob(dataSearchJob);
                break;
            }
            case 106: {
                DSReplyJob dSReplyJob = new DSReplyJob(this._drHandler, vRIMessage);
                this._drThread.enqueueJob(dSReplyJob);
                break;
            }
            default: {
                super.handleApplicationMessage(vRIMessage);
            }
        }
    }

    private final class DSReplyJob
    extends DCSStackImpl.ApplicationLayerJob {
        private final DRHandler _handler;
        private final VRIMessage _request;

        DSReplyJob(DRHandler dRHandler, VRIMessage vRIMessage) {
            super(DRSDataStackImpl.this);
            this._handler = dRHandler;
            this._request = vRIMessage;
        }

        public void process() {
            this._handler.handleSearchReply(this._request);
        }

        public String getTraceName() {
            return "DSReplyJob";
        }

        public void handleError(Throwable throwable) {
            TerminationEvent terminationEvent = new TerminationEvent(DRSDataStackImpl.this._traceContext, "DSReplyJob.process", throwable);
            DRSDataStackImpl.this.requestTermination(terminationEvent);
        }
    }

    private final class DRReplyJob
    extends DCSStackImpl.ApplicationLayerJob {
        private final DRHandler _handler;
        private final VRIMessage _request;

        DRReplyJob(DRHandler dRHandler, VRIMessage vRIMessage) {
            super(DRSDataStackImpl.this);
            this._handler = dRHandler;
            this._request = vRIMessage;
        }

        public void process() {
            this._handler.handleDataReply(this._request);
        }

        public String getTraceName() {
            return "DRReplyJob";
        }

        public void handleError(Throwable throwable) {
            TerminationEvent terminationEvent = new TerminationEvent(DRSDataStackImpl.this._traceContext, "DRReplyJob.process", throwable);
            DRSDataStackImpl.this.requestTermination(terminationEvent);
        }
    }

    public class DataRequestJob
    extends DCSStackImpl.ApplicationLayerJob {
        private final DataRequestListener _listener;
        private final DCSIncomingMessage _request;
        private final BaseVRIMessageFactory _msgFactory;

        DataRequestJob(DataRequestListener dataRequestListener, DCSIncomingMessage dCSIncomingMessage, BaseVRIMessageFactory baseVRIMessageFactory) {
            super(DRSDataStackImpl.this);
            this._listener = dataRequestListener;
            this._request = dCSIncomingMessage;
            this._msgFactory = baseVRIMessageFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() {
            Object object;
            VRIMessage vRIMessage = null;
            DCSOutgoingMessage dCSOutgoingMessage = null;
            DataRequestHeader dataRequestHeader = new DataRequestHeader();
            if ((dataRequestHeader = (DataRequestHeader)this._request.extractHeader(dataRequestHeader)) == null) {
                SuspectUnreadableMessageEvent suspectUnreadableMessageEvent = SuspectUnreadableMessageEvent.badHeader(DRSDataStackImpl.this._traceContext, this._request.getSender());
                suspectUnreadableMessageEvent.invokeNLSTrace();
                DRSDataStackImpl.this.suspectMember(suspectUnreadableMessageEvent, 2, "Received message with corrupted header");
                return;
            }
            if (this._listener != null) {
                dCSOutgoingMessage = (DCSOutgoingMessage)this._listener.getData(this._request);
            }
            Object object2 = object = DRSDataStackImpl.this._globals.getMutex();
            synchronized (object2) {
                if (DRSDataStackImpl.this._terminated) {
                    return;
                }
                VRIMemberDescription vRIMemberDescription = DRSDataStackImpl.this._mgr.getDefinedMember(this._request.getSender());
                if (vRIMemberDescription == null || vRIMemberDescription.isDenied() || !vRIMemberDescription.isInView()) {
                    return;
                }
                try {
                    if (dCSOutgoingMessage != null) {
                        vRIMessage = dCSOutgoingMessage.toVRIMessage();
                        dataRequestHeader.hasAnswer(true);
                    } else {
                        dataRequestHeader.hasAnswer(false);
                        vRIMessage = this._msgFactory.getMessage((byte)8, DRSDataStackImpl.this._thisMemberName, 256);
                    }
                    vRIMessage.setMessageType((byte)105);
                    vRIMessage.addHeader(dataRequestHeader);
                    DRSDataStackImpl.this._appModule.sendMessage(vRIMessage, vRIMemberDescription, DRSDataStackImpl.this._ucastQoS, null);
                }
                catch (Throwable throwable) {
                    DCSTraceable dCSTraceable;
                    if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                        dCSTraceable = DCSTraceBuffer.internalWarning(DRSDataStackImpl.this._traceContext, "Failed to send an answer", throwable);
                        ((DCSTraceBuffer)dCSTraceable).addProperty("Method", "DataRequestJob.process");
                        ((DCSTraceBuffer)dCSTraceable).invoke();
                    }
                    dCSTraceable = new TerminationEvent(DRSDataStackImpl.this._traceContext, "DataRequestJob.process", throwable);
                    DRSDataStackImpl.this.requestTermination((DCSTerminationEvent)dCSTraceable);
                }
            }
        }

        public String getTraceName() {
            return "DataRequestJob";
        }

        public void handleError(Throwable throwable) {
            CallbackFailedEvent callbackFailedEvent = new CallbackFailedEvent(DRSDataStackImpl.this._traceContext, "DataRequestJob.process", throwable);
            DRSDataStackImpl.this.requestTermination(callbackFailedEvent);
        }
    }

    private final class DataSearchJob
    extends DCSStackImpl.ApplicationLayerJob {
        private final DataRequestListener _listener;
        private final DCSIncomingMessage _request;
        private final BaseVRIMessageFactory _msgFactory;

        DataSearchJob(DataRequestListener dataRequestListener, DCSIncomingMessage dCSIncomingMessage, BaseVRIMessageFactory baseVRIMessageFactory) {
            super(DRSDataStackImpl.this);
            this._listener = dataRequestListener;
            this._request = dCSIncomingMessage;
            this._msgFactory = baseVRIMessageFactory;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() {
            Object object;
            DataRequestHeader dataRequestHeader = new DataRequestHeader();
            if ((dataRequestHeader = (DataRequestHeader)this._request.extractHeader(dataRequestHeader)) == null) {
                SuspectUnreadableMessageEvent suspectUnreadableMessageEvent = SuspectUnreadableMessageEvent.badHeader(DRSDataStackImpl.this._traceContext, this._request.getSender());
                suspectUnreadableMessageEvent.invokeNLSTrace();
                DRSDataStackImpl.this.suspectMember(suspectUnreadableMessageEvent, 2, "Received message with corrupted header");
                return;
            }
            if (this._listener != null) {
                if (DCSTraceBuffer.isDebugEnabled(TC)) {
                    object = DCSTraceBuffer.debug(DRSDataStackImpl.this._traceContext, "DataSearchJob.process", "Going to call the application");
                    ((DCSTraceBuffer)object).invoke();
                }
                dataRequestHeader.hasAnswer(this._listener.hasData(this._request));
                if (DCSTraceBuffer.isDebugEnabled(TC)) {
                    object = DCSTraceBuffer.debug(DRSDataStackImpl.this._traceContext, "DataSearchJob.process", "After calling the application");
                    ((DCSTraceBuffer)object).addProperty("ReturnCode", dataRequestHeader._hasAnswer);
                    ((DCSTraceBuffer)object).invoke();
                }
            } else {
                dataRequestHeader.hasAnswer(false);
            }
            Object object2 = object = DRSDataStackImpl.this._globals.getMutex();
            synchronized (object2) {
                if (DRSDataStackImpl.this._terminated) {
                    return;
                }
                VRIMemberDescription vRIMemberDescription = DRSDataStackImpl.this._mgr.getDefinedMember(this._request.getSender());
                if (vRIMemberDescription == null || vRIMemberDescription.isDenied() || !vRIMemberDescription.isInView()) {
                    return;
                }
                VRIMessage vRIMessage = this._msgFactory.getMessage((byte)8, DRSDataStackImpl.this._thisMemberName, 256);
                vRIMessage.setMessageType((byte)106);
                vRIMessage.addHeader(dataRequestHeader);
                try {
                    DRSDataStackImpl.this._appModule.sendMessage(vRIMessage, vRIMemberDescription, DRSDataStackImpl.this._ucastQoS, null);
                }
                catch (Throwable throwable) {
                    DCSTraceable dCSTraceable;
                    if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                        dCSTraceable = DCSTraceBuffer.internalWarning(DRSDataStackImpl.this._traceContext, "Failed to send an answer", throwable);
                        ((DCSTraceBuffer)dCSTraceable).addProperty("Method", "DataSearchJob.process");
                        ((DCSTraceBuffer)dCSTraceable).invoke();
                    }
                    dCSTraceable = new TerminationEvent(DRSDataStackImpl.this._traceContext, "DataSearchJob.process", throwable);
                    DRSDataStackImpl.this.requestTermination((DCSTerminationEvent)dCSTraceable);
                }
            }
        }

        public String getTraceName() {
            return "DataSearchJob";
        }

        public void handleError(Throwable throwable) {
            CallbackFailedEvent callbackFailedEvent = new CallbackFailedEvent(DRSDataStackImpl.this._traceContext, "DataSearchJob.process", throwable);
            DRSDataStackImpl.this.requestTermination(callbackFailedEvent);
        }
    }
}

