/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.rsmodule;

import com.ibm.ws.dcs.common.DCSMessage;
import com.ibm.ws.dcs.rsmodule.DCSListenerIsBlockedException;
import com.ibm.ws.dcs.rsmodule.RSProvider;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class BaseAckListener
implements RSProvider.DCSAcksListener {
    public static final int NEW = 1;
    public static final int BLOCKED = 2;
    public static final int ABORTED = 3;
    public static final int TERMINATED = 4;
    public static final int TIMEDOUT = 5;
    public static final int READY = 6;
    private final Lock _lock = new Lock();
    private int _state = 1;
    private final HashMap _acks = new HashMap();
    private final HashSet _targets;
    private final long _timeout;

    protected BaseAckListener(Set set, long l) {
        this._targets = new HashSet(set);
        this._timeout = l;
    }

    protected BaseAckListener(long l) {
        this._targets = new HashSet();
        this._timeout = l;
    }

    public final DCSMessage getAck(String string) {
        return (DCSMessage)this._acks.get(string);
    }

    public final Map getAcks() {
        return this._acks;
    }

    protected final void setAck(String string, DCSMessage dCSMessage) {
        this._acks.put(string, dCSMessage);
    }

    protected final boolean removeTarget(String string) {
        return this._targets.remove(string);
    }

    protected final Set getTargets() {
        return this._targets;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleFailedMembers(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        Lock lock = this._lock;
        synchronized (lock) {
            if (this.onFailedMembers(stringArray)) {
                this.abort();
            }
        }
    }

    protected abstract boolean onFailedMembers(String[] var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void block() {
        Lock lock = this._lock;
        synchronized (lock) {
            if (this._state != 1) {
                if (this._state == 2) {
                    throw new DCSListenerIsBlockedException();
                }
                return;
            }
            this._state = 2;
            long l = System.currentTimeMillis() + this._timeout;
            long l2 = this._timeout;
            while (this._state == 2) {
                try {
                    if (l2 == 0L) {
                        this._lock.wait();
                        continue;
                    }
                    this._lock.wait(l2);
                    if (this._state != 2 || (l2 = l - System.currentTimeMillis()) > 0L) continue;
                    this._state = 5;
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void handleAck(String string, DCSMessage dCSMessage) {
        Lock lock = this._lock;
        synchronized (lock) {
            if (this._state != 2 && this._state != 1) {
                return;
            }
        }
        if (this.onAck(string, dCSMessage)) {
            this.release(6);
        }
    }

    public final int getState() {
        return this._state;
    }

    protected abstract boolean onAck(String var1, DCSMessage var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        Lock lock = this._lock;
        synchronized (lock) {
            return this._state == 6;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void release(int n) {
        Lock lock = this._lock;
        synchronized (lock) {
            switch (this._state) {
                case 2: {
                    this._lock.notify();
                }
                case 1: {
                    this._state = n;
                    break;
                }
                case 3: 
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
        }
    }

    protected final void onTimeout() {
        this.release(5);
    }

    public final void abort() {
        this.release(3);
    }

    public final void terminate() {
        this.release(4);
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

