/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.rsmodule.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.DCSMessage;
import com.ibm.ws.dcs.common.MemberInfoManager;
import com.ibm.ws.dcs.common.QoS;
import com.ibm.ws.dcs.common.StateVersion;
import com.ibm.ws.dcs.common.ViewId;
import com.ibm.ws.dcs.common.exception.DCSException;
import com.ibm.ws.dcs.common.exception.DCSIllegalParameterException;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.common.exception.DCSInvalidViewIDException;
import com.ibm.ws.dcs.common.exception.DCSMemberIsNotInViewException;
import com.ibm.ws.dcs.common.exception.DCSNotImplementedException;
import com.ibm.ws.dcs.common.exception.DCSRuntimeException;
import com.ibm.ws.dcs.common.exception.DCSUnsupportedQoSException;
import com.ibm.ws.dcs.common.exception.DCSVerisionIncompatibleException;
import com.ibm.ws.dcs.rsmodule.BaseAckListener;
import com.ibm.ws.dcs.rsmodule.DCSInvalidListenerStateException;
import com.ibm.ws.dcs.rsmodule.DCSMessageListenerRS;
import com.ibm.ws.dcs.rsmodule.DCSRequestTimedOutException;
import com.ibm.ws.dcs.rsmodule.DCSStackTerminatedException;
import com.ibm.ws.dcs.rsmodule.DCSUnsupportedAckListenerTypeException;
import com.ibm.ws.dcs.rsmodule.DCSViewChangeInProcessException;
import com.ibm.ws.dcs.rsmodule.MultipleAcksListener;
import com.ibm.ws.dcs.rsmodule.RSProvider;
import com.ibm.ws.dcs.rsmodule.SingleAckListener;
import com.ibm.ws.dcs.rsmodule.impl.RSMessageHeader;
import com.ibm.ws.dcs.vri.common.CCVersion;
import com.ibm.ws.dcs.vri.common.JobsProcessorThread;
import com.ibm.ws.dcs.vri.common.ThreadManager;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.impl.DCSConfig;
import com.ibm.ws.dcs.vri.common.impl.DCSIncomingMessage;
import com.ibm.ws.dcs.vri.common.impl.DCSOutgoingMessage;
import com.ibm.ws.dcs.vri.common.impl.DCSStackImpl;
import com.ibm.ws.dcs.vri.common.nls.CallbackFailedEvent;
import com.ibm.ws.dcs.vri.common.nls.SuspectUnreadableMessageEvent;
import com.ibm.ws.dcs.vri.common.nls.TerminationEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class DCSRSStackImpl
extends DCSStackImpl
implements RSProvider {
    static final int VERSION = 0x1000000;
    private static final TraceComponent TC = Tr.register(DCSRSStackImpl.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private static final byte CC = 1;
    private static final byte CC_OK = 2;
    private static final byte NORMAL = 3;
    private static final byte TERMINATED = 4;
    private static final byte RS_MSG = 112;
    private static final byte RS_MSG_WITHOUT_SD = 113;
    private static final byte RS_ACK_WITH_DATA = 114;
    private static final byte RS_ACK_NO_DATA = 115;
    private int _rsMsgCounter = 0;
    private final HashMap _waitingList = new HashMap(1024);
    private final DCSTraceContext _traceContext;
    private final String _rsThreadOwner;
    private final JobsProcessorThread _rsThread;
    private final QoS.QOSMulticast _rsMcastQoS;
    private final QoS.QOSUnicast _rsUcastQoS;
    private HashSet _viewMembers = new HashSet();
    private byte _state = (byte)3;
    private String[] _failedMembers = null;

    protected DCSRSStackImpl(String string, DCSConfig dCSConfig, MemberInfoManager memberInfoManager, boolean bl) throws DCSException {
        super(string, dCSConfig, memberInfoManager, bl);
        this._traceContext = new DCSTraceContextImpl(TC, this._stackName, this._thisMemberName, LAYER_NAME);
        try {
            this._rsUcastQoS = QoS.getUnicastQoS(QoS.VS_CURRENT, QoS.FIFO);
            this._rsMcastQoS = QoS.getMulticastQoS(QoS.VS_CURRENT, QoS.FIFO);
        }
        catch (DCSUnsupportedQoSException dCSUnsupportedQoSException) {
            throw new DCSRuntimeException("Failed to create DRSDataStack", dCSUnsupportedQoSException);
        }
        this._rsThreadOwner = this._stackName + "." + "RSThread";
        this._rsThread = ThreadManager.getThread(this._rsThreadOwner, ThreadManager.INTERNAL_THREAD, 1);
        if (this._rsThread == null) {
            throw new DCSRuntimeException("Failed to create thread: " + this._rsThreadOwner);
        }
        this._viewMembers.add(this._thisMemberName);
    }

    public final void mcastMessageWithAck(DCSMessage dCSMessage, Comparable comparable) throws DCSException {
        this.mcastMessageWithAck(dCSMessage, comparable, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void mcastMessageWithAck(DCSMessage dCSMessage, Comparable comparable, boolean bl) throws DCSException {
        MultipleAcksListener multipleAcksListener;
        Object object = this._mutex;
        synchronized (object) {
            if (comparable == null) {
                throw new DCSIllegalParameterException("vid is null");
            }
            if (this._currentViewId == null) {
                throw new DCSViewChangeInProcessException();
            }
            if (!comparable.equals(this._currentViewId)) {
                throw new DCSInvalidViewIDException((ViewId)comparable, this._currentViewId, "Failed to send message with illegal view id");
            }
            if (this._viewMembers.size() == 1 && !bl) {
                return;
            }
            multipleAcksListener = new MultipleAcksListener(this._viewMembers);
        }
        this.mcastMessageWithAck(dCSMessage, comparable, multipleAcksListener, bl);
    }

    public final void mcastMessageWithAck(DCSMessage dCSMessage, Comparable comparable, RSProvider.DCSAcksListener dCSAcksListener, boolean bl) throws DCSException {
        if (dCSAcksListener == null) {
            throw new DCSIllegalParameterException("AckListener is null");
        }
        if (!(dCSAcksListener instanceof BaseAckListener)) {
            throw new DCSUnsupportedAckListenerTypeException(dCSAcksListener.getClass().getName());
        }
        BaseAckListener baseAckListener = (BaseAckListener)dCSAcksListener;
        this.mcastMessageWithAck(dCSMessage, comparable, baseAckListener, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void mcastMessageWithAck(DCSMessage dCSMessage, Comparable comparable, BaseAckListener baseAckListener, boolean bl) throws DCSException {
        Integer n = null;
        Object object = this._mutex;
        synchronized (object) {
            if (this._currentViewId == null) {
                throw new DCSViewChangeInProcessException();
            }
            if (!this._currentViewId.equals(comparable)) {
                throw new DCSViewChangeInProcessException("ViewId(" + comparable + ") is not equal to current ViewId(" + this._currentViewId + ")");
            }
            n = new Integer(this._rsMsgCounter);
            ++this._rsMsgCounter;
            this._waitingList.put(n, baseAckListener);
            byte by = bl ? (byte)112 : 113;
            VRIMessage vRIMessage = this.prepareMessage2Send(dCSMessage, by, n);
            this._appModule.mcastMessage(vRIMessage, this._rsMcastQoS, this._currentViewId);
            if (this._state == 1) {
                baseAckListener.handleFailedMembers(this._failedMembers);
            }
        }
        if (!bl) {
            baseAckListener.handleAck(this._thisMemberName, null);
        }
        baseAckListener.block();
        object = this._mutex;
        synchronized (object) {
            this._waitingList.remove(n);
        }
        if (!bl) {
            baseAckListener.getAcks().remove(this._thisMemberName);
        }
        switch (baseAckListener.getState()) {
            case 6: {
                return;
            }
            case 3: {
                throw new DCSViewChangeInProcessException();
            }
            case 4: {
                throw new DCSStackTerminatedException();
            }
            case 5: {
                throw new DCSRequestTimedOutException();
            }
        }
        throw new DCSInvalidListenerStateException("" + baseAckListener.getState());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final DCSMessage sendMessageWithAck(String string, DCSMessage dCSMessage, Comparable comparable) throws DCSException {
        Integer n = null;
        SingleAckListener singleAckListener = new SingleAckListener(string);
        Object object = this._mutex;
        synchronized (object) {
            if (this._currentViewId == null) {
                throw new DCSViewChangeInProcessException();
            }
            ViewIdImpl viewIdImpl = comparable != null ? (ViewIdImpl)comparable : this._currentViewId;
            VRIMemberDescription vRIMemberDescription = this._mgr.getViewMember(string);
            if (vRIMemberDescription == null) {
                String[] stringArray = VRIMemberUtils.getMemberNames(this._mgr.getViewMembers());
                throw new DCSMemberIsNotInViewException(string, stringArray);
            }
            if (this._state == 1 && vRIMemberDescription.isDenied()) {
                throw new DCSViewChangeInProcessException();
            }
            n = new Integer(this._rsMsgCounter);
            ++this._rsMsgCounter;
            this._waitingList.put(n, singleAckListener);
            VRIMessage vRIMessage = this.prepareMessage2Send(dCSMessage, (byte)112, n);
            this._appModule.sendMessage(vRIMessage, vRIMemberDescription, this._rsUcastQoS, viewIdImpl);
        }
        singleAckListener.block();
        object = this._mutex;
        synchronized (object) {
            this._waitingList.remove(n);
        }
        switch (singleAckListener.getState()) {
            case 6: {
                return singleAckListener.getAck(string);
            }
            case 3: {
                throw new DCSViewChangeInProcessException();
            }
            case 4: {
                throw new DCSStackTerminatedException();
            }
            case 5: {
                throw new DCSRequestTimedOutException();
            }
        }
        throw new DCSInvalidListenerStateException("" + singleAckListener.getState());
    }

    public final void sendMessageWithAck(String[] stringArray, DCSMessage dCSMessage, RSProvider.DCSAcksListener dCSAcksListener) throws DCSException {
        throw new DCSNotImplementedException();
    }

    private VRIMessage prepareMessage2Send(DCSMessage dCSMessage, byte by, Integer n) throws DCSException {
        if (!(dCSMessage instanceof DCSOutgoingMessage)) {
            DCSInvalidParametersException dCSInvalidParametersException = new DCSInvalidParametersException("Message is not DCSOutgoingMessage -  " + dCSMessage.getClass().getName());
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this._traceContext, "Trying to send message of unknown type", dCSInvalidParametersException);
                dCSTraceBuffer.invoke();
            }
            throw dCSInvalidParametersException;
        }
        VRIMessage vRIMessage = ((DCSOutgoingMessage)dCSMessage).toVRIMessage();
        vRIMessage.setMessageType(by);
        RSMessageHeader rSMessageHeader = new RSMessageHeader(n);
        vRIMessage.addHeader(rSMessageHeader);
        return vRIMessage;
    }

    protected void handleApplicationMessage(VRIMessage vRIMessage) {
        switch (vRIMessage.getMessageType()) {
            case 113: {
                if (vRIMessage.getSender().equals(this._thisMemberName)) {
                    return;
                }
            }
            case 112: {
                this.handleRSMessage(vRIMessage);
                break;
            }
            case 114: 
            case 115: {
                this.handleAck(vRIMessage);
                break;
            }
            default: {
                super.handleApplicationMessage(vRIMessage);
            }
        }
    }

    private void handleAck(VRIMessage vRIMessage) {
        BaseAckListener baseAckListener;
        RSMessageHeader rSMessageHeader = new RSMessageHeader();
        Integer n = null;
        if (vRIMessage.hasHeader((byte)8)) {
            try {
                rSMessageHeader = (RSMessageHeader)vRIMessage.extractHeader(rSMessageHeader);
            }
            catch (DCSVerisionIncompatibleException dCSVerisionIncompatibleException) {
                SuspectUnreadableMessageEvent suspectUnreadableMessageEvent = SuspectUnreadableMessageEvent.badHeader(this._traceContext, vRIMessage.getSender());
                suspectUnreadableMessageEvent.invokeNLSTrace();
                this.suspectMember(suspectUnreadableMessageEvent, 1, "Message version is incompatible");
                return;
            }
            n = rSMessageHeader.getRSID();
        }
        if ((baseAckListener = (BaseAckListener)this._waitingList.get(n)) == null) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.debug(this._traceContext, "handleAck", "Got unexpected ack");
            dCSTraceBuffer.addProperty("RSID", n);
            dCSTraceBuffer.invoke();
            return;
        }
        HandleAckJob handleAckJob = new HandleAckJob((DCSIncomingMessage)vRIMessage, baseAckListener);
        this._rsThread.enqueueJob(handleAckJob);
    }

    private void handleRSMessage(VRIMessage vRIMessage) {
        RSMessageHeader rSMessageHeader = new RSMessageHeader();
        if (vRIMessage.hasHeader((byte)8)) {
            try {
                rSMessageHeader = (RSMessageHeader)vRIMessage.extractHeader(rSMessageHeader);
            }
            catch (DCSVerisionIncompatibleException dCSVerisionIncompatibleException) {
                SuspectUnreadableMessageEvent suspectUnreadableMessageEvent = SuspectUnreadableMessageEvent.badHeader(this._traceContext, vRIMessage.getSender());
                suspectUnreadableMessageEvent.invokeNLSTrace();
                this.suspectMember(suspectUnreadableMessageEvent, 1, "Message version is incompatible");
                return;
            }
        }
        ViewIdImpl viewIdImpl = this._currentViewId != null ? this._currentViewId : this._previousViewId;
        HandleRSMessageJob handleRSMessageJob = new HandleRSMessageJob((DCSIncomingMessage)vRIMessage, rSMessageHeader, viewIdImpl);
        this._rsThread.enqueueJob(handleRSMessageJob);
    }

    protected void terminate() {
        ThreadManager.releaseThread(this._rsThreadOwner);
        Iterator iterator = this._waitingList.values().iterator();
        while (iterator.hasNext()) {
            BaseAckListener baseAckListener = (BaseAckListener)iterator.next();
            baseAckListener.terminate();
        }
        this._state = (byte)4;
        super.terminate();
    }

    protected void currentOK(CCVersion cCVersion) {
        if (1 == this._state) {
            Iterator iterator = this._waitingList.values().iterator();
            while (iterator.hasNext()) {
                BaseAckListener baseAckListener = (BaseAckListener)iterator.next();
                baseAckListener.abort();
            }
            this._state = (byte)2;
        }
        super.currentOK(cCVersion);
    }

    protected void newViewOK(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, Map map) {
        VRIMemberDescription[] vRIMemberDescriptionArray2 = this._mgr.getViewMembers();
        this._viewMembers = new HashSet();
        for (int i = 0; i < vRIMemberDescriptionArray2.length; ++i) {
            String string = vRIMemberDescriptionArray2[i].getName();
            this._viewMembers.add(string);
        }
        this._state = (byte)3;
        this._failedMembers = null;
        super.newViewOK(vRIMemberDescriptionArray, viewIdImpl, map);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleFailedMembers(String[] stringArray) {
        Object object = this._mutex;
        synchronized (object) {
            Iterator iterator = this._waitingList.values().iterator();
            while (iterator.hasNext()) {
                BaseAckListener baseAckListener = (BaseAckListener)iterator.next();
                baseAckListener.handleFailedMembers(stringArray);
            }
            this._state = 1;
            this._failedMembers = stringArray;
            super.handleFailedMembers(stringArray);
        }
    }

    public void setProtocol(int n, StateVersion stateVersion) {
    }

    private final class HandleRSMessageJob
    extends DCSStackImpl.ApplicationLayerJob {
        private final DCSIncomingMessage _message;
        private final RSMessageHeader _rsHeader;
        private final ViewId _vid;

        private HandleRSMessageJob(DCSIncomingMessage dCSIncomingMessage, RSMessageHeader rSMessageHeader, ViewId viewId) {
            super(DCSRSStackImpl.this);
            this._message = dCSIncomingMessage;
            this._rsHeader = rSMessageHeader;
            this._vid = viewId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() {
            block10: {
                Object object;
                DCSOutgoingMessage dCSOutgoingMessage = null;
                if (DCSRSStackImpl.this._appMessageListener instanceof DCSMessageListenerRS) {
                    object = (DCSMessageListenerRS)DCSRSStackImpl.this._appMessageListener;
                    dCSOutgoingMessage = (DCSOutgoingMessage)object.onMessageWithAck(this._message);
                } else {
                    DCSRSStackImpl.this._appMessageListener.onMessage(this._message);
                }
                if (dCSOutgoingMessage == null) {
                    dCSOutgoingMessage = (DCSOutgoingMessage)DCSRSStackImpl.this.createMessage(1024);
                    dCSOutgoingMessage.setMessageType((byte)115);
                } else {
                    dCSOutgoingMessage.setMessageType((byte)114);
                }
                try {
                    object = DCSRSStackImpl.this._mutex;
                    synchronized (object) {
                        if (this._vid == null || !this._vid.equals(DCSRSStackImpl.this._currentViewId)) {
                            return;
                        }
                        VRIMessage vRIMessage = dCSOutgoingMessage.toVRIMessage();
                        vRIMessage.addHeader(this._rsHeader);
                        VRIMemberDescription vRIMemberDescription = DCSRSStackImpl.this._mgr.getViewMember(this._message.getSender());
                        DCSRSStackImpl.this._appModule.sendMessage(vRIMessage, vRIMemberDescription, DCSRSStackImpl.this._rsUcastQoS, DCSRSStackImpl.this._currentViewId);
                    }
                }
                catch (DCSException dCSException) {
                    if (!DCSTraceBuffer.isInternalWarningEnabled(TC)) break block10;
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(DCSRSStackImpl.this._traceContext, "Failed to send ack", dCSException);
                    dCSTraceBuffer.invoke();
                }
            }
        }

        public void handleError(Throwable throwable) {
            CallbackFailedEvent callbackFailedEvent = new CallbackFailedEvent(DCSRSStackImpl.this._traceContext, "HandleRSMessageJob.process", throwable);
            DCSRSStackImpl.this.requestTermination(callbackFailedEvent);
        }

        public String getTraceName() {
            return "HandleRSMessageJob";
        }
    }

    private final class HandleAckJob
    extends DCSStackImpl.ApplicationLayerJob {
        private final String _sender;
        private final DCSIncomingMessage _ack;
        private final BaseAckListener _listener;

        private HandleAckJob(DCSIncomingMessage dCSIncomingMessage, BaseAckListener baseAckListener) {
            super(DCSRSStackImpl.this);
            this._sender = dCSIncomingMessage.getSender();
            this._ack = dCSIncomingMessage.getMessageType() == 114 ? dCSIncomingMessage : null;
            this._listener = baseAckListener;
        }

        public void process() {
            this._listener.handleAck(this._sender, this._ack);
        }

        public void handleError(Throwable throwable) {
            TerminationEvent terminationEvent = new TerminationEvent(DCSRSStackImpl.this._traceContext, "HandleAckJob.process", throwable);
            DCSRSStackImpl.this.requestTermination(terminationEvent);
        }

        public String getTraceName() {
            return "HandleAckJob";
        }
    }
}

