/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.rsmodule.impl;

import com.ibm.ws.dcs.common.exception.DCSVerisionIncompatibleException;
import com.ibm.ws.dcs.vri.common.Arrayable;
import com.ibm.ws.dcs.vri.common.Header;
import com.ibm.ws.dcs.vri.common.Utils;

final class RSMessageHeader
extends Header {
    private Integer _rsID = null;

    RSMessageHeader() {
        super((byte)8, 0x1000000);
    }

    RSMessageHeader(Integer n) {
        super((byte)8, 0x1000000);
        this._rsID = n;
    }

    public void toArray(byte[] byArray, Utils.Offset offset) {
        Utils.int2byteArray(this._version, byArray, offset);
        Utils.int2byteArray(this._rsID, byArray, offset);
    }

    public Arrayable fromArray(byte[] byArray, Utils.Offset offset) {
        int n = Utils.byteArray2int(byArray, offset);
        if (n != this._version) {
            throw new DCSVerisionIncompatibleException("My version is: " + Utils.getVersionAsString(this._version) + " received version is: " + Utils.getVersionAsString(n));
        }
        this._rsID = new Integer(Utils.byteArray2int(byArray, offset));
        return this;
    }

    public int getLength() {
        return 2 * Utils.sizeOfInt();
    }

    Integer getRSID() {
        return this._rsID;
    }
}

