/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.stat.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.stat.DCSStatsModule;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;

public class DCSInternalStatsModuleImpl
implements DCSStatsModule {
    private static final TraceComponent TC = Tr.register(DCSInternalStatsModuleImpl.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private static final String LAYER_NAME = "DCS_STAT_MODULE";
    public static final String PRINT_PREFIX = "DCSVIPMI";
    private static final String nl = System.getProperty("line.separator");
    private int _numOfReallocs;
    private AvgStat _outgoingMessageSize = new AvgStat();
    private int _outgoingMessageCounter;
    private AvgStat _incomingMessageSize = new AvgStat();
    private int _incomingMessageCounter;
    private TimeStat _vsCCTime = new TimeStat();
    private AvgStat _numOfVSCCMsgs = new AvgStat();
    private int _numOfVSTimeouts;
    private int _numOfTrCongestionEvents;
    private int _numOfMbrTimeouts;
    private TimeStat _coalesceTime = new TimeStat();
    private TimeStat _mergeTime = new TimeStat();
    private TimeStat _splitTime = new TimeStat();
    private int _numOfSuspects;
    private int _numOfViews;
    private AvgStat _groupSize = new AvgStat();
    private final DCSTraceContext _traceContext;

    public static final synchronized DCSStatsModule getInstance(String string, String string2) {
        Object object;
        DCSTraceContextImpl dCSTraceContextImpl = new DCSTraceContextImpl(TC, string, string2, LAYER_NAME);
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(dCSTraceContextImpl, "getInstance", "");
            ((DCSTraceBuffer)object).invoke();
        }
        object = new DCSInternalStatsModuleImpl(dCSTraceContextImpl);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(dCSTraceContextImpl, "getInstance", "");
            dCSTraceBuffer.addProperty("DCSStatModuleInstance", object);
            dCSTraceBuffer.invoke();
        }
        return object;
    }

    private DCSInternalStatsModuleImpl(DCSTraceContext dCSTraceContext) {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(dCSTraceContext, "DCSInternalStatsModuleImpl", "");
            dCSTraceBuffer.invoke();
        }
        this._traceContext = dCSTraceContext;
    }

    public final synchronized void onRealloc() {
        ++this._numOfReallocs;
    }

    public final synchronized void onMsgSent(int n) {
        if (this._outgoingMessageSize != null) {
            this._outgoingMessageSize.add(n);
        }
        ++this._outgoingMessageCounter;
    }

    public final synchronized void onMsgReceived(int n) {
        if (this._incomingMessageSize != null) {
            this._incomingMessageSize.add(n);
        }
        ++this._incomingMessageCounter;
    }

    public final void updateStatisticOnRequest(int n) {
    }

    public final synchronized void onViewChange(int n, int n2, int n3) {
        ++this._numOfViews;
        if (this._groupSize != null) {
            this._groupSize.add(n3);
        }
        switch (n) {
            case 1: {
                if (this._splitTime == null) break;
                this._splitTime.add(n2);
                break;
            }
            case 2: {
                if (this._mergeTime == null) break;
                this._mergeTime.add(n2);
                break;
            }
            default: {
                if (!DCSTraceBuffer.isInternalWarningEnabled(TC)) break;
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this._traceContext, "Unknown view change type", null);
                dCSTraceBuffer.addProperty("ViewChangeType", n);
                dCSTraceBuffer.invoke();
            }
        }
    }

    public final synchronized void onSuspect() {
        ++this._numOfSuspects;
    }

    public final synchronized void onCoalsceEvent(int n) {
        if (this._coalesceTime != null) {
            this._coalesceTime.add(n);
        }
    }

    public final synchronized void onMbrTimeout() {
        ++this._numOfMbrTimeouts;
    }

    public final synchronized void onTransmitterCongestionEvent() {
        ++this._numOfTrCongestionEvents;
    }

    public final synchronized void onVSTimeout() {
        ++this._numOfVSTimeouts;
    }

    public final synchronized void onCCOK(int n, int n2) {
        if (this._numOfVSCCMsgs != null) {
            this._numOfVSCCMsgs.add(n2);
        }
        if (this._vsCCTime != null) {
            this._vsCCTime.add(n);
        }
    }

    public synchronized void destroy() {
    }

    public synchronized String dump() {
        return "DCSVIPMI=S============================DCSVIPMIStatistics for stack " + this._traceContext.getStackName() + ", member " + this._traceContext.getMemberName() + nl + PRINT_PREFIX + "Number of reallocs: " + this._numOfReallocs + nl + PRINT_PREFIX + "Outgoing message size: " + this._outgoingMessageSize + nl + PRINT_PREFIX + "Outgoing message count: " + this._outgoingMessageCounter + nl + PRINT_PREFIX + "Incoming message size: " + this._incomingMessageSize + nl + PRINT_PREFIX + "Incoming message count: " + this._incomingMessageCounter + nl + PRINT_PREFIX + "VS completion time: " + this._vsCCTime + nl + PRINT_PREFIX + "Number of VS completion messages: " + this._numOfVSCCMsgs + nl + PRINT_PREFIX + "Number of VS timeouts: " + this._numOfVSTimeouts + nl + PRINT_PREFIX + "Number of Congestion Events: " + this._numOfTrCongestionEvents + nl + PRINT_PREFIX + "Number of Mbr Timeouts: " + this._numOfMbrTimeouts + nl + PRINT_PREFIX + "Coalesce time: " + this._coalesceTime + nl + PRINT_PREFIX + "Merge time: " + this._mergeTime + nl + PRINT_PREFIX + "Split time: " + this._splitTime + nl + PRINT_PREFIX + "Number of suspicions: " + this._numOfSuspects + nl + PRINT_PREFIX + "Number of views: " + this._numOfViews + nl + PRINT_PREFIX + "Group size: " + this._groupSize + nl + PRINT_PREFIX + "=E===========================";
    }

    public synchronized void setInternalStatCollection(boolean bl) {
    }

    public synchronized boolean getInternalStatCollection() {
        return true;
    }

    private class TimeStat {
        long _count = 0L;
        double _total = 0.0;
        long _min;
        long _max;

        TimeStat() {
        }

        void add(long l) {
            if (this._count == 0L || l < this._min) {
                this._min = l;
            }
            if (this._count == 0L || l > this._max) {
                this._max = l;
            }
            ++this._count;
            this._total += (double)l;
        }

        public String toString() {
            return this._count == 0L ? "no samples" : "min: " + (double)this._min * 1.0 / 1000.0 + "seconds, max: " + (double)this._max * 1.0 / 1000.0 + "seconds, avg: " + this._total * 1.0 / ((double)this._count * 1000.0) + " count: " + this._count;
        }
    }

    private class AvgStat {
        long _count = 0L;
        long _total = 0L;
        int _min;
        int _max;

        AvgStat() {
        }

        void add(int n) {
            if (this._count == 0L || n < this._min) {
                this._min = n;
            }
            if (this._count == 0L || n > this._max) {
                this._max = n;
            }
            ++this._count;
            this._total += (long)n;
        }

        public String toString() {
            return this._count == 0L ? "no samples" : "min: " + this._min + ", max: " + this._max + ", avg: " + (double)this._total * 1.0 / ((double)this._count * 1.0) + " count: " + this._count;
        }
    }
}

