/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.stat.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.stat.DCSStatsModule;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import com.ibm.wsspi.pmi.factory.StatisticActionListener;
import com.ibm.wsspi.pmi.factory.StatsFactory;
import com.ibm.wsspi.pmi.factory.StatsFactoryException;
import com.ibm.wsspi.pmi.factory.StatsGroup;
import com.ibm.wsspi.pmi.factory.StatsInstance;
import com.ibm.wsspi.pmi.factory.StatsTemplateLookup;
import com.ibm.wsspi.pmi.stat.SPIAverageStatistic;
import com.ibm.wsspi.pmi.stat.SPICountStatistic;
import com.ibm.wsspi.pmi.stat.SPIStatistic;
import com.ibm.wsspi.pmi.stat.SPITimeStatistic;

public class DCSStatsModuleImpl
implements StatisticActionListener,
DCSStatsModule {
    private static final TraceComponent TC = Tr.register(DCSStatsModuleImpl.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private static final String LAYER_NAME = "DCS_STAT_MODULE";
    private static StatsGroup _dcsStatsGroup;
    private StatsInstance _statsInstance;
    private SPICountStatistic _numOfReallocs;
    private SPIAverageStatistic _outgoingMessageSize;
    private SPICountStatistic _outgoingMessageCounter;
    private SPIAverageStatistic _incomingMessageSize;
    private SPICountStatistic _incomingMessageCounter;
    private SPITimeStatistic _vsCCTime;
    private SPIAverageStatistic _numOfVSCCMsgs;
    private SPICountStatistic _numOfVSTimeouts;
    private SPICountStatistic _numOfTrCongestionEvents;
    private SPICountStatistic _numOfMbrTimeouts;
    private SPITimeStatistic _coalesceTime;
    private SPITimeStatistic _mergeTime;
    private SPITimeStatistic _splitTime;
    private SPICountStatistic _numOfSuspects;
    private SPICountStatistic _numOfViews;
    private SPIAverageStatistic _groupSize;
    private final DCSTraceContext _traceContext;

    public static final synchronized DCSStatsModule getInstance(String string, String string2) {
        Object object;
        Object object2;
        DCSTraceContextImpl dCSTraceContextImpl;
        block12: {
            dCSTraceContextImpl = new DCSTraceContextImpl(TC, string, string2, LAYER_NAME);
            if (DCSTraceBuffer.isEntryEnabled(TC)) {
                object2 = DCSTraceBuffer.entry(dCSTraceContextImpl, "getInstance", "");
                ((DCSTraceBuffer)object2).invoke();
            }
            object2 = null;
            try {
                if (StatsFactory.isPMIEnabled()) {
                    if (DCSTraceBuffer.isEventEnabled(TC)) {
                        object = DCSTraceBuffer.event(dCSTraceContextImpl, "getInstance", "PMI is enabled");
                        ((DCSTraceBuffer)object).invoke();
                    }
                    if (_dcsStatsGroup == null) {
                        if (DCSTraceBuffer.isEventEnabled(TC)) {
                            object = DCSTraceBuffer.event(dCSTraceContextImpl, "getInstance", "_dcsStatsGroup is null - create");
                            ((DCSTraceBuffer)object).invoke();
                        }
                        try {
                            object = Class.forName("com.ibm.ws.pmi.preprocess.dcs_impl_StatsTemplateLookup");
                            StatsFactory.registerStatsTemplateLookup((StatsTemplateLookup)((Class)object).newInstance());
                        }
                        catch (Exception exception) {
                            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(dCSTraceContextImpl, "getInstance", "PMI StatsTemplateLookup class not found.");
                            dCSTraceBuffer.addProperty("ReasonException", exception);
                            dCSTraceBuffer.invoke();
                        }
                        _dcsStatsGroup = StatsFactory.createStatsGroup("DCSStats.Group", "/com/ibm/ws/dcs/stat/DCSStats.xml", null);
                        if (DCSTraceBuffer.isEventEnabled(TC)) {
                            object = DCSTraceBuffer.event(dCSTraceContextImpl, "getInstance", "_dcsStatsGroup successfully created");
                            ((DCSTraceBuffer)object).addProperty("DCSStatsGroup", _dcsStatsGroup);
                            ((DCSTraceBuffer)object).invoke();
                        }
                    }
                    object2 = new DCSStatsModuleImpl(dCSTraceContextImpl);
                    break block12;
                }
                if (TC.isEventEnabled()) {
                    Tr.event(TC, "getInstance(): PMI is disabled");
                }
            }
            catch (Throwable throwable) {
                if (!DCSTraceBuffer.isInternalInfoEnabled(TC)) break block12;
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalInfo(dCSTraceContextImpl, "Failed to create DCS Statistics Module");
                dCSTraceBuffer.addProperty("ReasonException", throwable);
                dCSTraceBuffer.invoke();
            }
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            object = DCSTraceBuffer.exit(dCSTraceContextImpl, "getInstance", "");
            ((DCSTraceBuffer)object).addProperty("DCSStatModuleInstance", object2);
            ((DCSTraceBuffer)object).invoke();
        }
        return object2;
    }

    private DCSStatsModuleImpl(DCSTraceContext dCSTraceContext) {
        DCSTraceBuffer dCSTraceBuffer;
        block5: {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.event(dCSTraceContext, "DCSStatsModuleImpl", "");
                dCSTraceBuffer.invoke();
            }
            this._traceContext = dCSTraceContext;
            try {
                this._statsInstance = StatsFactory.createStatsInstance(this._traceContext.getStackName(), _dcsStatsGroup, null, (StatisticActionListener)this);
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "DCSStatsModuleImpl", "Statistics instance was successfully created");
                    dCSTraceBuffer.addProperty("StatisticsInstance", this._statsInstance);
                    dCSTraceBuffer.invoke();
                }
            }
            catch (StatsFactoryException statsFactoryException) {
                if (!DCSTraceBuffer.isInternalWarningEnabled(TC)) break block5;
                DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.internalWarning(this._traceContext, "Failed to create statistics instance", statsFactoryException);
                dCSTraceBuffer2.invoke();
            }
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "DCSStatsModuleImpl", "");
            dCSTraceBuffer.invoke();
        }
    }

    public synchronized void statisticCreated(SPIStatistic sPIStatistic) {
        DCSTraceBuffer dCSTraceBuffer;
        if (sPIStatistic == null) {
            return;
        }
        int n = sPIStatistic.getId();
        boolean bl = true;
        switch (n) {
            case 1: {
                this._numOfReallocs = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 2: {
                this._outgoingMessageSize = (SPIAverageStatistic)sPIStatistic;
                break;
            }
            case 3: {
                this._outgoingMessageCounter = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 4: {
                this._incomingMessageSize = (SPIAverageStatistic)sPIStatistic;
                break;
            }
            case 5: {
                this._incomingMessageCounter = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 6: {
                this._vsCCTime = (SPITimeStatistic)sPIStatistic;
                break;
            }
            case 7: {
                this._numOfVSCCMsgs = (SPIAverageStatistic)sPIStatistic;
                break;
            }
            case 8: {
                this._numOfVSTimeouts = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 9: {
                this._numOfTrCongestionEvents = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 10: {
                this._numOfMbrTimeouts = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 11: {
                this._coalesceTime = (SPITimeStatistic)sPIStatistic;
                break;
            }
            case 12: {
                this._mergeTime = (SPITimeStatistic)sPIStatistic;
                break;
            }
            case 13: {
                this._splitTime = (SPITimeStatistic)sPIStatistic;
                break;
            }
            case 14: {
                this._numOfSuspects = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 15: {
                this._numOfViews = (SPICountStatistic)sPIStatistic;
                break;
            }
            case 16: {
                this._groupSize = (SPIAverageStatistic)sPIStatistic;
                break;
            }
            default: {
                if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                    dCSTraceBuffer = DCSTraceBuffer.internalWarning(this._traceContext, "Unknown statistics ID", null);
                    dCSTraceBuffer.addProperty("StatisticsID", String.valueOf(n));
                    dCSTraceBuffer.invoke();
                }
                bl = false;
            }
        }
        if (bl && DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "statisticCreated", "");
            dCSTraceBuffer.addProperty("StatisticsID", n);
            dCSTraceBuffer.addProperty("StatisticsInstance", sPIStatistic);
            dCSTraceBuffer.invoke();
        }
    }

    public final synchronized void onRealloc() {
        if (this._numOfReallocs != null) {
            this._numOfReallocs.increment();
        }
    }

    public final synchronized void onMsgSent(int n) {
        if (this._outgoingMessageSize != null) {
            this._outgoingMessageSize.add(n);
        }
        if (this._outgoingMessageCounter != null) {
            this._outgoingMessageCounter.increment();
        }
    }

    public final synchronized void onMsgReceived(int n) {
        if (this._incomingMessageSize != null) {
            this._incomingMessageSize.add(n);
        }
        if (this._incomingMessageCounter != null) {
            this._incomingMessageCounter.increment();
        }
    }

    public final void updateStatisticOnRequest(int n) {
    }

    public final synchronized void onViewChange(int n, int n2, int n3) {
        if (this._numOfViews != null) {
            this._numOfViews.increment();
        }
        if (this._groupSize != null) {
            this._groupSize.add(n3);
        }
        switch (n) {
            case 1: {
                if (this._splitTime == null) break;
                this._splitTime.add(n2);
                break;
            }
            case 2: {
                if (this._mergeTime == null) break;
                this._mergeTime.add(n2);
                break;
            }
            default: {
                if (!DCSTraceBuffer.isInternalWarningEnabled(TC)) break;
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this._traceContext, "Unknown view change type", null);
                dCSTraceBuffer.addProperty("ViewChangeType", n);
                dCSTraceBuffer.invoke();
            }
        }
    }

    public final synchronized void onSuspect() {
        if (this._numOfSuspects != null) {
            this._numOfSuspects.increment();
        }
    }

    public final synchronized void onCoalsceEvent(int n) {
        if (this._coalesceTime != null) {
            this._coalesceTime.add(n);
        }
    }

    public final synchronized void onMbrTimeout() {
        if (this._numOfMbrTimeouts != null) {
            this._numOfMbrTimeouts.increment();
        }
    }

    public final synchronized void onTransmitterCongestionEvent() {
        if (this._numOfTrCongestionEvents != null) {
            this._numOfTrCongestionEvents.increment();
        }
    }

    public final synchronized void onVSTimeout() {
        if (this._numOfVSTimeouts != null) {
            this._numOfVSTimeouts.increment();
        }
    }

    public final synchronized void onCCOK(int n, int n2) {
        if (this._numOfVSCCMsgs != null) {
            this._numOfVSCCMsgs.add(n2);
        }
        if (this._vsCCTime != null) {
            this._vsCCTime.add(n);
        }
    }

    public synchronized void destroy() {
        block4: {
            if (this._statsInstance == null) {
                return;
            }
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "destroy", "Destroing DCSStats instance");
                dCSTraceBuffer.invoke();
            }
            try {
                StatsFactory.removeStatsInstance(this._statsInstance);
            }
            catch (StatsFactoryException statsFactoryException) {
                if (!DCSTraceBuffer.isInternalWarningEnabled(TC)) break block4;
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this._traceContext, "Failed to destroy DCSStats instance", statsFactoryException);
                dCSTraceBuffer.invoke();
            }
        }
        this._statsInstance = null;
        this._numOfReallocs = null;
        this._outgoingMessageSize = null;
        this._outgoingMessageCounter = null;
        this._incomingMessageSize = null;
        this._incomingMessageCounter = null;
        this._vsCCTime = null;
        this._numOfVSCCMsgs = null;
        this._numOfVSTimeouts = null;
        this._numOfTrCongestionEvents = null;
        this._numOfMbrTimeouts = null;
        this._coalesceTime = null;
        this._mergeTime = null;
        this._splitTime = null;
        this._numOfSuspects = null;
        this._numOfViews = null;
        this._groupSize = null;
    }
}

