/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.utils.Alarm;
import com.ibm.ws.dcs.utils.AlarmListener;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import java.util.TimerTask;

abstract class AlarmImpl
implements Alarm {
    private static final TraceComponent TC = Tr.register(AlarmImpl.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private static final DCSTraceContext _traceContext = new DCSTraceContextImpl(TC, null, null, "");
    private final AlarmListener _alarmListener;
    private final Object _alarmContext;
    private final Object _alarmLock;
    protected volatile AlarmTask _alarmTask;

    protected AlarmImpl(AlarmListener alarmListener, Object object, Object object2) {
        this._alarmLock = object;
        this._alarmContext = object2;
        this._alarmListener = alarmListener;
        this._alarmTask = new AlarmTask();
    }

    public void cancel() {
        if (this._alarmLock != null) {
            this.cancelAlarmWithLock();
        } else {
            this.cancelAlarm();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cancelAlarmWithLock() {
        Object object = this._alarmLock;
        synchronized (object) {
            this.cancelAlarm();
        }
    }

    private void cancelAlarm() {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "cancelAlarm", new Object[]{this, this._alarmListener, this._alarmContext, this._alarmTask});
        }
        boolean bl = false;
        if (this._alarmTask != null) {
            this._alarmTask = null;
            this.doCancel();
            bl = true;
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "cancelAlarm", new Object[]{this, new Boolean(bl)});
        }
    }

    protected abstract void doCancel();

    private final class AlarmTask
    extends TimerTask
    implements com.ibm.ejs.util.am.AlarmListener {
        private AlarmTask() {
        }

        public void alarm(Object object) {
            this.run();
        }

        public void run() {
            boolean bl;
            block4: {
                if (TC.isEntryEnabled()) {
                    Tr.entry(TC, "AlarmTask.run", new Object[]{AlarmImpl.this._alarmListener, AlarmImpl.this._alarmContext, AlarmImpl.this._alarmTask});
                }
                bl = false;
                try {
                    bl = AlarmImpl.this._alarmLock != null ? this.executeWithLock() : this.execute();
                }
                catch (Throwable throwable) {
                    if (!DCSTraceBuffer.isInternalWarningEnabled(TC)) break block4;
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(_traceContext, "Call to AlarmListener failed.", throwable);
                    dCSTraceBuffer.addProperty("AlarmListener", AlarmImpl.this._alarmListener);
                    dCSTraceBuffer.addProperty("AlarmContext", AlarmImpl.this._alarmContext);
                    dCSTraceBuffer.invoke();
                }
            }
            if (TC.isEntryEnabled()) {
                Tr.exit(TC, "AlarmTask.run", new Object[]{new Boolean(bl)});
            }
        }

        private boolean execute() {
            boolean bl = false;
            if (AlarmImpl.this._alarmTask != null) {
                AlarmImpl.this._alarmTask = null;
                AlarmImpl.this._alarmListener.alarm(AlarmImpl.this._alarmContext);
                bl = true;
            }
            return bl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean executeWithLock() {
            Object object = AlarmImpl.this._alarmLock;
            synchronized (object) {
                return this.execute();
            }
        }
    }
}

