/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.utils;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.utils.Alarm;
import com.ibm.ws.dcs.utils.AlarmListener;
import com.ibm.ws.dcs.utils.DCSAlarmImpl;
import com.ibm.ws.dcs.utils.WASAlarmImpl;
import java.security.AccessController;
import java.security.PrivilegedAction;

public final class AlarmManager {
    public static final AlarmType DISCOVERY_ALARM;
    public static final AlarmType TA_ALARM;
    public static final AlarmType GENERAL_ALARM;
    public static final String USE_WAS_ALARMS = "USE_WAS_ALARMS";
    private static final TraceComponent TC;
    private static final boolean _useWASAlarms;

    private AlarmManager() {
    }

    public static final Alarm create(AlarmType alarmType, long l, Object object, AlarmListener alarmListener, Object object2) {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "create", new Object[]{new Long(l), alarmListener, object2});
        }
        Alarm alarm = _useWASAlarms ? WASAlarmImpl.getInstance(alarmType, l, object, alarmListener, object2) : DCSAlarmImpl.getInstance(alarmType, l, object, alarmListener, object2);
        if (TC.isEventEnabled()) {
            Tr.event(TC, "Alarm created: " + String.valueOf(alarm));
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "create", alarm);
        }
        return alarm;
    }

    public static final Alarm create(AlarmType alarmType, long l, Object object, AlarmListener alarmListener) {
        return AlarmManager.create(alarmType, l, object, alarmListener, null);
    }

    static {
        String string;
        DISCOVERY_ALARM = new AlarmType(1);
        TA_ALARM = new AlarmType(2);
        GENERAL_ALARM = new AlarmType(3);
        TC = Tr.register(AlarmManager.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
        try {
            string = (String)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    return System.getProperty(AlarmManager.USE_WAS_ALARMS, "true");
                }
            });
        }
        catch (Throwable throwable) {
            string = "true";
        }
        _useWASAlarms = Boolean.valueOf(string);
    }

    static final class AlarmType {
        private final int _type;

        AlarmType(int n) {
            this._type = n;
        }

        int getType() {
            return this._type;
        }
    }
}

