/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common;

import com.ibm.ws.dcs.drsmodule.impl.DRSDataStackImpl;
import com.ibm.ws.dcs.vri.common.Globals;
import com.ibm.ws.dcs.vri.common.MismatchingParamRecord;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import java.io.Serializable;
import java.util.Map;
import java.util.Vector;

public class ConfigurationComparator {
    private Globals _globals;

    public ConfigurationComparator(Globals globals) {
        this._globals = globals;
    }

    public String getConfiguratorVersion() {
        Map map = (Map)this._globals.getConfig().get("ORIGINAL_CONFIG_MAP");
        return (String)map.get("DCSConfigurationVersion");
    }

    public int[] getDefinedSetNameHashcode(String[] stringArray) {
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            nArray[i] = stringArray[i].hashCode();
        }
        return nArray;
    }

    public int[] getDefinedSetAddressHashcode(VRIMemberDescription[] vRIMemberDescriptionArray) {
        int[] nArray = new int[vRIMemberDescriptionArray.length];
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            nArray[i] = vRIMemberDescriptionArray[i].hashCode();
        }
        return nArray;
    }

    public Serializable[] getErrorParams() {
        Vector vector = this.extractErrorParams();
        Serializable[] serializableArray = new Serializable[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            serializableArray[i] = (Serializable)vector.elementAt(i);
        }
        return serializableArray;
    }

    public int getErrorParamsHashcode() {
        return this.extractErrorParams().hashCode();
    }

    public MismatchingParamRecord[] compareErrorParams(Serializable[] serializableArray) {
        Vector vector = this.extractErrorParams();
        ConfigurationComparator.removeNulls(vector, serializableArray);
        Vector<MismatchingParamRecord> vector2 = new Vector<MismatchingParamRecord>();
        Vector vector3 = null;
        int n = serializableArray.length;
        if (n > vector.size()) {
            n = vector.size();
        }
        for (int i = 0; i < n; ++i) {
            if (serializableArray[i].equals(vector.elementAt(i))) continue;
            if (vector3 == null) {
                vector3 = this.getErrorParamList();
            }
            vector2.add(new MismatchingParamRecord((String)vector3.elementAt(i), serializableArray[i].toString(), vector.elementAt(i).toString()));
        }
        if (vector.size() != serializableArray.length) {
            vector2.add(new MismatchingParamRecord("Different number of parameters", "" + serializableArray.length, "" + vector.size()));
        }
        MismatchingParamRecord[] mismatchingParamRecordArray = new MismatchingParamRecord[vector2.size()];
        for (int i = 0; i < vector2.size(); ++i) {
            mismatchingParamRecordArray[i] = (MismatchingParamRecord)vector2.elementAt(i);
        }
        return mismatchingParamRecordArray;
    }

    public Serializable[] getWarningParams() {
        Vector vector = this.extractWarningParams();
        Serializable[] serializableArray = new Serializable[vector.size()];
        for (int i = 0; i < vector.size(); ++i) {
            serializableArray[i] = (Serializable)vector.elementAt(i);
        }
        return serializableArray;
    }

    public int getWarningParamsHashcode() {
        return this.extractWarningParams().hashCode();
    }

    public MismatchingParamRecord[] compareWarningParams(Serializable[] serializableArray) {
        Vector vector = this.extractWarningParams();
        ConfigurationComparator.removeNulls(vector, serializableArray);
        ConfigurationComparator.dcsAssert(serializableArray.length == vector.size(), "Parameter lists of different length", "ConfigurationComparator", "compareWarningParams", this._globals.getGroupName());
        Vector<MismatchingParamRecord> vector2 = new Vector<MismatchingParamRecord>();
        Vector vector3 = null;
        for (int i = 0; i < serializableArray.length; ++i) {
            if (serializableArray[i].equals(vector.elementAt(i))) continue;
            if (vector3 == null) {
                vector3 = this.getWarningParamList();
            }
            vector2.add(new MismatchingParamRecord((String)vector3.elementAt(i), serializableArray[i].toString(), vector.elementAt(i).toString()));
        }
        MismatchingParamRecord[] mismatchingParamRecordArray = new MismatchingParamRecord[vector2.size()];
        for (int i = 0; i < vector2.size(); ++i) {
            mismatchingParamRecordArray[i] = (MismatchingParamRecord)vector2.elementAt(i);
        }
        return mismatchingParamRecordArray;
    }

    private Vector extractErrorParams() {
        Object object;
        Map map = (Map)this._globals.getConfig().get("ORIGINAL_CONFIG_MAP");
        Vector<Object> vector = new Vector<Object>();
        Map map2 = (Map)map.get("StackConstruction");
        vector.add(map2.get("enableVerificationMode"));
        vector.add(map2.get("useVirtualSynchronyMessaging"));
        String string = (String)map.get("FailureDetectorType");
        vector.add(string);
        if (string.equals("BasicHBT")) {
            object = (Map)map.get("FailureDetectorParameters");
            vector.add(object.get("HBTTimeoutPeriod"));
            vector.add(object.get("HBTTransmissionIntervalMilliSec"));
        }
        vector.add(map.get("ExpectedBringupTimeSec"));
        vector.add(map.get("CompletenessVsSpeed"));
        if (this._globals.isCoreStack()) {
            object = (String)map.get("TransportType");
            vector.add(object);
            if (((String)object).equals("RealMulticast")) {
                Map map3 = (Map)map.get("TransportConfiguration");
                vector.add(map3.get("MulticastGroupRangeStart"));
                vector.add(map3.get("MulticastGroupRangeEnd"));
                vector.add(map3.get("MulticastTransportProtocol"));
            }
        } else {
            object = (Class)map.get("DataStackType");
            vector.add(((Class)object).getName());
            if (object.equals(DRSDataStackImpl.class)) {
                Map map4 = (Map)map.get("SpecificDataStackConfiguration");
                Boolean bl = (Boolean)map4.get("USE_2_PHASE_DATA_REQUEST");
                vector.add(bl);
            }
        }
        return vector;
    }

    private Vector extractWarningParams() {
        Map map = (Map)this._globals.getConfig().get("ORIGINAL_CONFIG_MAP");
        Vector vector = new Vector();
        vector.add(map.get("MaxStackMemoryMB"));
        if (this._globals.isCoreStack()) {
            String string = (String)map.get("TransportType");
            Map map2 = (Map)map.get("TransportConfiguration");
            vector.add(map2.get("MaxInstanceMemoryMbytes"));
            vector.add(map2.get("NominalInstanceMemoryMbytes"));
            if (string.equals("RealMulticast")) {
                vector.add(map2.get("MulticastTTL"));
            }
        }
        return vector;
    }

    private Vector getErrorParamList() {
        Map map = (Map)this._globals.getConfig().get("ORIGINAL_CONFIG_MAP");
        Vector<String> vector = new Vector<String>();
        vector.add("ENABLE_VERIFICATION_MODE");
        vector.add("USE_VIRTUAL_SYNCHRONY_MESSAGING");
        vector.add("FAILURE_DETECTOR_TYPE");
        String string = (String)map.get("FailureDetectorType");
        if (string.equals("BasicHBT")) {
            vector.add("HBT_TIMEOUT_PERIOD");
            vector.add("HBT_TRANSMISSION_INTERVAL_MSEC");
        }
        vector.add("EXPECTED_BRINGUP_TIME_SEC");
        vector.add("COMPLETENESS_VS_SPEED");
        if (this._globals.isCoreStack()) {
            String string2 = (String)map.get("TransportType");
            vector.add("TRANSPORT_TYPE");
            if (string2.equals("RealMulticast")) {
                vector.add("MULTICAST_GROUP_RANGE_START");
                vector.add("MULTICAST_GROUP_RANGE_END");
                vector.add("MULTICAST_TRANSPORT_PROTOCOL");
            }
        } else {
            Class clazz = (Class)map.get("DataStackType");
            vector.add("DATA_STACK_TYPE");
            if (clazz.equals(DRSDataStackImpl.class)) {
                vector.add("USE_2_PHASE_DATA_REQUEST");
            }
        }
        return vector;
    }

    private Vector getWarningParamList() {
        Map map = (Map)this._globals.getConfig().get("ORIGINAL_CONFIG_MAP");
        Vector<String> vector = new Vector<String>();
        vector.add("MAX_STACK_MEMORY_MB");
        if (this._globals.isCoreStack()) {
            String string = (String)map.get("TransportType");
            vector.add("MAX_INSTANCE_MEMORY_MBYTES");
            vector.add("NOMINAL_INSTANCE_MEMORY_MBYTES");
            if (string.equals("RealMulticast")) {
                vector.add("MULTICAST_TTL");
            }
        }
        return vector;
    }

    private static final void removeNulls(Vector vector, Serializable[] serializableArray) {
        int n;
        for (n = 0; n < serializableArray.length; ++n) {
            if (serializableArray[n] != null) continue;
            serializableArray[n] = "null";
        }
        for (n = 0; n < vector.size(); ++n) {
            if (vector.elementAt(n) != null) continue;
            vector.setElementAt("null", n);
        }
    }

    private static final void dcsAssert(boolean bl, String string, String string2, String string3, String string4) {
    }
}

