/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.MemberInfoManager;
import com.ibm.ws.dcs.common.StateVersion;
import com.ibm.ws.dcs.common.exception.DCSException;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.stat.DCSStatsModule;
import com.ibm.ws.dcs.stat.impl.DCSInternalStatsModuleImpl;
import com.ibm.ws.dcs.stat.impl.DCSStatsModuleImpl;
import com.ibm.ws.dcs.vri.common.DCSDumpException;
import com.ibm.ws.dcs.vri.common.MetaMessageFactory;
import com.ibm.ws.dcs.vri.common.VRIMembersMGR;
import com.ibm.ws.dcs.vri.common.impl.DCSConfig;
import com.ibm.ws.dcs.vri.common.impl.DCSMessageFactory;
import com.ibm.ws.dcs.vri.common.impl.Sidecall;
import com.ibm.ws.dcs.vri.common.util.DCSDiagnosticModule;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import com.ibm.ws.dcs.vri.common.util.FFDCDumpable;
import java.text.SimpleDateFormat;
import java.util.Map;
import java.util.TimeZone;

public final class Globals
implements DCSTraceContext {
    private static final TraceComponent TC = Tr.register(Globals.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private final boolean _isCoreStack;
    private boolean _needsViewApproval;
    private static final DCSDiagnosticModule _diagnosticModule = new DCSDiagnosticModule();
    public static final String EOL = "\n";
    public static final SimpleDateFormat formatter = new SimpleDateFormat("[dd/MM/yy HH:mm:ss:SSS z]");
    private final Object _mutex;
    private final VRIMembersMGR _mmgr;
    private final String _groupName;
    private final MetaMessageFactory _mmf;
    private final DCSMessageFactory _messageFactory;
    private final DCSConfig _config;
    private final String _thisMemberName;
    private final MemberInfoManager _mim;
    private boolean _goingToTerminate;
    public DCSStatsModule statsModule;
    private final boolean internalPMI;
    public int _protocolVersion;

    public Globals(String string, DCSConfig dCSConfig, Sidecall sidecall, MemberInfoManager memberInfoManager, boolean bl) throws DCSException {
        block4: {
            this._needsViewApproval = false;
            this._goingToTerminate = false;
            this.statsModule = null;
            this._groupName = string;
            this._config = dCSConfig;
            this._thisMemberName = (String)this._config.get("ThisMemberName");
            Map map = (Map)this._config.get("DefinedSet");
            String string2 = (String)this._config.get("ThisMemberName");
            this._protocolVersion = (Integer)this._config.get("DCSProtocolVersion");
            this.internalPMI = (Boolean)this._config.get("DCSInternalPMI");
            this._mutex = new DCSStackMutex(string);
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "Globals", "Stack lock was created");
                dCSTraceBuffer.addProperty("Mutex", this._mutex);
                dCSTraceBuffer.invoke();
            }
            this._mmgr = new VRIMembersMGR(string, string2, map, this._protocolVersion);
            this._mmf = new MetaMessageFactory();
            if (memberInfoManager == null) {
                throw new DCSInvalidParametersException("MembersInfoManager is null");
            }
            this._mim = memberInfoManager;
            this._isCoreStack = bl;
            try {
                this.statsModule = this.internalPMI ? DCSInternalStatsModuleImpl.getInstance(this._groupName, string2) : DCSStatsModuleImpl.getInstance(this._groupName, string2);
            }
            catch (Throwable throwable) {
                if (!DCSTraceBuffer.isInternalWarningEnabled(TC)) break block4;
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "failed to create DCSStatsModule", throwable);
                dCSTraceBuffer.invoke();
            }
        }
        this._messageFactory = new DCSMessageFactory(this.statsModule);
        this._messageFactory.setDefaultMessageSize(this.getConfigParamAsInt("AM_DEFAULT_MESSAGE_SIZE"));
        this._mmf.registerMessageFactory(this._messageFactory);
        this._needsViewApproval = this._protocolVersion <= 51001;
    }

    public Object getMutex() {
        return this._mutex;
    }

    public VRIMembersMGR getVRIMembersMgr() {
        return this._mmgr;
    }

    public boolean isCoreStack() {
        return this._isCoreStack;
    }

    public MetaMessageFactory getMetaMessageFactory() {
        return this._mmf;
    }

    public DCSMessageFactory getDCSMessageFactory() {
        return this._messageFactory;
    }

    public MemberInfoManager getMemberInfoManager() {
        return this._mim;
    }

    public String getCoreGroupName() {
        if (this._isCoreStack) {
            return this._groupName;
        }
        return this._mim.getCoreGroupName();
    }

    public String getGroupName() {
        return this._groupName;
    }

    public DCSConfig getConfig() {
        return this._config;
    }

    public Object getConfigParam(Object object) {
        return this.getConfig().get(object);
    }

    public int getConfigParamAsInt(Object object) {
        return (Integer)this.getConfigParam(object);
    }

    public long getConfigParamAsLong(Object object) {
        return (Long)this.getConfigParam(object);
    }

    public String getConfigParamAsString(Object object) {
        return (String)this.getConfigParam(object);
    }

    public boolean getConfigParamAsBoolean(Object object) {
        return (Boolean)this.getConfigParam(object);
    }

    public void setProtocolVersion(int n, StateVersion stateVersion) {
        this._protocolVersion = n;
        this._mmgr.setProtocolVersion(n, stateVersion);
        this._needsViewApproval = this._protocolVersion <= 51001;
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public String getStackName() {
        return this._groupName;
    }

    public String getMemberName() {
        return this._thisMemberName;
    }

    public String getLayerName() {
        return "GLOBALS";
    }

    public boolean goingToTerminate() {
        return this._goingToTerminate;
    }

    public void terminate() {
        this._goingToTerminate = true;
    }

    public boolean viewsNeedApproval() {
        return this._needsViewApproval;
    }

    public void setViewApproval(boolean bl) {
        this._needsViewApproval = bl;
    }

    public static void causeDump(FFDCDumpable fFDCDumpable, String string) {
        Globals.causeDump(fFDCDumpable, new DCSDumpException(string));
    }

    public static void causeDump(FFDCDumpable fFDCDumpable, Throwable throwable) {
        block3: {
            try {
                if (_diagnosticModule != null) {
                    _diagnosticModule.causeDump(fFDCDumpable, throwable);
                }
            }
            catch (Throwable throwable2) {
                if (!DCSTraceBuffer.isInternalWarningEnabled(TC)) break block3;
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(new DCSTraceContextImpl(TC, null, null, "Globals"), "Failed to cause ffdc dump", throwable2);
                dCSTraceBuffer.invoke();
            }
        }
    }

    static {
        formatter.setTimeZone(TimeZone.getDefault());
    }

    private static final class DCSStackMutex {
        private final String _stackName;

        DCSStackMutex(String string) {
            this._stackName = string;
        }

        public String toString() {
            return "DCSStackMutex." + this._stackName;
        }
    }
}

