/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.exception.DCSException;
import com.ibm.ws.dcs.vri.common.Job;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.LinkedList;

public final class JobsProcessorThread
extends Thread {
    private static final TraceComponent TC = Tr.register(JobsProcessorThread.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private final Object _mutex;
    private LinkedList _queuedObjects;
    private LinkedList _tmpQueue;
    private volatile boolean _terminate;
    private final DCSTraceContext _traceContext;
    private final String _name;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JobsProcessorThread(String string) {
        super(string);
        this._name = string;
        this._traceContext = new DCSTraceContextImpl(TC, null, null, "ThreadMgr");
        this.setDaemon(true);
        JobsProcessorThread jobsProcessorThread = this;
        synchronized (jobsProcessorThread) {
            this._mutex = new JobProcessorMutex(string);
            this._queuedObjects = new LinkedList();
            this._tmpQueue = null;
            this._terminate = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueueJob(Job job) {
        Object object;
        if (DCSTraceBuffer.isDebugEnabled(TC)) {
            object = DCSTraceBuffer.debug(this._traceContext, "enqueueJob", "");
            ((DCSTraceBuffer)object).addProperty("ThreadName", this._name);
            ((DCSTraceBuffer)object).addProperty("Job", String.valueOf(job));
            ((DCSTraceBuffer)object).invoke();
        }
        object = null;
        Object object2 = this._mutex;
        synchronized (object2) {
            if (!this._terminate) {
                this._queuedObjects.addLast(job);
                if (this._queuedObjects.size() == 1) {
                    this._mutex.notifyAll();
                }
                return;
            }
            object = new DCSException("Job was submited to terminated processor thread");
        }
        if (object != null) {
            job.handleError((Throwable)object);
        }
    }

    /*
     * Exception decompiling
     */
    public final void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 11[MONITOR]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        Object object;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this._traceContext, "terminate", "JobProcessorThread is terminating");
            ((DCSTraceBuffer)object).addProperty("ThreadName", this._name);
            ((DCSTraceBuffer)object).invoke();
        }
        Object object2 = this._mutex;
        synchronized (object2) {
            object = this._queuedObjects;
            this._queuedObjects = null;
            this._terminate = true;
            if (Thread.currentThread() != this) {
                this.interrupt();
            }
        }
        object2 = null;
        while (!((AbstractCollection)object).isEmpty()) {
            object2 = (Job)((LinkedList)object).removeFirst();
            object2.cancel();
            object2 = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getNumberOfQueuedJobs() {
        int n = 0;
        Object object = this._mutex;
        synchronized (object) {
            if (!this._terminate && this._queuedObjects != null) {
                n = this._queuedObjects.size();
            }
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelJobs(String string) {
        Object object;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this._traceContext, "cancelJobs", "");
            ((DCSTraceBuffer)object).addProperty("ThreadName", this._name);
            ((DCSTraceBuffer)object).addProperty("Owner", string);
            ((DCSTraceBuffer)object).invoke();
        }
        if (string == null) {
            return;
        }
        object = null;
        LinkedList<Object> linkedList = new LinkedList<Object>();
        Object object2 = this._mutex;
        synchronized (object2) {
            if (!this._terminate) {
                Iterator iterator = this._queuedObjects.iterator();
                while (iterator.hasNext()) {
                    object = (Job)iterator.next();
                    if (string.equals(object.getOwner())) {
                        linkedList.addLast(object);
                        iterator.remove();
                    }
                    object = null;
                }
            } else {
                return;
            }
        }
        while (!linkedList.isEmpty()) {
            object = (Job)linkedList.removeFirst();
            object.cancel();
            object = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String dump() {
        Object object = this._mutex;
        synchronized (object) {
            String string = "JobsProcessorThread info:" + this._name + ": ";
            string = string + "Main Queue Size is " + (this._queuedObjects == null ? "null" : "" + this._queuedObjects.size());
            string = string + ", Temp Queue Size is " + (this._tmpQueue == null ? "null" : "" + this._tmpQueue.size());
            return string;
        }
    }

    private void executeJob(Job job) {
        try {
            job.process();
        }
        catch (Throwable throwable) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this._traceContext, "Failed to process job", throwable);
                dCSTraceBuffer.addProperty("ThreadName", this._name);
                dCSTraceBuffer.addProperty("Job", String.valueOf(job));
                dCSTraceBuffer.invoke();
            }
            job.handleError(throwable);
        }
    }

    private final class JobProcessorMutex {
        private final String _mutexName;

        JobProcessorMutex(String string) {
            this._mutexName = "JobProcessorMutex." + string;
        }

        public String toString() {
            return "JobProcessorMutex." + this._mutexName;
        }
    }
}

