/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common;

import com.ibm.ws.dcs.common.DCSTraceable;
import com.ibm.ws.dcs.common.MemberInfoManager;
import com.ibm.ws.dcs.common.exception.DCSIllegalParameterException;
import com.ibm.ws.dcs.common.exception.DCSMemberIsNotDefinedException;
import com.ibm.ws.dcs.vri.common.Arrayable;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public final class MemberInfo
implements Arrayable,
Comparable,
Serializable,
DCSTraceable {
    private static final long serialVersionUID = 8429864771685884574L;
    private String _memberName;
    private final Properties _address;
    private int _hashCode = 0;
    private int _length = 0;

    public MemberInfo(String string, Properties properties) {
        if (string == null) {
            throw new DCSIllegalParameterException("Null member name in memberInfo");
        }
        this._memberName = string;
        this._address = properties == null ? new Properties() : properties;
    }

    public MemberInfo() {
        this._memberName = "";
        this._address = new Properties();
    }

    public final Properties getAddress() {
        return this._address;
    }

    public final String getMemberName() {
        return this._memberName;
    }

    public String toString() {
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList("MemberInfo: ");
        dCSTraceBuffer.addProperty("memberName", this._memberName).addProperty("Address", (Object)this._address);
        return dCSTraceBuffer.toString();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof MemberInfo)) {
            return false;
        }
        MemberInfo memberInfo = (MemberInfo)object;
        return this.checkName(memberInfo);
    }

    public boolean checkName(MemberInfo memberInfo) {
        return this._memberName.equals(memberInfo._memberName);
    }

    public int hashCode() {
        if (this._hashCode == 0) {
            this._hashCode = this._memberName.hashCode();
        }
        return this._hashCode;
    }

    public void toArray(byte[] byArray, Utils.Offset offset) {
        Utils.string2byteArray(this._memberName, byArray, offset);
        Set<Object> set = this._address.keySet();
        Utils.int2byteArray(set.size(), byArray, offset);
        Iterator<Object> iterator = set.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            String string2 = this._address.getProperty(string);
            Utils.string2byteArray(string, byArray, offset);
            Utils.string2byteArray(string2, byArray, offset);
        }
    }

    public Arrayable fromArray(byte[] byArray, Utils.Offset offset) {
        this._memberName = Utils.byteArray2string(byArray, offset);
        int n = Utils.byteArray2int(byArray, offset);
        for (int i = 0; i < n; ++i) {
            String string = Utils.byteArray2string(byArray, offset);
            String string2 = Utils.byteArray2string(byArray, offset);
            this._address.setProperty(string, string2);
        }
        return this;
    }

    public int getLength() {
        if (this._length == 0) {
            this._length = Utils.sizeOfString(this._memberName);
            Set<Object> set = this._address.keySet();
            this._length += Utils.sizeOfInt();
            Iterator<Object> iterator = set.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                String string2 = this._address.getProperty(string);
                this._length += Utils.sizeOfString(string) + Utils.sizeOfString(string2);
            }
        }
        return this._length;
    }

    public static String[] getNames(MemberInfo[] memberInfoArray) {
        if (memberInfoArray == null) {
            return new String[0];
        }
        String[] stringArray = new String[memberInfoArray.length];
        for (int i = 0; i < memberInfoArray.length; ++i) {
            stringArray[i] = memberInfoArray[i].getMemberName();
        }
        return stringArray;
    }

    public int compareTo(Object object) {
        MemberInfo memberInfo = (MemberInfo)object;
        return this.getMemberName().compareTo(memberInfo.getMemberName());
    }

    public static MemberInfo[] getMemberInfo(String[] stringArray, MemberInfoManager memberInfoManager) throws DCSMemberIsNotDefinedException {
        Map map = memberInfoManager.getMembersInfo(stringArray);
        MemberInfo[] memberInfoArray = new MemberInfo[stringArray.length];
        for (int i = 0; i < memberInfoArray.length; ++i) {
            MemberInfo memberInfo;
            String string = stringArray[i];
            Properties properties = (Properties)map.get(string);
            memberInfoArray[i] = memberInfo = new MemberInfo(string, properties);
        }
        return memberInfoArray;
    }

    public String getTraceName() {
        return "MemberInfo";
    }
}

