/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common;

import com.ibm.ws.dcs.common.exception.DCSMessageCorruptedException;
import com.ibm.ws.dcs.common.exception.DCSRuntimeException;
import com.ibm.ws.dcs.vri.common.MessageFactory;
import com.ibm.ws.dcs.vri.common.VRIMessage;

public final class MetaMessageFactory {
    private MessageFactory[] _factories = new MessageFactory[256];

    public VRIMessage getMessage(String string, byte[] byArray, int n, int n2) throws DCSMessageCorruptedException {
        byte by = byArray[4];
        MessageFactory messageFactory = this._factories[by];
        if (messageFactory != null) {
            return messageFactory.getMessage(string, byArray, n, n2);
        }
        throw new DCSRuntimeException("Unknown message factory id: " + by);
    }

    public void registerMessageFactory(MessageFactory messageFactory) {
        this._factories[messageFactory.getFactoryID()] = messageFactory;
    }

    public MessageFactory getRegisteredFactory(byte by) {
        return this._factories[by];
    }
}

