/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common;

import com.ibm.ws.dcs.common.exception.DCSIllegalParameterException;
import com.ibm.ws.dcs.vri.common.Arrayable;
import com.ibm.ws.dcs.vri.common.Utils;
import java.util.Arrays;
import java.util.Iterator;

public class SpaceEfficientIntArray
implements Arrayable {
    public static final byte NEVERCOMPRESSED = 0;
    public static final byte ALWAYSCOMPRESSED = 1;
    public static final byte COMPRESSEDMIN = 2;
    public static final byte COMPRESSEDMAX = 3;
    public static final byte COMPRESSEDMOSTPOPULARLIMITED = 4;
    private static final int NUMDIFFVALUES = 5;
    private int _popularVal = 0;
    private int _popularCount = 0;
    private int[] noncompressed;
    private IntArrayRec[] compressed;

    public SpaceEfficientIntArray(int[] nArray, byte by) {
        if (nArray == null) {
            throw new DCSIllegalParameterException("intArray cannot be null");
        }
        switch (by) {
            case 1: {
                this.setMostPopularLim(0, nArray);
                this.createCompressedArray(nArray);
                return;
            }
            case 0: {
                this.noncompressed = nArray;
                return;
            }
            case 2: 
            case 3: 
            case 4: {
                boolean bl;
                int n = this.computeThreshold(nArray.length);
                if (n <= 0) {
                    this.noncompressed = nArray;
                    return;
                }
                boolean bl2 = bl = by == 4 ? this.setMostPopularLim(n, nArray) : this.setPopularMinMax(n, nArray, by);
                if (bl) {
                    this.createCompressedArray(nArray);
                } else {
                    this.noncompressed = nArray;
                }
                return;
            }
        }
        throw new DCSIllegalParameterException("Illegal compression type");
    }

    private boolean setMostPopularLim(int n, int[] nArray) {
        int n2;
        int[] nArray2 = new int[5];
        int[] nArray3 = new int[5];
        int n3 = 0;
        for (n2 = 0; n2 < nArray.length; ++n2) {
            int n4 = -1;
            while (++n4 < n3 && nArray[n2] != nArray2[n4]) {
            }
            if (n4 < n3) {
                int n5 = n4;
                nArray3[n5] = nArray3[n5] + 1;
                continue;
            }
            if (n3 >= 5) continue;
            nArray2[n3] = nArray[n2];
            nArray3[n3++] = 1;
        }
        this._popularVal = nArray2[0];
        this._popularCount = nArray3[0];
        for (n2 = 1; n2 < n3; ++n2) {
            if (nArray3[n2] <= this._popularCount) continue;
            this._popularVal = nArray2[n2];
            this._popularCount = nArray3[n2];
        }
        return nArray.length - this._popularCount < n;
    }

    private boolean setPopularMinMax(int n, int[] nArray, byte by) {
        this._popularVal = nArray[0];
        this._popularCount = 1;
        for (int i = 1; i < nArray.length; ++i) {
            if (nArray[i] == this._popularVal) {
                ++this._popularCount;
                continue;
            }
            if (by == 2 && nArray[i] < this._popularVal || by == 3 && nArray[i] > this._popularVal) {
                this._popularVal = nArray[i];
                this._popularCount = 1;
            }
            if (i + 1 - this._popularCount < n) continue;
            return false;
        }
        return true;
    }

    private void createCompressedArray(int[] nArray) {
        this.compressed = new IntArrayRec[nArray.length - this._popularCount];
        int n = 0;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == this._popularVal) continue;
            this.compressed[n++] = new IntArrayRec(i, nArray[i]);
        }
    }

    private final int computeThreshold(int n) {
        return n / 2 - 1;
    }

    public SpaceEfficientIntArray(int[] nArray) {
        this(nArray, 4);
    }

    public SpaceEfficientIntArray(int[] nArray, int n) {
        if (nArray == null) {
            throw new DCSIllegalParameterException("intArray cannot be null");
        }
        int n2 = this.computeThreshold(nArray.length);
        if (n2 <= 0) {
            this.noncompressed = nArray;
            return;
        }
        this._popularVal = n;
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == this._popularVal) {
                ++this._popularCount;
                continue;
            }
            if (i + 1 - this._popularCount < n2) continue;
            this.noncompressed = nArray;
            return;
        }
        this.createCompressedArray(nArray);
    }

    public SpaceEfficientIntArray() {
    }

    public final boolean isCompressed() {
        return this.noncompressed == null;
    }

    public final int size() {
        return this.isCompressed() ? this._popularCount + this.compressed.length : this.noncompressed.length;
    }

    public final int getPopularVal() {
        return this._popularVal;
    }

    public final int getPopularCount() {
        return this._popularCount;
    }

    public final int[] getNonCompressed() {
        return this.noncompressed;
    }

    public int[] getNonCompressedGuaranteed() {
        if (this.isCompressed()) {
            int[] nArray = new int[this.compressed.length + this._popularCount];
            this.fillCompressed(nArray);
            return nArray;
        }
        return this.noncompressed;
    }

    public final IntArrayRec[] getCompressed() {
        return this.compressed;
    }

    public int elementAt(int n) {
        if (this.isCompressed()) {
            if (n < 0 || n >= this.compressed.length + this._popularCount) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int n2 = Arrays.binarySearch(this.compressed, new Integer(n));
            return n2 != -1 && this.compressed[n2]._ind == n ? this.compressed[n2]._val : this._popularVal;
        }
        return this.noncompressed[n];
    }

    public Iterator getIterator() {
        return new Iterator(){
            private int ind = 0;
            private int compressedInd = 0;

            public boolean hasNext() {
                if (SpaceEfficientIntArray.this.isCompressed()) {
                    return this.ind < SpaceEfficientIntArray.this._popularCount + SpaceEfficientIntArray.this.compressed.length;
                }
                return this.ind < SpaceEfficientIntArray.this.noncompressed.length;
            }

            public Object next() {
                int n;
                if (SpaceEfficientIntArray.this.isCompressed()) {
                    if (this.compressedInd == SpaceEfficientIntArray.this.compressed.length || ((SpaceEfficientIntArray)SpaceEfficientIntArray.this).compressed[this.compressedInd]._ind != this.ind) {
                        ++this.ind;
                        n = SpaceEfficientIntArray.this._popularVal;
                    } else {
                        ++this.ind;
                        n = ((SpaceEfficientIntArray)SpaceEfficientIntArray.this).compressed[this.compressedInd++]._val;
                    }
                } else {
                    n = SpaceEfficientIntArray.this.noncompressed[this.ind++];
                }
                return new Integer(n);
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public int[] fillOrReplace(int[] nArray) {
        if (this.isCompressed()) {
            if (nArray.length != this._popularCount + this.compressed.length) {
                return null;
            }
            this.fillCompressed(nArray);
            return nArray;
        }
        if (nArray.length != this.noncompressed.length) {
            return null;
        }
        return this.noncompressed;
    }

    private void fillCompressed(int[] nArray) {
        int n;
        int n2 = 0;
        for (n = 0; n < this.compressed.length; ++n) {
            for (int i = n2; i < this.compressed[n]._ind; ++i) {
                nArray[i] = this._popularVal;
            }
            nArray[this.compressed[n]._ind] = this.compressed[n]._val;
            n2 = this.compressed[n]._ind + 1;
        }
        for (n = n2; n < nArray.length; ++n) {
            nArray[n] = this._popularVal;
        }
    }

    public boolean isGreaterThanOrEqual(int[] nArray) {
        if (this.isCompressed()) {
            int n;
            if (nArray.length != this._popularCount + this.compressed.length) {
                return false;
            }
            int n2 = 0;
            for (n = 0; n < this.compressed.length; ++n) {
                for (int i = n2; i < this.compressed[n]._ind; ++i) {
                    if (nArray[i] <= this._popularVal) continue;
                    return false;
                }
                if (nArray[this.compressed[n]._ind] > this.compressed[n]._val) {
                    return false;
                }
                n2 = this.compressed[n]._ind + 1;
            }
            for (n = n2; n < nArray.length; ++n) {
                if (nArray[n] <= this._popularVal) continue;
                return false;
            }
            return true;
        }
        return SpaceEfficientIntArray.isFirstVectorGreaterOrEqual(this.noncompressed, nArray);
    }

    public static boolean isFirstVectorGreaterOrEqual(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray2[i] - nArray[i] <= 0) continue;
            return false;
        }
        return true;
    }

    public String toString() {
        if (this.isCompressed()) {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("[");
            for (int i = 0; i < this.compressed.length; ++i) {
                stringBuffer.append(this.compressed[i]._ind);
                stringBuffer.append(':');
                stringBuffer.append(this.compressed[i]._val);
                stringBuffer.append(' ');
            }
            stringBuffer.append("; other ");
            stringBuffer.append(this._popularCount);
            stringBuffer.append(" values are ");
            stringBuffer.append(this._popularVal);
            stringBuffer.append("]");
            return stringBuffer.toString();
        }
        return Utils.toString(this.noncompressed);
    }

    public void toArray(byte[] byArray, Utils.Offset offset) {
        Utils.boolean2byteArray(this.isCompressed(), byArray, offset);
        if (this.isCompressed()) {
            Utils.int2byteArray(this._popularVal, byArray, offset);
            Utils.int2byteArray(this._popularCount, byArray, offset);
            Utils.int2byteArray(this.compressed.length, byArray, offset);
            for (int i = 0; i < this.compressed.length; ++i) {
                Utils.int2byteArray(this.compressed[i]._ind, byArray, offset);
                Utils.int2byteArray(this.compressed[i]._val, byArray, offset);
            }
        } else {
            Utils.int2byteArray(this.noncompressed.length, byArray, offset);
            for (int i = 0; i < this.noncompressed.length; ++i) {
                Utils.int2byteArray(this.noncompressed[i], byArray, offset);
            }
        }
    }

    public Arrayable fromArray(byte[] byArray, Utils.Offset offset) {
        if (Utils.byteArray2boolean(byArray, offset)) {
            this._popularVal = Utils.byteArray2int(byArray, offset);
            this._popularCount = Utils.byteArray2int(byArray, offset);
            int n = Utils.byteArray2int(byArray, offset);
            this.compressed = new IntArrayRec[n];
            for (int i = 0; i < n; ++i) {
                int n2 = Utils.byteArray2int(byArray, offset);
                int n3 = Utils.byteArray2int(byArray, offset);
                this.compressed[i] = new IntArrayRec(n2, n3);
            }
        } else {
            int n = Utils.byteArray2int(byArray, offset);
            this.noncompressed = new int[n];
            for (int i = 0; i < n; ++i) {
                this.noncompressed[i] = Utils.byteArray2int(byArray, offset);
            }
        }
        return this;
    }

    public int getLength() {
        if (this.isCompressed()) {
            return Utils.sizeOfByte() + (3 + 2 * this.compressed.length) * Utils.sizeOfInt();
        }
        return Utils.sizeOfByte() + (1 + this.noncompressed.length) * Utils.sizeOfInt();
    }

    public static class IntArrayRec
    implements Comparable {
        public int _ind;
        public int _val;

        public IntArrayRec(int n, int n2) {
            this._ind = n;
            this._val = n2;
        }

        public int compareTo(Object object) {
            int n = (Integer)object;
            return this._ind == n ? 0 : (this._ind < n ? -1 : 1);
        }
    }
}

