/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.DCSTraceable;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.common.exception.DCSRuntimeException;
import com.ibm.ws.dcs.vri.common.JobsProcessorThread;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import java.util.HashMap;

public final class ThreadManager {
    private static final TraceComponent TC = Tr.register(ThreadManager.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private static final String THREAD_NAME_PREFIX = "ThreadManager.JobsProcessorThread.";
    public static final int EASY_LOAD = 1;
    public static final int MEDIUM_LOAD = 5;
    public static final int HEAVY_LOAD = 7;
    public static final ThreadType APPLICATION_THREAD = new ThreadType("APPLICATION_THREAD");
    public static final ThreadType RMM_THREAD = new ThreadType("RMM_THREAD");
    public static final ThreadType DISCOVERY_THREAD = new ThreadType("DISCOVERY_THREAD");
    public static final ThreadType INTERNAL_THREAD = new ThreadType("INTERNAL_THREAD");
    public static final int UNLIMITED = -1;
    private static boolean _initialized = false;
    private static ThreadData[] _aplicationThreadPool = new ThreadData[0];
    private static ThreadData[] _rmmThreadPool = new ThreadData[0];
    private static ThreadData[] _internalThreadPool = new ThreadData[0];
    private static final HashMap _owners = new HashMap();
    private static boolean _unlimited;
    private static final DCSTraceContext _traceContext;

    private ThreadManager() {
    }

    private static synchronized void init(int n) {
        if (_initialized) {
            return;
        }
        _initialized = true;
        if (n != -1) {
            ThreadManager.allocatePools(n);
            _unlimited = false;
        } else {
            _unlimited = true;
        }
    }

    public static synchronized void increaseThreadPoolSize(int n) {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(_traceContext, "increaseThreadPoolSize", "");
            dCSTraceBuffer.addProperty("Increment", "Size", String.valueOf(n));
            dCSTraceBuffer.invoke();
        }
        if (!_initialized) {
            ThreadManager.init(n);
        } else if (!_unlimited && n != -1) {
            if (n < 0) {
                return;
            }
            ThreadManager.reallocPools(n);
        } else {
            _unlimited = true;
        }
    }

    private static void reallocPools(int n) {
        int n2;
        ThreadData[] threadDataArray;
        int n3 = _aplicationThreadPool.length + _rmmThreadPool.length + _internalThreadPool.length;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            threadDataArray = DCSTraceBuffer.event(_traceContext, "reallocPools", "");
            if (_unlimited) {
                threadDataArray.addProperty("Old", "Size", "unlimited");
            } else {
                threadDataArray.addProperty("Old", "Size", String.valueOf(n3));
            }
            threadDataArray.addProperty("Increment", "Size", String.valueOf(n));
            threadDataArray.invoke();
        }
        threadDataArray = _aplicationThreadPool;
        ThreadData[] threadDataArray2 = _rmmThreadPool;
        ThreadData[] threadDataArray3 = _internalThreadPool;
        ThreadManager.allocatePools(n3 += n);
        for (n2 = 0; n2 < threadDataArray.length; ++n2) {
            ThreadManager._aplicationThreadPool[n2] = threadDataArray[n2];
        }
        for (n2 = 0; n2 < threadDataArray2.length; ++n2) {
            ThreadManager._rmmThreadPool[n2] = threadDataArray2[n2];
        }
        for (n2 = 0; n2 < threadDataArray3.length; ++n2) {
            ThreadManager._internalThreadPool[n2] = threadDataArray3[n2];
        }
    }

    public static synchronized void releaseThread(String string) {
        Object object;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(_traceContext, "releaseThread", "");
            ((DCSTraceBuffer)object).addProperty("Owner", string);
            ((DCSTraceBuffer)object).invoke();
        }
        if ((object = (OwnerData)_owners.remove(string)) == null) {
            DCSInvalidParametersException dCSInvalidParametersException = new DCSInvalidParametersException("Unknown owner: " + string);
            if (DCSTraceBuffer.isInternalInfoEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalInfo(_traceContext, "Request to release thread from unknown owner");
                dCSTraceBuffer.addProperty(dCSInvalidParametersException);
                dCSTraceBuffer.invoke();
            }
            return;
        }
        int n = ((OwnerData)object).getOwnedThreadIndex();
        JobsProcessorThread jobsProcessorThread = ((OwnerData)object).getOwnedThread();
        jobsProcessorThread.cancelJobs(string);
        if (n == -1) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(_traceContext, "releaseThread", "No more users - terminate");
                dCSTraceBuffer.addProperty("ThreadName", jobsProcessorThread.getName());
                dCSTraceBuffer.invoke();
            }
            jobsProcessorThread.terminate();
        } else {
            ThreadType threadType = ((OwnerData)object).getThreadType();
            ThreadData[] threadDataArray = threadType == APPLICATION_THREAD ? _aplicationThreadPool : (threadType == RMM_THREAD ? _rmmThreadPool : _internalThreadPool);
            ThreadData threadData = threadDataArray[n];
            threadData.decreaseLoad(((OwnerData)object).getWeight());
            if (threadData.getLoad() == 0) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(_traceContext, "releaseThread", "No more users - terminate");
                    dCSTraceBuffer.addProperty("ThreadName", jobsProcessorThread.getName());
                    dCSTraceBuffer.invoke();
                }
                jobsProcessorThread.terminate();
                threadDataArray[n] = null;
            }
        }
    }

    public static synchronized JobsProcessorThread getThread(String string, ThreadType threadType, int n) {
        return ThreadManager.getThread(string, threadType, n, false);
    }

    public static synchronized JobsProcessorThread getThread(String string, ThreadType threadType, int n, boolean bl) {
        JobsProcessorThread jobsProcessorThread;
        Object object;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(_traceContext, "getThread", "");
            ((DCSTraceBuffer)object).addProperty("Owner", string).addProperty(threadType).addProperty("Weight", String.valueOf(n)).addProperty("ForCoreStack", String.valueOf(bl));
            ((DCSTraceBuffer)object).invoke();
        }
        if (!_initialized) {
            throw new DCSRuntimeException("Thread manager was not initialized");
        }
        object = (OwnerData)_owners.get(string);
        int n2 = -2;
        if (object == null) {
            if (_unlimited || threadType == DISCOVERY_THREAD || bl && (threadType == APPLICATION_THREAD || threadType == RMM_THREAD)) {
                jobsProcessorThread = new JobsProcessorThread(THREAD_NAME_PREFIX + string);
                jobsProcessorThread.start();
                n2 = -1;
            } else {
                String string2;
                ThreadData[] threadDataArray;
                if (threadType == APPLICATION_THREAD) {
                    threadDataArray = _aplicationThreadPool;
                    string2 = "ApplicationThread.";
                } else if (threadType == RMM_THREAD) {
                    threadDataArray = _rmmThreadPool;
                    string2 = "RmmThread.";
                } else {
                    threadDataArray = _internalThreadPool;
                    string2 = "InternalThread.";
                }
                n2 = ThreadManager.chooseNextThread(threadDataArray);
                ThreadData threadData = threadDataArray[n2];
                if (threadData == null) {
                    threadDataArray[n2] = threadData = new ThreadData(THREAD_NAME_PREFIX + string2 + n2);
                }
                jobsProcessorThread = threadData.getThread();
                threadData.increaseLoad(n);
            }
            object = new OwnerData(string, threadType, n, n2, jobsProcessorThread);
            _owners.put(string, object);
        } else {
            String string3 = "Get thread request from owner(" + string + ") that already got one thread";
            DCSInvalidParametersException dCSInvalidParametersException = new DCSInvalidParametersException(string3);
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(_traceContext, string3, dCSInvalidParametersException);
                dCSTraceBuffer.invoke();
            }
            jobsProcessorThread = null;
        }
        return jobsProcessorThread;
    }

    private static int chooseNextThread(ThreadData[] threadDataArray) {
        int n = Integer.MAX_VALUE;
        int n2 = 0;
        for (int i = 0; i < threadDataArray.length; ++i) {
            ThreadData threadData = threadDataArray[i];
            if (threadData == null) {
                n2 = i;
                break;
            }
            int n3 = threadData.getLoad();
            if (n3 < 5) {
                n2 = i;
                break;
            }
            if (n3 >= n) continue;
            n = n3;
            n2 = i;
        }
        return n2;
    }

    private static void allocatePools(int n) {
        if (n == -1) {
            return;
        }
        int n2 = (n + 2) / 3;
        _aplicationThreadPool = new ThreadData[n2];
        _rmmThreadPool = new ThreadData[n2];
        _internalThreadPool = new ThreadData[n2];
    }

    static {
        _traceContext = new DCSTraceContextImpl(TC, "", "", "ThreadMgr");
    }

    private static final class ThreadType
    implements DCSTraceable {
        private final String _typeName;

        ThreadType(String string) {
            this._typeName = string;
        }

        public String getTraceName() {
            return "ThreadType";
        }

        public String toString() {
            return this._typeName;
        }
    }

    private static final class ThreadData {
        private final JobsProcessorThread _thread;
        private int _load;

        ThreadData(String string) {
            this._thread = new JobsProcessorThread(string);
            this._thread.start();
            this._load = 0;
        }

        JobsProcessorThread getThread() {
            return this._thread;
        }

        int getLoad() {
            return this._load;
        }

        void increaseLoad(int n) {
            this._load += n;
        }

        void decreaseLoad(int n) {
            this._load -= n;
        }
    }

    private static final class OwnerData {
        private final String _owner;
        private final int _ownedThreadIndex;
        private final JobsProcessorThread _ownedThread;
        private final int _weight;
        private final ThreadType _threadType;

        OwnerData(String string, ThreadType threadType, int n, int n2, JobsProcessorThread jobsProcessorThread) {
            this._owner = string;
            this._ownedThreadIndex = n2;
            this._weight = n;
            this._ownedThread = jobsProcessorThread;
            this._threadType = threadType;
        }

        String getOwner() {
            return this._owner;
        }

        int getOwnedThreadIndex() {
            return this._ownedThreadIndex;
        }

        JobsProcessorThread getOwnedThread() {
            return this._ownedThread;
        }

        int getWeight() {
            return this._weight;
        }

        ThreadType getThreadType() {
            return this._threadType;
        }
    }
}

