/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common;

import com.ibm.ws.dcs.vri.common.Arrayable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashSet;

public final class Utils {
    public static byte[] string2byteArray(String string) {
        byte[] byArray = new byte[Utils.sizeOfString(string)];
        Utils.string2byteArray(string, byArray, new Offset());
        return byArray;
    }

    public static void string2byteArray(String string, byte[] byArray, Offset offset) {
        int n = string.length();
        if (n < Short.MAX_VALUE) {
            Utils.short2byteArray((short)n, byArray, offset);
        } else {
            Utils.short2byteArray((short)-1, byArray, offset);
            Utils.int2byteArray(n, byArray, offset);
        }
        int n2 = offset.getValue();
        for (int i = 0; i < n; ++i) {
            int n3 = string.charAt(i);
            byArray[n2++] = (byte)(n3 & 0xFF);
            byArray[n2++] = (byte)((n3 >>>= 8) & 0xFF);
        }
        offset.setValue(n2);
    }

    public static String byteArray2string(byte[] byArray) {
        return Utils.byteArray2string(byArray, new Offset());
    }

    public static String byteArray2string(byte[] byArray, Offset offset) {
        int n;
        char[] cArray;
        int n2 = offset.getValue();
        try {
            int n3 = Utils.byteArray2short(byArray, offset);
            if (n3 == -1) {
                n3 = Utils.byteArray2int(byArray, offset);
            }
            cArray = new char[n3];
            n = offset.getValue();
            for (int i = 0; i < n3; ++i) {
                int n4 = 0xFF & byArray[n++];
                int n5 = 0xFF & byArray[n++];
                cArray[i] = (char)(n4 |= (n5 <<= 8));
            }
        }
        catch (Throwable throwable) {
            offset.setValue(n2);
            return null;
        }
        offset.setValue(n);
        return new String(cArray);
    }

    public static byte[] short2byteArray(short s) {
        byte[] byArray = new byte[2];
        Utils.short2byteArray(s, byArray, new Offset());
        return byArray;
    }

    public static void short2byteArray(short n, byte[] byArray, Offset offset) {
        int n2 = n;
        int n3 = offset.getValue();
        byArray[n3++] = (byte)(n2 & 0xFF);
        byArray[n3++] = (byte)((n2 >>>= 8) & 0xFF);
        offset.setValue(n3);
    }

    public static short byteArray2short(byte[] byArray) {
        return Utils.byteArray2short(byArray, new Offset());
    }

    public static short byteArray2short(byte[] byArray, Offset offset) {
        int n = offset.getValue();
        int n2 = 0xFF & byArray[n++];
        int n3 = 0xFF & byArray[n++];
        offset.setValue(n);
        return (short)(n2 |= (n3 <<= 8));
    }

    public static byte[] int2byteArray(int n) {
        byte[] byArray = new byte[4];
        Utils.int2byteArray(n, byArray, new Offset());
        return byArray;
    }

    public static void int2byteArray(int n, byte[] byArray, Offset offset) {
        int n2 = n;
        int n3 = offset.getValue();
        byArray[n3++] = (byte)(n2 & 0xFF);
        byArray[n3++] = (byte)((n2 >>>= 8) & 0xFF);
        byArray[n3++] = (byte)((n2 >>>= 8) & 0xFF);
        byArray[n3++] = (byte)((n2 >>>= 8) & 0xFF);
        offset.setValue(n3);
    }

    public static int byteArray2int(byte[] byArray) {
        return Utils.byteArray2int(byArray, new Offset());
    }

    public static int byteArray2int(byte[] byArray, Offset offset) {
        int n = offset.getValue();
        int n2 = 0xFF & byArray[n++];
        int n3 = 0xFF & byArray[n++];
        int n4 = 0xFF & byArray[n++];
        int n5 = 0xFF & byArray[n++];
        int n6 = n2 | (n3 <<= 8) | (n4 <<= 16) | (n5 <<= 24);
        offset.setValue(n);
        return n6;
    }

    public static byte[] long2byteArray(long l) {
        byte[] byArray = new byte[8];
        Utils.long2byteArray(l, byArray, new Offset());
        return byArray;
    }

    public static void long2byteArray(long l, byte[] byArray, Offset offset) {
        int n = offset.getValue();
        long l2 = l;
        byArray[n++] = (byte)(l2 & 0xFFL);
        byArray[n++] = (byte)((l2 >>>= 8) & 0xFFL);
        byArray[n++] = (byte)((l2 >>>= 8) & 0xFFL);
        byArray[n++] = (byte)((l2 >>>= 8) & 0xFFL);
        byArray[n++] = (byte)((l2 >>>= 8) & 0xFFL);
        byArray[n++] = (byte)((l2 >>>= 8) & 0xFFL);
        byArray[n++] = (byte)((l2 >>>= 8) & 0xFFL);
        byArray[n++] = (byte)((l2 >>>= 8) & 0xFFL);
        offset.setValue(n);
    }

    public static long byteArray2long(byte[] byArray) {
        return Utils.byteArray2long(byArray, new Offset());
    }

    public static long byteArray2long(byte[] byArray, Offset offset) {
        int n = offset.getValue();
        long l = 0xFF & byArray[n++];
        long l2 = 0xFF & byArray[n++];
        long l3 = 0xFF & byArray[n++];
        long l4 = 0xFF & byArray[n++];
        long l5 = 0xFF & byArray[n++];
        long l6 = 0xFF & byArray[n++];
        long l7 = 0xFF & byArray[n++];
        long l8 = 0xFF & byArray[n++];
        long l9 = l | (l2 <<= 8) | (l3 <<= 16) | (l4 <<= 24) | (l5 <<= 32) | (l6 <<= 40) | (l7 <<= 48) | (l8 <<= 56);
        offset.setValue(n);
        return l9;
    }

    public static boolean byteArray2boolean(byte[] byArray, Offset offset) {
        byte by = byArray[offset.getValue()];
        offset.add(1);
        return by != 0;
    }

    public static byte[] boolean2byteArray(boolean bl) {
        byte[] byArray = new byte[1];
        Utils.boolean2byteArray(bl, byArray, new Offset());
        return byArray;
    }

    public static void boolean2byteArray(boolean bl, byte[] byArray, Offset offset) {
        int n = offset.getValue();
        byArray[n++] = bl ? (byte)1 : 0;
        offset.setValue(n);
    }

    public static String[] byteArray2stringArray(byte[] byArray) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
        int n = dataInputStream.readInt();
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            byte by = dataInputStream.readByte();
            byte[] byArray2 = new byte[by];
            dataInputStream.readFully(byArray2, 0, by);
            stringArray[i] = new String(byArray2);
        }
        return stringArray;
    }

    public static void stringArray2byteArray(byte[] byArray, Offset offset, String[] stringArray) {
        Utils.int2byteArray(stringArray.length, byArray, offset);
        for (int i = 0; i < stringArray.length; ++i) {
            Utils.string2byteArray(stringArray[i], byArray, offset);
        }
    }

    public static int getLength(String[] stringArray) {
        int n = Utils.sizeOfInt();
        for (int i = 0; i < stringArray.length; ++i) {
            n += Utils.sizeOfString(stringArray[i]);
        }
        return n;
    }

    public static int getLength(Arrayable[] arrayableArray) {
        int n = Utils.sizeOfInt();
        for (int i = 0; i < arrayableArray.length; ++i) {
            n += arrayableArray[i].getLength();
        }
        return n;
    }

    public static byte[] object2byteArray(Serializable serializable) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = null;
        byte[] byArray = null;
        objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
        objectOutputStream.writeObject(serializable);
        byArray = byteArrayOutputStream.toByteArray();
        return byArray;
    }

    public static Object byteArray2object(byte[] byArray) throws IOException, ClassNotFoundException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ObjectInputStream objectInputStream = null;
        Object object = null;
        objectInputStream = new ObjectInputStream(byteArrayInputStream);
        object = objectInputStream.readObject();
        return object;
    }

    public static int sizeOfBoolean() {
        return 1;
    }

    public static int sizeOfInt() {
        return 4;
    }

    public static int sizeOfFloat() {
        return 4;
    }

    public static int sizeOfByte() {
        return 1;
    }

    public static int sizeOfShort() {
        return 2;
    }

    public static int sizeOfChar() {
        return 2;
    }

    public static int sizeOfLong() {
        return 8;
    }

    public static int sizeOfDouble() {
        return 8;
    }

    public static int sizeOfString(String string) {
        if (string == null) {
            return 0;
        }
        int n = string.length();
        int n2 = 2 * n + Utils.sizeOfShort();
        if (n < Short.MAX_VALUE) {
            return n2;
        }
        return n2 + Utils.sizeOfInt();
    }

    public static boolean compareByteArrays(byte[] byArray, byte[] byArray2) {
        if (byArray.length == byArray2.length) {
            for (int i = 0; i < byArray2.length; ++i) {
                if (byArray[i] == byArray2[i]) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static String toString(Object[] objectArray) {
        if (objectArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < objectArray.length; ++i) {
            stringBuffer.append(objectArray[i]);
            stringBuffer.append(' ');
        }
        if (objectArray.length > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String getVersionAsString(byte[] byArray) {
        return Utils.getVersionAsString(byArray, 0);
    }

    public static String getVersionAsString(byte[] byArray, int n) {
        StringBuffer stringBuffer = new StringBuffer();
        n += 3;
        stringBuffer.append(byArray[n--]).append(".");
        stringBuffer.append(byArray[n--]).append(".");
        stringBuffer.append(byArray[n--]).append(".");
        stringBuffer.append(byArray[n]);
        return stringBuffer.toString();
    }

    public static String getVersionAsString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append((n & 0xFF000000) >>> 24).append(".");
        stringBuffer.append((n & 0xFF0000) >>> 16).append(".");
        stringBuffer.append((n & 0xFF00) >>> 8).append(".");
        stringBuffer.append(n & 0xFF);
        return stringBuffer.toString();
    }

    public static final Object[] removeNulls(Object[] objectArray, int n) {
        Object[] objectArray2 = (Object[])Array.newInstance(objectArray.getClass().getComponentType(), objectArray.length - n);
        int n2 = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] == null) continue;
            objectArray2[n2] = objectArray[i];
            ++n2;
        }
        return objectArray2;
    }

    public static final int countNulls(Object[] objectArray) {
        int n = 0;
        for (int i = 0; i < objectArray.length; ++i) {
            if (objectArray[i] != null) continue;
            ++n;
        }
        return n;
    }

    public static final Object[] removeNulls(Object[] objectArray) {
        return Utils.removeNulls(objectArray, Utils.countNulls(objectArray));
    }

    public static String toString(Throwable throwable) {
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        String string = null;
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            string = string + stackTraceElementArray[i].toString();
        }
        return string;
    }

    public static Object toString(boolean[] blArray) {
        if (blArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < blArray.length; ++i) {
            stringBuffer.append(blArray[i]);
            stringBuffer.append(' ');
        }
        if (blArray.length > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String toString(int[] nArray) {
        if (nArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]);
            stringBuffer.append(' ');
        }
        if (nArray.length > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String toString(byte[] byArray) {
        if (byArray == null) {
            return "null";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        for (int i = 0; i < byArray.length; ++i) {
            stringBuffer.append(byArray[i]);
            stringBuffer.append(' ');
        }
        if (byArray.length > 0) {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    public static String toPrintableString(String string) {
        try {
            String string2 = string;
            char[] cArray = string2.toCharArray();
            for (int i = 0; i < cArray.length; ++i) {
                if (!Character.isISOControl(cArray[i])) continue;
                cArray[i] = 63;
            }
            return new String(cArray);
        }
        catch (Throwable throwable) {
            return string;
        }
    }

    public static String getStackTraceAsString() {
        StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
        String string = null;
        for (int i = 0; i < stackTraceElementArray.length; ++i) {
            string = string + stackTraceElementArray[i].toString();
        }
        return string;
    }

    public static String getShortClassName(Class clazz) {
        String string = clazz.getName();
        if (clazz == null) {
            return null;
        }
        int n = string.lastIndexOf(46);
        if (n == -1) {
            return string;
        }
        return string.substring(n + 1);
    }

    public static class DiffSet {
        public final String[] newMinusOld;
        public final String[] oldMinusNew;

        public DiffSet(String[] stringArray, String[] stringArray2) {
            HashSet<String> hashSet = new HashSet<String>(Arrays.asList(stringArray));
            HashSet<String> hashSet2 = new HashSet<String>(Arrays.asList(stringArray2));
            hashSet.removeAll(hashSet2);
            hashSet2.removeAll(Arrays.asList(stringArray));
            this.oldMinusNew = hashSet.toArray(new String[hashSet.size()]);
            this.newMinusOld = hashSet2.toArray(new String[hashSet2.size()]);
        }
    }

    public static final class Offset {
        private int _value;

        public Offset(int n) {
            this._value = n;
        }

        public Offset() {
            this._value = 0;
        }

        public void setValue(int n) {
            this._value = n;
        }

        public int getValue() {
            return this._value;
        }

        public void add(int n) {
            this._value += n;
        }
    }
}

