/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.DCSTraceable;
import com.ibm.ws.dcs.common.StateVersion;
import com.ibm.ws.dcs.common.exception.DCSAssertException;
import com.ibm.ws.dcs.common.exception.DCSIllegalParameterException;
import com.ibm.ws.dcs.vri.common.MemberInfo;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRICheckFailedException;
import com.ibm.ws.dcs.vri.common.VRIDenialReason;
import com.ibm.ws.dcs.vri.common.VRIIllegalStateException;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberLayerData;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;

public final class VRIMembersMGR
implements DCSTraceable {
    private ViewIdImpl _curViewId;
    private final VRIMemberDescriptionImpl _thisMember;
    private final String _thisStackName;
    private Map _definedMembers;
    private Map _connectedMembers;
    private Map _deniedMembers;
    private VRIMemberDescriptionImpl[] _viewMembers;
    private HashMap _viewNameIndexMap;
    private HashMap[] _layerData2memberMaps;
    private static final TraceComponent TC = Tr.register(VRIMembersMGR.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    public static final int IN_VIEW = 1;
    public static final int CONNECTED_NOT_IN_VIEW = 2;
    public static final int DISCONNECTED_OR_DENIED = 3;
    public static final int NOT_DEFINED = 4;
    private final DCSTraceContext _traceContext;
    private int _protocolVersion;
    private StateVersion _protocolVersionContext;
    private VRIMemberDescription[] _definedMembersArray = null;

    public VRIMembersMGR(String string, String string2, Map map, int n) {
        Object object;
        this._traceContext = new DCSTraceContextImpl(TC, string, string2, "MBRS_MGR");
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this._traceContext, "VRIMembersMGR", "");
            ((DCSTraceBuffer)object).addProperty("DefinedSet", (Object)map);
            ((DCSTraceBuffer)object).invoke();
        }
        this._thisStackName = string;
        this._protocolVersion = n;
        this._definedMembers = new HashMap();
        object = map.keySet().iterator();
        while (object.hasNext()) {
            String string3 = (String)object.next();
            Properties properties = (Properties)map.get(string3);
            MemberInfo memberInfo = new MemberInfo(string3, properties);
            VRIMemberDescription vRIMemberDescription = this.createMemberDescription(memberInfo);
            this.addDefinedMember(vRIMemberDescription);
        }
        this.reIndexDefinedSet();
        this._thisMember = (VRIMemberDescriptionImpl)this.getDefinedMember(string2);
        if (this._thisMember == null) {
            throw new DCSIllegalParameterException("VRIMembersMGR.VRIMembersMGR: this member wasn't included in defined members. The defined members are: " + Utils.toString(this.getDefinedMembers(true)));
        }
        this._connectedMembers = new HashMap();
        this.addConnectedMember(this._thisMember.getName());
        this._deniedMembers = new HashMap();
        this._viewNameIndexMap = new HashMap();
        this._viewMembers = new VRIMemberDescriptionImpl[0];
        int n2 = 11;
        this._layerData2memberMaps = new HashMap[n2];
        for (int i = 0; i < n2; ++i) {
            this._layerData2memberMaps[i] = new HashMap();
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "VRIMembersMGR", "");
            dCSTraceBuffer.invoke();
        }
    }

    public void start(ViewIdImpl viewIdImpl) {
        if (DCSTraceBuffer.isDebugEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.debug(this._traceContext, "start", "");
            dCSTraceBuffer.addProperty("Initial", viewIdImpl);
            dCSTraceBuffer.invoke();
        }
        this._curViewId = viewIdImpl;
        this.newView(new VRIMemberDescription[]{this._thisMember}, this._curViewId);
    }

    public void writeMembersDescription(byte[] byArray, Utils.Offset offset, VRIMemberDescription[] vRIMemberDescriptionArray) {
        this.writeMembersDescription(byArray, offset, vRIMemberDescriptionArray, 4);
    }

    public void writeMembersDescription(byte[] byArray, Utils.Offset offset, VRIMemberDescription[] vRIMemberDescriptionArray, int n) {
        if (vRIMemberDescriptionArray == null) {
            vRIMemberDescriptionArray = new VRIMemberDescription[]{};
        }
        Utils.int2byteArray(vRIMemberDescriptionArray.length, byArray, offset);
        block4: for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            switch (n) {
                case 1: {
                    if (i == 0) {
                        this._curViewId.toArray(byArray, offset);
                    }
                    Utils.int2byteArray(vRIMemberDescriptionArray[i].getIndexInView(), byArray, offset);
                    continue block4;
                }
                case 2: {
                    if (i == 0) {
                        // empty if block
                    }
                    Utils.int2byteArray(vRIMemberDescriptionArray[i].getDefinedIndex(), byArray, offset);
                    continue block4;
                }
                default: {
                    if (vRIMemberDescriptionArray[i] == null) continue block4;
                    Utils.string2byteArray(vRIMemberDescriptionArray[i].getName(), byArray, offset);
                }
            }
        }
    }

    public VRIMemberDescription[] readMembersDescription(byte[] byArray, Utils.Offset offset) {
        return this.readMembersDescription(byArray, offset, 4, false);
    }

    public VRIMemberDescription[] readMembersDescription(byte[] byArray, Utils.Offset offset, int n, boolean bl) {
        int n2 = Utils.byteArray2int(byArray, offset);
        VRIMemberDescription[] vRIMemberDescriptionArray = new VRIMemberDescription[n2];
        ViewIdImpl viewIdImpl = null;
        boolean bl2 = true;
        block8: for (int i = 0; i < n2; ++i) {
            switch (n) {
                case 1: {
                    if (i == 0 && !this._curViewId.equals(viewIdImpl = (ViewIdImpl)new ViewIdImpl().fromArray(byArray, offset))) {
                        bl2 = false;
                        if (DCSTraceBuffer.isEventEnabled(TC)) {
                            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "readMembersDescription", "WARNING*** view message sent in wrong view");
                            dCSTraceBuffer.addProperty("Current", this._curViewId);
                            dCSTraceBuffer.addProperty("Sent", viewIdImpl);
                            dCSTraceBuffer.invoke();
                        }
                    }
                    int n3 = Utils.byteArray2int(byArray, offset);
                    String string = "ViewIndex" + n3;
                    try {
                        if (bl2) {
                            vRIMemberDescriptionArray[i] = this.getViewMember(n3);
                            continue block8;
                        }
                        vRIMemberDescriptionArray[i] = new ViewIndexVRIMemberDescriptionImpl(n3, viewIdImpl);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        if (bl) {
                            vRIMemberDescriptionArray[i] = new DummyVRIMemberDescriptionImpl(string);
                            continue block8;
                        }
                        this.warnUndefinedMember(n, bl, string, viewIdImpl);
                    }
                    continue block8;
                }
                case 2: {
                    if (i == 0) {
                        // empty if block
                    }
                    int n4 = Utils.byteArray2int(byArray, offset);
                    String string = "DefinedSetIndex" + n4;
                    try {
                        if (bl2) {
                            vRIMemberDescriptionArray[i] = this.getDefinedMember(n4);
                            continue block8;
                        }
                        vRIMemberDescriptionArray[i] = new DummyVRIMemberDescriptionImpl(string);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        if (bl) {
                            vRIMemberDescriptionArray[i] = new DummyVRIMemberDescriptionImpl(string);
                            continue block8;
                        }
                        this.warnUndefinedMember(n, bl, string, viewIdImpl);
                    }
                    continue block8;
                }
                default: {
                    String string = Utils.byteArray2string(byArray, offset);
                    vRIMemberDescriptionArray[i] = this.getDefinedMember(string);
                    if (vRIMemberDescriptionArray[i] != null) continue block8;
                    if (bl) {
                        vRIMemberDescriptionArray[i] = new DummyVRIMemberDescriptionImpl(string);
                        continue block8;
                    }
                    this.warnUndefinedMember(n, bl, string, null);
                }
            }
        }
        return vRIMemberDescriptionArray;
    }

    private void warnUndefinedMember(int n, boolean bl, String string, ViewIdImpl viewIdImpl) {
        if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this._traceContext, "Member is not defined", null);
            dCSTraceBuffer.addProperty("memberName", string);
            dCSTraceBuffer.addProperty("Method", "readMembersDescriptionE=" + n + "TF=" + bl + "Vid=" + viewIdImpl);
            dCSTraceBuffer.invoke();
        }
    }

    public VRIMemberDescription[] readDefinedMembersDescription(byte[] byArray, Utils.Offset offset) {
        return this.readMembersDescription(byArray, offset, 4, true);
    }

    public VRIMemberDescription[] readDefinedMembersDescription(byte[] byArray, Utils.Offset offset, int n) {
        return this.readMembersDescription(byArray, offset, n, true);
    }

    public int getLength(VRIMemberDescription[] vRIMemberDescriptionArray) throws NullPointerException {
        return this.getLength(vRIMemberDescriptionArray, 4);
    }

    public int getLength(VRIMemberDescription[] vRIMemberDescriptionArray, int n) throws NullPointerException {
        if (vRIMemberDescriptionArray == null) {
            vRIMemberDescriptionArray = new VRIMemberDescription[]{};
        }
        int n2 = 4;
        switch (n) {
            case 1: {
                if (vRIMemberDescriptionArray.length <= 0) break;
                n2 += vRIMemberDescriptionArray.length * Utils.sizeOfInt() + this._curViewId.getLength();
                break;
            }
            case 2: {
                if (vRIMemberDescriptionArray.length <= 0) break;
                n2 += vRIMemberDescriptionArray.length * Utils.sizeOfInt();
                break;
            }
            default: {
                for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
                    if (vRIMemberDescriptionArray[i] == null) {
                        DCSIllegalParameterException dCSIllegalParameterException = new DCSIllegalParameterException("null members");
                        throw dCSIllegalParameterException;
                    }
                    n2 += Utils.sizeOfString(vRIMemberDescriptionArray[i].getName());
                }
            }
        }
        return n2;
    }

    public int[] membersStatus(String[] stringArray) {
        if (stringArray == null) {
            return null;
        }
        int[] nArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            VRIMemberDescription vRIMemberDescription = this.getDefinedMember(stringArray[i]);
            nArray[i] = vRIMemberDescription == null ? 4 : (vRIMemberDescription.isDenied() || !vRIMemberDescription.isConnected() ? 3 : (vRIMemberDescription.isInView() ? 1 : 2));
        }
        return nArray;
    }

    public VRIMemberDescription[] getDefinedMembers(String[] stringArray) {
        VRIMemberDescription[] vRIMemberDescriptionArray = new VRIMemberDescription[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            vRIMemberDescriptionArray[i] = this.getDefinedMember(stringArray[i]);
        }
        return vRIMemberDescriptionArray;
    }

    public VRIMemberDescription getDefinedMember(String string) {
        return (VRIMemberDescriptionImpl)this._definedMembers.get(string);
    }

    public VRIMemberDescription getDefinedMember(int n) {
        if (n >= 0 && n < this._definedMembersArray.length) {
            return (VRIMemberDescriptionImpl)this._definedMembersArray[n];
        }
        return null;
    }

    public VRIMemberDescription getConnectedMember(String string) {
        return (VRIMemberDescriptionImpl)this._connectedMembers.get(string);
    }

    public VRIMemberDescription getDeniedMember(String string) {
        return (VRIMemberDescriptionImpl)this._deniedMembers.get(string);
    }

    public VRIMemberDescription getViewMember(String string) {
        Integer n = (Integer)this._viewNameIndexMap.get(string);
        if (n == null) {
            return null;
        }
        return this._viewMembers[n];
    }

    public VRIMemberDescription getViewMember(int n) {
        return this._viewMembers[n];
    }

    public int getViewMemberIndex(String string) {
        Integer n = (Integer)this._viewNameIndexMap.get(string);
        if (n == null) {
            return -1;
        }
        return n;
    }

    public boolean isDefined(String string) {
        return this._definedMembers.containsKey(string);
    }

    public boolean areAllDefined(VRIMemberDescription[] vRIMemberDescriptionArray) {
        if (vRIMemberDescriptionArray == null) {
            return true;
        }
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            if (vRIMemberDescriptionArray[i] == null || vRIMemberDescriptionArray[i].isDefined()) continue;
            return false;
        }
        return true;
    }

    public VRIMemberDescription[] removeUndefined(VRIMemberDescription[] vRIMemberDescriptionArray) {
        int n = 0;
        if (vRIMemberDescriptionArray == null) {
            return null;
        }
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            if (vRIMemberDescriptionArray[i] != null && !vRIMemberDescriptionArray[i].isDefined()) continue;
            ++n;
        }
        if (n == vRIMemberDescriptionArray.length) {
            return vRIMemberDescriptionArray;
        }
        VRIMemberDescription[] vRIMemberDescriptionArray2 = new VRIMemberDescriptionImpl[n];
        int n2 = 0;
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            if (vRIMemberDescriptionArray[i] != null && !vRIMemberDescriptionArray[i].isDefined()) continue;
            vRIMemberDescriptionArray2[n2] = vRIMemberDescriptionArray[i];
            ++n2;
        }
        return vRIMemberDescriptionArray2;
    }

    public boolean isConnected(String string) {
        return this._connectedMembers.containsKey(string);
    }

    public boolean isDenied(String string) {
        return this._deniedMembers.containsKey(string);
    }

    public boolean isDenied(byte by, String string) {
        VRIMemberDescriptionImpl vRIMemberDescriptionImpl = (VRIMemberDescriptionImpl)this.getDeniedMember(string);
        if (vRIMemberDescriptionImpl == null) {
            return false;
        }
        return vRIMemberDescriptionImpl.isDenied(by);
    }

    public boolean isDeniedByThisLayer(byte by, String string) {
        VRIMemberDescriptionImpl vRIMemberDescriptionImpl = (VRIMemberDescriptionImpl)this.getDeniedMember(string);
        if (vRIMemberDescriptionImpl == null) {
            return false;
        }
        return vRIMemberDescriptionImpl.isDeniedByThisLayer(by);
    }

    public boolean isInView(String string) {
        return this._viewNameIndexMap.containsKey(string);
    }

    public VRIMemberDescription[] getDefinedMembers(boolean bl) {
        Object[] objectArray = new VRIMemberDescriptionImpl[this._definedMembers.size()];
        objectArray = this._definedMembers.values().toArray(objectArray);
        if (bl) {
            Arrays.sort(objectArray);
        }
        return objectArray;
    }

    public VRIMemberDescription[] getConnectedMembers(boolean bl) {
        Object[] objectArray = new VRIMemberDescriptionImpl[this._connectedMembers.size()];
        objectArray = this._connectedMembers.values().toArray(objectArray);
        if (bl) {
            Arrays.sort(objectArray);
        }
        return objectArray;
    }

    public VRIMemberDescription[] getDeniedMembers(boolean bl) {
        if (this._deniedMembers.isEmpty()) {
            return new VRIMemberDescriptionImpl[0];
        }
        Object[] objectArray = new VRIMemberDescriptionImpl[this._deniedMembers.size()];
        objectArray = this._deniedMembers.values().toArray(objectArray);
        if (bl) {
            Arrays.sort(objectArray);
        }
        return objectArray;
    }

    public VRIMemberDescription[] getDeniedMembers(byte by, boolean bl) {
        Object[] objectArray;
        if (this._deniedMembers.isEmpty()) {
            return new VRIMemberDescriptionImpl[0];
        }
        LinkedList<Object[]> linkedList = new LinkedList<Object[]>();
        Iterator iterator = this._deniedMembers.values().iterator();
        while (iterator.hasNext()) {
            objectArray = (Object[])iterator.next();
            if (!objectArray.isDenied(by)) continue;
            linkedList.addLast(objectArray);
        }
        objectArray = linkedList.toArray(new VRIMemberDescription[linkedList.size()]);
        if (bl) {
            Arrays.sort(objectArray);
        }
        return objectArray;
    }

    public VRIMemberDescription[] getViewMinusDenied(byte by) {
        return VRIMemberUtils.minus((VRIMemberDescription[])this._viewMembers, this.getDeniedMembers(by, true));
    }

    public VRIMemberDescription[] getViewMinusDenied() {
        return VRIMemberUtils.minus((VRIMemberDescription[])this._viewMembers, this.getDeniedMembers(true));
    }

    public VRIMemberDescription[] getConnectedMinusDenied() {
        return VRIMemberUtils.minus(this.getConnectedMembers(true), this.getDeniedMembers(true));
    }

    public VRIMemberDescription[] getViewMembers() {
        VRIMemberDescription[] vRIMemberDescriptionArray = new VRIMemberDescriptionImpl[this._viewMembers.length];
        System.arraycopy(this._viewMembers, 0, vRIMemberDescriptionArray, 0, this._viewMembers.length);
        return vRIMemberDescriptionArray;
    }

    private boolean addDefinedMember(VRIMemberDescription vRIMemberDescription) {
        Object object;
        Object object2;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object2 = DCSTraceBuffer.entry(this._traceContext, "addDefinedMember", "");
            ((DCSTraceBuffer)object2).addProperty(vRIMemberDescription.getMemberDetails());
            ((DCSTraceBuffer)object2).invoke();
        }
        if (vRIMemberDescription == null) {
            object2 = new DCSIllegalParameterException("null member");
            throw object2;
        }
        boolean bl = false;
        if (this.isDefined(vRIMemberDescription.getName())) {
            bl = false;
        } else {
            object = (VRIMemberDescriptionImpl)vRIMemberDescription;
            ((VRIMemberDescriptionImpl)object).setDefined(true);
            this._definedMembers.put(vRIMemberDescription.getName(), object);
            this.reIndexDefinedSet();
            bl = true;
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            object = DCSTraceBuffer.exit(this._traceContext, "addDefinedMember", "");
            ((DCSTraceBuffer)object).addProperty("ReturnCode", bl);
            ((DCSTraceBuffer)object).invoke();
        }
        return bl;
    }

    public VRIMemberDescription[] addDefinedMembers(byte by, MemberInfo[] memberInfoArray, List list) {
        VRIMemberDescription[] vRIMemberDescriptionArray = null;
        if (memberInfoArray != null && memberInfoArray.length > 0) {
            vRIMemberDescriptionArray = new VRIMemberDescription[memberInfoArray.length];
            for (int i = 0; i < memberInfoArray.length; ++i) {
                if (!this.isDefined(memberInfoArray[i].getMemberName())) {
                    vRIMemberDescriptionArray[i] = this.createMemberDescription(memberInfoArray[i]);
                    this.addDefinedMember(vRIMemberDescriptionArray[i]);
                } else {
                    this.unDenyMember(by, memberInfoArray[i].getMemberName());
                    vRIMemberDescriptionArray[i] = this.getDefinedMember(memberInfoArray[i].getMemberName());
                }
                if (vRIMemberDescriptionArray[i] != null) continue;
                list.add(memberInfoArray[i].getMemberName());
            }
            this.reIndexDefinedSet();
        }
        return vRIMemberDescriptionArray;
    }

    private void reIndexDefinedSet() {
        this._definedMembersArray = this._definedMembers.values().toArray(new VRIMemberDescription[0]);
        Arrays.sort(this._definedMembersArray);
        for (int i = 0; i < this._definedMembersArray.length; ++i) {
            ((VRIMemberDescriptionImpl)this._definedMembersArray[i]).setDefinedIndex(i);
        }
    }

    public VRIMemberDescription createMemberDescription(MemberInfo memberInfo) {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this._traceContext, "createMemberDescription", "");
            ((DCSTraceBuffer)object).addProperty(memberInfo);
            ((DCSTraceBuffer)object).invoke();
        }
        if (memberInfo == null) {
            object = new DCSIllegalParameterException("VRIMembersMGR.createMemberDescription: null member");
            throw object;
        }
        object = new VRIMemberDescriptionImpl(memberInfo);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "createMemberDescription", "");
            dCSTraceBuffer.addProperty(object.getMemberDetails());
            dCSTraceBuffer.invoke();
        }
        return object;
    }

    public boolean addConnectedMember(String string) throws VRIIllegalStateException {
        boolean bl;
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this._traceContext, "addConnectedMember", "");
            ((DCSTraceBuffer)object).addProperty("memberName", string);
            ((DCSTraceBuffer)object).invoke();
        }
        if ((object = (VRIMemberDescriptionImpl)this.getDefinedMember(string)) == null) {
            VRIIllegalStateException vRIIllegalStateException = new VRIIllegalStateException(11, "VRIMembersMGR.addConnectedMember: member is not defined: " + string);
            throw vRIIllegalStateException;
        }
        if (((VRIMemberDescriptionImpl)object).isConnected()) {
            bl = false;
        } else {
            this._connectedMembers.put(string, object);
            ((VRIMemberDescriptionImpl)object).setConnected(true);
            bl = true;
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "addConnectedMember", "");
            dCSTraceBuffer.addProperty("ReturnCode", bl);
            dCSTraceBuffer.invoke();
        }
        return bl;
    }

    public boolean denyMember(String string, VRIDenialReason vRIDenialReason) throws VRIIllegalStateException {
        boolean bl;
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this._traceContext, "denyMember", "");
            ((DCSTraceBuffer)object).addProperty("memberName", string);
            ((DCSTraceBuffer)object).addProperty(vRIDenialReason);
            ((DCSTraceBuffer)object).invoke();
        }
        if (this._thisMember.getName().equals(string)) {
            object = new VRIIllegalStateException(11, "VRIMembersMGR.denyMember: member is this member");
            throw object;
        }
        object = (VRIMemberDescriptionImpl)this.getDefinedMember(string);
        if (object == null) {
            VRIIllegalStateException vRIIllegalStateException = new VRIIllegalStateException(11, "VRIMembersMGR.denyMember: member is not defined");
            throw vRIIllegalStateException;
        }
        ((VRIMemberDescriptionImpl)object).addDenialReason(vRIDenialReason);
        if (this.isDenied(string)) {
            bl = false;
        } else {
            this._deniedMembers.put(string, object);
            bl = true;
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "denyMember", "");
            dCSTraceBuffer.addProperty("ReturnCode", bl);
            dCSTraceBuffer.invoke();
        }
        return bl;
    }

    public void removeDefinedMembers(byte by, String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            String string = stringArray[i];
            VRIMemberDescription vRIMemberDescription = this.getDefinedMember(string);
            if (vRIMemberDescription == null) continue;
            this.resetMemberLayerData(string, by);
            this.removeConnectedMember(string);
            this.removeDefinedMember(string);
        }
        this.reIndexDefinedSet();
    }

    private boolean removeDefinedMember(String string) throws VRIIllegalStateException {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this._traceContext, "removeDefinedMember", "");
            ((DCSTraceBuffer)object).addProperty("memberName", string);
            ((DCSTraceBuffer)object).invoke();
        }
        if ((object = (VRIMemberDescriptionImpl)this.getDefinedMember(string)) == null) {
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "removeDefinedMember", "");
                dCSTraceBuffer.addProperty("ReturnCode", false);
                dCSTraceBuffer.invoke();
            }
            return false;
        }
        if (this._thisMember.getName().equals(string)) {
            VRIIllegalStateException vRIIllegalStateException = new VRIIllegalStateException(11, "VRIMembersMGR.removeDefinedMember: member is this member");
            throw vRIIllegalStateException;
        }
        if (((VRIMemberDescriptionImpl)object).isInView()) {
            VRIIllegalStateException vRIIllegalStateException = new VRIIllegalStateException(11, "VRIMembersMGR.removeDefinedMember: member is in view");
            throw vRIIllegalStateException;
        }
        for (byte by = 0; by < 11; by = (byte)(by + 1)) {
            this.resetMemberLayerData(string, by);
            this.unDenyMember(by, string);
        }
        this._deniedMembers.remove(string);
        this._connectedMembers.remove(string);
        this._definedMembers.remove(string);
        ((VRIMemberDescriptionImpl)object).setDefined(false);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "removeDefinedMember", "");
            dCSTraceBuffer.addProperty("ReturnCode", true);
            dCSTraceBuffer.invoke();
        }
        return true;
    }

    public boolean removeConnectedMember(String string) throws VRIIllegalStateException {
        Object object;
        boolean bl;
        Object object2;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object2 = DCSTraceBuffer.entry(this._traceContext, "removeConnectedMember", "");
            ((DCSTraceBuffer)object2).addProperty("memberName", string);
            ((DCSTraceBuffer)object2).invoke();
        }
        if (this._thisMember.getName().equals(string)) {
            object2 = new VRIIllegalStateException(11, "VRIMembersMGR.removeConnectedMember: member is this member");
            throw object2;
        }
        if (!this.isConnected(string)) {
            bl = false;
        } else {
            object = (VRIMemberDescriptionImpl)this._definedMembers.get(string);
            ((VRIMemberDescriptionImpl)object).setConnected(false);
            this._connectedMembers.remove(string);
            bl = true;
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            object = DCSTraceBuffer.exit(this._traceContext, "removeConnectedMember", "");
            ((DCSTraceBuffer)object).addProperty("ReturnCode", bl);
            ((DCSTraceBuffer)object).invoke();
        }
        return bl;
    }

    public boolean unDenyMember(byte by, String string) {
        boolean bl;
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this._traceContext, "unDenyMember", "");
            ((DCSTraceBuffer)object).addProperty("Layer", by);
            ((DCSTraceBuffer)object).addProperty("memberName", string);
            ((DCSTraceBuffer)object).invoke();
        }
        if ((object = (VRIMemberDescriptionImpl)this.getDefinedMember(string)) == null) {
            return false;
        }
        ((VRIMemberDescriptionImpl)object).removeDenialReason(by);
        if (((VRIMemberDescriptionImpl)object).isDenialReasonsEmpty()) {
            this._deniedMembers.remove(string);
            bl = true;
        } else {
            bl = false;
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "unDenyMember", "");
            dCSTraceBuffer.addProperty("ReturnCode", bl);
            dCSTraceBuffer.invoke();
        }
        return bl;
    }

    public void unDenyAll(byte by, int[] nArray, boolean bl) {
        VRIMemberDescription[] vRIMemberDescriptionArray;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            vRIMemberDescriptionArray = DCSTraceBuffer.entry(this._traceContext, "unDenyAll", "");
            vRIMemberDescriptionArray.addProperty("Layer", by);
            vRIMemberDescriptionArray.addProperty("DenialCodes", nArray);
            vRIMemberDescriptionArray.addProperty("Flag", bl);
            vRIMemberDescriptionArray.invoke();
        }
        if (nArray == null) {
            nArray = new int[]{};
        }
        if ((vRIMemberDescriptionArray = this.getDeniedMembers(by, false)) != null) {
            for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
                VRIMemberDescription vRIMemberDescription = vRIMemberDescriptionArray[i];
                if (!vRIMemberDescription.isDeniedByThisLayer(by) || bl && vRIMemberDescription.isInView()) continue;
                VRIDenialReason vRIDenialReason = vRIMemberDescription.getDenialReason(by);
                boolean bl2 = true;
                for (int j = 0; j < nArray.length; ++j) {
                    if (vRIDenialReason.getDenialReasonCode() != nArray[j]) continue;
                    bl2 = false;
                    break;
                }
                if (!bl2) continue;
                this.unDenyMember(by, vRIMemberDescription.getName());
            }
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "unDenyAll", "");
            dCSTraceBuffer.invoke();
        }
    }

    public VRIDenialReason[] getDenialReasons(String string) {
        if (this.isDenied(string)) {
            VRIMemberDescriptionImpl vRIMemberDescriptionImpl = (VRIMemberDescriptionImpl)this.getDeniedMember(string);
            return vRIMemberDescriptionImpl.getDenialReasons();
        }
        return null;
    }

    public void newView(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl) throws VRIIllegalStateException {
        VRIMemberDescriptionImpl[] vRIMemberDescriptionImplArray;
        int n;
        DCSTraceBuffer dCSTraceBuffer;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this._traceContext, "newView", "");
            dCSTraceBuffer.addProperty(viewIdImpl);
            dCSTraceBuffer.addProperty("viewMembers", VRIMemberUtils.toString(vRIMemberDescriptionArray));
            dCSTraceBuffer.invoke();
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "newView", "");
            dCSTraceBuffer.addProperty(viewIdImpl);
            dCSTraceBuffer.addProperty("viewMembers", VRIMemberUtils.toString(vRIMemberDescriptionArray));
            dCSTraceBuffer.invoke();
        }
        if (viewIdImpl == null) {
            this.handleIllegalNewView();
            throw new VRIIllegalStateException(11, "VRIMembersMGR.newView: null view id");
        }
        if (vRIMemberDescriptionArray == null) {
            this.handleIllegalNewView();
            throw new VRIIllegalStateException(11, "VRIMembersMGR.newView: null view members");
        }
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            if (vRIMemberDescriptionArray[i] != null) continue;
            this.handleIllegalNewView();
            throw new VRIIllegalStateException(11, "VRIMembersMGR.newView: null view member in entry: " + i);
        }
        Object[] objectArray = new VRIMemberDescriptionImpl[vRIMemberDescriptionArray.length];
        System.arraycopy(vRIMemberDescriptionArray, 0, objectArray, 0, vRIMemberDescriptionArray.length);
        Arrays.sort(objectArray);
        this._curViewId = viewIdImpl;
        for (n = 0; n < this._viewMembers.length; ++n) {
            this._viewMembers[n].setNotInView();
        }
        this._viewMembers = (VRIMemberDescriptionImpl[])objectArray;
        this._viewNameIndexMap.clear();
        for (n = 0; n < this._viewMembers.length; ++n) {
            vRIMemberDescriptionImplArray = this._viewMembers[n];
            if (!this.isDefined(vRIMemberDescriptionImplArray.getName())) {
                VRIIllegalStateException vRIIllegalStateException = new VRIIllegalStateException(11, "VRIMembersMGR.newView: member " + vRIMemberDescriptionImplArray.getName() + " is not defined ");
                this.handleIllegalNewView();
                throw vRIIllegalStateException;
            }
            this._viewMembers[n] = vRIMemberDescriptionImplArray;
            this._viewNameIndexMap.put(vRIMemberDescriptionImplArray.getName(), new Integer(n));
            this._viewMembers[n].setInView(n);
        }
        if (!this._thisMember.isInView()) {
            VRIIllegalStateException vRIIllegalStateException = new VRIIllegalStateException(11, "VRIMembersMGR.newView: this member is not in view");
            this._viewMembers = new VRIMemberDescriptionImpl[0];
            vRIMemberDescriptionImplArray = (VRIMemberDescriptionImpl[])this.getDefinedMembers(false);
            for (int i = 0; i < vRIMemberDescriptionImplArray.length; ++i) {
                vRIMemberDescriptionImplArray[i].setNotInView();
            }
            this.handleIllegalNewView();
            throw vRIIllegalStateException;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.event(this._traceContext, "newView", "Status after newView");
            dCSTraceBuffer2.addProperty(this);
            dCSTraceBuffer2.invoke();
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer3 = DCSTraceBuffer.exit(this._traceContext, "newView", "");
            dCSTraceBuffer3.invoke();
        }
    }

    public int getDefinedMembersSize() {
        return this._definedMembers.size();
    }

    public int getConnectedMembersSize() {
        return this._connectedMembers.size();
    }

    public int getViewMembersSize() {
        return this._viewMembers.length;
    }

    public int getDeniedMembersSize() {
        return this._deniedMembers.size();
    }

    public boolean setMemberLayerData(String string, VRIMemberLayerData vRIMemberLayerData) throws VRIIllegalStateException {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this._traceContext, "setMemberLayerData", "");
            ((DCSTraceBuffer)object).addProperty("memberName", string);
            ((DCSTraceBuffer)object).addProperty("MemberLayerData", vRIMemberLayerData);
            ((DCSTraceBuffer)object).invoke();
        }
        if ((object = (VRIMemberDescriptionImpl)this.getDefinedMember(string)) == null) {
            VRIIllegalStateException vRIIllegalStateException = new VRIIllegalStateException(11, "VRIMembersMGR.setLayerData: member " + string + " is not defined ");
            throw vRIIllegalStateException;
        }
        boolean bl = true;
        if (((VRIMemberDescriptionImpl)object).getLayerData(vRIMemberLayerData.getLayer()) != null) {
            this.resetMemberLayerData(string, vRIMemberLayerData.getLayer());
            bl = false;
        }
        this._layerData2memberMaps[vRIMemberLayerData.getLayer()].put(vRIMemberLayerData.getHashKey(), object);
        ((VRIMemberDescriptionImpl)object).setLayerData(vRIMemberLayerData);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "setMemberLayerData", "");
            dCSTraceBuffer.addProperty("ReturnCode", bl);
            dCSTraceBuffer.invoke();
        }
        return bl;
    }

    public VRIMemberLayerData getMemberLayerData(String string, byte by) throws VRIIllegalStateException {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this._traceContext, "getMemberLayerData", "");
            ((DCSTraceBuffer)object).addProperty("memberName", string);
            ((DCSTraceBuffer)object).addProperty("Layer", by);
            ((DCSTraceBuffer)object).invoke();
        }
        if ((object = (VRIMemberDescriptionImpl)this.getDefinedMember(string)) == null) {
            VRIIllegalStateException vRIIllegalStateException = new VRIIllegalStateException(11, "VRIMembersMGR.getLayerData: member " + string + " is not defined ");
            throw vRIIllegalStateException;
        }
        VRIMemberLayerData vRIMemberLayerData = ((VRIMemberDescriptionImpl)object).getLayerData(by);
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "getMemberLayerData", "");
            dCSTraceBuffer.addProperty("ReturnCode", vRIMemberLayerData);
            dCSTraceBuffer.invoke();
        }
        return vRIMemberLayerData;
    }

    public boolean resetMemberLayerData(String string, byte by) throws VRIIllegalStateException {
        boolean bl;
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this._traceContext, "resetMemberLayerData", "");
            ((DCSTraceBuffer)object).addProperty("memberName", string);
            ((DCSTraceBuffer)object).addProperty("Layer", by);
            ((DCSTraceBuffer)object).invoke();
        }
        if (!this.isDefined(string)) {
            object = new VRIIllegalStateException(11, "VRIMembersMGR.resetLayerData: member " + string + " is not defined ");
            throw object;
        }
        object = (VRIMemberDescriptionImpl)this.getDefinedMember(string);
        VRIMemberLayerData vRIMemberLayerData = ((VRIMemberDescriptionImpl)object).getLayerData(by);
        if (vRIMemberLayerData != null) {
            this._layerData2memberMaps[by].remove(vRIMemberLayerData.getHashKey());
            ((VRIMemberDescriptionImpl)object).resetLayerData(by);
            bl = true;
        } else {
            bl = false;
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "resetMemberLayerData", "");
            dCSTraceBuffer.addProperty("ReturnCode", bl);
            dCSTraceBuffer.invoke();
        }
        return bl;
    }

    public VRIMemberDescription getMemberByLayerData(byte by, String string) {
        return (VRIMemberDescription)this._layerData2memberMaps[by].get(string);
    }

    public VRIMemberLayerData[] getMembersLayerData(byte by, VRIMemberDescription[] vRIMemberDescriptionArray) {
        VRIMemberLayerData[] vRIMemberLayerDataArray = new VRIMemberLayerData[vRIMemberDescriptionArray.length];
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            vRIMemberLayerDataArray[i] = vRIMemberDescriptionArray[i].getLayerData(by);
        }
        return vRIMemberLayerDataArray;
    }

    public String dump() {
        if (DCSTraceBuffer.isDumpEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "dump", "");
            dCSTraceBuffer.addProperty(this);
            dCSTraceBuffer.invoke();
        }
        return this.toString();
    }

    public VRICheckFailedException check() {
        Object object;
        Object object2;
        int n;
        boolean bl = true;
        String string = "VRIMembersMGR.check: FALSE:";
        VRIMemberDescription[] vRIMemberDescriptionArray = null;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.entry(this._traceContext, "check", "");
            dCSTraceBuffer.invoke();
        }
        vRIMemberDescriptionArray = this.getConnectedMembers(false);
        for (n = 0; n < vRIMemberDescriptionArray.length; ++n) {
            if (vRIMemberDescriptionArray[n].isDefined()) continue;
            object2 = ".Found a connected member, that is not defined:" + vRIMemberDescriptionArray[n].getName();
            bl = false;
            string = string + (String)object2;
            if (!DCSTraceBuffer.isDebugEnabled(TC)) continue;
            object = DCSTraceBuffer.debug(this._traceContext, "check", "Check failed: Connected member is not defined");
            ((DCSTraceBuffer)object).addProperty("memberName", vRIMemberDescriptionArray[n].getName());
            ((DCSTraceBuffer)object).invoke();
        }
        vRIMemberDescriptionArray = this.getViewMembers();
        for (n = 0; n < vRIMemberDescriptionArray.length; ++n) {
            if (vRIMemberDescriptionArray[n].isDefined()) continue;
            object2 = ".Found a view member, that is not defined:" + vRIMemberDescriptionArray[n].getName();
            bl = false;
            string = string + (String)object2;
            if (!DCSTraceBuffer.isDebugEnabled(TC)) continue;
            object = DCSTraceBuffer.debug(this._traceContext, "check", "Check failed: View member is not defined");
            ((DCSTraceBuffer)object).addProperty("memberName", vRIMemberDescriptionArray[n].getName());
            ((DCSTraceBuffer)object).invoke();
        }
        if (this.getDeniedMembersSize() != 0) {
            vRIMemberDescriptionArray = this.getDeniedMembers(false);
            for (n = 0; n < vRIMemberDescriptionArray.length; ++n) {
                if (vRIMemberDescriptionArray[n].isDefined()) continue;
                object2 = ".Found a denied member, that is not defined:" + vRIMemberDescriptionArray[n].getName();
                bl = false;
                string = string + (String)object2;
                if (!DCSTraceBuffer.isDebugEnabled(TC)) continue;
                object = DCSTraceBuffer.debug(this._traceContext, "check", "Check failed: Denied member is not defined");
                ((DCSTraceBuffer)object).addProperty("memberName", vRIMemberDescriptionArray[n].getName());
                ((DCSTraceBuffer)object).invoke();
            }
        }
        if (!this._thisMember.isDefined()) {
            String string2 = ".local member is not in defined";
            bl = false;
            string = string + string2;
            if (DCSTraceBuffer.isDebugEnabled(TC)) {
                object2 = DCSTraceBuffer.debug(this._traceContext, "check", "Check failed: Local member is not defined");
                ((DCSTraceBuffer)object2).addProperty("memberName", this._thisMember.getName());
                ((DCSTraceBuffer)object2).invoke();
            }
        }
        if (!this._thisMember.isConnected()) {
            String string3 = ".local member is not in connected";
            bl = false;
            string = string + string3;
            if (DCSTraceBuffer.isDebugEnabled(TC)) {
                object2 = DCSTraceBuffer.debug(this._traceContext, "check", "Check failed: Local member is not connected");
                ((DCSTraceBuffer)object2).addProperty("memberName", this._thisMember.getName());
                ((DCSTraceBuffer)object2).invoke();
            }
        }
        if (!this._thisMember.isInView()) {
            String string4 = ".local member is not in view";
            bl = false;
            string = string + string4;
            if (DCSTraceBuffer.isDebugEnabled(TC)) {
                object2 = DCSTraceBuffer.debug(this._traceContext, "check", "Check failed: Local member is not in view");
                ((DCSTraceBuffer)object2).addProperty("memberName", this._thisMember.getName());
                ((DCSTraceBuffer)object2).invoke();
            }
        }
        if (this._thisMember.isDenied()) {
            String string5 = ".local member is denied";
            bl = false;
            string = string + string5;
            if (DCSTraceBuffer.isDebugEnabled(TC)) {
                object2 = DCSTraceBuffer.debug(this._traceContext, "check", "Check failed: Local member is denied");
                ((DCSTraceBuffer)object2).addProperty("memberName", this._thisMember.getName());
                ((DCSTraceBuffer)object2).invoke();
            }
        }
        vRIMemberDescriptionArray = this.getDefinedMembers(false);
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            DCSTraceBuffer dCSTraceBuffer;
            object2 = vRIMemberDescriptionArray[i];
            if (!object2.isDefined()) {
                object = ".found a member in defined members, that has defined flag off:\n" + object2.getName();
                bl = false;
                string = string + (String)object;
                if (DCSTraceBuffer.isDebugEnabled(TC)) {
                    dCSTraceBuffer = DCSTraceBuffer.debug(this._traceContext, "check", "Check failed: Defined member with defined flag off");
                    dCSTraceBuffer.addProperty("memberName", object2.getName());
                    dCSTraceBuffer.invoke();
                }
            }
            if (object2.isConnected()) {
                if (!this.isConnected(object2.getName())) {
                    object = ".found a member with connected flag on, that is not in connected:\n" + object2.getName();
                    bl = false;
                    string = string + (String)object;
                    if (DCSTraceBuffer.isDebugEnabled(TC)) {
                        dCSTraceBuffer = DCSTraceBuffer.debug(this._traceContext, "check", "Check failed: Disconnected member with connected flag on");
                        dCSTraceBuffer.addProperty("memberName", object2.getName());
                        dCSTraceBuffer.invoke();
                    }
                }
            } else if (this.isConnected(object2.getName())) {
                object = ".found a member with connected flag off, that is in connected:\n" + object2.getName();
                bl = false;
                string = string + (String)object;
                if (DCSTraceBuffer.isDebugEnabled(TC)) {
                    dCSTraceBuffer = DCSTraceBuffer.debug(this._traceContext, "check", "Check failed: Connected member with connected flag off");
                    dCSTraceBuffer.addProperty("memberName", object2.getName());
                    dCSTraceBuffer.invoke();
                }
            }
            if (object2.isInView()) {
                if (!this.isInView(object2.getName())) {
                    object = ".found a member with inView flag on, that is not in view:\n" + object2.getName();
                    bl = false;
                    string = string + (String)object;
                    if (DCSTraceBuffer.isDebugEnabled(TC)) {
                        dCSTraceBuffer = DCSTraceBuffer.debug(this._traceContext, "check", "Check failed: Not in view member with inView flag on");
                        dCSTraceBuffer.addProperty("memberName", object2.getName());
                        dCSTraceBuffer.invoke();
                    }
                }
                if (object2.getIndexInView() != this.getViewMemberIndex(object2.getName())) {
                    object = ".found a member with inViewIndex not correspond to real index:\n" + object2.getName() + "\n" + "ViewIndex is " + object2.getIndexInView() + "\n" + "Real index is " + this.getViewMemberIndex(object2.getName());
                    bl = false;
                    string = string + (String)object;
                    if (DCSTraceBuffer.isDebugEnabled(TC)) {
                        dCSTraceBuffer = DCSTraceBuffer.debug(this._traceContext, "check", "Check failed: Wrong view index");
                        dCSTraceBuffer.addProperty("memberName", object2.getName());
                        dCSTraceBuffer.addProperty("ViewIndex", object2.getIndexInView());
                        dCSTraceBuffer.addProperty("RealIndex", this.getViewMemberIndex(object2.getName()));
                        dCSTraceBuffer.invoke();
                    }
                }
            } else {
                if (this.isInView(object2.getName())) {
                    object = ".found a member with inView flag off, that is in view:\n" + object2.getName();
                    bl = false;
                    string = string + (String)object;
                    if (DCSTraceBuffer.isDebugEnabled(TC)) {
                        dCSTraceBuffer = DCSTraceBuffer.debug(this._traceContext, "check", "Check failed: View member with inView flag off");
                        dCSTraceBuffer.addProperty("memberName", object2.getName());
                        dCSTraceBuffer.invoke();
                    }
                }
                if (object2.getIndexInView() != -1 && TC.isDebugEnabled()) {
                    object = ".found a member not in view, with a view index:\n" + object2.getName() + "\n" + "ViewIndex is " + object2.getIndexInView();
                    bl = false;
                    string = string + (String)object;
                    if (DCSTraceBuffer.isDebugEnabled(TC)) {
                        dCSTraceBuffer = DCSTraceBuffer.debug(this._traceContext, "check", "Check failed: Not in view member with valid viewIndex");
                        dCSTraceBuffer.addProperty("memberName", object2.getName());
                        dCSTraceBuffer.addProperty("ViewIndex", object2.getIndexInView());
                        dCSTraceBuffer.invoke();
                    }
                }
            }
            if (object2.isDenied()) {
                if (this.isDenied(object2.getName())) continue;
                object = ".found a member with denied flag on, that is not in denied:\n" + object2.getName();
                bl = false;
                string = string + (String)object;
                if (!DCSTraceBuffer.isDebugEnabled(TC)) continue;
                dCSTraceBuffer = DCSTraceBuffer.debug(this._traceContext, "check", "Check failed: Not denied member with denied flag on");
                dCSTraceBuffer.addProperty("memberName", object2.getName());
                dCSTraceBuffer.invoke();
                continue;
            }
            if (!this.isDenied(object2.getName())) continue;
            object = ".found member with denied flag off, that is in denied:\n" + object2.getName();
            bl = false;
            string = string + (String)object;
            if (!DCSTraceBuffer.isDebugEnabled(TC)) continue;
            dCSTraceBuffer = DCSTraceBuffer.debug(this._traceContext, "check", "Check failed: Denied member with denied flag off");
            dCSTraceBuffer.addProperty("memberName", object2.getName());
            dCSTraceBuffer.invoke();
        }
        VRICheckFailedException vRICheckFailedException = null;
        if (!bl) {
            vRICheckFailedException = new VRICheckFailedException(string);
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            object2 = DCSTraceBuffer.exit(this._traceContext, "check", "");
            ((DCSTraceBuffer)object2).addProperty("ReturnCode", vRICheckFailedException);
            ((DCSTraceBuffer)object2).invoke();
        }
        return vRICheckFailedException;
    }

    public String toString() {
        Object object;
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList("VRIMembersMGR.Status");
        dCSTraceBuffer.addProperty(this._curViewId).addProperty("Version", this._protocolVersion).addProperty("Context", this._protocolVersionContext).addProperty("Local", this._thisMember.getMemberDetails()).addProperty("DefinedSet", VRIMemberUtils.toString(this.getDefinedMembers(true))).addProperty("connectedMembers", VRIMemberUtils.toString(this.getConnectedMembers(true))).addProperty("viewMembers", VRIMemberUtils.toString(this.getViewMembers())).addProperty("deniedMembers", VRIMemberUtils.toString(this.getDeniedMembers(true)));
        DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.propertyList("DefinedMembersDescription");
        Iterator iterator = this._definedMembers.values().iterator();
        while (iterator.hasNext()) {
            object = (VRIMemberDescription)iterator.next();
            dCSTraceBuffer2.addProperty(object.getName(), object.getMemberDetails());
        }
        dCSTraceBuffer.addProperty(dCSTraceBuffer2);
        dCSTraceBuffer2 = DCSTraceBuffer.propertyList("LayerNodeData");
        for (int i = 0; i < this._layerData2memberMaps.length; ++i) {
            object = this._layerData2memberMaps[i];
            if (object.isEmpty()) continue;
            dCSTraceBuffer2.addProperty("Layer" + i, object.toString());
        }
        dCSTraceBuffer.addProperty(dCSTraceBuffer2);
        return dCSTraceBuffer.toString();
    }

    private void handleIllegalNewView() {
        this._curViewId = new ViewIdImpl(-1, "illegal");
        this._viewMembers = new VRIMemberDescriptionImpl[0];
        this._viewNameIndexMap.clear();
        VRIMemberDescriptionImpl[] vRIMemberDescriptionImplArray = (VRIMemberDescriptionImpl[])this.getDefinedMembers(false);
        for (int i = 0; i < vRIMemberDescriptionImplArray.length; ++i) {
            vRIMemberDescriptionImplArray[i].setNotInView();
        }
    }

    public String getTraceName() {
        return "VRIMembersManager";
    }

    public VRIMemberDescription getThisMember() {
        return this._thisMember;
    }

    public String getThisStackName() {
        return this._thisStackName;
    }

    public boolean denyMembers(VRIMemberDescription[] vRIMemberDescriptionArray, VRIDenialReason vRIDenialReason) throws VRIIllegalStateException {
        int n;
        if (vRIMemberDescriptionArray == null || vRIDenialReason == null) {
            throw new VRIIllegalStateException(11, "VRIMembersMGR.denyMembers: null parameters");
        }
        for (n = 0; n < vRIMemberDescriptionArray.length; ++n) {
            if (vRIMemberDescriptionArray[n] == null) {
                throw new VRIIllegalStateException(11, "VRIMembersMGR.denyMembers: null parameter at index " + n);
            }
            if (vRIMemberDescriptionArray[n].isDefined()) continue;
            throw new VRIIllegalStateException(11, "VRIMembersMGR.denyMembers: member " + vRIMemberDescriptionArray[n].getName() + " is not defined");
        }
        n = 0;
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            boolean bl = this.denyMember(vRIMemberDescriptionArray[i].getName(), vRIDenialReason);
            n = n != 0 || bl ? 1 : 0;
        }
        return n != 0;
    }

    public void removeAdminastrativeDenials(byte by, int n) {
        VRIMemberDescription[] vRIMemberDescriptionArray = this.getDeniedMembers(by, true);
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            VRIDenialReason vRIDenialReason = vRIMemberDescriptionArray[i].getDenialReason(by);
            if (vRIDenialReason == null || vRIDenialReason.getDenialReasonCode() != n) continue;
            this.removeDefinedMember(vRIMemberDescriptionArray[i].getName());
        }
        this.reIndexDefinedSet();
    }

    public String[] getAdminastrativeDenials(byte by, int n) {
        VRIMemberDescription[] vRIMemberDescriptionArray = this.getDeniedMembers(by, true);
        int n2 = 0;
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            VRIDenialReason vRIDenialReason = vRIMemberDescriptionArray[i].getDenialReason(by);
            if (vRIDenialReason == null || vRIDenialReason.getDenialReasonCode() != n) continue;
            ++n2;
        }
        String[] stringArray = new String[n2];
        int n3 = 0;
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            VRIDenialReason vRIDenialReason = vRIMemberDescriptionArray[i].getDenialReason(by);
            if (vRIDenialReason == null || vRIDenialReason.getDenialReasonCode() != n) continue;
            stringArray[n3++] = vRIMemberDescriptionArray[i].getName();
        }
        return stringArray;
    }

    public VRIDenialReason[] getDenialReasons(VRIMemberDescription[] vRIMemberDescriptionArray, byte by) {
        if (vRIMemberDescriptionArray == null) {
            return new VRIDenialReason[0];
        }
        VRIDenialReason[] vRIDenialReasonArray = new VRIDenialReason[vRIMemberDescriptionArray.length];
        for (int i = 0; i < vRIMemberDescriptionArray.length; ++i) {
            vRIDenialReasonArray[i] = vRIMemberDescriptionArray[i].getDenialReason(by);
        }
        return vRIDenialReasonArray;
    }

    public int getViewMembersMinusDeniedSize() {
        int n = this.getViewMinusDenied().length;
        return n;
    }

    public int getConnectedMembersMinusDeniedSize() {
        int n = this.getConnectedMinusDenied().length;
        return n;
    }

    public final VRIMemberDescription pickActiveLeader(VRIMemberDescription[] vRIMemberDescriptionArray) {
        VRIMemberDescription[] vRIMemberDescriptionArray2 = this.getViewMinusDenied();
        if (vRIMemberDescriptionArray != null) {
            vRIMemberDescriptionArray2 = VRIMemberUtils.minus(vRIMemberDescriptionArray2, vRIMemberDescriptionArray);
        }
        if (vRIMemberDescriptionArray2 == null || vRIMemberDescriptionArray2.length == 0) {
            throw new DCSAssertException("No active members");
        }
        return VRIMemberUtils.pickLeader(vRIMemberDescriptionArray2);
    }

    public final int getProtocolVersion() {
        return this._protocolVersion;
    }

    public final StateVersion getProtocolVersionContext() {
        return this._protocolVersionContext;
    }

    public final void setProtocolVersion(int n, StateVersion stateVersion) {
        this._protocolVersion = n;
        this._protocolVersionContext = stateVersion;
    }

    private class ViewIndexVRIMemberDescriptionImpl
    implements VRIMemberDescription {
        private final int _sentIndex;
        private final ViewIdImpl _sentViewId;
        private boolean retrievedViewRecord = false;
        private VRIMemberDescription vmd = null;

        private boolean checkView() {
            if (this.retrievedViewRecord) {
                return true;
            }
            if (VRIMembersMGR.this._curViewId.equals(this._sentViewId)) {
                try {
                    this.vmd = VRIMembersMGR.this.getViewMember(this._sentIndex);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return false;
                }
                this.retrievedViewRecord = true;
                return true;
            }
            return false;
        }

        public MemberInfo getMemberInfo() {
            if (this.checkView()) {
                return this.vmd.getMemberInfo();
            }
            throw new DCSAssertException("Method should never be called");
        }

        public String toString() {
            if (this.checkView()) {
                return this.vmd.toString();
            }
            return "VI[" + this._sentIndex + "]__VW" + this._sentViewId;
        }

        public String getName() {
            if (this.checkView()) {
                return this.vmd.getName();
            }
            return "VI[" + this._sentIndex + "]__VW" + this._sentViewId;
        }

        public boolean isDefined() {
            if (this.checkView()) {
                return this.vmd.isDefined();
            }
            return false;
        }

        public boolean isConnected() {
            if (this.checkView()) {
                return this.vmd.isConnected();
            }
            throw new DCSAssertException("Method should never be called");
        }

        public boolean isInView() {
            if (this.checkView()) {
                return this.vmd.isInView();
            }
            throw new DCSAssertException("Method should never be called");
        }

        public int getIndexInView() {
            if (this.checkView()) {
                return this.vmd.getIndexInView();
            }
            throw new DCSAssertException("Method should never be called");
        }

        public boolean isDenied() {
            if (this.checkView()) {
                return this.vmd.isDenied();
            }
            throw new DCSAssertException("Method should not be called");
        }

        public boolean isDenied(byte by) {
            if (this.checkView()) {
                return this.vmd.isDenied(by);
            }
            throw new DCSAssertException("Method should not be called");
        }

        public boolean isDeniedByThisLayer(byte by) {
            if (this.checkView()) {
                return this.vmd.isDeniedByThisLayer(by);
            }
            throw new DCSAssertException("Method should not be called");
        }

        public VRIDenialReason getDenialReason(byte by) {
            if (this.checkView()) {
                return this.vmd.getDenialReason(by);
            }
            throw new DCSAssertException("Method should not be called");
        }

        public VRIMemberLayerData getLayerData(byte by) {
            if (this.checkView()) {
                return this.vmd.getLayerData(by);
            }
            throw new DCSAssertException("Method should not be called");
        }

        public DCSTraceable getMemberDetails() {
            if (this.checkView()) {
                return this.vmd.getMemberDetails();
            }
            throw new DCSAssertException("Method should not be called");
        }

        public int compareTo(Object object) {
            VRIMemberDescription vRIMemberDescription = (VRIMemberDescription)object;
            return this.getName().compareTo(vRIMemberDescription.getName());
        }

        public ViewIndexVRIMemberDescriptionImpl(int n, ViewIdImpl viewIdImpl) {
            this._sentIndex = n;
            this._sentViewId = viewIdImpl;
        }

        public String getTraceName() {
            return "ViewIndexMemberDescription";
        }

        public void setDefinedIndex(int n) {
            if (this.checkView()) {
                ((VRIMemberDescriptionImpl)this.vmd).setDefinedIndex(n);
            }
        }

        public int getDefinedIndex() {
            if (this.checkView()) {
                return this.vmd.getDefinedIndex();
            }
            return -1;
        }
    }

    private class DummyVRIMemberDescriptionImpl
    implements VRIMemberDescription {
        private String _memberId;

        private DummyVRIMemberDescriptionImpl() {
            throw new DCSAssertException("Method should never be called");
        }

        public MemberInfo getMemberInfo() {
            throw new DCSAssertException("Method should never be called");
        }

        public String toString() {
            return this._memberId;
        }

        public String getName() {
            return this._memberId;
        }

        public boolean isDefined() {
            return false;
        }

        public boolean isConnected() {
            throw new DCSAssertException("Method should never be called");
        }

        public boolean isInView() {
            return false;
        }

        public int getIndexInView() {
            throw new DCSAssertException("Method should never be called");
        }

        public boolean isDenied() {
            throw new DCSAssertException("Method should not be called");
        }

        public boolean isDenied(byte by) {
            throw new DCSAssertException("Method should not be called");
        }

        public boolean isDeniedByThisLayer(byte by) {
            throw new DCSAssertException("Method should not be called");
        }

        public VRIDenialReason getDenialReason(byte by) {
            throw new DCSAssertException("Method should not be called");
        }

        public VRIMemberLayerData getLayerData(byte by) {
            throw new DCSAssertException("Method should not be called");
        }

        public DCSTraceable getMemberDetails() {
            throw new DCSAssertException("Method should not be called");
        }

        public int compareTo(Object object) {
            VRIMemberDescription vRIMemberDescription = (VRIMemberDescription)object;
            return this.getName().compareTo(vRIMemberDescription.getName());
        }

        public DummyVRIMemberDescriptionImpl(String string) {
            this._memberId = string;
        }

        public String getTraceName() {
            return "DummyMemberDescription";
        }

        public void setDefinedIndex(int n) {
        }

        public int getDefinedIndex() {
            return -1;
        }
    }

    private class VRIMemberDescriptionImpl
    implements VRIMemberDescription {
        private int _definedIndex = -1;
        private String _memberId;
        private MemberInfo _memberInfo;
        private VRIMemberLayerData[] _layersData;
        private SortedMap _denialReasons;
        private boolean _isDefined;
        private boolean _isConnected;
        private boolean _isInView;
        private int _indexInView;

        private VRIMemberDescriptionImpl(MemberInfo memberInfo) {
            this._memberId = memberInfo.getMemberName();
            this._memberInfo = memberInfo;
            this._layersData = new VRIMemberLayerData[11];
            this._denialReasons = new TreeMap();
            this._isDefined = false;
            this._isConnected = false;
            this._isInView = false;
            this._indexInView = -1;
        }

        public MemberInfo getMemberInfo() {
            return this._memberInfo;
        }

        public String getName() {
            return this._memberId;
        }

        private boolean setLayerData(VRIMemberLayerData vRIMemberLayerData) {
            if (DCSTraceBuffer.isEntryEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.entry(VRIMembersMGR.this._traceContext, "setLayerData", "");
                dCSTraceBuffer.addProperty("LayerData", vRIMemberLayerData);
                dCSTraceBuffer.invoke();
            }
            boolean bl = this._layersData[vRIMemberLayerData.getLayer()] == null;
            this._layersData[vRIMemberLayerData.getLayer()] = vRIMemberLayerData;
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(VRIMembersMGR.this._traceContext, "setLayerData", "");
                dCSTraceBuffer.addProperty("ReturnCode", bl);
                dCSTraceBuffer.invoke();
            }
            return bl;
        }

        public VRIMemberLayerData getLayerData(byte by) {
            return this._layersData[by];
        }

        private boolean resetLayerData(byte by) {
            boolean bl;
            if (DCSTraceBuffer.isEntryEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.entry(VRIMembersMGR.this._traceContext, "resetLayerData", "");
                dCSTraceBuffer.addProperty("Layer", by);
                dCSTraceBuffer.invoke();
            }
            if (this._layersData[by] == null) {
                bl = false;
            } else {
                this._layersData[by] = null;
                bl = true;
            }
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(VRIMembersMGR.this._traceContext, "resetLayerData", "");
                dCSTraceBuffer.addProperty("ReturnCode", bl);
                dCSTraceBuffer.invoke();
            }
            return bl;
        }

        public void dump() {
            if (DCSTraceBuffer.isDumpEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(VRIMembersMGR.this._traceContext, "dump", "");
                dCSTraceBuffer.addProperty(this.getMemberDetails());
                dCSTraceBuffer.invoke();
            }
        }

        private boolean addDenialReason(VRIDenialReason vRIDenialReason) {
            DCSTraceable dCSTraceable;
            boolean bl;
            Byte by;
            if (DCSTraceBuffer.isEntryEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.entry(VRIMembersMGR.this._traceContext, "addDenialReason", "");
                dCSTraceBuffer.addProperty(vRIDenialReason);
                dCSTraceBuffer.invoke();
            }
            if (this._denialReasons.containsKey(by = new Byte(vRIDenialReason.getLayer()))) {
                bl = false;
                dCSTraceable = (VRIDenialReason)this._denialReasons.get(by);
                if (!((VRIDenialReason)dCSTraceable).isSticky(vRIDenialReason)) {
                    this._denialReasons.put(by, vRIDenialReason);
                }
            } else {
                bl = true;
                this._denialReasons.put(by, vRIDenialReason);
            }
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                dCSTraceable = DCSTraceBuffer.exit(VRIMembersMGR.this._traceContext, "addDenialReason", "");
                ((DCSTraceBuffer)dCSTraceable).addProperty("ReturnCode", bl);
                ((DCSTraceBuffer)dCSTraceable).invoke();
            }
            return bl;
        }

        private boolean removeDenialReason(byte by) {
            boolean bl;
            Byte by2;
            if (DCSTraceBuffer.isEntryEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.entry(VRIMembersMGR.this._traceContext, "removeDenialReason", "");
                dCSTraceBuffer.addProperty("Layer", by);
                dCSTraceBuffer.invoke();
            }
            if (this._denialReasons.containsKey(by2 = new Byte(by))) {
                this._denialReasons.remove(by2);
                bl = true;
            } else {
                bl = false;
            }
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(VRIMembersMGR.this._traceContext, "removeDenialReason", "");
                dCSTraceBuffer.addProperty("ReturnCode", bl);
                dCSTraceBuffer.invoke();
            }
            return bl;
        }

        private VRIDenialReason[] getDenialReasons() {
            if (this._denialReasons.isEmpty()) {
                return null;
            }
            VRIDenialReason[] vRIDenialReasonArray = new VRIDenialReason[this._denialReasons.size()];
            vRIDenialReasonArray = this._denialReasons.values().toArray(vRIDenialReasonArray);
            return vRIDenialReasonArray;
        }

        private VRIDenialReason getFirstDenialReason() {
            if (this._denialReasons.isEmpty()) {
                return null;
            }
            return (VRIDenialReason)this._denialReasons.get(this._denialReasons.firstKey());
        }

        public VRIDenialReason getDenialReason(byte by) {
            Byte by2 = new Byte(by);
            return (VRIDenialReason)this._denialReasons.get(by2);
        }

        private boolean isDenialReasonsEmpty() {
            return this._denialReasons.isEmpty();
        }

        public int compareTo(Object object) {
            if (object instanceof DummyVRIMemberDescriptionImpl) {
                return -1 * ((DummyVRIMemberDescriptionImpl)object).compareTo(this);
            }
            VRIMemberDescriptionImpl vRIMemberDescriptionImpl = (VRIMemberDescriptionImpl)object;
            return this.getName().compareTo(vRIMemberDescriptionImpl.getName());
        }

        public int hashCode() {
            return this.getName().hashCode();
        }

        public String toString() {
            return this._memberId;
        }

        public DCSTraceable getMemberDetails() {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList("memberDescription");
            dCSTraceBuffer.addProperty("memberName", this._memberId);
            dCSTraceBuffer.addProperty(this._memberInfo);
            DCSTraceBuffer dCSTraceBuffer2 = DCSTraceBuffer.propertyList("LayersData");
            for (int i = 0; i < this._layersData.length; ++i) {
                if (this._layersData[i] == null) continue;
                dCSTraceBuffer2.addProperty("Layer" + i, ((Object)this._layersData[i]).toString());
            }
            dCSTraceBuffer.addProperty(dCSTraceBuffer2);
            dCSTraceBuffer2 = DCSTraceBuffer.propertyList("DenialReasons");
            Iterator iterator = this._denialReasons.values().iterator();
            while (iterator.hasNext()) {
                VRIDenialReason vRIDenialReason = (VRIDenialReason)iterator.next();
                dCSTraceBuffer2.addProperty(vRIDenialReason);
            }
            dCSTraceBuffer.addProperty(dCSTraceBuffer2);
            return dCSTraceBuffer;
        }

        public boolean equals(Object object) {
            if (object == null) {
                return false;
            }
            if (!(object instanceof VRIMemberDescriptionImpl)) {
                return false;
            }
            return this.compareTo(object) == 0;
        }

        public boolean isConnected() {
            return this._isConnected;
        }

        public boolean isDefined() {
            return this._isDefined;
        }

        public boolean isInView() {
            return this._isInView;
        }

        private void setConnected(boolean bl) {
            this._isConnected = bl;
        }

        private void setDefined(boolean bl) {
            this._isDefined = bl;
        }

        private void setInView(int n) {
            this._isInView = true;
            this._indexInView = n;
        }

        private void setNotInView() {
            this._isInView = false;
            this._indexInView = -1;
        }

        public boolean isDenied(byte by) {
            if (!this.isDenied()) {
                return false;
            }
            byte by2 = this.getFirstDenialReason().getLayer();
            return by2 <= by;
        }

        public boolean isDeniedByThisLayer(byte by) {
            if (!this.isDenied()) {
                return false;
            }
            return this.getDenialReason(by) != null;
        }

        public boolean isDenied() {
            return !this._denialReasons.isEmpty();
        }

        public int getIndexInView() {
            return this._indexInView;
        }

        void setDefinedIndex(int n) {
            this._definedIndex = n;
        }

        public int getDefinedIndex() {
            return this._definedIndex;
        }
    }

    public class Encoding {
        public static final int VIEW = 1;
        public static final int DEFINED_SET = 2;
        public static final int MIXED = 3;
        public static final int FULL = 4;
    }
}

