/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common;

import com.ibm.ws.dcs.common.DCSTraceable;
import com.ibm.ws.dcs.common.ViewId;
import com.ibm.ws.dcs.vri.common.Arrayable;
import com.ibm.ws.dcs.vri.common.Utils;
import java.io.IOException;

public final class ViewIdImpl
implements Arrayable,
DCSTraceable,
ViewId {
    private static final long serialVersionUID = 9111475521977185523L;
    private static final int FIRSTVIEWNUM = 1;
    private int _viewNumberMajor = 0;
    private int _viewNumberMinor = 0;
    private String _leader = null;
    private byte[] _baForm = null;
    private int _length = -1;
    private boolean _internalView = false;

    public ViewIdImpl(ViewIdImpl viewIdImpl) {
        this._viewNumberMajor = viewIdImpl._viewNumberMajor;
        this._viewNumberMinor = viewIdImpl._viewNumberMinor;
        this._leader = viewIdImpl._leader;
        this._internalView = viewIdImpl._internalView;
    }

    public ViewIdImpl() {
    }

    public ViewIdImpl(byte[] byArray, Utils.Offset offset) throws IOException {
        if (this.fromArray(byArray, offset) == null) {
            throw new IOException("Failed to extract view id from byte array");
        }
    }

    public ViewIdImpl(int n, String string) {
        this._viewNumberMajor = n;
        this._viewNumberMinor = 0;
        this._leader = string;
    }

    public ViewIdImpl(String string) {
        int n = string.indexOf(58);
        int n2 = string.indexOf(46);
        String string2 = string.substring(1, n);
        String string3 = string.substring(n + 1, n2);
        this._leader = string.substring(n2 + 1, string.length() - 1);
        this._viewNumberMajor = Integer.parseInt(string2);
        this._viewNumberMinor = Integer.parseInt(string3);
    }

    public static ViewIdImpl createFirstViewID(String string) {
        return new ViewIdImpl(1, string);
    }

    public int getViewMajorNumber() {
        return this._viewNumberMajor;
    }

    public double getViewNum() {
        return this._viewNumberMajor * 256 * 256 + this._viewNumberMinor;
    }

    public String getViewLeader() {
        return this._leader;
    }

    public int compareTo(Object object) {
        ViewIdImpl viewIdImpl = (ViewIdImpl)object;
        if (this._viewNumberMajor > viewIdImpl.getViewMajorNumber()) {
            return 1;
        }
        if (this._viewNumberMajor < viewIdImpl.getViewMajorNumber()) {
            return -1;
        }
        return this._leader.compareTo(viewIdImpl.getViewLeader());
    }

    public boolean isInternalView() {
        return this._internalView;
    }

    public void internalView(boolean bl) {
        this._internalView = bl;
        this._baForm = null;
    }

    public boolean isPossibleFromFuture(ViewIdImpl viewIdImpl) {
        return viewIdImpl.getViewMajorNumber() > this._viewNumberMajor;
    }

    public Arrayable fromArray(byte[] byArray, Utils.Offset offset) {
        this._viewNumberMajor = Utils.byteArray2int(byArray, offset);
        this._leader = Utils.byteArray2string(byArray, offset);
        if (this._leader == null) {
            return null;
        }
        int n = offset.getValue();
        this._internalView = byArray[n++] != 0;
        offset.setValue(n);
        return this;
    }

    public void toArray(byte[] byArray, Utils.Offset offset) {
        if (this._baForm == null) {
            this._baForm = new byte[this.getLength()];
            Utils.Offset offset2 = new Utils.Offset(0);
            Utils.int2byteArray(this._viewNumberMajor, this._baForm, offset2);
            Utils.string2byteArray(this._leader, this._baForm, offset2);
            int n = offset2.getValue();
            this._baForm[n++] = (byte)(this._internalView ? 1 : 0);
            offset2.setValue(n);
        }
        System.arraycopy(this._baForm, 0, byArray, offset.getValue(), this._length);
        offset.add(this._length);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (!(object instanceof ViewIdImpl)) {
            return false;
        }
        return this.compareTo(object) == 0;
    }

    public int hashCode() {
        return this._leader.hashCode() + this._viewNumberMajor;
    }

    public String toString() {
        return "(" + this._viewNumberMajor + ":" + this._viewNumberMinor + "." + this._leader + ")";
    }

    public int getLength() {
        if (this._length == -1) {
            this._length = Utils.sizeOfInt() + Utils.sizeOfString(this._leader) + 1;
        }
        return this._length;
    }

    public String getTraceName() {
        return "ViewID";
    }

    public boolean isPossibleFromFuture(ViewId viewId) {
        return false;
    }
}

