/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common.event;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.DCSTraceable;
import com.ibm.ws.dcs.common.exception.DCSAssertException;
import com.ibm.ws.dcs.vri.common.event.VRIEventHandler;
import com.ibm.ws.dcs.vri.common.event.VRIEventHandlersMap;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import java.util.LinkedList;

public abstract class VRIEvent
implements DCSTraceable,
DCSTraceContext {
    public static final int CONTINUE = 1;
    public static final int WAIT = 2;
    public static final int STOP = 3;
    private static final TraceComponent TC = Tr.register(VRIEvent.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    protected final LinkedList _history = new LinkedList();
    private final String _stackName;
    private final String _memberName;
    private String _currentLayer = null;

    protected VRIEvent(String string, String string2) {
        this._stackName = string;
        this._memberName = string2;
    }

    final void handle(String string, VRIEventHandlersMap vRIEventHandlersMap) {
        this._currentLayer = string;
        int n = 1;
        VRIEventHandler vRIEventHandler = null;
        if (vRIEventHandlersMap != null) {
            vRIEventHandler = vRIEventHandlersMap.getVRIEventHandler(this);
        }
        if (vRIEventHandler != null) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "handle", "");
                dCSTraceBuffer.addProperty(this);
                dCSTraceBuffer.addProperty(vRIEventHandler);
                dCSTraceBuffer.invoke();
            }
            n = vRIEventHandler.handle(this);
            this._history.addLast(string);
        } else if (DCSTraceBuffer.isDebugEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.debug(this, "handle", "Handler is not defined - ignore and continue");
            dCSTraceBuffer.addProperty(this);
            dCSTraceBuffer.invoke();
        }
        this.doAction(n);
    }

    private final void doAction(int n) {
        switch (n) {
            case 1: {
                if (this.isNextLayerSet()) {
                    if (DCSTraceBuffer.isDebugEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.debug(this, "handle", "Continue to next layer");
                        dCSTraceBuffer.addProperty(this);
                        dCSTraceBuffer.invoke();
                    }
                    this.goToNextLayer();
                    break;
                }
                this.stopHandling(false);
                break;
            }
            case 2: {
                if (!DCSTraceBuffer.isEventEnabled(TC)) break;
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "doAction", "Handle event asyncronously - waiting for resume");
                dCSTraceBuffer.addProperty(this);
                dCSTraceBuffer.invoke();
                break;
            }
            case 3: {
                this.stopHandling(true);
                break;
            }
            default: {
                DCSAssertException dCSAssertException = new DCSAssertException("Unknown action: " + n);
                if (!DCSTraceBuffer.isInternalWarningEnabled(TC)) break;
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "", dCSAssertException);
                dCSTraceBuffer.addProperty(this);
                dCSTraceBuffer.addProperty("History", this._history.toString());
                dCSTraceBuffer.invoke();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resumeHandling(Object object) {
        Object object2;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object2 = DCSTraceBuffer.event(this, "resumeHandling", "");
            ((DCSTraceBuffer)object2).addProperty(this);
            ((DCSTraceBuffer)object2).invoke();
        }
        if (this.isNextLayerSet()) {
            object2 = object;
            synchronized (object2) {
                this.goToNextLayer();
            }
        } else {
            this.stopHandling(false);
        }
    }

    public final void stopHandling() {
        this.stopHandling(true);
    }

    abstract void goToNextLayer();

    abstract boolean isNextLayerSet();

    public boolean isHandled() {
        return !this._history.isEmpty();
    }

    private void stopHandling(boolean bl) {
        if (this.isHandled()) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                String string = bl ? "Got explicit request to stop handling - handle done" : "No more layers - handle done";
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "handle", string);
                dCSTraceBuffer.addProperty(this);
                dCSTraceBuffer.addProperty("History", this._history.toString());
                dCSTraceBuffer.invoke();
            }
        } else {
            if (bl) {
                DCSAssertException dCSAssertException = new DCSAssertException("Event handling was stoped, but it's not fully handled");
                if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "", dCSAssertException);
                    dCSTraceBuffer.addProperty(this);
                    dCSTraceBuffer.addProperty("History", this._history.toString());
                    dCSTraceBuffer.invoke();
                }
                throw dCSAssertException;
            }
            if (DCSTraceBuffer.isInternalInfoEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalInfo(this, "No more layers, but event was not fully handled");
                dCSTraceBuffer.addProperty(this);
                dCSTraceBuffer.addProperty("History", this._history);
                dCSTraceBuffer.invoke();
            }
        }
    }

    public String getLayerName() {
        return this._currentLayer;
    }

    public String getMemberName() {
        return this._memberName;
    }

    public String getStackName() {
        return this._stackName;
    }

    public TraceComponent getTraceComponent() {
        return this.getTC();
    }

    protected TraceComponent getTC() {
        return TC;
    }
}

