/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.QoS;
import com.ibm.ws.dcs.common.ViewId;
import com.ibm.ws.dcs.common.event.DCSSuspectEvent;
import com.ibm.ws.dcs.common.event.DCSTerminationEvent;
import com.ibm.ws.dcs.common.exception.DCSAssertException;
import com.ibm.ws.dcs.common.exception.DCSCongestionException;
import com.ibm.ws.dcs.common.exception.DCSException;
import com.ibm.ws.dcs.common.exception.DCSIllegalParameterException;
import com.ibm.ws.dcs.common.exception.DCSInvalidMemberException;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.common.exception.DCSInvalidViewIDException;
import com.ibm.ws.dcs.common.exception.DCSMemberIsDeniedException;
import com.ibm.ws.dcs.common.exception.DCSMemberIsNotDefinedException;
import com.ibm.ws.dcs.common.exception.DCSMemberIsNotInViewException;
import com.ibm.ws.dcs.common.exception.DCSRuntimeException;
import com.ibm.ws.dcs.common.exception.DCSTransportLayerException;
import com.ibm.ws.dcs.common.exception.DCSUnsupportedQoSException;
import com.ibm.ws.dcs.stat.DCSStatsModule;
import com.ibm.ws.dcs.vri.common.AddDefinedFailedException;
import com.ibm.ws.dcs.vri.common.CCVersion;
import com.ibm.ws.dcs.vri.common.DCSConstants;
import com.ibm.ws.dcs.vri.common.Downcalls;
import com.ibm.ws.dcs.vri.common.Globals;
import com.ibm.ws.dcs.vri.common.LayerLinkage;
import com.ibm.ws.dcs.vri.common.Upcalls;
import com.ibm.ws.dcs.vri.common.VRICheckFailedException;
import com.ibm.ws.dcs.vri.common.VRIDenialReason;
import com.ibm.ws.dcs.vri.common.VRIIllegalStateException;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMembersMGR;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.event.CongestionControlEvent;
import com.ibm.ws.dcs.vri.common.event.VRIDownEvent;
import com.ibm.ws.dcs.vri.common.event.VRIEvent;
import com.ibm.ws.dcs.vri.common.event.VRIEventHandler;
import com.ibm.ws.dcs.vri.common.event.VRIEventHandlersMap;
import com.ibm.ws.dcs.vri.common.event.VRINotifyUpEvent;
import com.ibm.ws.dcs.vri.common.event.VRIUpEvent;
import com.ibm.ws.dcs.vri.common.impl.DCSOutgoingMessage;
import com.ibm.ws.dcs.vri.common.impl.Sidecall;
import com.ibm.ws.dcs.vri.common.nls.FreezeEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import com.ibm.ws.dcs.vri.common.util.FFDCDumper;
import java.util.Map;

public class ApplicationModuleImpl
implements Downcalls,
Upcalls,
LayerLinkage {
    private static final TraceComponent TC = Tr.register(ApplicationModuleImpl.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private static final String LAYER_NAME = DCSConstants.TRACE_LAYER_NAMES[8];
    static final int VERSION = 0x1000000;
    private final boolean _shortcutSelefsendPath;
    private final long _congestionTimeout;
    private final VRIMembersMGR _mgr;
    private final Object _mutex;
    private final Globals _globals;
    private Upcalls _up;
    private Downcalls _down;
    private final String _thisMemberName;
    private final String _stackName;
    private ViewIdImpl _currentViewID = null;
    private final CongestionLock _congestionLock;
    private final VRIEventHandlersMap _eventHandlers = new VRIEventHandlersMap();
    private final Sidecall _sidecall;
    private final int _checkInterval;
    private long _lastCheckTime = 0L;
    private final DCSTraceContext _traceContext;
    boolean _terminated = false;
    private final DCSStatsModule _statsModule;
    private final QoS.QOSMulticast _mcastFifoQOS;

    ApplicationModuleImpl(Globals globals, Sidecall sidecall) {
        this._globals = globals;
        this._shortcutSelefsendPath = this._globals.getConfigParamAsBoolean("SHORTCUT_SELFSEND_PATH");
        this._congestionTimeout = this._globals.getConfigParamAsLong("CONGESTION_TIMEOUT");
        this._mutex = this._globals.getMutex();
        this._mgr = this._globals.getVRIMembersMgr();
        this._thisMemberName = this._mgr.getThisMember().getName();
        this._sidecall = sidecall;
        this._stackName = this._globals.getGroupName();
        this._traceContext = new DCSTraceContextImpl(TC, this._stackName, this._thisMemberName, LAYER_NAME);
        this._statsModule = this._globals.statsModule;
        this._congestionLock = new CongestionLock();
        this._eventHandlers.setVRIEventHandler(CongestionControlEvent.class, this._congestionLock);
        this._checkInterval = globals.getConfigParamAsInt("DCS_CHECK_TIME_SEC") * 1000;
        try {
            this._mcastFifoQOS = QoS.getMulticastQoS(QoS.RELIABLE, QoS.FIFO);
        }
        catch (DCSUnsupportedQoSException dCSUnsupportedQoSException) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this._traceContext, "Failed to get desired QoS", dCSUnsupportedQoSException);
                dCSTraceBuffer.invoke();
            }
            throw new DCSRuntimeException("ApplicationModuleImpl initialization failed.", dCSUnsupportedQoSException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String string, DCSOutgoingMessage dCSOutgoingMessage, QoS.QOSUnicast qOSUnicast, Comparable comparable) throws DCSException {
        if (!this._thisMemberName.equals(string) || !this._shortcutSelefsendPath) {
            Object object;
            Object object2;
            if (DCSTraceBuffer.isDebugEnabled(TC)) {
                object2 = DCSTraceBuffer.debug(this._traceContext, "sendMessage", "before waitIfCongested");
                ((DCSTraceBuffer)object2).invoke();
            }
            object2 = this._congestionLock.waitIfCongested(this._congestionTimeout);
            if (DCSTraceBuffer.isDebugEnabled(TC)) {
                object = DCSTraceBuffer.debug(this._traceContext, "sendMessage", "after waitIfCongested");
                ((DCSTraceBuffer)object).addProperty("ReturnCode", String.valueOf(object2));
                ((DCSTraceBuffer)object).invoke();
            }
            if (object2 != null) {
                throw object2;
            }
            object = this._mutex;
            synchronized (object) {
                if (this._terminated) {
                    throw new DCSException("DCS stack " + this._stackName + " is terminated.");
                }
                VRIMemberDescription vRIMemberDescription = this._mgr.getDefinedMember(string);
                if (vRIMemberDescription == null) {
                    Object object3;
                    if (DCSTraceBuffer.isDebugEnabled(TC)) {
                        object3 = DCSTraceBuffer.debug(this._traceContext, "sendMessage", "Target node is not defined");
                        ((DCSTraceBuffer)object3).addProperty("memberName", string);
                        ((DCSTraceBuffer)object3).invoke();
                    }
                    object3 = this._mgr.getDefinedMembers(false);
                    throw new DCSMemberIsNotDefinedException(string, VRIMemberUtils.getMemberNames((VRIMemberDescription[])object3));
                }
                if (!vRIMemberDescription.isInView()) {
                    VRIMemberDescription[] vRIMemberDescriptionArray;
                    if (DCSTraceBuffer.isDebugEnabled(TC)) {
                        vRIMemberDescriptionArray = DCSTraceBuffer.debug(this._traceContext, "sendMessage", "Target node is not in view");
                        vRIMemberDescriptionArray.addProperty("memberName", string);
                        vRIMemberDescriptionArray.invoke();
                    }
                    vRIMemberDescriptionArray = this._mgr.getViewMembers();
                    throw new DCSMemberIsNotInViewException(string, VRIMemberUtils.getMemberNames(vRIMemberDescriptionArray));
                }
                try {
                    this.sendMessage(dCSOutgoingMessage.toVRIMessage(), vRIMemberDescription, qOSUnicast, (ViewIdImpl)comparable);
                }
                catch (DCSMemberIsDeniedException dCSMemberIsDeniedException) {
                    if (DCSTraceBuffer.isDebugEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.debug(this._traceContext, "sendMessage", "Target node is denied");
                        dCSTraceBuffer.addProperty("memberName", string);
                        dCSTraceBuffer.invoke();
                    }
                    return;
                }
            }
        }
        Object object = this._mutex;
        synchronized (object) {
            if (comparable != null && !comparable.equals(this._currentViewID)) {
                Object object4;
                if (DCSTraceBuffer.isDebugEnabled(TC)) {
                    object4 = DCSTraceBuffer.debug(this._traceContext, "sendMessage", "Invalid view id");
                    ((DCSTraceBuffer)object4).addProperty((ViewIdImpl)comparable);
                    ((DCSTraceBuffer)object4).invoke();
                }
                object4 = new DCSInvalidViewIDException((ViewId)comparable, this._currentViewID, "Trying to send message to itself in a wrong view");
                throw object4;
            }
            VRIMessage vRIMessage = dCSOutgoingMessage.toVRIMessage();
            int n = vRIMessage.prepareBuffer();
            byte[] byArray = vRIMessage.getDataBuffer();
            vRIMessage = this._globals.getMetaMessageFactory().getMessage(this._thisMemberName, byArray, 0, n);
            this._sidecall.onMessage(vRIMessage);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendMessage(String[] stringArray, DCSOutgoingMessage dCSOutgoingMessage, QoS qoS, Comparable comparable) throws DCSException {
        Object object;
        Object object2;
        if (stringArray == null || stringArray.length == 0) {
            return;
        }
        if (DCSTraceBuffer.isDebugEnabled(TC)) {
            object2 = DCSTraceBuffer.debug(this._traceContext, "sendMessage", "before waitIfCongested");
            ((DCSTraceBuffer)object2).invoke();
        }
        object2 = this._congestionLock.waitIfCongested(this._congestionTimeout);
        if (DCSTraceBuffer.isDebugEnabled(TC)) {
            object = DCSTraceBuffer.debug(this._traceContext, "sendMessage", "after waitIfCongested");
            ((DCSTraceBuffer)object).addProperty("ReturnCode", String.valueOf(object2));
            ((DCSTraceBuffer)object).invoke();
        }
        if (object2 != null) {
            throw object2;
        }
        object = this._mutex;
        synchronized (object) {
            if (qoS.isVS()) {
                throw new DCSIllegalParameterException("VS is not supported for group send");
            }
            VRIMemberDescription[] vRIMemberDescriptionArray = this.getTargets(stringArray);
            VRIMessage vRIMessage = dCSOutgoingMessage.toVRIMessage();
            this.mcastMessage(vRIMessage, vRIMemberDescriptionArray, this._mcastFifoQOS, null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mcastMessage(DCSOutgoingMessage dCSOutgoingMessage, QoS.QOSMulticast qOSMulticast, Comparable comparable) throws DCSException {
        Object object;
        Object object2;
        if (DCSTraceBuffer.isDebugEnabled(TC)) {
            object2 = DCSTraceBuffer.debug(this._traceContext, "mcastMessage", "before waitIfCongested");
            ((DCSTraceBuffer)object2).invoke();
        }
        object2 = this._congestionLock.waitIfCongested(this._congestionTimeout);
        if (DCSTraceBuffer.isDebugEnabled(TC)) {
            object = DCSTraceBuffer.debug(this._traceContext, "mcastMessage", "after waitIfCongested");
            ((DCSTraceBuffer)object).addProperty("ReturnCode", String.valueOf(object2));
            ((DCSTraceBuffer)object).invoke();
        }
        if (object2 != null) {
            throw object2;
        }
        object = this._mutex;
        synchronized (object) {
            if (this._terminated) {
                throw new DCSException("DCS stack " + this._stackName + " is terminated.");
            }
            this.mcastMessage(dCSOutgoingMessage.toVRIMessage(), qOSMulticast, (ViewIdImpl)comparable);
        }
    }

    public VRICheckFailedException check() {
        long l;
        Throwable throwable = this._sidecall.check();
        long l2 = System.currentTimeMillis();
        if (this._lastCheckTime != 0L && (l = this._lastCheckTime + (long)this._checkInterval) + 15000L < l2) {
            FreezeEvent freezeEvent = new FreezeEvent(this._traceContext, this._lastCheckTime, l2 - l);
            freezeEvent.invokeNLSTrace();
            VRINotifyUpEvent vRINotifyUpEvent = new VRINotifyUpEvent(freezeEvent);
            this._sidecall.onVRIUpEvent(vRINotifyUpEvent);
        }
        this._lastCheckTime = l2;
        if (throwable == null) {
            return this._up.check();
        }
        VRICheckFailedException vRICheckFailedException = new VRICheckFailedException("Application check failed", throwable);
        vRICheckFailedException.setUpperLayerExcetion(this._up.check());
        return vRICheckFailedException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void denyMember(DCSSuspectEvent dCSSuspectEvent, VRIDenialReason vRIDenialReason) {
        Object object = this._mutex;
        synchronized (object) {
            if (this._terminated) {
                return;
            }
            String[] stringArray = dCSSuspectEvent.getSuspectedMembers();
            for (int i = 0; i < stringArray.length; ++i) {
                this._mgr.denyMember(stringArray[i], vRIDenialReason);
            }
            this._up.suspectMembers(new DCSSuspectEvent[]{dCSSuspectEvent});
        }
    }

    void clearLayerSuspectList() {
        this._mgr.unDenyAll((byte)8, new int[0], true);
    }

    public void connectMembers(VRIMemberDescription[] vRIMemberDescriptionArray) {
        this._up.connectMembers(vRIMemberDescriptionArray);
    }

    public void suspectMembers(DCSSuspectEvent[] dCSSuspectEventArray) {
        this._up.suspectMembers(dCSSuspectEventArray);
    }

    public void currentOK(CCVersion cCVersion) {
        this._sidecall.currentOK(cCVersion);
    }

    public void completeCurrent(VRIMemberDescription[] vRIMemberDescriptionArray, CCVersion cCVersion) {
        this._sidecall.completeCurrent(vRIMemberDescriptionArray, cCVersion);
    }

    public void newViewOK(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, Map map) {
        this._sidecall.newViewOK(vRIMemberDescriptionArray, viewIdImpl, map);
    }

    public void deliver(VRIMessage vRIMessage) {
        this._sidecall.onMessage(vRIMessage);
    }

    public void requestTermination(DCSTerminationEvent dCSTerminationEvent) {
        this._up.requestTermination(dCSTerminationEvent);
    }

    public void proposeAgreement(VRIMessage vRIMessage) {
        this._up.proposeAgreement(vRIMessage);
    }

    public void deliverAgreed(VRIMessage vRIMessage) {
        this._up.deliverAgreed(vRIMessage);
    }

    public void newView(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, Map map) {
        this._currentViewID = viewIdImpl;
        this._sidecall.newView(vRIMemberDescriptionArray, viewIdImpl, map);
    }

    public void mcastMessage(VRIMessage vRIMessage, QoS.QOSMulticast qOSMulticast, ViewIdImpl viewIdImpl) throws DCSInvalidParametersException, DCSTransportLayerException {
        if (vRIMessage.getOriginatorLayer() == 8) {
            this._down.mcastMessage(vRIMessage, qOSMulticast, viewIdImpl);
            return;
        }
        this._sidecall.sendMbrMessage(vRIMessage, qOSMulticast, viewIdImpl, null);
    }

    public void mcastMessage(VRIMessage vRIMessage, VRIMemberDescription[] vRIMemberDescriptionArray, QoS.QOSMulticast qOSMulticast, ViewIdImpl viewIdImpl) throws DCSInvalidParametersException, DCSTransportLayerException {
        if (vRIMessage.getOriginatorLayer() == 8) {
            this._down.mcastMessage(vRIMessage, vRIMemberDescriptionArray, qOSMulticast, viewIdImpl);
            return;
        }
        this._sidecall.sendMbrMessage(vRIMessage, qOSMulticast, viewIdImpl, vRIMemberDescriptionArray);
    }

    public void sendMessage(VRIMessage vRIMessage, VRIMemberDescription vRIMemberDescription, QoS.QOSUnicast qOSUnicast, ViewIdImpl viewIdImpl) throws DCSInvalidParametersException, DCSTransportLayerException {
        if (vRIMessage.getOriginatorLayer() == 8) {
            this._down.sendMessage(vRIMessage, vRIMemberDescription, qOSUnicast, viewIdImpl);
            return;
        }
        this._sidecall.sendMbrMessage(vRIMessage, qOSUnicast, viewIdImpl, new VRIMemberDescription[]{vRIMemberDescription});
    }

    public void start(ViewIdImpl viewIdImpl) {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "start", "");
            dCSTraceBuffer.addProperty(viewIdImpl);
            dCSTraceBuffer.invoke();
        }
        this._currentViewID = viewIdImpl;
        this._down.start(viewIdImpl);
        this._lastCheckTime = System.currentTimeMillis();
    }

    public void terminate(boolean bl, DCSTerminationEvent dCSTerminationEvent) {
        this._sidecall.terminate(bl, dCSTerminationEvent);
    }

    public void changeDefinedMembers(String[] stringArray, String[] stringArray2) throws AddDefinedFailedException {
        this._down.changeDefinedMembers(stringArray, stringArray2);
    }

    void doTerminate(boolean bl, DCSTerminationEvent dCSTerminationEvent) {
        this._terminated = true;
        this._congestionLock.terminate();
        this._down.terminate(bl, dCSTerminationEvent);
    }

    public void dumpAll(FFDCDumper fFDCDumper) {
        fFDCDumper.writeLine("Layer", LAYER_NAME);
        fFDCDumper.writeLine("isCongested", String.valueOf(this._congestionLock._congested));
        this._sidecall.dumpAll(fFDCDumper);
        fFDCDumper.writeLine("=============================================================");
        this._down.dumpAll(fFDCDumper);
    }

    public Object getMutex() {
        return this._globals.getMutex();
    }

    public void syncCurrent() throws VRIIllegalStateException {
        this._down.syncCurrent();
    }

    public void updateBehavor(Map map) throws DCSAssertException {
        this._down.updateBehavor(map);
    }

    public void unblock() throws DCSAssertException {
        this._down.unblock();
    }

    public void setDownLayer(Downcalls downcalls) {
        this._down = downcalls;
    }

    public void setUpperLayer(Upcalls upcalls) {
        this._up = upcalls;
    }

    private VRIMemberDescription[] getTargets(String[] stringArray) throws DCSInvalidMemberException {
        VRIMemberDescription[] vRIMemberDescriptionArray = new VRIMemberDescription[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            VRIMemberDescription[] vRIMemberDescriptionArray2;
            vRIMemberDescriptionArray[i] = this._mgr.getDefinedMember(stringArray[i]);
            if (vRIMemberDescriptionArray[i] == null) {
                Object object;
                if (DCSTraceBuffer.isDebugEnabled(TC)) {
                    object = DCSTraceBuffer.debug(this._traceContext, "getTargets", "Target node is not defined");
                    ((DCSTraceBuffer)object).addProperty("memberName", stringArray[i]);
                    ((DCSTraceBuffer)object).invoke();
                }
                object = this._mgr.getDefinedMembers(false);
                throw new DCSMemberIsNotDefinedException(stringArray[i], VRIMemberUtils.getMemberNames((VRIMemberDescription[])object));
            }
            if (vRIMemberDescriptionArray[i].isInView()) continue;
            if (DCSTraceBuffer.isDebugEnabled(TC)) {
                vRIMemberDescriptionArray2 = DCSTraceBuffer.debug(this._traceContext, "getTargets", "Target node is not in view");
                vRIMemberDescriptionArray2.addProperty("memberName", stringArray[i]);
                vRIMemberDescriptionArray2.invoke();
            }
            vRIMemberDescriptionArray2 = this._mgr.getViewMembers();
            throw new DCSMemberIsNotInViewException(stringArray[i], VRIMemberUtils.getMemberNames(vRIMemberDescriptionArray2));
        }
        return vRIMemberDescriptionArray;
    }

    final Upcalls getUpperLayer() {
        return this._up;
    }

    final Downcalls getDownLayer() {
        return this._down;
    }

    final void invalidateViewID() {
        this._currentViewID = null;
    }

    public void onCongestionControlEvent(CongestionControlEvent congestionControlEvent) {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "onCongestionControlEvent", "");
            dCSTraceBuffer.addProperty(congestionControlEvent);
            dCSTraceBuffer.invoke();
        }
        this._congestionLock.onCongestionControlEvent(congestionControlEvent);
    }

    public void onVRIDownEvent(VRIDownEvent vRIDownEvent) {
        vRIDownEvent.handle(LAYER_NAME, this._eventHandlers, this._sidecall);
    }

    public void onVRIUpEvent(VRIUpEvent vRIUpEvent) {
        vRIUpEvent.handle(LAYER_NAME, this._eventHandlers, this._sidecall);
    }

    private final class CongestionLock
    implements VRIEventHandler {
        private boolean _congested = false;
        private boolean _canceled = false;
        private final Object _lock = new Object();

        private CongestionLock() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void onCongestionControlEvent(CongestionControlEvent congestionControlEvent) {
            Object object;
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(ApplicationModuleImpl.this._traceContext, "CongestionLock.onCongestionControlEvent", "");
                ((DCSTraceBuffer)object).addProperty(congestionControlEvent);
                ((DCSTraceBuffer)object).invoke();
            }
            object = this._lock;
            synchronized (object) {
                if (congestionControlEvent.isRed()) {
                    this._congested = true;
                    if (ApplicationModuleImpl.this._statsModule != null) {
                        ApplicationModuleImpl.this._statsModule.onTransmitterCongestionEvent();
                    }
                } else if (congestionControlEvent.isGreen()) {
                    this._congested = false;
                    this._lock.notifyAll();
                }
            }
        }

        DCSCongestionException waitIfCongested() {
            return this.waitIfCongested(0L);
        }

        /*
         * Exception decompiling
         */
        DCSCongestionException waitIfCongested(long var1_1) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [5[DOLOOP]], but top level block is 11[SIMPLE_IF_TAKEN]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void terminate() {
            Object object = this._lock;
            synchronized (object) {
                this._canceled = true;
                this._lock.notifyAll();
            }
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(ApplicationModuleImpl.this._traceContext, "terminate", "");
                ((DCSTraceBuffer)object).invoke();
            }
        }

        public int handle(VRIEvent vRIEvent) {
            this.onCongestionControlEvent((CongestionControlEvent)vRIEvent);
            return 1;
        }

        public String getTraceName() {
            return "CongestionLock";
        }
    }
}

