/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.vri.common.Arrayable;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public final class ArrayableObject
implements Arrayable {
    private static final TraceComponent TC = Tr.register(ArrayableObject.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private Serializable _object;
    private byte[] _serializedObject;
    private int _length;

    public ArrayableObject(Serializable serializable) {
        this._object = serializable;
        this._serializedObject = null;
        this._length = 0;
    }

    public ArrayableObject() {
        this._object = null;
        this._serializedObject = null;
        this._length = 0;
    }

    public void toArray(byte[] byArray, Utils.Offset offset) {
        if (this._serializedObject == null) {
            this.serializeObject();
        }
        Utils.int2byteArray(this._length, byArray, offset);
        System.arraycopy(this._serializedObject, 0, byArray, offset.getValue(), this._length);
        offset.add(this._length);
    }

    public Arrayable fromArray(byte[] byArray, Utils.Offset offset) {
        int n = Utils.byteArray2int(byArray, offset);
        if (n == 0) {
            this._serializedObject = new byte[0];
            this._object = null;
            return this;
        }
        if (offset.getValue() + n > byArray.length) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(new DCSTraceContextImpl(TC, null, null, "ArrayableObject"), "Failed to deserialize object - not enough data to read", null);
                dCSTraceBuffer.addProperty("Available", byArray.length - offset.getValue());
                dCSTraceBuffer.addProperty("Expected", n);
                dCSTraceBuffer.invoke();
            }
            return null;
        }
        this._serializedObject = new byte[n];
        this._length = n;
        System.arraycopy(byArray, offset.getValue(), this._serializedObject, 0, this._length);
        offset.add(n);
        this._object = this.deserializeObject();
        if (this._object == null) {
            return null;
        }
        return this;
    }

    public int getLength() {
        if (this._serializedObject == null) {
            this._length = this.serializeObject();
        }
        return this._length + Utils.sizeOfInt();
    }

    private int serializeObject() {
        int n;
        try {
            if (this._object != null) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4096);
                ObjectOutputStream objectOutputStream = new ObjectOutputStream(byteArrayOutputStream);
                objectOutputStream.writeObject(this._object);
                objectOutputStream.flush();
                byteArrayOutputStream.flush();
                this._serializedObject = byteArrayOutputStream.toByteArray();
                n = this._serializedObject.length;
            } else {
                n = 0;
                this._serializedObject = new byte[0];
            }
        }
        catch (IOException iOException) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(new DCSTraceContextImpl(TC, null, null, "ArrayableObject"), "Failed to serialize object", iOException);
                dCSTraceBuffer.addProperty("Object", this._object);
                dCSTraceBuffer.invoke();
            }
            n = 0;
        }
        return n;
    }

    private Serializable deserializeObject() {
        Serializable serializable;
        try {
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this._serializedObject);
            ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
            serializable = (Serializable)objectInputStream.readObject();
        }
        catch (Exception exception) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(new DCSTraceContextImpl(TC, null, null, "ArrayableObject"), "Failed to deserialize object", exception);
                dCSTraceBuffer.invoke();
            }
            serializable = null;
        }
        return serializable;
    }

    public Object getObject() {
        return this._object;
    }
}

