/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.exception.DCSRuntimeException;
import com.ibm.ws.dcs.common.exception.DCSVerisionIncompatibleException;
import com.ibm.ws.dcs.vri.common.DCSConstants;
import com.ibm.ws.dcs.vri.common.Header;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import java.net.InetAddress;

public class BaseVRIMessage
implements VRIMessage {
    private static final TraceComponent TC = Tr.register(BaseVRIMessage.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private static final int BASE_MSG_SIZE = 2048;
    private static final byte[] VERSION = new byte[]{1, 0, 0, 0};
    private static final String S_VERSION = "1.0.0.0";
    private static final String LAYER_NAME = "VRIMsg";
    private static final DCSTraceContext _traceContext = new DCSTraceContextImpl(TC, "", "", "VRIMsg");
    protected static final int HEADER_METADATA_SIZE = 5;
    protected static final int MESSAGE_METADATA_SIZE = 8;
    protected static final int LAYER_ID_INDEX = 5;
    protected static final int MSG_TYPE_INDEX = 6;
    protected static final int NUM_OF_HDRS_INDEX = 7;
    private InetAddress _sourceAddress = null;
    private int _sourcePort = 0;
    private long _sourceStreamID = 0L;
    private String _sourceTopicName = null;
    private byte _numOfHeaders = 0;
    protected byte[] _buffer;
    protected int _startDataIndex = 0;
    protected int _bufferLength = 0;
    protected int _index = 0;
    protected String _sender = null;
    protected Utils.Offset _tempOffset = new Utils.Offset(0);
    private Header _lastHeader = null;
    private int _lastHeaderStart = 0;
    private byte _msgType = (byte)-1;
    private byte _msgOrigLayer = (byte)-1;

    protected BaseVRIMessage() {
    }

    protected BaseVRIMessage(byte by, byte by2, byte by3, String string, int n) {
        this._buffer = new byte[n];
        this._bufferLength = n;
        this._sender = string;
        this._startDataIndex = 0;
        byte[] byArray = this.getImplementationVersion();
        this._buffer[0] = byArray[0];
        this._buffer[1] = byArray[1];
        this._buffer[2] = byArray[2];
        this._buffer[3] = byArray[3];
        this._buffer[4] = by;
        this._buffer[5] = by3;
        this._buffer[6] = by2;
        this._index = 8;
        this._tempOffset.setValue(this._index);
        this._msgType = by2;
        this._msgOrigLayer = by3;
    }

    protected BaseVRIMessage(byte by, byte by2, byte by3, String string) {
        this(by, by2, by3, string, 2048);
    }

    protected BaseVRIMessage(String string, byte[] byArray, int n, int n2) {
        this._buffer = byArray;
        this._index = this._bufferLength = n2;
        this._startDataIndex = n;
        this._tempOffset.setValue(n);
        if (!this.compatible(byArray, n)) {
            String string2 = Utils.getVersionAsString(byArray, n);
            if (DCSTraceBuffer.isInternalInfoEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalInfo(_traceContext, "Incompatible message version");
                dCSTraceBuffer.addProperty("Sender", string).addProperty("My", "Version", S_VERSION).addProperty("Sender", "Version", string2);
                dCSTraceBuffer.invoke();
            }
            throw new DCSVerisionIncompatibleException();
        }
        this._msgOrigLayer = this._buffer[this._startDataIndex + 5];
        this._msgType = this._buffer[this._startDataIndex + 6];
        this._numOfHeaders = this._buffer[this._startDataIndex + 7];
        this._sender = string;
        this._tempOffset.setValue(n + 8);
    }

    public void changeSender(String string) {
        if (DCSTraceBuffer.isDebugEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.debug(_traceContext, "changeSender", "");
            dCSTraceBuffer.addProperty("Old", "Sender", this._sender);
            dCSTraceBuffer.addProperty("New", "Sender", string);
            dCSTraceBuffer.invoke();
        }
        this._sender = string;
    }

    public VRIMessage copy(boolean bl) {
        Object object;
        if (DCSTraceBuffer.isDebugEnabled(TC)) {
            object = DCSTraceBuffer.debug(_traceContext, "copy", "");
            ((DCSTraceBuffer)object).addProperty("Message", this.toString());
            ((DCSTraceBuffer)object).addProperty("Deep", bl);
            ((DCSTraceBuffer)object).invoke();
        }
        object = this.getNewInstance();
        ((BaseVRIMessage)object)._bufferLength = this._bufferLength;
        ((BaseVRIMessage)object)._index = this._index;
        ((BaseVRIMessage)object)._sender = this._sender;
        ((BaseVRIMessage)object)._numOfHeaders = this._numOfHeaders;
        ((BaseVRIMessage)object)._msgOrigLayer = this._msgOrigLayer;
        ((BaseVRIMessage)object)._msgType = this._msgType;
        if (bl) {
            ((BaseVRIMessage)object)._buffer = new byte[this._bufferLength];
            ((BaseVRIMessage)object)._startDataIndex = 0;
            System.arraycopy(this._buffer, this._startDataIndex, ((BaseVRIMessage)object)._buffer, 0, this._index);
        } else {
            ((BaseVRIMessage)object)._startDataIndex = this._startDataIndex;
            ((BaseVRIMessage)object)._buffer = this._buffer;
        }
        return object;
    }

    protected BaseVRIMessage getNewInstance() {
        return new BaseVRIMessage();
    }

    public String getSender() {
        return this._sender;
    }

    public byte getOriginatorLayer() {
        return this._msgOrigLayer;
    }

    public boolean hasHeader(byte by) {
        if (this._numOfHeaders == 0) {
            return false;
        }
        byte by2 = this._buffer[this._startDataIndex + this._index - 1];
        if (by2 == by) {
            return true;
        }
        if (by2 > by) {
            return false;
        }
        throw new DCSRuntimeException("Current header layer is invalid: current header layer is " + DCSConstants.LAYER_NAMES[by2] + " requested layer is " + DCSConstants.LAYER_NAMES[by]);
    }

    public byte getMessageType() {
        return this._msgType;
    }

    public void setMessageType(byte by) {
        this._buffer[this._startDataIndex + 6] = by;
        this._msgType = by;
    }

    public byte[] getDataBuffer() {
        Object object;
        if (this._startDataIndex == 0) {
            return this._buffer;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(_traceContext, "getDataBuffer", "_startDataIndex is not 0 - perform deep copy.");
            ((DCSTraceBuffer)object).invoke();
        }
        object = new byte[this._index];
        System.arraycopy(this._buffer, this._startDataIndex, object, 0, this._index);
        this._buffer = (byte[])object;
        this._startDataIndex = 0;
        return this._buffer;
    }

    public void addHeader(Header header2) {
        int n;
        if (DCSTraceBuffer.isDebugEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.debug(_traceContext, "addHeader", "");
            dCSTraceBuffer.addProperty("Header", header2);
            dCSTraceBuffer.invoke();
        }
        if (this._index + (n = header2.getLength()) + 5 >= this._bufferLength) {
            this.realloc(n + 5);
        }
        int n2 = this._startDataIndex + this._index;
        this._tempOffset.setValue(n2);
        header2.toArray(this._buffer, this._tempOffset);
        int n3 = this._tempOffset.getValue() - n2;
        if (n3 != n) {
            throw new DCSRuntimeException("Number of bytes written to the message(" + n3 + ") is not equal to the header's length(" + n + ")");
        }
        Utils.int2byteArray(n, this._buffer, this._tempOffset);
        this._buffer[this._tempOffset.getValue()] = header2.getLayer();
        this._index += n + 5;
        this._numOfHeaders = (byte)(this._numOfHeaders + 1);
    }

    public Header getHeader(Header header2) {
        if (this._lastHeader == null) {
            if (this._numOfHeaders > 0) {
                this._tempOffset.setValue(this._startDataIndex + this._index - 5);
                int n = Utils.byteArray2int(this._buffer, this._tempOffset);
                int n2 = this._index - 5 - n;
                if (n2 >= 8) {
                    this._tempOffset.setValue(this._startDataIndex + n2);
                    try {
                        this._lastHeader = (Header)header2.fromArray(this._buffer, this._tempOffset);
                        if (this._lastHeader != null) {
                            this._lastHeaderStart = n2;
                        }
                    }
                    catch (Throwable throwable) {
                        if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(_traceContext, "Failed to read header", throwable);
                            dCSTraceBuffer.addProperty("Header", "Type", header2.getClass().getName());
                            dCSTraceBuffer.invoke();
                        }
                        return null;
                    }
                    if (this._lastHeader == null || this._lastHeader.getLength() != n) {
                        if (DCSTraceBuffer.isInternalInfoEnabled(TC)) {
                            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalInfo(_traceContext, "Message header is corrupted - wrong length");
                            dCSTraceBuffer.addProperty("Sender", this._sender);
                            dCSTraceBuffer.addProperty("Header", "Type", header2.getClass().getName());
                            dCSTraceBuffer.addProperty("Stored", "HeaderLength", n);
                            int n3 = this._lastHeader != null ? this._lastHeader.getLength() : 0;
                            dCSTraceBuffer.addProperty("Read", "HeaderLength", n3);
                            dCSTraceBuffer.invoke();
                        }
                        this._lastHeader = null;
                    }
                }
            } else if (DCSTraceBuffer.isInternalInfoEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalInfo(_traceContext, "No more headers in message");
                dCSTraceBuffer.invoke();
            }
            return this._lastHeader;
        }
        if (this._lastHeader.getClass() == header2.getClass()) {
            return this._lastHeader;
        }
        if (DCSTraceBuffer.isInternalInfoEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalInfo(_traceContext, "Incompatible header type");
            dCSTraceBuffer.addProperty("Requested", "HeaderType", header2.getClass().getName()).addProperty("Last", "HeaderType", this._lastHeader.getClass().getName());
            dCSTraceBuffer.invoke();
        }
        return null;
    }

    public Header extractHeader(Header header2) {
        Header header3 = this.getHeader(header2);
        if (header3 != null) {
            this._lastHeader = null;
            this._index = this._lastHeaderStart;
            this._lastHeaderStart = 0;
            this._numOfHeaders = (byte)(this._numOfHeaders - 1);
            if (DCSTraceBuffer.isDebugEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.debug(_traceContext, "extractHeader", "");
                dCSTraceBuffer.invoke();
            }
        }
        return header3;
    }

    public int prepareBuffer() {
        this._buffer[this._startDataIndex + 7] = this._numOfHeaders;
        return this._index;
    }

    public int getLength() {
        return this._index;
    }

    protected byte[] getImplementationVersion() {
        return VERSION;
    }

    protected void realloc(int n) {
        Object object;
        if (DCSTraceBuffer.isDebugEnabled(TC)) {
            object = DCSTraceBuffer.debug(_traceContext, "realloc", "");
            ((DCSTraceBuffer)object).addProperty("Current", "Size", this._bufferLength);
            ((DCSTraceBuffer)object).addProperty("Increment", n);
            ((DCSTraceBuffer)object).invoke();
        }
        if (n < 0) {
            return;
        }
        if (this._bufferLength > n) {
            n = this._bufferLength;
        }
        this._bufferLength += n;
        object = new byte[this._bufferLength];
        System.arraycopy(this._buffer, this._startDataIndex, object, 0, this._index);
        this._buffer = (byte[])object;
        this._startDataIndex = 0;
    }

    protected boolean compatible(byte[] byArray, int n) {
        byte[] byArray2 = this.getImplementationVersion();
        return byArray2[0] == byArray[n++] && byArray2[1] == byArray[n++] && byArray2[2] == byArray[n++] && byArray2[3] == byArray[n];
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        stringBuffer.append(" : VERSION: ").append(Utils.getVersionAsString(this.getImplementationVersion())).append(" : OriginatorLayer: ").append(this._msgOrigLayer).append(" : MessageType: ").append(this._msgType).append(" : Sender: ").append(this._sender).append(" : startDataIndex: ").append(this._startDataIndex).append(" : bufferLength: ").append(this._bufferLength).append(" : index: ").append(this._index).append(" : numOfHeaders: ").append(this._numOfHeaders);
        return stringBuffer.toString();
    }

    public final InetAddress getSourceAddress() {
        return this._sourceAddress;
    }

    public final int getSourcePort() {
        return this._sourcePort;
    }

    public final long getSourceStreamID() {
        return this._sourceStreamID;
    }

    public final String getSourceTopicName() {
        return this._sourceTopicName;
    }

    public final void setSourceTopicName(String string) {
        this._sourceTopicName = string;
    }

    public final void setSourceAddress(InetAddress inetAddress) {
        this._sourceAddress = inetAddress;
    }

    public final void setSourcePort(int n) {
        this._sourcePort = n;
    }

    public final void setSourceStreamID(long l) {
        this._sourceStreamID = l;
    }
}

