/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.config.DCSCoreStackConfigMap;
import com.ibm.ws.dcs.common.config.DCSDataStackConfigMap;
import com.ibm.ws.dcs.common.config.DCSIllegalConfigurationException;
import com.ibm.ws.dcs.common.config.DCSMandatoryParamsNotSpecifiedException;
import com.ibm.ws.dcs.common.config.DCSStackConfigMap;
import com.ibm.ws.dcs.common.config.rmm.RMMCFConfigMap;
import com.ibm.ws.dcs.common.config.rmm.RMMConfigMap;
import com.ibm.ws.dcs.common.config.rmm.RMMMbuConfigMap;
import com.ibm.ws.dcs.common.config.rmm.RMMMulticastConfigMap;
import com.ibm.ws.dcs.vri.common.impl.DCSConfig;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class ConfigurationParser {
    private static TraceComponent TC = Tr.register(ConfigurationParser.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");

    private ConfigurationParser() {
    }

    public static DCSConfig parseStackConfiguration(String string, DCSStackConfigMap dCSStackConfigMap) throws DCSIllegalConfigurationException {
        Object object;
        Object object2;
        DCSTraceContextImpl dCSTraceContextImpl = new DCSTraceContextImpl(TC, string, "", "CONFIG");
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object2 = DCSTraceBuffer.event(dCSTraceContextImpl, "ConfigurationParser.parseStackConfiguration()", "Input Config Map");
            ((DCSTraceBuffer)object2).addProperty("ClassName", dCSStackConfigMap.getClass().getName());
            ((DCSTraceBuffer)object2).addProperty("ConfigMap", (Object)dCSStackConfigMap);
            ((DCSTraceBuffer)object2).invoke();
        }
        ConfigurationParser.checkMandatoryParams(dCSStackConfigMap, string);
        object2 = dCSStackConfigMap.setOptionalParams();
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(dCSTraceContextImpl, "ConfigurationParser.parseStackConfiguration()", "Full given config (after setting the optional params)");
            ((DCSTraceBuffer)object).addProperty("ClassName", dCSStackConfigMap.getClass().getName());
            ((DCSTraceBuffer)object).addProperty("ConfigMap", object2);
            ((DCSTraceBuffer)object).invoke();
        }
        object = new HashMap(object2);
        DCSConfig dCSConfig = ConfigurationParser.abstract2raw((Map)object2, dCSStackConfigMap.getClass());
        ConfigurationParser.setExtraDefaults((Map)object, dCSStackConfigMap.getClass());
        dCSConfig.put("ORIGINAL_CONFIG_MAP", object);
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(dCSTraceContextImpl, "ConfigurationParser.parseStackConfiguration()", "Raw DCS config");
            dCSTraceBuffer.addProperty("ClassName", dCSStackConfigMap.getClass().getName());
            dCSTraceBuffer.addProperty("ConfigMap", (Object)dCSConfig);
            dCSTraceBuffer.invoke();
        }
        return dCSConfig;
    }

    private static void setExtraDefaults(Map map, Class clazz) {
        RMMConfigMap rMMConfigMap;
        if (clazz != DCSCoreStackConfigMap.class) {
            return;
        }
        String string = (String)map.get("TransportType");
        Map map2 = (Map)map.get("TransportConfiguration");
        if (string == null || map2 == null) {
            throw new DCSIllegalConfigurationException("ConfigurationParser.setExtraDefaults: illegal params " + string + ", " + map2);
        }
        if (string.equals("RealMulticast")) {
            rMMConfigMap = new RMMMulticastConfigMap(map2);
        } else if (string.equals("MulticastByUnicast")) {
            rMMConfigMap = new RMMMbuConfigMap(map2);
        } else if (string.equals("ChannelFramework")) {
            rMMConfigMap = new RMMCFConfigMap(map2);
        } else {
            throw new DCSIllegalConfigurationException("ConfigurationParser.setExtraDefaults: unknown transport type " + string);
        }
        map.put("TransportConfiguration", rMMConfigMap.setOptionalParams());
    }

    private static DCSConfig abstract2raw(Map map, Class clazz) {
        int n;
        int n2;
        DCSConfig dCSConfig = new DCSConfig();
        Object v = map.get("DCSProtocolVersion");
        int n3 = (Integer)v;
        dCSConfig.put("DCSProtocolVersion", new Integer(n3));
        Boolean bl = (Boolean)map.get("CheckConfiguration");
        boolean bl2 = bl;
        dCSConfig.put("CheckConfiguration", (Object)bl2);
        Boolean bl3 = (Boolean)map.get("DCSInternalPMI");
        boolean bl4 = bl3;
        dCSConfig.put("DCSInternalPMI", (Object)bl4);
        Map map2 = (Map)map.get("StackConstruction");
        boolean bl5 = (Boolean)map2.get("useVirtualSynchronyMessaging");
        int n4 = (Integer)map.get("MaxStackMemoryMB");
        Map map3 = (Map)map.get("FailureDetectorParameters");
        int n5 = (Integer)map3.get("HBTTransmissionIntervalMilliSec");
        int n6 = (Integer)map3.get("HBTTimeoutPeriod");
        int n7 = n5 * n6;
        String string = (String)map.get("MessagingDirection");
        int n8 = (Integer)map.get("ExpectedBringupTimeSec");
        int n9 = (Integer)map.get("CompletenessVsSpeed");
        int n10 = (Integer)map.get("ExpectedMessagePayloadSizeBytes");
        dCSConfig.put("HBTTimeoutPeriod", new Integer(n6));
        dCSConfig.put("HBTTransmissionIntervalMilliSec", new Integer(n5));
        int n11 = Math.min(n7 * 2, 200000);
        n11 = Math.max(n11, 5000);
        dCSConfig.put("TRANSPORT_ADAPTER_NEW_VIEW_MEMBER_TIMEOUT", new Integer(n11));
        dCSConfig.put("RMM_ADAPTER_TRANS_CLOSE_TIME", new Integer(n11));
        Integer n12 = new Integer(64);
        if (bl5) {
            n2 = (int)((double)n4 * 0.08 * 1024.0);
            n12 = new Integer(n2);
        }
        dCSConfig.put("VS_MAX_MEMORY_KB", n12);
        dCSConfig.put("VS_DEFAULT_MESSAGES_NUM_TO_SEND_RCV_VECTOR", new Integer(100));
        dCSConfig.put("VS_CC_MESSAGES_NUM_TO_SEND_RCV_VECTOR", new Integer(10));
        n2 = n7 / 1000 + 5 + n12 / 1024;
        n2 = Math.min(n2, 300);
        n2 = Math.max((n11 + 15000) / 1000, n2);
        dCSConfig.put("VS_CC_TIMEOUT_SEC", new Integer(n2));
        dCSConfig.put("TA_CC_TIMEOUT_SEC", new Integer(n2 - 3));
        String string2 = (String)map.get("VSLeaderPolicy");
        dCSConfig.put("VSLeaderPolicy", string2);
        if (string.equals("Out")) {
            n = 1;
        } else if (string.equals("In")) {
            n = -1;
        } else if (string.equals("Both")) {
            n = 0;
        } else {
            throw new DCSIllegalConfigurationException("Internal exception in parsing message direction with value " + string);
        }
        int n13 = (int)((double)n4 * (0.8 + 0.2 * (double)n) * 1024.0);
        dCSConfig.put("CONGESTION_SENDER_RED_LINE_KB", new Integer(n13));
        int n14 = (int)((double)n13 * 0.9);
        dCSConfig.put("CONGESTION_SENDER_YELLOW_LINE_KB", new Integer(n14));
        int n15 = (int)((double)n13 * 0.2);
        dCSConfig.put("CONGESTION_SENDER_GREEN_LINE_KB", new Integer(n15));
        int n16 = n8 + 2;
        if (clazz == DCSCoreStackConfigMap.class) {
            n16 += 2;
        }
        dCSConfig.put("MEMBERSHIP_MAX_MERGE_TIMEOUT", new Integer(n16));
        dCSConfig.put("MEMBER_STARTUP_TIMEOUT", map.get("MEMBER_STARTUP_TIMEOUT"));
        int n17 = 0;
        switch (n9) {
            case 1: {
                n17 = 100;
                break;
            }
            case 2: {
                n17 = 75;
                break;
            }
            case 3: {
                n17 = 50;
                break;
            }
            case 4: {
                n17 = 5;
                break;
            }
            case 5: {
                n17 = 0;
                break;
            }
            default: {
                throw new DCSIllegalConfigurationException("Internal exception in parsing completenessVsSpeed with value " + n9);
            }
        }
        dCSConfig.put("MEMBERSHIP_MAX_MERGE_RETRIES", new Integer(n17));
        int n18 = (int)((double)n2 * 1.1 + 1.0);
        dCSConfig.put("VIEW_LEADER_WAIT_FOR_MEMBER_CC_TIMEOUT", new Integer(n18));
        int n19 = (int)((double)n18 * 1.1 + 2.0);
        dCSConfig.put("MERGE_LEADER_WAIT_FOR_VIEW_LEADER_CC_TIMEOUT", new Integer(n19));
        int n20 = (int)((double)n19 * 1.1 + 2.0);
        dCSConfig.put("VIEW_LEADER_WAIT_FOR_MERGE_LEADER_NV_TIMEOUT", new Integer(n20));
        int n21 = (int)((double)n20 * 1.1 + 2.0);
        dCSConfig.put("MEMBER_WAIT_FOR_VIEW_LEADER_NV_TIMEOUT", new Integer(n21));
        int n22 = (int)((double)n21 * 1.125 + 2.0);
        dCSConfig.put("REQUESTED_VIEW_TIMEOUT", new Integer(n22));
        int n23 = (int)((double)n20 * 0.25) + 1;
        dCSConfig.put("APPROVAL_KEEP_ALIVE", new Integer(n23));
        int n24 = (int)((double)(n7 / 1000) * 0.5) + 1;
        n24 = Math.max(n24, 5);
        dCSConfig.put("DCS_CHECK_TIME_SEC", new Integer(n24));
        dCSConfig.put("AM_DEFAULT_MESSAGE_SIZE", new Integer(n10));
        Map map4 = null;
        if (clazz == DCSCoreStackConfigMap.class) {
            map4 = ConfigurationParser.abstract2raw4core(map);
        } else if (clazz == DCSDataStackConfigMap.class) {
            map4 = ConfigurationParser.abstract2raw4data(map);
        } else {
            throw new DCSIllegalConfigurationException("Internal exception in getting stack params type. Stack type is " + clazz);
        }
        dCSConfig.put("StackConstruction", map.get("StackConstruction"));
        dCSConfig.put("SHORTCUT_SELFSEND_PATH", (Object)true);
        dCSConfig.put("CONGESTION_TIMEOUT", new Long(3000L));
        dCSConfig.putAll(map4);
        return dCSConfig;
    }

    private static Map abstract2raw4core(Map map) {
        HashMap hashMap = new HashMap();
        hashMap.put("TRANSPORT_TYPE", map.get("TransportType"));
        hashMap.put("TRANSPORT_CONFIGURATION", map.get("TransportConfiguration"));
        hashMap.put("DefinedSet", map.get("DefinedSet"));
        hashMap.put("ThisMemberName", map.get("ThisMemberName"));
        hashMap.put("DcsThreadsNum", map.get("DcsThreadsNum"));
        hashMap.put("AddressResolver", map.get("AddressResolver"));
        hashMap.put("StateBlobInitialConfiguration", map.get("StateBlobInitialConfiguration"));
        return hashMap;
    }

    private static Map abstract2raw4data(Map map) {
        HashMap hashMap = new HashMap();
        hashMap.put("DATA_STACK_TYPE", map.get("DataStackType"));
        hashMap.put("SPECIFIC_DATA_STACK_CONFIGURATION", map.get("SpecificDataStackConfiguration"));
        return hashMap;
    }

    private static void checkMandatoryParams(DCSStackConfigMap dCSStackConfigMap, String string) {
        Set set = dCSStackConfigMap.getUnspecifiedMandatoryParams();
        if (!set.isEmpty()) {
            throw new DCSMandatoryParamsNotSpecifiedException("Configuration parameters in the config set of type " + dCSStackConfigMap.getClass() + ", with stack name " + string + ", do not include the following mandatory parameters - " + set);
        }
    }
}

