/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.DCSCoreStack;
import com.ibm.ws.dcs.common.DCSTraceable;
import com.ibm.ws.dcs.common.MemberInfoManager;
import com.ibm.ws.dcs.common.MemberStatusListener;
import com.ibm.ws.dcs.common.QoS;
import com.ibm.ws.dcs.common.exception.DCSException;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.common.exception.DCSMemberIsNotDefinedException;
import com.ibm.ws.dcs.rsmodule.impl.DCSRSStackImpl;
import com.ibm.ws.dcs.vri.common.Downcalls;
import com.ibm.ws.dcs.vri.common.MemberInfo;
import com.ibm.ws.dcs.vri.common.Upcalls;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.event.RequestChangeDefinedEvent;
import com.ibm.ws.dcs.vri.common.event.VRIUpEvent;
import com.ibm.ws.dcs.vri.common.impl.ApplicationModuleImpl;
import com.ibm.ws.dcs.vri.common.impl.DCSConfig;
import com.ibm.ws.dcs.vri.common.impl.DCSIncomingMessage;
import com.ibm.ws.dcs.vri.common.impl.DCSOutgoingMessage;
import com.ibm.ws.dcs.vri.common.nls.SuspectUnreadableMessageEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import com.ibm.ws.dcs.vri.membership.CGMBRUp;
import com.ibm.ws.dcs.vri.membership.MBRConfigChecker;
import com.ibm.ws.dcs.vri.testerlayer.TesterLayer;
import com.ibm.ws.dcs.vri.transportAdapter.TransportAdapter;
import com.ibm.ws.dcs.vri.vsync.VSync;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public final class DCSCoreStackImpl
extends DCSRSStackImpl
implements DCSCoreStack {
    private static final byte CHANGE_DEFINED_MSG = 51;
    private static final byte ADD_DEFINED = 1;
    private static final byte REMOVE_DEFINED = 2;
    private static final TraceComponent TC = Tr.register(DCSCoreStackImpl.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private final DCSTraceContext _traceContext;

    public static DCSCoreStackImpl getInstance(String string, DCSConfig dCSConfig, MemberInfoManager memberInfoManager) throws UnknownHostException, DCSException {
        return new DCSCoreStackImpl(string, dCSConfig, memberInfoManager);
    }

    private DCSCoreStackImpl(String string, DCSConfig dCSConfig, MemberInfoManager memberInfoManager) throws UnknownHostException, DCSException {
        super(string, dCSConfig, memberInfoManager, true);
        Downcalls downcalls;
        this._traceContext = new DCSTraceContextImpl(TC, this._stackName, this._thisMemberName, LAYER_NAME);
        Map map = (Map)this._globals.getConfigParam("StackConstruction");
        Boolean bl = (Boolean)map.get("enableVerificationMode");
        this._appModule = new ApplicationModuleImpl(this._globals, this);
        CGMBRUp cGMBRUp = new CGMBRUp(this._globals);
        VSync vSync = new VSync(this._globals);
        TransportAdapter transportAdapter = TransportAdapter.getInstance(this._globals);
        boolean bl2 = this._globals.getConfigParamAsBoolean("CheckConfiguration");
        if (bl2) {
            downcalls = new MBRConfigChecker(this._globals);
            cGMBRUp.setDownLayer(downcalls);
            ((MBRConfigChecker)downcalls).setDownLayer(this._appModule);
            ((MBRConfigChecker)downcalls).setUpperLayer(cGMBRUp);
            this._appModule.setUpperLayer((Upcalls)((Object)downcalls));
        } else {
            cGMBRUp.setDownLayer(this._appModule);
            this._appModule.setUpperLayer(cGMBRUp);
        }
        this._mssAdmin = cGMBRUp;
        if (bl.booleanValue()) {
            downcalls = new TesterLayer(this._globals);
            this._appModule.setDownLayer(downcalls);
            ((TesterLayer)downcalls).setUpperLayer(this._appModule);
            ((TesterLayer)downcalls).setDownLayer(vSync);
            vSync.setUpperLayer((Upcalls)((Object)downcalls));
        } else {
            this._appModule.setDownLayer(vSync);
            vSync.setUpperLayer(this._appModule);
        }
        vSync.setDownLayer(transportAdapter);
        transportAdapter.setUpperLayer(vSync);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkMembers(String[] stringArray, MemberStatusListener memberStatusListener) {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this._traceContext, "checkMembers", "");
            ((DCSTraceBuffer)object).addProperty("memberNames", stringArray).addProperty("Listener", String.valueOf(memberStatusListener));
            ((DCSTraceBuffer)object).invoke();
        }
        if (memberStatusListener != null) {
            Object object2 = this._mutex;
            synchronized (object2) {
                object = this._mgr.membersStatus(stringArray);
            }
            memberStatusListener.memberStatus(stringArray, (int[])object);
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            object = DCSTraceBuffer.exit(this._traceContext, "checkMembers", "");
            ((DCSTraceBuffer)object).invoke();
        }
    }

    public void addDefined(Map map, int n) throws DCSException {
        Object v;
        Object object;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this._traceContext, "addDefined", "");
            ((DCSTraceBuffer)object).addProperty("Context", String.valueOf(n)).addProperty("AddedMembers", String.valueOf(map));
            ((DCSTraceBuffer)object).invoke();
        }
        if ((v = ((HashMap)(object = new HashMap(map))).remove(this._thisMemberName)) != null && DCSTraceBuffer.isInternalWarningEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this._traceContext, "Local memeber was included in addDefined request - ignore", null);
            dCSTraceBuffer.invoke();
        }
        this.createAndMcastChangeDefinedMessage((byte)1, (Serializable)object, n);
    }

    public void removeDefined(String[] stringArray, int n) throws DCSException {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "removeDefined", "");
            dCSTraceBuffer.addProperty("Context", String.valueOf(n)).addProperty("RemovedMembers", stringArray);
            dCSTraceBuffer.invoke();
        }
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this._thisMemberName.equals(stringArray[i])) continue;
            DCSInvalidParametersException dCSInvalidParametersException = new DCSInvalidParametersException("This member  - " + this._thisMemberName + " -  is included in leave members list.");
            throw dCSInvalidParametersException;
        }
        this.createAndMcastChangeDefinedMessage((byte)2, (Serializable)stringArray, n);
    }

    protected void handleApplicationMessage(VRIMessage vRIMessage) {
        byte by = vRIMessage.getMessageType();
        if (by == 51) {
            this.processChangeDefinedMsg((DCSIncomingMessage)vRIMessage);
            return;
        }
        super.handleApplicationMessage(vRIMessage);
    }

    private void processChangeDefinedMsg(DCSIncomingMessage dCSIncomingMessage) {
        DCSTraceable dCSTraceable;
        byte by = dCSIncomingMessage.readByte();
        int n = dCSIncomingMessage.readInt();
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceable = DCSTraceBuffer.event(this._traceContext, "processChangeDefinedMsg", "");
            dCSTraceable.addProperty("ChangeDefinedType", String.valueOf(by)).addProperty("Context", String.valueOf(n));
            dCSTraceable.invoke();
        }
        dCSTraceable = null;
        switch (by) {
            case 1: {
                Object object;
                Map map = (Map)((Object)dCSIncomingMessage.readObject());
                Object v = map.remove(this._thisMemberName);
                if (v != null && DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                    object = DCSTraceBuffer.internalWarning(this._traceContext, "Local memeber was included in addDefined request - ignore", null);
                    ((DCSTraceBuffer)object).invoke();
                }
                object = map.keySet();
                MemberInfo[] memberInfoArray = new MemberInfo[object.size()];
                int n2 = 0;
                Iterator iterator = object.iterator();
                while (iterator.hasNext()) {
                    String string = (String)iterator.next();
                    Properties properties = (Properties)map.get(string);
                    memberInfoArray[n2++] = new MemberInfo(string, properties);
                }
                dCSTraceable = new RequestChangeDefinedEvent(this._stackName, this._thisMemberName, memberInfoArray, null, n);
                break;
            }
            case 2: {
                String[] stringArray = (String[])dCSIncomingMessage.readObject();
                dCSTraceable = new RequestChangeDefinedEvent(this._stackName, this._thisMemberName, null, stringArray, n);
                break;
            }
            default: {
                SuspectUnreadableMessageEvent suspectUnreadableMessageEvent = SuspectUnreadableMessageEvent.badMessageType(this._traceContext, dCSIncomingMessage.getSender(), "changeDefined", by);
                suspectUnreadableMessageEvent.invokeNLSTrace();
                this.suspectMember(suspectUnreadableMessageEvent, 1, "Invalid message received: Undefined change defined type");
            }
        }
        if (dCSTraceable != null) {
            this._appModule.getUpperLayer().onVRIUpEvent((VRIUpEvent)dCSTraceable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndMcastChangeDefinedMessage(byte by, Serializable serializable, int n) throws DCSException {
        DCSOutgoingMessage dCSOutgoingMessage = (DCSOutgoingMessage)this._factory.getMessage((byte)8, this._thisMemberName, 4096);
        dCSOutgoingMessage.setMessageType((byte)51);
        dCSOutgoingMessage.writeByte(by);
        dCSOutgoingMessage.writeInt(n);
        dCSOutgoingMessage.writeObject(serializable);
        VRIMessage vRIMessage = dCSOutgoingMessage.toVRIMessage();
        QoS.QOSMulticast qOSMulticast = QoS.getMulticastQoS(QoS.VS_ANY, QoS.FIFO);
        Object object = this._mutex;
        synchronized (object) {
            if (this._terminated) {
                throw new DCSException("DCS stack " + this._stackName + " at member " + this._thisMemberName + " terminated.");
            }
            this._appModule.mcastMessage(vRIMessage, qOSMulticast, null);
        }
    }

    public String getLocalMemberName() {
        return this._thisMemberName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map getMembersInfo(String[] stringArray) throws DCSMemberIsNotDefinedException {
        HashMap<String, Properties> hashMap = new HashMap<String, Properties>();
        Object object = this._mutex;
        synchronized (object) {
            for (int i = 0; i < stringArray.length; ++i) {
                VRIMemberDescription vRIMemberDescription = this._mgr.getDefinedMember(stringArray[i]);
                if (vRIMemberDescription == null) {
                    throw new DCSMemberIsNotDefinedException(stringArray[i], VRIMemberUtils.getMemberNames(this._mgr.getDefinedMembers(false)));
                }
                hashMap.put(vRIMemberDescription.getName(), vRIMemberDescription.getMemberInfo().getAddress());
            }
        }
        return hashMap;
    }

    public String getCoreGroupName() {
        return this._stackName;
    }
}

