/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.DCSDataStack;
import com.ibm.ws.dcs.common.DCSTraceable;
import com.ibm.ws.dcs.common.MemberInfoManager;
import com.ibm.ws.dcs.common.QoS;
import com.ibm.ws.dcs.common.ViewApprover;
import com.ibm.ws.dcs.common.event.DCSTerminationEvent;
import com.ibm.ws.dcs.common.exception.DCSException;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.common.exception.DCSInvalidViewIDException;
import com.ibm.ws.dcs.rsmodule.impl.DCSRSStackImpl;
import com.ibm.ws.dcs.stat.impl.DCSInternalStatsModuleImpl;
import com.ibm.ws.dcs.vri.common.Downcalls;
import com.ibm.ws.dcs.vri.common.Upcalls;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.event.ApprovePartialViewEvent;
import com.ibm.ws.dcs.vri.common.event.PartialViewApprovedEvent;
import com.ibm.ws.dcs.vri.common.event.RequestViewChangeEvent;
import com.ibm.ws.dcs.vri.common.event.VRIEvent;
import com.ibm.ws.dcs.vri.common.event.VRIEventHandler;
import com.ibm.ws.dcs.vri.common.event.VRIUpEvent;
import com.ibm.ws.dcs.vri.common.impl.ApplicationModuleImpl;
import com.ibm.ws.dcs.vri.common.impl.DCSConfig;
import com.ibm.ws.dcs.vri.common.impl.DCSIncomingMessage;
import com.ibm.ws.dcs.vri.common.impl.DCSOutgoingMessage;
import com.ibm.ws.dcs.vri.common.impl.DCSStackImpl;
import com.ibm.ws.dcs.vri.common.nls.CallbackFailedEvent;
import com.ibm.ws.dcs.vri.common.nls.TerminationEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import com.ibm.ws.dcs.vri.membership.DSMBRUp;
import com.ibm.ws.dcs.vri.membership.MBRConfigChecker;
import com.ibm.ws.dcs.vri.testerlayer.TesterLayer;
import com.ibm.ws.dcs.vri.transportAdapter.TransportAdapter;
import com.ibm.ws.dcs.vri.vsync.VSync;
import java.net.UnknownHostException;
import java.util.Map;
import java.util.Properties;

public class DCSDataStackImpl
extends DCSRSStackImpl
implements DCSDataStack {
    private static final byte REQUEST_VIEW_MSG = 51;
    private static final TraceComponent TC = Tr.register(DCSDataStackImpl.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private ViewApprover _viewApprover = null;
    private final DCSTraceContext _traceContext = new DCSTraceContextImpl(TC, this._stackName, this._thisMemberName, LAYER_NAME);

    public static DCSDataStackImpl getInstance(String string, DCSConfig dCSConfig, MemberInfoManager memberInfoManager) throws UnknownHostException, DCSException {
        return new DCSDataStackImpl(string, dCSConfig, memberInfoManager);
    }

    protected DCSDataStackImpl(String string, DCSConfig dCSConfig, MemberInfoManager memberInfoManager) throws UnknownHostException, DCSException {
        super(string, dCSConfig, memberInfoManager, false);
        Downcalls downcalls;
        DCSTraceContext dCSTraceContext;
        Map map = (Map)this._globals.getConfigParam("StackConstruction");
        Boolean bl = (Boolean)map.get("enableVerificationMode");
        Boolean bl2 = (Boolean)map.get("useVirtualSynchronyMessaging");
        DSMBRUp dSMBRUp = new DSMBRUp(this._globals);
        this._appModule = new ApplicationModuleImpl(this._globals, this);
        if (!bl2.booleanValue() && DCSTraceBuffer.isInternalInfoEnabled(TC)) {
            dCSTraceContext = DCSTraceBuffer.internalInfo(this._traceContext, "useVS set to false");
            ((DCSTraceBuffer)dCSTraceContext).invoke();
        }
        dCSTraceContext = new VSync(this._globals);
        TransportAdapter transportAdapter = TransportAdapter.getInstance(this._globals);
        boolean bl3 = this._globals.getConfigParamAsBoolean("CheckConfiguration");
        if (bl3) {
            downcalls = new MBRConfigChecker(this._globals);
            dSMBRUp.setDownLayer(downcalls);
            ((MBRConfigChecker)downcalls).setDownLayer(this._appModule);
            ((MBRConfigChecker)downcalls).setUpperLayer(dSMBRUp);
            this._appModule.setUpperLayer((Upcalls)((Object)downcalls));
        } else {
            dSMBRUp.setDownLayer(this._appModule);
            this._appModule.setUpperLayer(dSMBRUp);
        }
        this._mssAdmin = dSMBRUp;
        if (bl.booleanValue()) {
            downcalls = new TesterLayer(this._globals);
            this._appModule.setDownLayer(downcalls);
            ((TesterLayer)downcalls).setUpperLayer(this._appModule);
            ((TesterLayer)downcalls).setDownLayer((Downcalls)((Object)dCSTraceContext));
            ((VSync)dCSTraceContext).setUpperLayer((Upcalls)((Object)downcalls));
        } else {
            this._appModule.setDownLayer((Downcalls)((Object)dCSTraceContext));
            ((VSync)dCSTraceContext).setUpperLayer(this._appModule);
        }
        ((VSync)dCSTraceContext).setDownLayer(transportAdapter);
        transportAdapter.setUpperLayer((Upcalls)((Object)dCSTraceContext));
        this._eventHandlers.setVRIEventHandler(ApprovePartialViewEvent.class, new ApprovePartialViewEventHandler());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requestView(String[] stringArray, int n, Comparable comparable) throws DCSException {
        ViewIdImpl viewIdImpl = (ViewIdImpl)comparable;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "requestView", "");
            dCSTraceBuffer.addProperty("Context", String.valueOf(n)).addProperty("viewMembers", stringArray).addProperty(viewIdImpl);
            dCSTraceBuffer.invoke();
        }
        boolean bl = true;
        for (int i = 0; i < stringArray.length; ++i) {
            if (!this._thisMemberName.equals(stringArray[i])) continue;
            bl = false;
            break;
        }
        if (bl) {
            DCSInvalidParametersException dCSInvalidParametersException = new DCSInvalidParametersException("This member  - " + this._thisMemberName + " -  is not included in the requested view.");
            throw dCSInvalidParametersException;
        }
        Object object = this._mutex;
        synchronized (object) {
            QoS.QOSMulticast qOSMulticast = QoS.getMulticastQoS(QoS.VS_CURRENT, QoS.FIFO);
            this.createAndMcastRequestViewMessage(stringArray, n, viewIdImpl, qOSMulticast);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAndMcastRequestViewMessage(String[] stringArray, int n, ViewIdImpl viewIdImpl, QoS.QOSMulticast qOSMulticast) throws DCSException {
        Map map = this._globals.getMemberInfoManager().getMembersInfo(stringArray);
        this.checkViewRequest(map, stringArray);
        DCSOutgoingMessage dCSOutgoingMessage = (DCSOutgoingMessage)this._factory.getMessage((byte)8, this._thisMemberName, 4096);
        dCSOutgoingMessage.writeInt(n);
        dCSOutgoingMessage.writeInt(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            dCSOutgoingMessage.writeString(stringArray[i]);
        }
        dCSOutgoingMessage.setMessageType((byte)51);
        VRIMessage vRIMessage = dCSOutgoingMessage.toVRIMessage();
        Object object = this._mutex;
        synchronized (object) {
            if (this._terminated) {
                throw new DCSException("DCS stack " + this._stackName + " at member " + this._thisMemberName + " terminated.");
            }
            this._appModule.mcastMessage(vRIMessage, qOSMulticast, viewIdImpl);
        }
    }

    protected void handleApplicationMessage(VRIMessage vRIMessage) {
        byte by = vRIMessage.getMessageType();
        if (by == 51) {
            this.processRequestViewMsg((DCSIncomingMessage)vRIMessage);
            return;
        }
        super.handleApplicationMessage(vRIMessage);
    }

    private final void processRequestViewMsg(DCSIncomingMessage dCSIncomingMessage) {
        int n = dCSIncomingMessage.readInt();
        int n2 = dCSIncomingMessage.readInt();
        Object[] objectArray = new String[n2];
        for (int i = 0; i < objectArray.length; ++i) {
            objectArray[i] = dCSIncomingMessage.readString();
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "processRequestViewMsg", "");
            dCSTraceBuffer.addProperty("Context", n);
            dCSTraceBuffer.addProperty("Requested", "viewMembers", Utils.toString(objectArray));
            dCSTraceBuffer.invoke();
        }
        ViewIdImpl viewIdImpl = this._currentViewId != null ? this._currentViewId : this._previousViewId;
        RequestViewChangeEvent requestViewChangeEvent = new RequestViewChangeEvent(this._stackName, this._thisMemberName, (String[])objectArray, viewIdImpl, n);
        this._appModule.getUpperLayer().onVRIUpEvent(requestViewChangeEvent);
    }

    private final void checkViewRequest(Map map, String[] stringArray) throws DCSException {
        for (int i = 0; i < stringArray.length; ++i) {
            Properties properties = (Properties)map.get(stringArray[i]);
            if (properties != null) continue;
            DCSInvalidParametersException dCSInvalidParametersException = new DCSInvalidParametersException("Member " + stringArray[i] + "  is not defined in core stack");
            throw dCSInvalidParametersException;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void partialViewApproved(Comparable comparable, int n) throws DCSInvalidViewIDException {
        DCSTraceable dCSTraceable;
        Object object;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this._traceContext, "partialViewApproved", "");
            dCSTraceable = (ViewIdImpl)comparable;
            ((DCSTraceBuffer)object).addProperty(dCSTraceable).addProperty("Context", String.valueOf(n));
            ((DCSTraceBuffer)object).invoke();
        }
        object = this._mutex;
        synchronized (object) {
            if (!this._terminated) {
                dCSTraceable = new PartialViewApprovedEvent(this._stackName, this._thisMemberName, comparable, n, true);
                ((VRIUpEvent)dCSTraceable).startHandling(this._mutex, this._appModule.getUpperLayer());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void partialViewDeniedRequestNewView(Comparable comparable, int n, String[] stringArray, int n2) throws DCSException {
        DCSTraceable dCSTraceable;
        Object object;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this._traceContext, "partialViewDeniedRequestNewView", "");
            dCSTraceable = (ViewIdImpl)comparable;
            ((DCSTraceBuffer)object).addProperty(dCSTraceable).addProperty("Context", n).addProperty("Requested", "viewMembers", stringArray).addProperty("New", "Context", n2);
            ((DCSTraceBuffer)object).invoke();
        }
        object = this._mutex;
        synchronized (object) {
            dCSTraceable = QoS.getMulticastQoS(QoS.VS_ANY, QoS.FIFO);
            PartialViewApprovedEvent partialViewApprovedEvent = new PartialViewApprovedEvent(this._stackName, this._thisMemberName, comparable, n, false);
            this._appModule.getUpperLayer().onVRIUpEvent(partialViewApprovedEvent);
            this.createAndMcastRequestViewMessage(stringArray, n2, null, (QoS.QOSMulticast)dCSTraceable);
        }
    }

    public void setViewApprover(ViewApprover viewApprover) {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "setViewApprover", "");
            dCSTraceBuffer.addProperty("ViewApprover", String.valueOf(viewApprover));
            dCSTraceBuffer.invoke();
        }
        this._viewApprover = viewApprover;
        if (viewApprover != null) {
            this._globals.setViewApproval(true);
        }
    }

    protected void terminate() {
        this._viewApprover = null;
        this._globals.setViewApproval(false);
        super.terminate();
    }

    public void setInternalStatCollection(boolean bl) {
        DCSInternalStatsModuleImpl dCSInternalStatsModuleImpl = (DCSInternalStatsModuleImpl)this._globals.statsModule;
        dCSInternalStatsModuleImpl.setInternalStatCollection(bl);
    }

    public boolean getInternalStatCollection() {
        DCSInternalStatsModuleImpl dCSInternalStatsModuleImpl = (DCSInternalStatsModuleImpl)this._globals.statsModule;
        return dCSInternalStatsModuleImpl.getInternalStatCollection();
    }

    public String dumpInternalStats() {
        DCSInternalStatsModuleImpl dCSInternalStatsModuleImpl = (DCSInternalStatsModuleImpl)this._globals.statsModule;
        return dCSInternalStatsModuleImpl == null ? "Internal PMI not configured" : dCSInternalStatsModuleImpl.dump();
    }

    private final class ApprovePartialViewEventHandler
    implements VRIEventHandler {
        private ApprovePartialViewEventHandler() {
        }

        public int handle(VRIEvent vRIEvent) {
            if (!DCSDataStackImpl.this._terminated) {
                ApproveViewJob approveViewJob = new ApproveViewJob((ApprovePartialViewEvent)vRIEvent, DCSDataStackImpl.this._viewApprover);
                DCSDataStackImpl.this._applicationModuleThread.enqueueJob(approveViewJob);
            }
            return 3;
        }

        public String getTraceName() {
            return "ApprovePartialViewEventHandler";
        }
    }

    private final class ApproveViewJob
    extends DCSStackImpl.ApplicationLayerJob {
        private final ViewIdImpl _viewID;
        private final String[] _viewMembers;
        private final int _context;
        private final ViewApprover _viewApprover1;

        ApproveViewJob(ApprovePartialViewEvent approvePartialViewEvent, ViewApprover viewApprover) {
            super(DCSDataStackImpl.this);
            this._viewMembers = approvePartialViewEvent.getProposedViewMembers();
            this._viewID = approvePartialViewEvent.getProposedViewID();
            this._context = approvePartialViewEvent.getContext();
            this._viewApprover1 = viewApprover;
        }

        public void process() {
            if (DCSDataStackImpl.this._terminated) {
                return;
            }
            if (this._viewApprover1 != null) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(DCSDataStackImpl.this._traceContext, "ApproveViewJob.process", "going to ask for approval");
                    dCSTraceBuffer.addProperty(this._viewID).addProperty("Context", this._context).addProperty("viewMembers", this._viewMembers).addProperty("ViewApprover", String.valueOf(this._viewApprover1));
                    dCSTraceBuffer.invoke();
                }
                this._viewApprover1.approvePartialNewView(this._viewID, this._viewMembers, this._context);
            } else {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(DCSDataStackImpl.this._traceContext, "ApproveViewJob.process", "No view approver. Approve automatically.");
                    dCSTraceBuffer.addProperty(this._viewID).addProperty("Context", this._context).addProperty("viewMembers", this._viewMembers).addProperty("ViewApprover", String.valueOf(this._viewApprover1));
                    dCSTraceBuffer.invoke();
                }
                try {
                    DCSDataStackImpl.this.partialViewApproved(this._viewID, this._context);
                }
                catch (DCSInvalidViewIDException dCSInvalidViewIDException) {
                    DCSTraceable dCSTraceable;
                    if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                        dCSTraceable = DCSTraceBuffer.internalWarning(DCSDataStackImpl.this._traceContext, "Automatic partialViewApproved failed", dCSInvalidViewIDException);
                        dCSTraceable.invoke();
                    }
                    dCSTraceable = new TerminationEvent(DCSDataStackImpl.this._traceContext, "ApproveViewJob.process", dCSInvalidViewIDException);
                    DCSDataStackImpl.this.requestTermination((DCSTerminationEvent)dCSTraceable);
                }
            }
        }

        public String toString() {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
            dCSTraceBuffer.addProperty(this._viewID).addProperty("Context", this._context).addProperty("viewMembers", this._viewMembers).addProperty("ViewApprover", String.valueOf(this._viewApprover1));
            return dCSTraceBuffer.toString();
        }

        public String getTraceName() {
            return "ApproveViewJob";
        }

        public void handleError(Throwable throwable) {
            CallbackFailedEvent callbackFailedEvent = new CallbackFailedEvent(DCSDataStackImpl.this._traceContext, "ApproveViewJob.process", throwable);
            DCSDataStackImpl.this.requestTermination(callbackFailedEvent);
        }
    }
}

