/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common.impl;

import com.ibm.ws.dcs.common.DCSMessage;
import com.ibm.ws.dcs.common.exception.DCSException;
import com.ibm.ws.dcs.common.exception.DCSMessageCorruptedException;
import com.ibm.ws.dcs.common.exception.DCSMessageNotWritableException;
import com.ibm.ws.dcs.common.exception.DCSRuntimeException;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.impl.BaseVRIMessage;
import com.ibm.ws.dcs.vri.common.impl.DCSMessageImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;

public final class DCSIncomingMessage
extends DCSMessageImpl
implements DCSMessage {
    private DCSInputStream _is = null;
    private ObjectInputStream _ois = null;

    private DCSIncomingMessage() {
    }

    protected DCSIncomingMessage(String string, byte[] byArray, int n, int n2) throws DCSMessageCorruptedException {
        super(string, byArray, n, n2);
        this.readProperties();
        this._is = new DCSInputStream();
    }

    public boolean readBoolean() {
        return this._is.readBoolean();
    }

    public byte readByte() {
        return this._is.readByte();
    }

    public int readBytes(byte[] byArray) {
        return this._is.readBytes(byArray);
    }

    public int readBytes(byte[] byArray, int n, int n2) {
        return this._is.readBytes(byArray, n, n2);
    }

    public char readChar() {
        return this._is.readChar();
    }

    public double readDouble() {
        return this._is.readDouble();
    }

    public float readFloat() {
        return this._is.readFloat();
    }

    public int readInt() {
        return this._is.readInt();
    }

    public short readShort() {
        return this._is.readShort();
    }

    public long readLong() {
        return this._is.readLong();
    }

    public int readUnsignedByte() {
        return this._is.readUnsignedByte();
    }

    public int readUnsignedShort() {
        return this._is.readUnsignedShort();
    }

    public String readString() {
        return this._is.readString();
    }

    public Serializable readObject() {
        int n = this._offset.getValue();
        try {
            if (this._ois == null) {
                this._ois = new ObjectInputStream(this._is);
            }
            int n2 = this._is.readInt();
            int n3 = this._offset.getValue();
            Serializable serializable = (Serializable)this._ois.readObject();
            return serializable;
        }
        catch (Exception exception) {
            this._offset.setValue(n);
            throw new DCSRuntimeException("Failed to read object", exception);
        }
    }

    public byte[] readObjectAsByteArray() {
        int n;
        byte[] byArray;
        int n2;
        Utils.Offset offset = new Utils.Offset(this._offset.getValue());
        if (this._ois == null) {
            try {
                this._ois = new ObjectInputStream(this._is);
            }
            catch (IOException iOException) {
                this._offset = offset;
                return null;
            }
        }
        if ((n2 = this.readBytes(byArray = new byte[n = this.readInt()])) != n) {
            this._offset = offset;
            this._ois = null;
            return null;
        }
        return byArray;
    }

    public byte[] getBodyAsByteArray() {
        Utils.Offset offset = new Utils.Offset(this._startDataIndex + 8);
        this._dataLength = Utils.byteArray2int(this._buffer, offset);
        byte[] byArray = new byte[this._dataLength];
        System.arraycopy(this._buffer, offset.getValue(), byArray, 0, this._dataLength);
        return byArray;
    }

    public int getMessageDataSize() {
        Utils.Offset offset = new Utils.Offset(this._startDataIndex + 8);
        int n = Utils.byteArray2int(this._buffer, offset);
        return n;
    }

    public void reset() {
        try {
            this._ois.close();
            this._is.open();
            this._offset.setValue(this._startDataIndex + 8);
            this._dataLength = Utils.byteArray2int(this._buffer, this._offset);
            this._ois = null;
        }
        catch (IOException iOException) {
            throw new DCSRuntimeException(iOException);
        }
    }

    public void writeBoolean(boolean bl) {
        throw new DCSMessageNotWritableException();
    }

    public void writeByte(byte by) {
        throw new DCSMessageNotWritableException();
    }

    public void writeBytes(byte[] byArray) {
        throw new DCSMessageNotWritableException();
    }

    public void writeBytes(byte[] byArray, int n, int n2) {
        throw new DCSMessageNotWritableException();
    }

    public void writeChar(char c) {
        throw new DCSMessageNotWritableException();
    }

    public void writeDouble(double d) {
        throw new DCSMessageNotWritableException();
    }

    public void writeFloat(float f) {
        throw new DCSMessageNotWritableException();
    }

    public void writeInt(int n) {
        throw new DCSMessageNotWritableException();
    }

    public void writeShort(short s) {
        throw new DCSMessageNotWritableException();
    }

    public void writeLong(long l) {
        throw new DCSMessageNotWritableException();
    }

    public void writeObject(Serializable serializable) {
        throw new DCSMessageNotWritableException();
    }

    public void writeObjectFromByteArray(byte[] byArray) {
        throw new DCSMessageNotWritableException();
    }

    public void writeString(String string) {
        throw new DCSMessageNotWritableException();
    }

    public void clearBody() {
        throw new DCSMessageNotWritableException();
    }

    public VRIMessage toVRIMessage() throws DCSException {
        throw new DCSMessageNotWritableException();
    }

    public VRIMessage copy(boolean bl) {
        DCSIncomingMessage dCSIncomingMessage = (DCSIncomingMessage)super.copy(bl);
        dCSIncomingMessage._is = this._is;
        dCSIncomingMessage._ois = this._ois;
        return dCSIncomingMessage;
    }

    protected BaseVRIMessage getNewInstance() {
        return new DCSIncomingMessage();
    }

    private final class DCSInputStream
    extends InputStream {
        private boolean _closed = false;

        private DCSInputStream() {
        }

        public void close() throws IOException {
            this._closed = true;
        }

        public void open() {
            this._closed = false;
        }

        public int available() throws IOException {
            if (this._closed) {
                return 0;
            }
            return DCSIncomingMessage.this._dataLength;
        }

        public boolean markSupported() {
            return false;
        }

        public int read() throws IOException {
            if (this._closed) {
                IOException iOException = new IOException("Stream is closed.");
                throw iOException;
            }
            if (DCSIncomingMessage.this._dataLength == 0) {
                return -1;
            }
            int n = DCSIncomingMessage.this._offset.getValue();
            DCSIncomingMessage.this._offset.add(1);
            --DCSIncomingMessage.this._dataLength;
            return 0xFF & DCSIncomingMessage.this._buffer[n];
        }

        public int read(byte[] byArray) throws IOException {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (this._closed) {
                IOException iOException = new IOException("Stream is closed.");
                throw iOException;
            }
            return this.readBytes(byArray, n, n2);
        }

        public long skip(int n) throws IOException {
            if (this._closed) {
                IOException iOException = new IOException("Stream is closed.");
                throw iOException;
            }
            int n2 = DCSIncomingMessage.this._offset.getValue();
            int n3 = DCSIncomingMessage.this._dataLength;
            if (n3 <= 0) {
                return -1L;
            }
            if (n3 > n) {
                n3 = n;
            }
            DCSIncomingMessage.this._offset.setValue(n2 + n3);
            DCSIncomingMessage.this._dataLength -= n3;
            return n3;
        }

        public boolean readBoolean() {
            return this.readByte() != 0;
        }

        public byte readByte() {
            if (DCSIncomingMessage.this._dataLength < 1) {
                throw new DCSRuntimeException("End of stream");
            }
            int n = DCSIncomingMessage.this._offset.getValue();
            DCSIncomingMessage.this._offset.setValue(n + 1);
            --DCSIncomingMessage.this._dataLength;
            return DCSIncomingMessage.this._buffer[n];
        }

        public int readBytes(byte[] byArray) {
            return this.readBytes(byArray, 0, byArray.length);
        }

        public int readBytes(byte[] byArray, int n, int n2) {
            int n3 = DCSIncomingMessage.this._offset.getValue();
            int n4 = DCSIncomingMessage.this._dataLength;
            if (n4 <= 0) {
                return -1;
            }
            if (n4 > n2) {
                n4 = n2;
            }
            System.arraycopy(DCSIncomingMessage.this._buffer, n3, byArray, n, n4);
            DCSIncomingMessage.this._offset.setValue(n3 + n4);
            DCSIncomingMessage.this._dataLength -= n4;
            return n4;
        }

        public char readChar() {
            return (char)this.readShort();
        }

        public double readDouble() {
            long l = this.readLong();
            return Double.longBitsToDouble(l);
        }

        public float readFloat() {
            int n = this.readInt();
            return Float.intBitsToFloat(n);
        }

        public int readInt() {
            if (DCSIncomingMessage.this._dataLength < Utils.sizeOfInt()) {
                throw new DCSRuntimeException("End of stream");
            }
            DCSIncomingMessage.this._dataLength -= Utils.sizeOfInt();
            return Utils.byteArray2int(DCSIncomingMessage.this._buffer, DCSIncomingMessage.this._offset);
        }

        public short readShort() {
            if (DCSIncomingMessage.this._dataLength < Utils.sizeOfShort()) {
                throw new DCSRuntimeException("End of stream");
            }
            DCSIncomingMessage.this._dataLength -= Utils.sizeOfShort();
            return Utils.byteArray2short(DCSIncomingMessage.this._buffer, DCSIncomingMessage.this._offset);
        }

        public long readLong() {
            if (DCSIncomingMessage.this._dataLength < Utils.sizeOfLong()) {
                throw new DCSRuntimeException("End of stream");
            }
            DCSIncomingMessage.this._dataLength -= Utils.sizeOfLong();
            return Utils.byteArray2long(DCSIncomingMessage.this._buffer, DCSIncomingMessage.this._offset);
        }

        public int readUnsignedByte() {
            return 0xFF & this.readByte();
        }

        public int readUnsignedShort() {
            return 0xFFFF & this.readShort();
        }

        public String readString() {
            String string = null;
            int n = DCSIncomingMessage.this._offset.getValue();
            try {
                string = Utils.byteArray2string(DCSIncomingMessage.this._buffer, DCSIncomingMessage.this._offset);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new DCSRuntimeException("End of stream");
            }
            DCSIncomingMessage.this._dataLength -= DCSIncomingMessage.this._offset.getValue() - n;
            if (DCSIncomingMessage.this._dataLength < 0) {
                DCSIncomingMessage.this._offset.setValue(n);
                throw new DCSRuntimeException("End of stream");
            }
            return string;
        }
    }
}

