/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common.impl;

import com.ibm.ws.dcs.common.DCSMessage;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.impl.BaseVRIMessage;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public abstract class DCSMessageImpl
extends BaseVRIMessage
implements DCSMessage {
    private static final byte[] VERSION = new byte[]{1, 0, 0, 0};
    protected Properties _props = null;
    protected Utils.Offset _offset;
    protected int _lastIndex;
    protected int _dataLength = 0;

    protected DCSMessageImpl() {
    }

    protected DCSMessageImpl(byte by, byte by2, byte by3, String string, int n) {
        super(by, by2, by3, string, n);
        this._props = new Properties();
    }

    protected DCSMessageImpl(String string, byte[] byArray, int n, int n2) {
        super(string, byArray, n, n2);
        this._props = new Properties();
    }

    public final void clearProperties() {
        this._props.clear();
    }

    public final boolean propertyExists(String string) {
        return this._props.containsKey(string);
    }

    public final void setProperty(String string, String string2) {
        this._props.setProperty(string, string2);
    }

    public final String getProperty(String string) {
        return this._props.getProperty(string);
    }

    public final Properties getProperties() {
        return this._props;
    }

    public final void setProperties(Properties properties) {
        this._props = properties;
    }

    protected void readProperties() {
        this._tempOffset.setValue(this._startDataIndex + 8);
        this._dataLength = Utils.byteArray2int(this._buffer, this._tempOffset);
        this._offset = new Utils.Offset(this._tempOffset.getValue());
        this._tempOffset.add(this._dataLength);
        int n = Utils.byteArray2int(this._buffer, this._tempOffset);
        for (int i = 0; i < n; ++i) {
            String string = Utils.byteArray2string(this._buffer, this._tempOffset);
            String string2 = Utils.byteArray2string(this._buffer, this._tempOffset);
            this._props.setProperty(string, string2);
        }
    }

    protected void writeProperties() {
        this._tempOffset.setValue(this._startDataIndex + 8);
        Utils.int2byteArray(this._dataLength, this._buffer, this._tempOffset);
        int n = this._props.size();
        this.writeInt(n);
        if (n == 0) {
            return;
        }
        Set<Map.Entry<Object, Object>> set = this._props.entrySet();
        Iterator<Map.Entry<Object, Object>> iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry<Object, Object> entry = iterator.next();
            this.writeString((String)entry.getKey());
            this.writeString((String)entry.getValue());
        }
    }

    public VRIMessage copy(boolean bl) {
        DCSMessageImpl dCSMessageImpl = (DCSMessageImpl)super.copy(bl);
        dCSMessageImpl._props = this._props;
        dCSMessageImpl._offset = this._offset;
        dCSMessageImpl._lastIndex = this._lastIndex;
        dCSMessageImpl._dataLength = this._dataLength;
        return dCSMessageImpl;
    }

    protected final byte[] getImplementationVersion() {
        return VERSION;
    }

    public final void release() {
    }
}

