/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.DCSMessage;
import com.ibm.ws.dcs.common.exception.DCSMessageCorruptedException;
import com.ibm.ws.dcs.common.exception.DCSMessageNotReadableException;
import com.ibm.ws.dcs.common.exception.DCSRuntimeException;
import com.ibm.ws.dcs.stat.DCSStatsModule;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.impl.BaseVRIMessage;
import com.ibm.ws.dcs.vri.common.impl.DCSMessageImpl;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.Properties;

public final class DCSOutgoingMessage
extends DCSMessageImpl
implements DCSMessage {
    private static final TraceComponent TC = Tr.register(DCSOutgoingMessage.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private DCSOutputStream _os = null;
    private ObjectOutputStream _oos = null;
    private DCSStatsModule _stats = null;

    private DCSOutgoingMessage() {
    }

    protected DCSOutgoingMessage(byte by, byte by2, String string, int n, DCSStatsModule dCSStatsModule) {
        super(by, (byte)-1, by2, string, n + 512);
        int n2 = 8 + Utils.sizeOfInt();
        this._offset = new Utils.Offset(n2);
        this._lastIndex = n2 + n;
        this._props = new Properties();
        this._os = new DCSOutputStream();
        this._stats = dCSStatsModule;
    }

    public boolean readBoolean() {
        throw new DCSMessageNotReadableException();
    }

    public byte readByte() {
        throw new DCSMessageNotReadableException();
    }

    public int readBytes(byte[] byArray) {
        throw new DCSMessageNotReadableException();
    }

    public int readBytes(byte[] byArray, int n, int n2) {
        throw new DCSMessageNotReadableException();
    }

    public char readChar() {
        throw new DCSMessageNotReadableException();
    }

    public double readDouble() {
        throw new DCSMessageNotReadableException();
    }

    public float readFloat() {
        throw new DCSMessageNotReadableException();
    }

    public int readInt() {
        throw new DCSMessageNotReadableException();
    }

    public short readShort() {
        throw new DCSMessageNotReadableException();
    }

    public long readLong() {
        throw new DCSMessageNotReadableException();
    }

    public int readUnsignedByte() {
        throw new DCSMessageNotReadableException();
    }

    public int readUnsignedShort() {
        throw new DCSMessageNotReadableException();
    }

    public String readString() {
        throw new DCSMessageNotReadableException();
    }

    public Serializable readObject() {
        throw new DCSMessageNotReadableException();
    }

    public byte[] readObjectAsByteArray() {
        throw new DCSMessageNotReadableException();
    }

    public byte[] getBodyAsByteArray() {
        throw new DCSMessageNotReadableException();
    }

    public int getMessageDataSize() {
        return this._dataLength;
    }

    public void reset() {
        throw new DCSMessageNotReadableException();
    }

    public void writeBoolean(boolean bl) {
        this._os.writeBoolean(bl);
    }

    public void writeByte(byte by) {
        this._os.writeByte(by);
    }

    public void writeBytes(byte[] byArray) {
        this._os.writeBytes(byArray);
    }

    public void writeBytes(byte[] byArray, int n, int n2) {
        this._os.writeBytes(byArray, n, n2);
    }

    public void writeChar(char c) {
        this._os.writeChar(c);
    }

    public void writeDouble(double d) {
        this._os.writeDouble(d);
    }

    public void writeFloat(float f) {
        this._os.writeFloat(f);
    }

    public void writeInt(int n) {
        this._os.writeInt(n);
    }

    public void writeShort(short s) {
        this._os.writeShort(s);
    }

    public void writeLong(long l) {
        this._os.writeLong(l);
    }

    public void writeObject(Serializable serializable) {
        int n = this._offset.getValue();
        try {
            if (this._oos == null) {
                this._oos = new ObjectOutputStream(this._os);
            }
            int n2 = this._offset.getValue();
            this._os.writeInt(0);
            int n3 = this._offset.getValue();
            this._oos.writeObject(serializable);
            this._oos.flush();
            int n4 = this._offset.getValue();
            int n5 = n4 - n3;
            Utils.int2byteArray(n5, this._buffer, new Utils.Offset(n2));
        }
        catch (IOException iOException) {
            this._offset.setValue(n);
            throw new DCSRuntimeException(iOException);
        }
    }

    public void writeObjectFromByteArray(byte[] byArray) {
        int n = this._offset.getValue();
        try {
            if (this._oos == null) {
                this._oos = new ObjectOutputStream(this._os);
            }
            this.writeInt(byArray.length);
            this.writeBytes(byArray);
        }
        catch (IOException iOException) {
            this._offset.setValue(n);
            throw new DCSRuntimeException(iOException);
        }
    }

    public void writeString(String string) {
        this._os.writeString(string);
    }

    public VRIMessage toVRIMessage() throws DCSMessageCorruptedException {
        if (this._os == null) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceContextImpl dCSTraceContextImpl = new DCSTraceContextImpl(TC, null, null, "DCSMsg");
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(dCSTraceContextImpl, "Message already closed", null);
                dCSTraceBuffer.addProperty("Layer", this.getOriginatorLayer());
                dCSTraceBuffer.addProperty("Sender", this.getSender());
                dCSTraceBuffer.invoke();
            }
            return this;
        }
        try {
            this.writeProperties();
            if (this._oos != null) {
                this._oos.close();
            }
            this._oos = null;
            this._os = null;
            this._index = this._offset.getValue() - this._startDataIndex;
        }
        catch (IOException iOException) {
            throw new DCSMessageCorruptedException(iOException.getMessage());
        }
        return this;
    }

    protected void realloc(int n) {
        if (this._stats != null) {
            this._stats.onRealloc();
        }
        if (this._os == null) {
            super.realloc(n);
        } else {
            this._index = this._offset.getValue() - this._startDataIndex;
            super.realloc(n);
            this._lastIndex = this._bufferLength - 512;
            this._offset.setValue(this._startDataIndex + this._index);
        }
    }

    public VRIMessage copy(boolean bl) {
        DCSOutgoingMessage dCSOutgoingMessage = (DCSOutgoingMessage)super.copy(bl);
        dCSOutgoingMessage._os = this._os;
        dCSOutgoingMessage._oos = this._oos;
        return dCSOutgoingMessage;
    }

    protected BaseVRIMessage getNewInstance() {
        return new DCSOutgoingMessage();
    }

    private final class DCSOutputStream
    extends OutputStream {
        private boolean _closed = false;

        private DCSOutputStream() {
        }

        public void open() {
            this._closed = false;
        }

        public void close() throws IOException {
            this._closed = true;
        }

        public void flush() throws IOException {
        }

        public void write(int n) throws IOException {
            if (this._closed) {
                IOException iOException = new IOException("Stream is closed.");
                throw iOException;
            }
            this.writeByte((byte)(n & 0xFF));
        }

        public void write(byte[] byArray) throws IOException {
            this.write(byArray, 0, byArray.length);
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (this._closed) {
                IOException iOException = new IOException("Stream is closed.");
                throw iOException;
            }
            this.writeBytes(byArray, n, n2);
        }

        public void writeBoolean(boolean bl) {
            byte by = (byte)(bl ? 1 : 0);
            this.writeByte(by);
        }

        public void writeByte(byte by) {
            if (DCSOutgoingMessage.this._offset.getValue() + 1 > DCSOutgoingMessage.this._lastIndex) {
                DCSOutgoingMessage.this.realloc(1);
            }
            int n = DCSOutgoingMessage.this._offset.getValue();
            DCSOutgoingMessage.this._buffer[n++] = by;
            DCSOutgoingMessage.this._offset.setValue(n);
            ++DCSOutgoingMessage.this._dataLength;
        }

        public void writeBytes(byte[] byArray) {
            this.writeBytes(byArray, 0, byArray.length);
        }

        public void writeBytes(byte[] byArray, int n, int n2) {
            while (DCSOutgoingMessage.this._offset.getValue() + n2 > DCSOutgoingMessage.this._lastIndex) {
                DCSOutgoingMessage.this.realloc(n2);
            }
            int n3 = DCSOutgoingMessage.this._offset.getValue();
            System.arraycopy(byArray, n, DCSOutgoingMessage.this._buffer, n3, n2);
            DCSOutgoingMessage.this._offset.add(n2);
            DCSOutgoingMessage.this._dataLength += n2;
        }

        public void writeChar(char c) {
            this.writeShort((short)c);
        }

        public void writeDouble(double d) {
            this.writeLong(Double.doubleToLongBits(d));
        }

        public void writeFloat(float f) {
            this.writeInt(Float.floatToIntBits(f));
        }

        public void writeInt(int n) {
            if (DCSOutgoingMessage.this._offset.getValue() + Utils.sizeOfInt() > DCSOutgoingMessage.this._lastIndex) {
                DCSOutgoingMessage.this.realloc(Utils.sizeOfInt());
            }
            Utils.int2byteArray(n, DCSOutgoingMessage.this._buffer, DCSOutgoingMessage.this._offset);
            DCSOutgoingMessage.this._dataLength += Utils.sizeOfInt();
        }

        public void writeShort(short s) {
            if (DCSOutgoingMessage.this._offset.getValue() + Utils.sizeOfShort() > DCSOutgoingMessage.this._lastIndex) {
                DCSOutgoingMessage.this.realloc(Utils.sizeOfShort());
            }
            Utils.short2byteArray(s, DCSOutgoingMessage.this._buffer, DCSOutgoingMessage.this._offset);
            DCSOutgoingMessage.this._dataLength += Utils.sizeOfShort();
        }

        public void writeLong(long l) {
            if (DCSOutgoingMessage.this._offset.getValue() + Utils.sizeOfLong() > DCSOutgoingMessage.this._lastIndex) {
                DCSOutgoingMessage.this.realloc(Utils.sizeOfLong());
            }
            Utils.long2byteArray(l, DCSOutgoingMessage.this._buffer, DCSOutgoingMessage.this._offset);
            DCSOutgoingMessage.this._dataLength += Utils.sizeOfLong();
        }

        public void writeString(String string) {
            int n = Utils.sizeOfString(string);
            while (DCSOutgoingMessage.this._offset.getValue() + n > DCSOutgoingMessage.this._lastIndex) {
                DCSOutgoingMessage.this.realloc(n);
            }
            Utils.string2byteArray(string, DCSOutgoingMessage.this._buffer, DCSOutgoingMessage.this._offset);
            DCSOutgoingMessage.this._dataLength += n;
        }
    }
}

