/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.DCSCoreStack;
import com.ibm.ws.dcs.common.DCSDataStack;
import com.ibm.ws.dcs.common.MemberInfoManager;
import com.ibm.ws.dcs.common.config.DCSCoreStackConfigMap;
import com.ibm.ws.dcs.common.config.DCSDataStackConfigMap;
import com.ibm.ws.dcs.common.exception.DCSException;
import com.ibm.ws.dcs.common.exception.DCSRuntimeException;
import com.ibm.ws.dcs.vri.common.impl.ConfigurationParser;
import com.ibm.ws.dcs.vri.common.impl.DCSConfig;
import com.ibm.ws.dcs.vri.common.impl.DCSCoreStackImpl;
import com.ibm.ws.dcs.vri.common.impl.DCSStacksRegistry;
import com.ibm.ws.dcs.vri.common.impl.DataStackClassResolver;
import com.ibm.ws.dcs.vri.common.util.DCSConfigPrinter;
import java.lang.reflect.Method;
import java.util.Map;

public class DCSStackFactory {
    private static final TraceComponent TC = Tr.register(DCSStackFactory.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");

    private DCSStackFactory() {
    }

    public static synchronized DCSCoreStack getCoreStack(String string, DCSCoreStackConfigMap dCSCoreStackConfigMap) throws DCSException {
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, "getCoreStack():", new Object[]{string, dCSCoreStackConfigMap});
        }
        if (DCSStacksRegistry.isRegistered(string)) {
            throw new DCSException("DCS Core stack " + string + " already exists.");
        }
        new DCSConfigPrinter(dCSCoreStackConfigMap).print();
        DCSConfig dCSConfig = ConfigurationParser.parseStackConfiguration(string, dCSCoreStackConfigMap);
        DCSCoreStackImpl dCSCoreStackImpl = null;
        try {
            dCSCoreStackImpl = DCSCoreStackImpl.getInstance(string, dCSConfig, null);
            DCSStacksRegistry.registerStack(string, dCSCoreStackImpl);
        }
        catch (Throwable throwable) {
            DCSRuntimeException dCSRuntimeException = new DCSRuntimeException("Failed to create core stack", throwable);
            throw dCSRuntimeException;
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "getCoreStack(): " + dCSCoreStackImpl);
        }
        return dCSCoreStackImpl;
    }

    public static synchronized DCSDataStack getDCSDataStack(String string, String[] stringArray, DCSDataStackConfigMap dCSDataStackConfigMap, MemberInfoManager memberInfoManager) throws DCSException {
        DCSDataStack dCSDataStack;
        if (TC.isEntryEnabled()) {
            Tr.entry(TC, " getDataStack(): ", new Object[]{string, stringArray, dCSDataStackConfigMap, memberInfoManager});
        }
        if (memberInfoManager == null) {
            throw new DCSException("MemberInfoManager is null.");
        }
        String string2 = DCSStacksRegistry.createDataStackName(memberInfoManager.getCoreGroupName(), string);
        if (DCSStacksRegistry.isRegistered(string2)) {
            throw new DCSException("DCS Data stack " + string + " already exists in core group " + memberInfoManager.getCoreGroupName());
        }
        new DCSConfigPrinter(dCSDataStackConfigMap).print();
        DCSConfig dCSConfig = ConfigurationParser.parseStackConfiguration(string, dCSDataStackConfigMap);
        Map map = memberInfoManager.getMembersInfo(stringArray);
        dCSConfig.put("DefinedSet", map);
        dCSConfig.put("ThisMemberName", memberInfoManager.getLocalMemberName());
        try {
            dCSDataStack = DCSStackFactory.getStackInstance(string2, dCSConfig, memberInfoManager);
            DCSStacksRegistry.registerStack(string2, dCSDataStack);
        }
        catch (Throwable throwable) {
            DCSRuntimeException dCSRuntimeException = new DCSRuntimeException("Failed to create data stack", throwable);
            throw dCSRuntimeException;
        }
        if (TC.isEntryEnabled()) {
            Tr.exit(TC, "getDataStack(): " + dCSDataStack);
        }
        return dCSDataStack;
    }

    private static DCSDataStack getStackInstance(String string, DCSConfig dCSConfig, MemberInfoManager memberInfoManager) throws DCSException {
        try {
            Class clazz = (Class)dCSConfig.get("DATA_STACK_TYPE");
            clazz = DataStackClassResolver.resolveClass(clazz);
            if (clazz == null) {
                throw new DCSRuntimeException("Unknown data stack");
            }
            Class[] classArray = new Class[]{String.class, DCSConfig.class, MemberInfoManager.class};
            Method method2 = clazz.getMethod("getInstance", classArray);
            Object[] objectArray = new Object[]{string, dCSConfig, memberInfoManager};
            DCSDataStack dCSDataStack = (DCSDataStack)method2.invoke(null, objectArray);
            return dCSDataStack;
        }
        catch (Throwable throwable) {
            DCSRuntimeException dCSRuntimeException = new DCSRuntimeException("Failed to create data stack", throwable);
            throw dCSRuntimeException;
        }
    }
}

