/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common.impl;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.DCSMessage;
import com.ibm.ws.dcs.common.DCSMessageListener;
import com.ibm.ws.dcs.common.DCSNotificationsListener;
import com.ibm.ws.dcs.common.DCSStack;
import com.ibm.ws.dcs.common.DCSTraceable;
import com.ibm.ws.dcs.common.MemberInfoManager;
import com.ibm.ws.dcs.common.MembershipListener;
import com.ibm.ws.dcs.common.QoS;
import com.ibm.ws.dcs.common.StateBlob;
import com.ibm.ws.dcs.common.StateVersion;
import com.ibm.ws.dcs.common.ViewChangeEvent;
import com.ibm.ws.dcs.common.ViewChangeListener;
import com.ibm.ws.dcs.common.event.DCSExternalEvent;
import com.ibm.ws.dcs.common.event.DCSSuspectEvent;
import com.ibm.ws.dcs.common.event.DCSTerminationEvent;
import com.ibm.ws.dcs.common.exception.DCSException;
import com.ibm.ws.dcs.common.exception.DCSInvalidParametersException;
import com.ibm.ws.dcs.common.exception.DCSRuntimeException;
import com.ibm.ws.dcs.common.exception.DCSUnsupportedQoSException;
import com.ibm.ws.dcs.stat.DCSStatsModule;
import com.ibm.ws.dcs.vri.DCSImpl;
import com.ibm.ws.dcs.vri.common.AdministrativeTerminationRequest;
import com.ibm.ws.dcs.vri.common.CCVersion;
import com.ibm.ws.dcs.vri.common.DCSConstants;
import com.ibm.ws.dcs.vri.common.Downcalls;
import com.ibm.ws.dcs.vri.common.Globals;
import com.ibm.ws.dcs.vri.common.Header;
import com.ibm.ws.dcs.vri.common.Job;
import com.ibm.ws.dcs.vri.common.JobsProcessorThread;
import com.ibm.ws.dcs.vri.common.MSSAdmin;
import com.ibm.ws.dcs.vri.common.ThreadManager;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRIDenialReason;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMembersMGR;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.event.CongestionControlEvent;
import com.ibm.ws.dcs.vri.common.event.NotifyExternalEvent;
import com.ibm.ws.dcs.vri.common.event.RequestChangeProtocolEvent;
import com.ibm.ws.dcs.vri.common.event.RequestDumpEvent;
import com.ibm.ws.dcs.vri.common.event.RequestStateChangeEvent;
import com.ibm.ws.dcs.vri.common.event.VRIDownEvent;
import com.ibm.ws.dcs.vri.common.event.VRIEvent;
import com.ibm.ws.dcs.vri.common.event.VRIEventHandler;
import com.ibm.ws.dcs.vri.common.event.VRIEventHandlersMap;
import com.ibm.ws.dcs.vri.common.event.VRINotifyDownEvent;
import com.ibm.ws.dcs.vri.common.event.VRINotifyUpEvent;
import com.ibm.ws.dcs.vri.common.event.VRIUpEvent;
import com.ibm.ws.dcs.vri.common.impl.ApplicationModuleImpl;
import com.ibm.ws.dcs.vri.common.impl.BaseVRIMessage;
import com.ibm.ws.dcs.vri.common.impl.DCSConfig;
import com.ibm.ws.dcs.vri.common.impl.DCSIncomingMessage;
import com.ibm.ws.dcs.vri.common.impl.DCSMessageFactory;
import com.ibm.ws.dcs.vri.common.impl.DCSOutgoingMessage;
import com.ibm.ws.dcs.vri.common.impl.DCSStacksRegistry;
import com.ibm.ws.dcs.vri.common.impl.Sidecall;
import com.ibm.ws.dcs.vri.common.impl.SubgroupMcastHeader;
import com.ibm.ws.dcs.vri.common.nls.AbstractNLSEvent;
import com.ibm.ws.dcs.vri.common.nls.CallbackFailedEvent;
import com.ibm.ws.dcs.vri.common.nls.StackStartedEvent;
import com.ibm.ws.dcs.vri.common.nls.SuspectUnreadableMessageEvent;
import com.ibm.ws.dcs.vri.common.nls.TerminationEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import com.ibm.ws.dcs.vri.common.util.FFDCDumper;
import java.util.Map;
import java.util.Properties;

public abstract class DCSStackImpl
extends Sidecall
implements DCSStack {
    protected static final String LAYER_NAME = DCSConstants.TRACE_LAYER_NAMES[8];
    protected static final int INVALID_MESSAGE_ERROR = 1;
    public static final int CORRUPTED_MSG_HEADER = 2;
    private static final byte SET_STATE_MSG = 1;
    private static final byte SET_PROTOCOL_MSG = 2;
    protected static final byte REGULAR_MSG_HA = 101;
    protected static final byte REGULAR_MSG_APP = 102;
    private static final TraceComponent TC = Tr.register(DCSStackImpl.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    protected ApplicationModuleImpl _appModule;
    protected MSSAdmin _mssAdmin;
    protected final Globals _globals;
    protected final VRIMembersMGR _mgr;
    protected final String _stackName;
    protected final DCSMessageFactory _factory;
    protected final String _thisMemberName;
    protected final QoS.QOSMulticast _defaultMcastQOS;
    protected final QoS.QOSMulticast _vsAnyMcastQOS;
    protected final QoS.QOSUnicast _defaultUcastQOS;
    protected final Object _mutex;
    protected DCSMessageListener _appMessageListener = null;
    protected DCSMessageListener _haMessageListener = null;
    protected ViewChangeListener _viewChangeListener = null;
    protected MembershipListener _membershipListener = null;
    protected DCSNotificationsListener _notificationListener = null;
    protected ViewIdImpl _currentViewId = null;
    protected ViewIdImpl _previousViewId = null;
    protected final String _applicationModuleThreadName;
    protected final JobsProcessorThread _applicationModuleThread;
    protected volatile boolean _terminated = false;
    protected final VRIEventHandlersMap _eventHandlers = new VRIEventHandlersMap();
    private final DCSTraceContext _traceContext;
    private final DCSStatsModule _statsModule;
    private volatile TerminateJob _administrativeTerminationJob = null;

    protected DCSStackImpl(String string, DCSConfig dCSConfig, MemberInfoManager memberInfoManager, boolean bl) throws DCSException {
        Object object;
        this._stackName = string;
        if (bl) {
            if (memberInfoManager == null) {
                memberInfoManager = (MemberInfoManager)((Object)this);
            }
            if (DCSConfig.UNLIMITED_THREADS_NUM.equals(object = (Integer)dCSConfig.get("DcsThreadsNum"))) {
                ThreadManager.increaseThreadPoolSize(-1);
            } else {
                ThreadManager.increaseThreadPoolSize((Integer)object);
            }
        }
        this._globals = new Globals(string, dCSConfig, this, memberInfoManager, bl);
        this._mgr = this._globals.getVRIMembersMgr();
        this._mutex = this._globals.getMutex();
        this._thisMemberName = this._mgr.getThisMember().getName();
        this._factory = this._globals.getDCSMessageFactory();
        this._traceContext = new DCSTraceContextImpl(TC, this._stackName, this._thisMemberName, LAYER_NAME);
        try {
            this._defaultMcastQOS = QoS.getMulticastQoS(QoS.RELIABLE, QoS.FIFO);
            this._defaultUcastQOS = QoS.getUnicastQoS(QoS.RELIABLE, QoS.FIFO);
            this._vsAnyMcastQOS = QoS.getMulticastQoS(QoS.VS_ANY, QoS.FIFO);
        }
        catch (DCSUnsupportedQoSException dCSUnsupportedQoSException) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this._traceContext, "Failed to get desired QoS", dCSUnsupportedQoSException);
                dCSTraceBuffer.invoke();
            }
            throw new DCSRuntimeException("ApplicationModuleImpl initialization failed.", dCSUnsupportedQoSException);
        }
        this._applicationModuleThreadName = this._stackName + ".ApplicationLayerThread";
        this._applicationModuleThread = ThreadManager.getThread(this._applicationModuleThreadName, ThreadManager.APPLICATION_THREAD, 7, bl);
        if (this._applicationModuleThread == null) {
            throw new DCSRuntimeException("Failed to create thread: " + this._applicationModuleThreadName);
        }
        this._statsModule = this._globals.statsModule;
        object = new NotifyEventHandler();
        this._eventHandlers.setVRIEventHandler(VRINotifyDownEvent.class, (VRIEventHandler)object);
        this._eventHandlers.setVRIEventHandler(VRINotifyUpEvent.class, (VRIEventHandler)object);
        this._eventHandlers.setVRIEventHandler(CongestionControlEvent.class, (VRIEventHandler)object);
    }

    public final Properties getMemberAddress(String string) {
        VRIMemberDescription vRIMemberDescription = this._mgr.getDefinedMember(string);
        if (vRIMemberDescription == null) {
            return null;
        }
        return vRIMemberDescription.getMemberInfo().getAddress();
    }

    public final Comparable start() {
        DCSTraceable dCSTraceable;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceable = DCSTraceBuffer.entry(this._traceContext, "start", "");
            ((DCSTraceBuffer)dCSTraceable).invoke();
        }
        this._currentViewId = this._mssAdmin.requestStart();
        dCSTraceable = new StackStartedEvent(this._traceContext, DCSImpl.getDCS_BUILD_VERSION(), this._mgr.getProtocolVersion());
        ((AbstractNLSEvent)dCSTraceable).invokeNLSTrace();
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "start", "");
            dCSTraceBuffer.addProperty(this._currentViewId);
            dCSTraceBuffer.invoke();
        }
        return this._currentViewId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void requestTermination() {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            object = DCSTraceBuffer.entry(this._traceContext, "requestTermination", "");
            ((DCSTraceBuffer)object).invoke();
        }
        if (!this._terminated) {
            object = this._mutex;
            synchronized (object) {
                TerminationEvent terminationEvent = new TerminationEvent(this._traceContext, "requestTermination", new AdministrativeTerminationRequest("Explicit termination request", true));
                this.requestTermination(terminationEvent);
            }
            if (this._administrativeTerminationJob != null) {
                this._administrativeTerminationJob.process();
            }
        }
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            object = DCSTraceBuffer.exit(this._traceContext, "requestTermination", "");
            ((DCSTraceBuffer)object).invoke();
        }
    }

    public final void sendMessage(String string, int n, DCSMessage dCSMessage) throws DCSException {
        this.sendMessage(string, n, dCSMessage, this._defaultUcastQOS, null);
    }

    public final void sendMessage(String string, int n, DCSMessage dCSMessage, QoS.QOSUnicast qOSUnicast) throws DCSException {
        this.sendMessage(string, n, dCSMessage, qOSUnicast, null);
    }

    public final void sendMessage(String string, int n, DCSMessage dCSMessage, QoS.QOSUnicast qOSUnicast, Comparable comparable) throws DCSException {
        try {
            this._appModule.sendMessage(string, this.prepareMessage2Send(dCSMessage, n), qOSUnicast, comparable);
        }
        catch (RuntimeException runtimeException) {
            TerminationEvent terminationEvent = new TerminationEvent(this._traceContext, "sendMessage", runtimeException);
            this.requestTermination(terminationEvent);
            throw new DCSException("DCS failed to send message", runtimeException);
        }
        catch (Error error) {
            TerminationEvent terminationEvent = new TerminationEvent(this._traceContext, "sendMessage", error);
            this.requestTermination(terminationEvent);
            throw new DCSException("DCS failed to send message", error);
        }
    }

    public final void sendMessage(String[] stringArray, int n, DCSMessage dCSMessage, QoS qoS) throws DCSException {
        try {
            this._appModule.sendMessage(stringArray, this.prepareMessage2Send(dCSMessage, n), qoS, null);
        }
        catch (RuntimeException runtimeException) {
            TerminationEvent terminationEvent = new TerminationEvent(this._traceContext, "sendMessage", runtimeException);
            this.requestTermination(terminationEvent);
            throw new DCSException("DCS failed to send message to subgroup", runtimeException);
        }
        catch (Error error) {
            TerminationEvent terminationEvent = new TerminationEvent(this._traceContext, "sendMessage", error);
            this.requestTermination(terminationEvent);
            throw new DCSException("DCS failed to send messageto subgroup", error);
        }
    }

    public final void sendMessage(String[] stringArray, int n, DCSMessage dCSMessage, QoS qoS, Comparable comparable) throws DCSException {
        try {
            this._appModule.sendMessage(stringArray, this.prepareMessage2Send(dCSMessage, n), qoS, comparable);
        }
        catch (RuntimeException runtimeException) {
            TerminationEvent terminationEvent = new TerminationEvent(this._traceContext, "sendMessage", runtimeException);
            this.requestTermination(terminationEvent);
            throw new DCSException("DCS failed to send message to subgroup", runtimeException);
        }
        catch (Error error) {
            TerminationEvent terminationEvent = new TerminationEvent(this._traceContext, "sendMessage", error);
            this.requestTermination(terminationEvent);
            throw new DCSException("DCS failed to send messageto subgroup", error);
        }
    }

    public final void mcastMessage(int n, DCSMessage dCSMessage) throws DCSException {
        this.mcastMessage(n, dCSMessage, this._defaultMcastQOS, null);
    }

    public final void mcastMessage(int n, DCSMessage dCSMessage, QoS.QOSMulticast qOSMulticast) throws DCSException {
        this.mcastMessage(n, dCSMessage, qOSMulticast, null);
    }

    public final void mcastMessage(int n, DCSMessage dCSMessage, QoS.QOSMulticast qOSMulticast, Comparable comparable) throws DCSException {
        try {
            this._appModule.mcastMessage(this.prepareMessage2Send(dCSMessage, n), qOSMulticast, comparable);
        }
        catch (RuntimeException runtimeException) {
            TerminationEvent terminationEvent = new TerminationEvent(this._traceContext, "mcastMessage", runtimeException);
            this.requestTermination(terminationEvent);
            throw new DCSException("DCS failed to mcast message", runtimeException);
        }
        catch (Error error) {
            TerminationEvent terminationEvent = new TerminationEvent(this._traceContext, "mcastMessage", error);
            this.requestTermination(terminationEvent);
            throw new DCSException("DCS failed to mcast message", error);
        }
    }

    public final DCSMessage createMessage() {
        return this._factory.getMessage((byte)8, this._thisMemberName);
    }

    public final DCSMessage createMessage(int n) {
        return this._factory.getMessage((byte)8, this._thisMemberName, n);
    }

    public void setState(StateBlob stateBlob) throws DCSException {
        Object object;
        if (stateBlob != null) {
            object = stateBlob.getVersion();
            if (object == null) {
                DCSInvalidParametersException dCSInvalidParametersException = new DCSInvalidParametersException("State version is null");
                throw dCSInvalidParametersException;
            }
        } else {
            DCSInvalidParametersException dCSInvalidParametersException = new DCSInvalidParametersException("StateBlob is null");
            throw dCSInvalidParametersException;
        }
        object = (DCSOutgoingMessage)this._factory.getMessage((byte)8, this._thisMemberName, 4096);
        ((BaseVRIMessage)object).setMessageType((byte)1);
        ((DCSOutgoingMessage)object).writeObject(stateBlob);
        this._appModule.mcastMessage((DCSOutgoingMessage)object, this._vsAnyMcastQOS, (Comparable)null);
    }

    public int getDCSProtocolVersion() {
        return this._mgr.getProtocolVersion();
    }

    public void setDCSProtocolVersion(int n, StateVersion stateVersion) throws DCSException {
        Object object;
        if (n > 0) {
            if (stateVersion == null) {
                DCSInvalidParametersException dCSInvalidParametersException = new DCSInvalidParametersException("Protocol version context is null");
                throw dCSInvalidParametersException;
            }
            object = this._mgr.getProtocolVersionContext();
            if (object != null && stateVersion.compareTo(object) <= 0) {
                DCSInvalidParametersException dCSInvalidParametersException = new DCSInvalidParametersException("Protocol version context is not newer old= " + this._mgr.getProtocolVersionContext() + " new =" + stateVersion);
                throw dCSInvalidParametersException;
            }
            if (n == this.getDCSProtocolVersion()) {
                DCSInvalidParametersException dCSInvalidParametersException = new DCSInvalidParametersException("Trying to update with current protocol" + n);
                throw dCSInvalidParametersException;
            }
        } else {
            DCSInvalidParametersException dCSInvalidParametersException = new DCSInvalidParametersException("Protocol Version is not greater than 0");
            throw dCSInvalidParametersException;
        }
        object = (DCSOutgoingMessage)this._factory.getMessage((byte)8, this._thisMemberName, 4096);
        ((BaseVRIMessage)object).setMessageType((byte)2);
        ((DCSOutgoingMessage)object).writeInt(n);
        ((DCSOutgoingMessage)object).writeObject(stateVersion);
        this._appModule.mcastMessage((DCSOutgoingMessage)object, this._vsAnyMcastQOS, (Comparable)null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestDumpAll(String string, int n) throws DCSException {
        Object object = this._mutex;
        synchronized (object) {
            if (!this._terminated) {
                RequestDumpEvent requestDumpEvent = new RequestDumpEvent(this._stackName, this._thisMemberName, string, n);
                try {
                    requestDumpEvent.startHandling(this._mutex, this._appModule.getUpperLayer());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    public final void handleViewChangeEventDone(ViewChangeEvent viewChangeEvent) {
        DCSTraceBuffer dCSTraceBuffer;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this._traceContext, "handleViewChangeEventDone", "");
            dCSTraceBuffer.addProperty(viewChangeEvent);
            dCSTraceBuffer.invoke();
        }
        viewChangeEvent.handleDone();
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "handleViewChangeEventDone", "");
            dCSTraceBuffer.invoke();
        }
    }

    private DCSOutgoingMessage prepareMessage2Send(DCSMessage dCSMessage, int n) throws DCSInvalidParametersException {
        DCSOutgoingMessage dCSOutgoingMessage;
        if (dCSMessage instanceof DCSOutgoingMessage) {
            dCSOutgoingMessage = (DCSOutgoingMessage)dCSMessage;
            if (n == 1) {
                dCSOutgoingMessage.setMessageType((byte)102);
            } else {
                dCSOutgoingMessage.setMessageType((byte)101);
            }
        } else {
            DCSInvalidParametersException dCSInvalidParametersException = new DCSInvalidParametersException("Message is not DCSOutgoingMessage -  " + dCSMessage.getClass().getName());
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this._traceContext, "Trying to send message of unknown type", dCSInvalidParametersException);
                dCSTraceBuffer.invoke();
            }
            throw dCSInvalidParametersException;
        }
        return dCSOutgoingMessage;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void requestTermination(DCSTerminationEvent dCSTerminationEvent) {
        Object object;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            object = DCSTraceBuffer.event(this._traceContext, "requestTermination", "");
            ((DCSTraceBuffer)object).addProperty(dCSTerminationEvent);
            ((DCSTraceBuffer)object).invoke();
        }
        object = this._mutex;
        synchronized (object) {
            this._appModule.getUpperLayer().requestTermination(dCSTerminationEvent);
        }
    }

    public final void setMembershipListener(MembershipListener membershipListener) {
        DCSTraceBuffer dCSTraceBuffer;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this._traceContext, "setMembershipListener", "");
            dCSTraceBuffer.addProperty("Listener", String.valueOf(membershipListener));
            dCSTraceBuffer.invoke();
        }
        this._membershipListener = membershipListener;
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "setMembershipListener", "");
            dCSTraceBuffer.invoke();
        }
    }

    public final void setNotificationListener(DCSNotificationsListener dCSNotificationsListener) {
        DCSTraceBuffer dCSTraceBuffer;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this._traceContext, "setNotificationListener", "");
            dCSTraceBuffer.addProperty("Listener", String.valueOf(dCSNotificationsListener));
            dCSTraceBuffer.invoke();
        }
        this._notificationListener = dCSNotificationsListener;
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "setNotificationListener", "");
            dCSTraceBuffer.invoke();
        }
    }

    public final void setViewChangeListener(ViewChangeListener viewChangeListener) {
        DCSTraceBuffer dCSTraceBuffer;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this._traceContext, "setViewChangeListener", "");
            dCSTraceBuffer.addProperty("Listener", String.valueOf(viewChangeListener));
            dCSTraceBuffer.invoke();
        }
        this._viewChangeListener = viewChangeListener;
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "setViewChangeListener", "");
            dCSTraceBuffer.invoke();
        }
    }

    public final void setHAMessageListener(DCSMessageListener dCSMessageListener) {
        DCSTraceBuffer dCSTraceBuffer;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this._traceContext, "setHAMessageListener", "");
            dCSTraceBuffer.addProperty("Listener", String.valueOf(dCSMessageListener));
            dCSTraceBuffer.invoke();
        }
        this._haMessageListener = dCSMessageListener;
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "setHAMessageListener", "");
            dCSTraceBuffer.invoke();
        }
    }

    public final void setApplicationMessageListener(DCSMessageListener dCSMessageListener) {
        DCSTraceBuffer dCSTraceBuffer;
        if (DCSTraceBuffer.isEntryEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.entry(this._traceContext, "setApplicationMessageListener", "");
            dCSTraceBuffer.addProperty("Listener", String.valueOf(dCSMessageListener));
            dCSTraceBuffer.invoke();
        }
        this._appMessageListener = dCSMessageListener;
        if (DCSTraceBuffer.isExitEnabled(TC)) {
            dCSTraceBuffer = DCSTraceBuffer.exit(this._traceContext, "setApplicationMessageListener", "");
            dCSTraceBuffer.invoke();
        }
    }

    protected Throwable check() {
        if (this._appMessageListener != null) {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "check", "Going to check application.");
                dCSTraceBuffer.invoke();
            }
            return this._appMessageListener.check();
        }
        return null;
    }

    protected void currentOK(CCVersion cCVersion) {
        DCSTraceable dCSTraceable;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceable = DCSTraceBuffer.event(this._traceContext, "currentOK", "");
            ((DCSTraceBuffer)dCSTraceable).addProperty(cCVersion);
            ((DCSTraceBuffer)dCSTraceable).invoke();
        }
        if (!this._terminated) {
            dCSTraceable = new CCOKJob(cCVersion);
            this._applicationModuleThread.enqueueJob((Job)((Object)dCSTraceable));
        }
    }

    final void completeCurrent(VRIMemberDescription[] vRIMemberDescriptionArray, CCVersion cCVersion) {
        DCSTraceable dCSTraceable;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceable = DCSTraceBuffer.event(this._traceContext, "completeCurrent", "");
            ((DCSTraceBuffer)dCSTraceable).addProperty(cCVersion);
            ((DCSTraceBuffer)dCSTraceable).addProperty("failedMembers", Utils.toString(VRIMemberUtils.getMemberNames(vRIMemberDescriptionArray)));
            ((DCSTraceBuffer)dCSTraceable).invoke();
        }
        if (!this._terminated) {
            dCSTraceable = new CCJob(vRIMemberDescriptionArray, cCVersion, this._viewChangeListener, this._membershipListener);
            this._applicationModuleThread.enqueueJob((Job)((Object)dCSTraceable));
        }
    }

    protected void newViewOK(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, Map map) {
        DCSTraceable dCSTraceable;
        this._currentViewId = viewIdImpl;
        VRIMemberDescription[] vRIMemberDescriptionArray2 = this._mgr.getViewMembers();
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceable = DCSTraceBuffer.event(this._traceContext, "newViewOK", "");
            ((DCSTraceBuffer)dCSTraceable).addProperty(this._currentViewId);
            ((DCSTraceBuffer)dCSTraceable).addProperty("viewMembers", Utils.toString(VRIMemberUtils.getMemberNames(vRIMemberDescriptionArray2)));
            ((DCSTraceBuffer)dCSTraceable).addProperty("Successful", "viewMembers", Utils.toString(VRIMemberUtils.getMemberNames(vRIMemberDescriptionArray)));
            ((DCSTraceBuffer)dCSTraceable).invoke();
        }
        if (!this._terminated) {
            dCSTraceable = new NewViewOKJob(vRIMemberDescriptionArray2, vRIMemberDescriptionArray, viewIdImpl, this._viewChangeListener, this._membershipListener, map);
            this._applicationModuleThread.enqueueJob((Job)((Object)dCSTraceable));
        }
    }

    protected void handleFailedMembers(String[] stringArray) {
    }

    final void newView(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, Map map) {
        DCSTraceable dCSTraceable;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceable = DCSTraceBuffer.event(this._traceContext, "newView", "");
            ((DCSTraceBuffer)dCSTraceable).addProperty(viewIdImpl);
            ((DCSTraceBuffer)dCSTraceable).addProperty("viewMembers", Utils.toString(VRIMemberUtils.getMemberNames(vRIMemberDescriptionArray)));
            ((DCSTraceBuffer)dCSTraceable).invoke();
        }
        if (!this._terminated) {
            dCSTraceable = new NewViewJob(vRIMemberDescriptionArray, viewIdImpl, map);
            this._applicationModuleThread.enqueueJob((Job)((Object)dCSTraceable));
        }
    }

    final void terminate(boolean bl, DCSTerminationEvent dCSTerminationEvent) {
        AdministrativeTerminationRequest administrativeTerminationRequest;
        Throwable throwable;
        DCSTraceable dCSTraceable;
        if (this._terminated) {
            return;
        }
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceable = DCSTraceBuffer.event(this._traceContext, "terminate", "");
            ((DCSTraceBuffer)dCSTraceable).addProperty("Graceful", String.valueOf(bl));
            ((DCSTraceBuffer)dCSTraceable).addProperty(dCSTerminationEvent);
            ((DCSTraceBuffer)dCSTraceable).invoke();
        }
        this._globals.terminate();
        dCSTraceable = new TerminateJob(bl, dCSTerminationEvent, this._viewChangeListener, this._membershipListener, this._notificationListener);
        if (dCSTerminationEvent != null && dCSTerminationEvent.isAdministrative() && (throwable = dCSTerminationEvent.getTerminationReason()) instanceof AdministrativeTerminationRequest && (administrativeTerminationRequest = (AdministrativeTerminationRequest)throwable).isDirectRequest()) {
            this._administrativeTerminationJob = dCSTraceable;
            return;
        }
        this._applicationModuleThread.enqueueJob((Job)((Object)dCSTraceable));
    }

    final void onMessage(VRIMessage vRIMessage) {
        if (this._terminated) {
            return;
        }
        if (vRIMessage.getOriginatorLayer() == 8) {
            this.handleApplicationMessage(vRIMessage);
        } else {
            DCSTraceable dCSTraceable;
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                dCSTraceable = DCSTraceBuffer.event(this._traceContext, "onMessage", "Got message for MBR");
                ((DCSTraceBuffer)dCSTraceable).invoke();
            }
            dCSTraceable = new IncomingMbrMessageJob(vRIMessage);
            this._applicationModuleThread.enqueueJob((Job)((Object)dCSTraceable));
        }
    }

    protected void handleApplicationMessage(VRIMessage vRIMessage) {
        switch (vRIMessage.getMessageType()) {
            case 102: {
                IncomingMessageJob incomingMessageJob = new IncomingMessageJob(this._appMessageListener, (DCSIncomingMessage)vRIMessage);
                this._applicationModuleThread.enqueueJob(incomingMessageJob);
                break;
            }
            case 101: {
                IncomingMessageJob incomingMessageJob = new IncomingMessageJob(this._haMessageListener, (DCSIncomingMessage)vRIMessage);
                this._applicationModuleThread.enqueueJob(incomingMessageJob);
                break;
            }
            case 1: {
                try {
                    SetStateJob setStateJob = new SetStateJob((DCSIncomingMessage)vRIMessage);
                    this._applicationModuleThread.enqueueJob(setStateJob);
                }
                catch (DCSException dCSException) {
                    SuspectUnreadableMessageEvent suspectUnreadableMessageEvent = SuspectUnreadableMessageEvent.badHeader(this._traceContext, vRIMessage.getSender());
                    suspectUnreadableMessageEvent.invokeNLSTrace();
                    this.suspectMember(suspectUnreadableMessageEvent, 2, "Failed to read state object");
                }
                break;
            }
            case 2: {
                try {
                    SetProtocolJob setProtocolJob = new SetProtocolJob((DCSIncomingMessage)vRIMessage);
                    this._applicationModuleThread.enqueueJob(setProtocolJob);
                }
                catch (DCSException dCSException) {
                    SuspectUnreadableMessageEvent suspectUnreadableMessageEvent = SuspectUnreadableMessageEvent.badHeader(this._traceContext, vRIMessage.getSender());
                    suspectUnreadableMessageEvent.invokeNLSTrace();
                    this.suspectMember(suspectUnreadableMessageEvent, 2, "Failed to read state object");
                }
                break;
            }
            default: {
                if (!DCSTraceBuffer.isInternalInfoEnabled(TC)) break;
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalInfo(this._traceContext, "Unknown message type - ignore");
                dCSTraceBuffer.addProperty("MessageType", String.valueOf(vRIMessage.getMessageType()));
                dCSTraceBuffer.invoke();
            }
        }
    }

    public final void onVRIDownEvent(VRIDownEvent vRIDownEvent) {
        vRIDownEvent.handle(LAYER_NAME, this._eventHandlers, this._appModule.getDownLayer());
    }

    public final void onVRIUpEvent(VRIUpEvent vRIUpEvent) {
        vRIUpEvent.handle(LAYER_NAME, this._eventHandlers, this._appModule.getUpperLayer());
    }

    final void sendMbrMessage(VRIMessage vRIMessage, QoS qoS, ViewIdImpl viewIdImpl, VRIMemberDescription[] vRIMemberDescriptionArray) {
        DCSTraceable dCSTraceable;
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            dCSTraceable = DCSTraceBuffer.event(this._traceContext, "sendMbrMessage", "");
            dCSTraceable.invoke();
        }
        if (!this._terminated) {
            dCSTraceable = new MBRMessageSender(this._appModule.getDownLayer(), vRIMessage, qoS, viewIdImpl, vRIMemberDescriptionArray);
            this._applicationModuleThread.enqueueJob((Job)((Object)dCSTraceable));
        }
    }

    public void dumpAll(FFDCDumper fFDCDumper) {
        int n = this._applicationModuleThread.getNumberOfQueuedJobs();
        fFDCDumper.writeLine("NumberOfQueuedJobs", String.valueOf(n));
    }

    public Object getMutex() {
        return this._mutex;
    }

    protected void terminate() {
        if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this._traceContext, "terminate", "");
            dCSTraceBuffer.invoke();
        }
        ThreadManager.releaseThread(this._applicationModuleThreadName);
        this._appMessageListener = null;
        this._haMessageListener = null;
        this._notificationListener = null;
        this._viewChangeListener = null;
        this._membershipListener = null;
        if (this._globals.statsModule != null) {
            this._globals.statsModule.destroy();
        }
        DCSStacksRegistry.unregisterStack(this._stackName);
    }

    public final void suspectMember(DCSSuspectEvent dCSSuspectEvent, int n, String string) {
        VRIDenialReason vRIDenialReason = new VRIDenialReason(8, n, string);
        this._appModule.denyMember(dCSSuspectEvent, vRIDenialReason);
    }

    private final class SetProtocolJob
    extends ApplicationLayerJob {
        private final int _pv;
        private final StateVersion _context;

        private SetProtocolJob(DCSIncomingMessage dCSIncomingMessage) throws DCSException {
            try {
                this._pv = dCSIncomingMessage.readInt();
                this._context = (StateVersion)dCSIncomingMessage.readObject();
            }
            catch (Throwable throwable) {
                throw new DCSException("Failed to read protocol object", throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() {
            Object object;
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(DCSStackImpl.this._traceContext, "SetProtocolJob.process", "");
                ((DCSTraceBuffer)object).addProperty("Version", String.valueOf(this._pv));
                ((DCSTraceBuffer)object).invoke();
            }
            object = DCSStackImpl.this._mutex;
            synchronized (object) {
                if (!DCSStackImpl.this._terminated) {
                    RequestChangeProtocolEvent requestChangeProtocolEvent = new RequestChangeProtocolEvent(DCSStackImpl.this._stackName, DCSStackImpl.this._thisMemberName, this._pv, this._context);
                    try {
                        requestChangeProtocolEvent.startHandling(DCSStackImpl.this._mutex, DCSStackImpl.this._appModule.getUpperLayer());
                    }
                    catch (Throwable throwable) {
                        TerminationEvent terminationEvent = new TerminationEvent(DCSStackImpl.this._traceContext, "SetStateJob.process", throwable);
                        DCSStackImpl.this.requestTermination(terminationEvent);
                    }
                }
            }
        }

        public String getTraceName() {
            return "SetProtocolJob";
        }

        public String toString() {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
            dCSTraceBuffer.addProperty("Version", String.valueOf(this._pv));
            return dCSTraceBuffer.toString();
        }

        public void handleError(Throwable throwable) {
            CallbackFailedEvent callbackFailedEvent = new CallbackFailedEvent(DCSStackImpl.this._traceContext, "SetProtocolJob.process", throwable);
            DCSStackImpl.this.requestTermination(callbackFailedEvent);
        }
    }

    private final class SetStateJob
    extends ApplicationLayerJob {
        private final StateBlob _state;

        private SetStateJob(DCSIncomingMessage dCSIncomingMessage) throws DCSException {
            try {
                this._state = (StateBlob)dCSIncomingMessage.readObject();
            }
            catch (Throwable throwable) {
                throw new DCSException("Failed to read state object", throwable);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() {
            Object object;
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(DCSStackImpl.this._traceContext, "SetStateJob.process", "");
                ((DCSTraceBuffer)object).addProperty("State", String.valueOf(this._state));
                ((DCSTraceBuffer)object).invoke();
            }
            object = DCSStackImpl.this._mutex;
            synchronized (object) {
                if (!DCSStackImpl.this._terminated) {
                    RequestStateChangeEvent requestStateChangeEvent = new RequestStateChangeEvent(DCSStackImpl.this._stackName, DCSStackImpl.this._thisMemberName, this._state);
                    try {
                        requestStateChangeEvent.startHandling(DCSStackImpl.this._mutex, DCSStackImpl.this._appModule.getUpperLayer());
                    }
                    catch (Throwable throwable) {
                        TerminationEvent terminationEvent = new TerminationEvent(DCSStackImpl.this._traceContext, "SetStateJob.process", throwable);
                        DCSStackImpl.this.requestTermination(terminationEvent);
                    }
                }
            }
        }

        public String getTraceName() {
            return "SetStateJob";
        }

        public String toString() {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
            dCSTraceBuffer.addProperty("State", String.valueOf(this._state));
            return dCSTraceBuffer.toString();
        }

        public void handleError(Throwable throwable) {
            CallbackFailedEvent callbackFailedEvent = new CallbackFailedEvent(DCSStackImpl.this._traceContext, "SetStateJob.process", throwable);
            DCSStackImpl.this.requestTermination(callbackFailedEvent);
        }
    }

    private final class NotifyEventHandler
    implements VRIEventHandler {
        private NotifyEventHandler() {
        }

        public int handle(VRIEvent vRIEvent) {
            DCSTraceable dCSTraceable;
            NotifyExternalEvent notifyExternalEvent = (NotifyExternalEvent)((Object)vRIEvent);
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                dCSTraceable = DCSTraceBuffer.event(DCSStackImpl.this._traceContext, "NotifyEventHandler.handle", "");
                ((DCSTraceBuffer)dCSTraceable).addProperty(vRIEvent);
                ((DCSTraceBuffer)dCSTraceable).invoke();
            }
            if (!DCSStackImpl.this._terminated) {
                dCSTraceable = notifyExternalEvent.getExternalEvent();
                DCSStackImpl.this._applicationModuleThread.enqueueJob(new NotifyEventJob(DCSStackImpl.this._notificationListener, (DCSExternalEvent)dCSTraceable));
            }
            return 3;
        }

        public String getTraceName() {
            return "NotifyEventHandler";
        }

        public String toString() {
            return "";
        }
    }

    private final class NewViewOKJob
    extends ViewChangeEventJob {
        private final ViewIdImpl _viewID;
        private final VRIMemberDescription[] _viewMembers;
        private final VRIMemberDescription[] _successfulViewMembers;
        private final ViewChangeListener _vcListener;
        private final MembershipListener _mbrListener;
        private final Map _newConfigMap;

        protected NewViewOKJob(VRIMemberDescription[] vRIMemberDescriptionArray, VRIMemberDescription[] vRIMemberDescriptionArray2, ViewIdImpl viewIdImpl, ViewChangeListener viewChangeListener, MembershipListener membershipListener, Map map) {
            super(4, VRIMemberUtils.getMemberNames(DCSStackImpl.this._mgr.getViewMembers()));
            this._viewMembers = vRIMemberDescriptionArray;
            this._successfulViewMembers = vRIMemberDescriptionArray2;
            this._viewID = viewIdImpl;
            this._vcListener = viewChangeListener;
            this._mbrListener = membershipListener;
            this._newConfigMap = map;
        }

        public void handleDone() {
            DCSTraceBuffer dCSTraceBuffer;
            if (DCSTraceBuffer.isEntryEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.entry(DCSStackImpl.this._traceContext, "NewViewOKJob.handleDone", "");
                dCSTraceBuffer.addProperty(this);
                dCSTraceBuffer.invoke();
            }
            if (this._mbrListener != null) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    dCSTraceBuffer = DCSTraceBuffer.event(DCSStackImpl.this._traceContext, "NewViewOKJob.handleDone", "Going to inform MembershipListener");
                    dCSTraceBuffer.addProperty(this);
                    dCSTraceBuffer.invoke();
                }
                this._mbrListener.newViewInstalled(this._viewID, this.getMembersNames());
            }
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.exit(DCSStackImpl.this._traceContext, "NewViewOKJob.handleDone", "");
                dCSTraceBuffer.invoke();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() {
            Object object;
            if (DCSStackImpl.this._terminated) {
                return;
            }
            if (DCSTraceBuffer.isEntryEnabled(TC)) {
                object = DCSTraceBuffer.entry(DCSStackImpl.this._traceContext, "NewViewOKJob.process", "");
                ((DCSTraceBuffer)object).addProperty(this);
                ((DCSTraceBuffer)object).invoke();
            }
            if (!this._viewID.isInternalView()) {
                if (this._vcListener != null) {
                    if (DCSTraceBuffer.isEventEnabled(TC)) {
                        object = DCSTraceBuffer.event(DCSStackImpl.this._traceContext, "NewViewOKJob.process", "Going to inform ViewChangeListener");
                        ((DCSTraceBuffer)object).addProperty(this);
                        ((DCSTraceBuffer)object).invoke();
                    }
                    this._vcListener.handleViewChangeEvent(this, this._viewID);
                } else {
                    this.handleDone();
                }
            } else if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(DCSStackImpl.this._traceContext, "NewViewOKJob.process", "Internal view - do not inform listeners");
                ((DCSTraceBuffer)object).addProperty(this);
                ((DCSTraceBuffer)object).invoke();
            }
            object = DCSStackImpl.this._mutex;
            synchronized (object) {
                DCSStackImpl.this._appModule.getUpperLayer().newViewOK(this._successfulViewMembers, this._viewID, this._newConfigMap);
            }
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                object = DCSTraceBuffer.exit(DCSStackImpl.this._traceContext, "NewViewOKJob.process", "");
                ((DCSTraceBuffer)object).invoke();
            }
        }

        public String toString() {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
            dCSTraceBuffer.addProperty(this._viewID).addProperty("viewMembers", Utils.toString(this._viewMembers)).addProperty("Successful", "viewMembers", Utils.toString(this._successfulViewMembers));
            return dCSTraceBuffer.toString();
        }

        public String getTraceName() {
            return "NEW_VIEW_OK_EVENT";
        }

        public void handleError(Throwable throwable) {
            CallbackFailedEvent callbackFailedEvent = new CallbackFailedEvent(DCSStackImpl.this._traceContext, "NewViewOKJob.process", throwable);
            DCSStackImpl.this.requestTermination(callbackFailedEvent);
        }
    }

    private final class NewViewJob
    extends ViewChangeEventJob {
        private final ViewIdImpl _viewID;
        private final VRIMemberDescription[] _viewMembers;
        private final Map _newConfigMap;

        protected NewViewJob(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, Map map) {
            super(3, VRIMemberUtils.getMemberNames(vRIMemberDescriptionArray));
            this._viewMembers = vRIMemberDescriptionArray;
            this._newConfigMap = map;
            this._viewID = viewIdImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleDone() {
            Object object;
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(DCSStackImpl.this._traceContext, "NewViewJob.handleDone", "");
                ((DCSTraceBuffer)object).addProperty(this);
                ((DCSTraceBuffer)object).invoke();
            }
            object = DCSStackImpl.this._mutex;
            synchronized (object) {
                if (!DCSStackImpl.this._terminated) {
                    DCSStackImpl.this._appModule.clearLayerSuspectList();
                    DCSStackImpl.this._appModule.getDownLayer().newView(this._viewMembers, this._viewID, this._newConfigMap);
                }
            }
        }

        public void process() {
            this.handleDone();
        }

        public String toString() {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
            dCSTraceBuffer.addProperty(this._viewID).addProperty("viewMembers", Utils.toString(this.getMembersNames()));
            return dCSTraceBuffer.toString();
        }

        public String getTraceName() {
            return "NEW_VIEW_event";
        }

        public void handleError(Throwable throwable) {
            TerminationEvent terminationEvent = new TerminationEvent(DCSStackImpl.this._traceContext, "NewViewJob.process", throwable);
            DCSStackImpl.this.requestTermination(terminationEvent);
        }
    }

    private final class CCOKJob
    extends ViewChangeEventJob {
        private final CCVersion _ccVersion;

        protected CCOKJob(CCVersion cCVersion) {
            super(2, null);
            this._ccVersion = cCVersion;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleDone() {
            if (!DCSStackImpl.this._terminated) {
                Object object;
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    object = DCSTraceBuffer.event(DCSStackImpl.this._traceContext, "CCOKJob.handleDone", "");
                    ((DCSTraceBuffer)object).addProperty(this);
                    ((DCSTraceBuffer)object).invoke();
                }
                object = DCSStackImpl.this._mutex;
                synchronized (object) {
                    if (!DCSStackImpl.this._terminated) {
                        DCSStackImpl.this._appModule.getUpperLayer().currentOK(this._ccVersion);
                    }
                }
            }
        }

        public void process() {
            this.handleDone();
        }

        public String toString() {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
            dCSTraceBuffer.addProperty(this._ccVersion);
            return dCSTraceBuffer.toString();
        }

        public String getTraceName() {
            return "CC_OK_event";
        }

        public void handleError(Throwable throwable) {
            TerminationEvent terminationEvent = new TerminationEvent(DCSStackImpl.this._traceContext, "CCOKJob.process", throwable);
            DCSStackImpl.this.requestTermination(terminationEvent);
        }
    }

    private final class CCJob
    extends ViewChangeEventJob {
        private final CCVersion _ccVersion;
        private final VRIMemberDescription[] _failedMembers;
        private final ViewChangeListener _vcListener;
        private final MembershipListener _mbrListener;

        CCJob(VRIMemberDescription[] vRIMemberDescriptionArray, CCVersion cCVersion, ViewChangeListener viewChangeListener, MembershipListener membershipListener) {
            super(1, VRIMemberUtils.getMemberNames(vRIMemberDescriptionArray));
            this._failedMembers = vRIMemberDescriptionArray;
            this._ccVersion = cCVersion;
            this._vcListener = viewChangeListener;
            this._mbrListener = membershipListener;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleDone() {
            Object object;
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(DCSStackImpl.this._traceContext, "CCJob.handleDone", "");
                ((DCSTraceBuffer)object).addProperty(this);
                ((DCSTraceBuffer)object).invoke();
            }
            object = DCSStackImpl.this._mutex;
            synchronized (object) {
                if (!DCSStackImpl.this._terminated) {
                    if (DCSStackImpl.this._currentViewId != null) {
                        DCSStackImpl.this._previousViewId = DCSStackImpl.this._currentViewId;
                        DCSStackImpl.this._currentViewId = null;
                        DCSStackImpl.this._appModule.invalidateViewID();
                    }
                    DCSStackImpl.this._appModule.getDownLayer().completeCurrent(this._failedMembers, this._ccVersion);
                }
            }
        }

        public void process() {
            DCSTraceBuffer dCSTraceBuffer;
            if (DCSStackImpl.this._terminated) {
                return;
            }
            if (DCSTraceBuffer.isEntryEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.entry(DCSStackImpl.this._traceContext, "CCJob.process", "");
                dCSTraceBuffer.addProperty(this);
                dCSTraceBuffer.invoke();
            }
            if (this._mbrListener != null) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    dCSTraceBuffer = DCSTraceBuffer.event(DCSStackImpl.this._traceContext, "CCJob.process", "Going to inform MembershipListener");
                    dCSTraceBuffer.addProperty(this);
                    dCSTraceBuffer.invoke();
                }
                this._mbrListener.suspectMembers(this.getMembersNames());
            }
            if (this._vcListener != null) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    dCSTraceBuffer = DCSTraceBuffer.event(DCSStackImpl.this._traceContext, "CCJob.process", "Going to inform ViewChangeListener");
                    dCSTraceBuffer.addProperty(this);
                    dCSTraceBuffer.invoke();
                }
                this._vcListener.handleViewChangeEvent(this, this._ccVersion);
            } else {
                this.handleDone();
            }
            DCSStackImpl.this.handleFailedMembers(this.getMembersNames());
            if (DCSTraceBuffer.isExitEnabled(TC)) {
                dCSTraceBuffer = DCSTraceBuffer.exit(DCSStackImpl.this._traceContext, "CCJob.process", "");
                dCSTraceBuffer.invoke();
            }
        }

        public String toString() {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
            dCSTraceBuffer.addProperty(this._ccVersion).addProperty("failedMembers", Utils.toString(this.getMembersNames()));
            return dCSTraceBuffer.toString();
        }

        public String getTraceName() {
            return "CC_event";
        }

        public void handleError(Throwable throwable) {
            CallbackFailedEvent callbackFailedEvent = new CallbackFailedEvent(DCSStackImpl.this._traceContext, "CCJob.process", throwable);
            DCSStackImpl.this.requestTermination(callbackFailedEvent);
        }
    }

    private final class TerminateJob
    extends ViewChangeEventJob {
        private final boolean _grace;
        private final ViewChangeListener _vcListener;
        private final MembershipListener _mbrListener;
        private final DCSNotificationsListener _notificationListener1;
        private final DCSTerminationEvent _terminationReason;

        protected TerminateJob(boolean bl, DCSTerminationEvent dCSTerminationEvent, ViewChangeListener viewChangeListener, MembershipListener membershipListener, DCSNotificationsListener dCSNotificationsListener) {
            super(5, null);
            this._grace = bl;
            this._terminationReason = dCSTerminationEvent != null ? dCSTerminationEvent : new TerminationEvent(DCSStackImpl.this._traceContext, "Unknown", new DCSException("Termination - reason unknown"));
            this._vcListener = viewChangeListener;
            this._mbrListener = membershipListener;
            this._notificationListener1 = dCSNotificationsListener;
        }

        public void handleDone() {
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(DCSStackImpl.this._traceContext, "TerminateJob.handleDone", "");
                dCSTraceBuffer.addProperty(this);
                dCSTraceBuffer.invoke();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() {
            Object object;
            block13: {
                this._terminationReason.invokeNLSTrace();
                if (this._notificationListener1 != null) {
                    if (DCSTraceBuffer.isEventEnabled(TC)) {
                        object = DCSTraceBuffer.event(DCSStackImpl.this._traceContext, "TerminateJob.process", "Going to notify listener.");
                        ((DCSTraceBuffer)object).invoke();
                    }
                    try {
                        this._notificationListener1.notifyEvent(this._terminationReason);
                    }
                    catch (Throwable throwable) {
                        if (!DCSTraceBuffer.isInternalWarningEnabled(TC)) break block13;
                        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(DCSStackImpl.this._traceContext, " Failed to process TerminateJob", throwable);
                        dCSTraceBuffer.addProperty(this);
                        dCSTraceBuffer.invoke();
                    }
                }
            }
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(DCSStackImpl.this._traceContext, "TerminateJob.process", "Going to terminate");
                ((DCSTraceBuffer)object).addProperty(this);
                ((DCSTraceBuffer)object).invoke();
            }
            object = DCSStackImpl.this._mutex;
            synchronized (object) {
                if (!DCSStackImpl.this._terminated) {
                    DCSStackImpl.this._terminated = true;
                    DCSStackImpl.this._appModule.doTerminate(this._grace, this._terminationReason);
                    DCSStackImpl.this.terminate();
                }
            }
            if (this._mbrListener != null) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    object = DCSTraceBuffer.event(DCSStackImpl.this._traceContext, "TerminateJob.process", "Going to inform MembershipListener.");
                    ((DCSTraceBuffer)object).invoke();
                }
                this._mbrListener.terminationRequest();
            }
            if (this._vcListener != null) {
                if (DCSTraceBuffer.isEventEnabled(TC)) {
                    object = DCSTraceBuffer.event(DCSStackImpl.this._traceContext, "TerminateJob.process", "Going to inform ViewChangeListener.");
                    ((DCSTraceBuffer)object).invoke();
                }
                this._vcListener.handleViewChangeEvent(this, null);
            }
        }

        public String toString() {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
            dCSTraceBuffer.addProperty(this._terminationReason);
            dCSTraceBuffer.addProperty("Graceful", this._grace);
            return dCSTraceBuffer.toString();
        }

        public String getTraceName() {
            return "Terminate_event";
        }

        public void handleError(Throwable throwable) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(DCSStackImpl.this._traceContext, " Failed to process TerminateJob", throwable);
                dCSTraceBuffer.addProperty(this);
                dCSTraceBuffer.invoke();
            }
        }
    }

    protected abstract class ViewChangeEventJob
    extends ViewChangeEvent
    implements Job {
        protected ViewChangeEventJob(int n, String[] stringArray) {
            super(n, stringArray);
        }

        public void cancel() {
            if (!DCSStackImpl.this._terminated) {
                if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(DCSStackImpl.this._traceContext, "ViewChangeEventJob was canceled", null);
                    dCSTraceBuffer.addProperty(this);
                    dCSTraceBuffer.invoke();
                }
            } else if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(DCSStackImpl.this._traceContext, "ViewChangeEventJob.cancel", "");
                dCSTraceBuffer.addProperty(this);
                dCSTraceBuffer.invoke();
            }
        }

        public String getOwner() {
            return DCSStackImpl.this._applicationModuleThreadName;
        }
    }

    private final class IncomingMbrMessageJob
    extends ApplicationLayerJob {
        private final VRIMessage _msg;

        IncomingMbrMessageJob(VRIMessage vRIMessage) {
            this._msg = vRIMessage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() {
            Object object;
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(DCSStackImpl.this._traceContext, "IncomingMbrMessageJob.process", "Deliver message to MBR");
                ((DCSTraceBuffer)object).invoke();
            }
            object = DCSStackImpl.this._mutex;
            synchronized (object) {
                if (!DCSStackImpl.this._terminated) {
                    DCSStackImpl.this._appModule.getUpperLayer().deliver(this._msg);
                }
            }
        }

        public String getTraceName() {
            return "IncomingMbrMessageJob";
        }

        public String toString() {
            return String.valueOf(this._msg);
        }

        public void handleError(Throwable throwable) {
            TerminationEvent terminationEvent = new TerminationEvent(DCSStackImpl.this._traceContext, "IncomingMbrMessageJob.process", throwable);
            DCSStackImpl.this.requestTermination(terminationEvent);
        }
    }

    private final class NotifyEventJob
    extends ApplicationLayerJob {
        private final DCSNotificationsListener _listener;
        private final DCSExternalEvent _event;

        NotifyEventJob(DCSNotificationsListener dCSNotificationsListener, DCSExternalEvent dCSExternalEvent) {
            this._listener = dCSNotificationsListener;
            this._event = dCSExternalEvent;
            if (DCSStackImpl.this._statsModule != null && this._event instanceof DCSSuspectEvent) {
                DCSStackImpl.this._statsModule.onSuspect();
            }
        }

        public void process() {
            if (!DCSStackImpl.this._terminated) {
                if (this._listener != null) {
                    if (DCSTraceBuffer.isEventEnabled(TC)) {
                        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(DCSStackImpl.this._traceContext, "NotifyEventJob.process()", "Going to notify about event");
                        dCSTraceBuffer.addProperty(this._event);
                        dCSTraceBuffer.invoke();
                    }
                    this._listener.notifyEvent(this._event);
                } else if (DCSTraceBuffer.isInternalInfoEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalInfo(DCSStackImpl.this._traceContext, "There was no listener to notify about event");
                    dCSTraceBuffer.addProperty(this._event);
                    dCSTraceBuffer.invoke();
                }
            }
        }

        public String getTraceName() {
            return "NotifyEventJob";
        }

        public String toString() {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
            dCSTraceBuffer.addProperty(this._event);
            return dCSTraceBuffer.toString();
        }

        public void handleError(Throwable throwable) {
            CallbackFailedEvent callbackFailedEvent = new CallbackFailedEvent(DCSStackImpl.this._traceContext, "NotifyEventJob.process", throwable);
            DCSStackImpl.this.requestTermination(callbackFailedEvent);
        }
    }

    private final class IncomingMessageJob
    extends ApplicationLayerJob {
        private final DCSMessageListener _listener;
        private final DCSIncomingMessage _message;

        IncomingMessageJob(DCSMessageListener dCSMessageListener, DCSIncomingMessage dCSIncomingMessage) {
            this._listener = dCSMessageListener;
            this._message = dCSIncomingMessage;
        }

        public void process() {
            if (!DCSStackImpl.this._terminated) {
                Object object;
                if (this._message.hasHeader((byte)8)) {
                    object = new SubgroupMcastHeader();
                    if (this._message.extractHeader((Header)object) != null) {
                        if (!((SubgroupMcastHeader)object).isInTargets(DCSStackImpl.this._thisMemberName)) {
                            return;
                        }
                    } else {
                        SuspectUnreadableMessageEvent suspectUnreadableMessageEvent = SuspectUnreadableMessageEvent.badHeader(DCSStackImpl.this._traceContext, this._message.getSender());
                        suspectUnreadableMessageEvent.invokeNLSTrace();
                        DCSStackImpl.this.suspectMember(suspectUnreadableMessageEvent, 2, "Received message with corrupted header");
                        return;
                    }
                }
                if (this._listener != null) {
                    this._listener.onMessage(this._message);
                } else if (DCSTraceBuffer.isInternalInfoEnabled(TC)) {
                    object = DCSTraceBuffer.internalInfo(DCSStackImpl.this._traceContext, "Message arrived but there was no listener");
                    ((DCSTraceBuffer)object).invoke();
                }
            }
        }

        public String getTraceName() {
            return "IncomingMessageJob";
        }

        public String toString() {
            return String.valueOf(this._message);
        }

        public void handleError(Throwable throwable) {
            CallbackFailedEvent callbackFailedEvent = new CallbackFailedEvent(DCSStackImpl.this._traceContext, "IncomingMessageJob.process", throwable);
            DCSStackImpl.this.requestTermination(callbackFailedEvent);
        }
    }

    private final class MBRMessageSender
    extends ApplicationLayerJob {
        private final Downcalls _down;
        private final VRIMessage _msg;
        private final QoS _qos;
        private final ViewIdImpl _viewID;
        private final VRIMemberDescription[] _targets;

        MBRMessageSender(Downcalls downcalls, VRIMessage vRIMessage, QoS qoS, ViewIdImpl viewIdImpl, VRIMemberDescription[] vRIMemberDescriptionArray) {
            this._down = downcalls;
            this._msg = vRIMessage;
            this._qos = qoS;
            this._viewID = viewIdImpl;
            this._targets = vRIMemberDescriptionArray;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process() {
            Object object = DCSStackImpl.this._mutex;
            synchronized (object) {
                if (DCSStackImpl.this._terminated) {
                    return;
                }
                try {
                    DCSTraceable dCSTraceable;
                    if (DCSTraceBuffer.isEventEnabled(TC)) {
                        dCSTraceable = DCSTraceBuffer.event(DCSStackImpl.this._traceContext, "MBRMessageSender.process", "");
                        ((DCSTraceBuffer)dCSTraceable).addProperty(this);
                        ((DCSTraceBuffer)dCSTraceable).invoke();
                    }
                    if (this._qos instanceof QoS.QOSUnicast) {
                        dCSTraceable = (QoS.QOSUnicast)this._qos;
                        this._down.sendMessage(this._msg, this._targets[0], (QoS.QOSUnicast)dCSTraceable, this._viewID);
                    } else {
                        dCSTraceable = (QoS.QOSMulticast)this._qos;
                        if (this._targets == null) {
                            this._down.mcastMessage(this._msg, (QoS.QOSMulticast)dCSTraceable, this._viewID);
                        } else {
                            this._down.mcastMessage(this._msg, this._targets, (QoS.QOSMulticast)dCSTraceable, this._viewID);
                        }
                    }
                }
                catch (DCSException dCSException) {
                    DCSTraceable dCSTraceable;
                    if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                        dCSTraceable = DCSTraceBuffer.internalWarning(DCSStackImpl.this._traceContext, "Failed to send MBR message", dCSException);
                        dCSTraceable.invoke();
                    }
                    dCSTraceable = new TerminationEvent(DCSStackImpl.this._traceContext, "MBRMessageSender.process", dCSException);
                    DCSStackImpl.this.requestTermination((DCSTerminationEvent)dCSTraceable);
                }
            }
        }

        public String getTraceName() {
            return "MBRMessageSender";
        }

        public String toString() {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
            dCSTraceBuffer.addProperty(this._qos).addProperty(this._viewID).addProperty("Message", this._msg);
            return dCSTraceBuffer.toString();
        }

        public void handleError(Throwable throwable) {
            TerminationEvent terminationEvent = new TerminationEvent(DCSStackImpl.this._traceContext, "MBRMessageSender.process", throwable);
            DCSStackImpl.this.requestTermination(terminationEvent);
        }
    }

    protected abstract class ApplicationLayerJob
    implements Job,
    DCSTraceable {
        protected ApplicationLayerJob() {
        }

        public void cancel() {
            if (!DCSStackImpl.this._terminated) {
                if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                    DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(DCSStackImpl.this._traceContext, "ApplicationLayerJob was canceled", null);
                    dCSTraceBuffer.addProperty(this);
                    dCSTraceBuffer.invoke();
                }
            } else if (DCSTraceBuffer.isEventEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(DCSStackImpl.this._traceContext, "cancel", "");
                dCSTraceBuffer.addProperty(this);
                dCSTraceBuffer.invoke();
            }
        }

        public String getOwner() {
            return DCSStackImpl.this._applicationModuleThreadName;
        }
    }
}

