/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common.nls;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.event.DCSNLSEvent;
import com.ibm.ws.dcs.vri.common.nls.DCSNLSRegistry;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import java.util.Arrays;

public abstract class AbstractNLSEvent
implements DCSNLSEvent {
    private static final TraceComponent TC = Tr.register(AbstractNLSEvent.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private final String _layerName;
    private final String _stackName;
    private final String _memberName;
    private final DCSNLSRegistry.NLSEntry _NLSEntry;
    private final Object _NLSEntryRetrieveKey;
    private final TraceComponent _tc;

    private AbstractNLSEvent() {
        this(new DCSTraceContextImpl(TC, null, null, null));
    }

    protected AbstractNLSEvent(TraceComponent traceComponent, String string, String string2, String string3, Object object) {
        this(new DCSTraceContextImpl(traceComponent, string2, string3, string), object);
    }

    public AbstractNLSEvent(TraceComponent traceComponent, String string, String string2, String string3) {
        this(traceComponent, string, string2, string3, null);
    }

    public AbstractNLSEvent(DCSTraceContext dCSTraceContext) {
        this(dCSTraceContext, null);
    }

    protected AbstractNLSEvent(DCSTraceContext dCSTraceContext, Object clazz) {
        this._tc = dCSTraceContext.getTraceComponent();
        this._layerName = dCSTraceContext.getLayerName();
        this._stackName = dCSTraceContext.getStackName();
        this._memberName = dCSTraceContext.getMemberName();
        this._NLSEntryRetrieveKey = clazz == null ? this.getClass() : clazz;
        this._NLSEntry = DCSNLSRegistry.getNLSEntry(this._NLSEntryRetrieveKey);
    }

    protected DCSTraceBuffer toTraceBuffer() {
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList(this.getClass().getName());
        dCSTraceBuffer.addProperty("NLSKey", this._NLSEntry.NLSkey).addProperty("Layer", this._layerName).addProperty("StackName", this._stackName).addProperty("memberName", this._memberName).addProperty("Severity", this.getSeverityName());
        this.setCustomTraceProperties(dCSTraceBuffer);
        return dCSTraceBuffer;
    }

    public String toString() {
        return this.toTraceBuffer().toString();
    }

    public final void invokeNLSTrace() {
        Object[] objectArray = this.getCustomNLSObjects();
        Object[] objectArray2 = this.getNLSObjects(objectArray);
        if (objectArray2.length != this._NLSEntry.params.length || "DCSV0000".equals(this._NLSEntry.NLSkey)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
            dCSTraceBuffer.addProperty("ClassName", this.getClass().getName()).addProperty("Bad", "NLSKey", this.getNLSKey());
            if (objectArray != null) {
                dCSTraceBuffer.addProperty("Bad", "Objects", Arrays.asList(objectArray));
            }
            this.setCustomTraceProperties(dCSTraceBuffer);
            Tr.warning(this._tc, "DCSV0000", new Object[]{this.getStackName(), this.getMemberName(), dCSTraceBuffer.toString()});
            return;
        }
        switch (this._NLSEntry.severity) {
            case 2: {
                Tr.info(this._tc, this._NLSEntry.NLSkey, objectArray2);
                return;
            }
            case 3: {
                Tr.warning(this._tc, this._NLSEntry.NLSkey, objectArray2);
                return;
            }
            case 4: {
                Tr.error(this._tc, this._NLSEntry.NLSkey, objectArray2);
                return;
            }
            case 5: {
                Tr.fatal(this._tc, this._NLSEntry.NLSkey, objectArray2);
                return;
            }
            case 1: {
                return;
            }
        }
    }

    private final Object[] getNLSObjects(Object[] objectArray) {
        int n = objectArray == null ? 0 : objectArray.length;
        Object[] objectArray2 = new Object[2 + n];
        objectArray2[0] = this.getStackName();
        objectArray2[1] = this.getMemberName();
        if (n != 0) {
            System.arraycopy(objectArray, 0, objectArray2, 2, n);
        }
        return objectArray2;
    }

    public final String getStackName() {
        return this._stackName;
    }

    public final String getMemberName() {
        return this._memberName;
    }

    public final String getLayerName() {
        return this._layerName;
    }

    public final int getSeverity() {
        return this._NLSEntry.severity;
    }

    public final String getSeverityName() {
        return this._NLSEntry.getSeverityName();
    }

    public String getNLSKey() {
        return this._NLSEntry.NLSkey;
    }

    public final int getRecommendedAction() {
        return this._NLSEntry.recommendedAction;
    }

    public final String getRecommendedActionDescription() {
        return this._NLSEntry.getActionDescritpion();
    }

    public String getTraceName() {
        return "ExternalEvent";
    }

    protected abstract void setCustomTraceProperties(DCSTraceBuffer var1);

    protected abstract Object[] getCustomNLSObjects();
}

