/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common.nls;

import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.nls.AbstractNLSEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;

public final class FailedMergeAttempt
extends AbstractNLSEvent {
    public static final String GENERAL_FAILURE = "General";
    public static final String TIMEDOUT = "TIMEOUT";
    public static final String IMPROPER_STATE = "BADSTATE";
    public final String[] rejectedPartners;
    public final String reason;
    public final int seconds;
    private final String version;

    public FailedMergeAttempt(DCSTraceContext dCSTraceContext, String[] stringArray) {
        super(dCSTraceContext, IMPROPER_STATE);
        this.rejectedPartners = stringArray;
        this.reason = null;
        this.seconds = -1;
        this.version = IMPROPER_STATE;
    }

    public FailedMergeAttempt(DCSTraceContext dCSTraceContext, String[] stringArray, int n) {
        super(dCSTraceContext, TIMEDOUT);
        this.rejectedPartners = stringArray;
        this.reason = null;
        this.seconds = n / 1000;
        this.version = TIMEDOUT;
    }

    public FailedMergeAttempt(DCSTraceContext dCSTraceContext, String[] stringArray, String string) {
        super(dCSTraceContext, GENERAL_FAILURE);
        this.rejectedPartners = stringArray;
        this.reason = string;
        this.seconds = -1;
        this.version = GENERAL_FAILURE;
    }

    protected Object[] getCustomNLSObjects() {
        if (this.version.equals(GENERAL_FAILURE)) {
            return new Object[]{Utils.toString(this.rejectedPartners), this.reason};
        }
        if (this.version.equals(TIMEDOUT)) {
            return new Object[]{new Integer(this.seconds), Utils.toString(this.rejectedPartners)};
        }
        return new Object[]{Utils.toString(this.rejectedPartners)};
    }

    protected void setCustomTraceProperties(DCSTraceBuffer dCSTraceBuffer) {
    }
}

