/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common.nls;

import com.ibm.ws.dcs.common.event.DCSFreezeEvent;
import com.ibm.ws.dcs.vri.common.nls.AbstractNLSEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import java.text.SimpleDateFormat;
import java.util.Date;

public class FreezeEvent
extends AbstractNLSEvent
implements DCSFreezeEvent {
    private static final SimpleDateFormat TIME_FORMATTER = new SimpleDateFormat("HH:mm:ss:SSS z");
    private final Date _lastCheckTime;
    private final Long _duration;

    public FreezeEvent(DCSTraceContext dCSTraceContext, long l, long l2) {
        super(dCSTraceContext);
        this._lastCheckTime = new Date(l);
        this._duration = new Long(l2 / 1000L);
    }

    protected final void setCustomTraceProperties(DCSTraceBuffer dCSTraceBuffer) {
        dCSTraceBuffer.addProperty("LastCheckTime", this._lastCheckTime).addProperty("FreezeDuration", this._duration);
    }

    protected final Object[] getCustomNLSObjects() {
        return new Object[]{TIME_FORMATTER.format(this.getLastCheckTime()), this.getFreezeDuration()};
    }

    public final Date getLastCheckTime() {
        return this._lastCheckTime;
    }

    public final Long getFreezeDuration() {
        return this._duration;
    }
}

