/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common.nls;

import com.ibm.ws.dcs.common.event.DCSInconsistentDefinedSetEvent;
import com.ibm.ws.dcs.common.event.DCSSuspectEvent;
import com.ibm.ws.dcs.vri.common.MemberInfo;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.nls.AbstractNLSEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;

public class InconsistentDefinedSetEvent
extends AbstractNLSEvent
implements DCSInconsistentDefinedSetEvent,
DCSSuspectEvent {
    private final String sender;
    private final VRIMemberDescription[] mySet;
    private final MemberInfo[] sentSet;
    private String[] onlyMySet;
    private String[] onlySentSet;
    private final String[] sentViewMembers;

    public InconsistentDefinedSetEvent(DCSTraceContext dCSTraceContext, VRIMemberDescription[] vRIMemberDescriptionArray, String string, MemberInfo[] memberInfoArray, String[] stringArray) {
        super(dCSTraceContext);
        this.sender = string;
        this.mySet = vRIMemberDescriptionArray;
        this.sentSet = memberInfoArray;
        this.sentViewMembers = stringArray;
        this.computeDiffSets(this.getMyset(), this.getSentSet());
    }

    protected void setCustomTraceProperties(DCSTraceBuffer dCSTraceBuffer) {
        dCSTraceBuffer.addProperty("Sender", "memberName", this.sender).addProperty("OnlyMy", "DefinedSet", Utils.toString(this.getOnlyMySet())).addProperty("OnlySender", "DefinedSet", Utils.toString(this.getOnlySentSet())).addProperty("Sender", "viewMembers", Utils.toString(this.getSentViewMembers()));
    }

    protected Object[] getCustomNLSObjects() {
        return new Object[]{this.getSender(), Utils.toString(this.getOnlyMySet()), Utils.toString(this.getOnlySentSet())};
    }

    public String[] getMyset() {
        String[] stringArray = VRIMemberUtils.getMemberNames(this.mySet);
        return stringArray == null ? new String[]{} : stringArray;
    }

    public String[] getSentSet() {
        String[] stringArray = MemberInfo.getNames(this.sentSet);
        return stringArray == null ? new String[]{} : stringArray;
    }

    public MemberInfo[] getSentSetInfo() {
        return this.sentSet;
    }

    private void computeDiffSets(String[] stringArray, String[] stringArray2) {
        if (stringArray.length == 0 || stringArray2.length == 0) {
            this.onlyMySet = stringArray;
            this.onlySentSet = stringArray2;
            return;
        }
        Utils.DiffSet diffSet = new Utils.DiffSet(stringArray, stringArray2);
        this.onlyMySet = diffSet.oldMinusNew;
        this.onlySentSet = diffSet.newMinusOld;
    }

    public String getSender() {
        return this.sender;
    }

    public String[] getOnlyMySet() {
        return this.onlyMySet;
    }

    public String[] getOnlySentSet() {
        return this.onlySentSet;
    }

    public String[] getSentViewMembers() {
        return this.sentViewMembers;
    }

    public String[] getSuspectedMembers() {
        return this.getSentViewMembers();
    }
}

