/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.config.DCSConfigMap;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class DCSConfigPrinter
implements DCSTraceContext {
    private static final String EOL = "\n";
    private final TraceComponent TC;
    private final DCSConfigMap dcm;

    public DCSConfigPrinter(DCSConfigMap dCSConfigMap) {
        this.dcm = dCSConfigMap;
        this.TC = Tr.register(dCSConfigMap.getClass(), "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    }

    private static final String printArrayValueMap(Map map) {
        HashMap hashMap = new HashMap();
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            Object k = iterator.next();
            Object[] objectArray = (Object[])map.get(k);
            hashMap.put(k, Utils.toString(objectArray));
        }
        return ((Object)hashMap).toString();
    }

    public final void print() {
        String string = "Printing defined parameters: \n";
        string = string + "Default params: " + this.dcm.get_defaultParams() + EOL;
        string = string + "Mandatory params: " + this.dcm.get_mandatoryParams() + EOL;
        string = string + "Enum params: " + DCSConfigPrinter.printArrayValueMap(this.dcm.get_enumParams()) + EOL;
        string = string + "MinMax params: " + DCSConfigPrinter.printArrayValueMap(this.dcm.get_minMaxParams()) + EOL;
        if (DCSTraceBuffer.isEventEnabled(this.TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "DCSConfigMap.print()", "Configuration Setting");
            dCSTraceBuffer.addProperty("Configuration", string);
            dCSTraceBuffer.invoke();
        }
    }

    public TraceComponent getTraceComponent() {
        return this.TC;
    }

    public String getStackName() {
        return this.dcm.getStackName();
    }

    public String getMemberName() {
        return this.dcm.getMemberName();
    }

    public String getLayerName() {
        return this.dcm.getLayerName();
    }
}

