/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.exception.DCSRuntimeException;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.FFDCDCSDumpRecord;
import com.ibm.ws.dcs.vri.common.util.FFDCDumpable;
import com.ibm.ws.dcs.vri.common.util.FFDCDumper;
import com.ibm.ws.ffdc.DiagnosticModule;
import com.ibm.ws.ffdc.FFDC;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.IncidentStream;

public class DCSDiagnosticModule
extends DiagnosticModule
implements DCSTraceContext {
    private static final TraceComponent TC = Tr.register(DCSDiagnosticModule.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private final boolean _registered;

    public DCSDiagnosticModule() {
        Throwable throwable = null;
        try {
            int n = FFDC.registerDiagnosticModule(this, "com.ibm.ws.dcs");
            if (n != 0) {
                throwable = new DCSRuntimeException("FFDC.registerDiagnosticModule returned " + n);
            }
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
        }
        if (throwable != null) {
            if (DCSTraceBuffer.isInternalWarningEnabled(TC)) {
                DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.internalWarning(this, "failed to register DCS diagnostic module", throwable);
                dCSTraceBuffer.invoke();
            }
            this._registered = false;
        } else {
            this._registered = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ffdcDumpDefaultDCS(Throwable throwable, IncidentStream incidentStream, Object object, Object[] objectArray, String string) {
        block10: {
            if (objectArray != null && objectArray.length > 0 && objectArray[0] instanceof FFDCDCSDumpRecord) {
                FFDCDCSDumpRecord fFDCDCSDumpRecord = (FFDCDCSDumpRecord)objectArray[0];
                FFDCDumper fFDCDumper = new FFDCDumper(fFDCDCSDumpRecord.getReason(), incidentStream);
                fFDCDumper.writeLine("Reason", String.valueOf(fFDCDCSDumpRecord.getReason()));
                FFDCDumpable fFDCDumpable = fFDCDCSDumpRecord.getDumpable();
                if (fFDCDumpable != null) {
                    try {
                        Object object2 = fFDCDumpable.getMutex();
                        if (object2 != null) {
                            Object object3 = object2;
                            synchronized (object3) {
                                fFDCDumpable.dumpAll(fFDCDumper);
                                break block10;
                            }
                        }
                        fFDCDumpable.dumpAll(fFDCDumper);
                    }
                    catch (Throwable throwable2) {
                        fFDCDumper.writeLine("Exception was thrown from dumpAll", String.valueOf(throwable2));
                    }
                } else {
                    fFDCDumper.writeLine("FFDCDumpable is null");
                }
            } else {
                incidentStream.writeLine("sourceId ", string);
                incidentStream.writeLine("Unexpected exception", throwable);
            }
        }
    }

    public void causeDump(FFDCDumpable fFDCDumpable, Throwable throwable) {
        if (this._registered) {
            Object object;
            if (DCSTraceBuffer.isEventEnabled(TC)) {
                object = DCSTraceBuffer.event(this, "causeDump", "Going to produce FFDC dump");
                ((DCSTraceBuffer)object).addProperty("Dumpable", fFDCDumpable);
                ((DCSTraceBuffer)object).addProperty("Reason", throwable);
                ((DCSTraceBuffer)object).invoke();
            }
            object = new Object[]{new FFDCDCSDumpRecord(fFDCDumpable, throwable)};
            FFDCFilter.processException(throwable, "com.ibm.ws.dcs.vri.common.util.DCSDiagnosticModule.causeDump", "100", this, (Object[])object);
        } else if (DCSTraceBuffer.isEventEnabled(TC)) {
            DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.event(this, "causeDump", "Diagnostic module is not registered - do nothing");
            dCSTraceBuffer.addProperty("Dumpable", fFDCDumpable);
            dCSTraceBuffer.addProperty("Reason", throwable);
            dCSTraceBuffer.invoke();
        }
    }

    public TraceComponent getTraceComponent() {
        return TC;
    }

    public String getStackName() {
        return null;
    }

    public String getMemberName() {
        return null;
    }

    public String getLayerName() {
        return "DCSDiagnosticsModule";
    }
}

