/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common.util;

import com.ibm.ejs.ras.Tr;
import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.dcs.common.DCSTraceable;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.nls.IllegalStateEvent;
import com.ibm.ws.dcs.vri.common.nls.UnusualStateEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContextImpl;
import com.ibm.ws.dcs.vri.common.util.DCSTraceInvokable;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class DCSTraceBuffer
implements DCSTraceable,
DCSTraceInvokable,
DCSTraceContext {
    private static final TraceComponent TC = Tr.register(DCSTraceBuffer.class, "DCS", "com.ibm.ws.dcs.common.event.nls.dcs");
    private static final int INITIAL_BUF_SIZE = 240;
    static final String DCS_PREFIX = "DCS";
    static final String AT = " at ";
    static final String PREFIX_SEP = ".";
    static final String PREFIX_END = ": ";
    static final String SEP = " ";
    static final String FOCUS_SEP = ", ";
    private static final int FOCUS_COLUMN_WIDTH = 21;
    private static final char[] BLANK_COLUMN = new char[21];
    static final String PROPERTY_START = " {";
    public static final String PROPERTY_RELATION = "=";
    static final String PROPERTY_END = "} ";
    static final String PROPERTY_SEP = ", ";
    private static final int PROPERTY_SEP_LENGTH;
    public static final String NULL_PROPERTY_KEY = "NullPropertyKey";
    public static final String TRACE_NAME = "DCSTraceBuffer";
    private static final String[] _eventTypes;
    public static final int PROPRTY_LIST = -1;
    public static final int FOCUS_EVENT = 0;
    public static final int INTERNAL_INFO = 1;
    public static final int INTERNAL_WARNING = 2;
    public static final int EVENT = 3;
    public static final int DEBUG = 4;
    public static final int DUMP = 5;
    public static final int ENTRY = 6;
    public static final int EXIT = 7;
    private final int _eventType;
    private String _traceName = "DCSTraceBuffer";
    private final DCSTraceContext _dtc;
    private final String _methodName;
    private final String _focusEntry;
    private final String _description;
    private final LinkedHashMap _properties = new LinkedHashMap();
    private Throwable _cause = null;

    protected DCSTraceBuffer(DCSTraceBuffer dCSTraceBuffer, DCSTraceContext dCSTraceContext, int n, String string, String string2, String[] stringArray) {
        this._eventType = n;
        if (dCSTraceBuffer != null) {
            if (dCSTraceContext == null && dCSTraceBuffer._eventType != -1) {
                dCSTraceContext = dCSTraceBuffer._dtc;
            }
            if (string == null) {
                string = dCSTraceBuffer._methodName;
            }
            this._properties.putAll(dCSTraceBuffer._properties);
        }
        if (dCSTraceContext == null && this._eventType != -1) {
            throw new IllegalArgumentException("TraceContext must not be null unless PROPERTY_LIST");
        }
        this._dtc = dCSTraceContext;
        this._methodName = string;
        this._description = string2;
        this._focusEntry = this._eventType == 0 ? this.formatFocusColumns(stringArray) : null;
    }

    private String formatFocusColumns(String[] stringArray) {
        if (stringArray == null) {
            return "";
        }
        int n = stringArray.length;
        StringBuffer stringBuffer = new StringBuffer(n * 21);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (stringArray[i] == null) continue;
            stringBuffer.append(", ");
            stringBuffer.append(stringArray[i]);
            int n3 = (n2 += 21) - stringBuffer.length();
            if (n3 <= 0) continue;
            stringBuffer.append(BLANK_COLUMN, 0, n3);
        }
        return stringBuffer.toString();
    }

    public String getPropertiesString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.writeProperties(stringBuffer);
        return stringBuffer.toString();
    }

    public String[] getPropertiesStringArray() {
        if (this._properties == null || this._properties.size() == 0) {
            return new String[0];
        }
        String[] stringArray = new String[this._properties.size()];
        int n = 0;
        Iterator iterator = this._properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringArray[n] = entry.getKey() + PROPERTY_RELATION + entry.getValue();
            ++n;
        }
        return stringArray;
    }

    public DCSTraceBuffer mergePropertyList(DCSTraceBuffer dCSTraceBuffer) {
        if (dCSTraceBuffer == null) {
            return this;
        }
        return this.addProperty(dCSTraceBuffer.getProperties());
    }

    public DCSTraceBuffer addProperty(DCSTraceable dCSTraceable) {
        return this.addProperty(null, dCSTraceable);
    }

    public DCSTraceBuffer addProperty(String string, DCSTraceable dCSTraceable) {
        if (dCSTraceable == null) {
            return this.addProperty(string, NULL_PROPERTY_KEY, "NullDSCTraceable");
        }
        if (dCSTraceable == this) {
            return this.addProperty(string, dCSTraceable.getTraceName(), "this");
        }
        return this.addProperty(string, dCSTraceable.getTraceName(), dCSTraceable);
    }

    public DCSTraceBuffer addProperty(String string, Object object) {
        return this.addProperty(null, string, object);
    }

    public DCSTraceBuffer addProperty(String string, String string2, Object object) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string).append(":");
        }
        if (string2 == null) {
            stringBuffer.append(NULL_PROPERTY_KEY);
        } else {
            stringBuffer.append(string2);
        }
        if (this._properties.containsKey(stringBuffer.toString())) {
            int n = 1;
            stringBuffer.insert(0, String.valueOf(n) + ':');
            while (this._properties.containsKey(stringBuffer.toString())) {
                stringBuffer.replace(0, String.valueOf(n).length(), String.valueOf(++n));
            }
        }
        this._properties.put(stringBuffer.toString(), object);
        return this;
    }

    public DCSTraceBuffer addProperty(String string, int n) {
        return this.addProperty(null, string, String.valueOf(n));
    }

    public DCSTraceBuffer addProperty(String string, String string2, int n) {
        return this.addProperty(string, string2, String.valueOf(n));
    }

    public DCSTraceBuffer addProperty(String string, String string2, int[] nArray) {
        return this.addProperty(string, string2, Utils.toString(nArray));
    }

    public DCSTraceBuffer addProperty(String string, int[] nArray) {
        return this.addProperty(string, Utils.toString(nArray));
    }

    public DCSTraceBuffer addProperty(String string, long l) {
        return this.addProperty(null, string, String.valueOf(l));
    }

    public DCSTraceBuffer addProperty(String string, String string2, long l) {
        return this.addProperty(string, string2, String.valueOf(l));
    }

    public DCSTraceBuffer addProperty(String string, boolean bl) {
        return this.addProperty(null, string, String.valueOf(bl));
    }

    public DCSTraceBuffer addProperty(String string, String string2, boolean bl) {
        return this.addProperty(string, string2, String.valueOf(bl));
    }

    public DCSTraceBuffer addProperty(String string, double d) {
        return this.addProperty(null, string, String.valueOf(d));
    }

    public DCSTraceBuffer addProperty(String string, String string2, double d) {
        return this.addProperty(string, string2, String.valueOf(d));
    }

    public DCSTraceBuffer addProperty(String string, Object[] objectArray) {
        return this.addProperty((String)null, string, objectArray);
    }

    public DCSTraceBuffer addProperty(String string, String string2, Object[] objectArray) {
        return this.addProperty(string, string2, Utils.toString(objectArray));
    }

    public DCSTraceBuffer addProperty(Throwable throwable) {
        return this.addProperty(null, throwable);
    }

    public DCSTraceBuffer addProperty(String string, Throwable throwable) {
        if (throwable != null) {
            return this.addProperty(string, throwable.getClass().getName(), DCSTraceBuffer.throwableToString(throwable));
        }
        return this.addProperty(string, NULL_PROPERTY_KEY, "NullThrowable");
    }

    public DCSTraceBuffer addProperty(Map map) {
        return this.addProperty(null, map);
    }

    private DCSTraceBuffer addProperty(String string, Map map) {
        if (map != null && map.size() > 0) {
            Iterator iterator = map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                this.addProperty(null, (String)entry.getKey(), entry.getValue());
            }
        } else {
            this.addProperty(string, NULL_PROPERTY_KEY, "NullPropertiesMap");
        }
        return this;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(240);
        this.writeMessage(stringBuffer);
        this.writeProperties(stringBuffer);
        return stringBuffer.toString();
    }

    public StringBuffer writeMessage(StringBuffer stringBuffer) {
        switch (this._eventType) {
            case -1: {
                return stringBuffer;
            }
            case 1: 
            case 2: {
                break;
            }
            case 0: {
                stringBuffer.append(_eventTypes[0]).append(PREFIX_SEP);
            }
            default: {
                String string;
                String string2;
                stringBuffer.append(DCS_PREFIX).append(PREFIX_SEP).append(this._dtc.getLayerName());
                if (this._methodName != null && this._methodName.length() > 0 && !SEP.equals(this._methodName)) {
                    stringBuffer.append(PREFIX_SEP).append(this._methodName);
                }
                if ((string2 = this._dtc.getStackName()) != null && string2.length() > 0 && !SEP.equals(string2)) {
                    stringBuffer.append(SEP).append(string2);
                }
                if ((string = this._dtc.getMemberName()) != null && string.length() > 0 && !SEP.equals(string)) {
                    stringBuffer.append(AT).append(string);
                }
                stringBuffer.append(PREFIX_END);
                if (this._eventType != 0) break;
                stringBuffer.append(this._focusEntry);
            }
        }
        if (this._description != null && this._description.length() != 0 && !SEP.equals(this._description)) {
            stringBuffer.append(SEP).append('\"').append(this._description).append('\"');
        }
        return stringBuffer;
    }

    public StringBuffer writeProperties(StringBuffer stringBuffer) {
        if (this._properties.size() == 0) {
            if (this._eventType == -1) {
                stringBuffer.append(PROPERTY_START).append(SEP).append(PROPERTY_END);
            }
            return stringBuffer;
        }
        stringBuffer.append(PROPERTY_START);
        Iterator iterator = this._properties.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = iterator.next();
            stringBuffer.append(entry.getKey());
            stringBuffer.append(PROPERTY_RELATION);
            stringBuffer.append(entry.getValue());
            stringBuffer.append(", ");
        }
        stringBuffer.replace(stringBuffer.length() - PROPERTY_SEP_LENGTH, stringBuffer.length(), PROPERTY_END);
        return stringBuffer;
    }

    public static String throwableToString(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        printWriter.println();
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public void invoke() {
        this.invoke(this._eventType);
    }

    public void invoke(int n) {
        switch (n) {
            case 0: 
            case 3: {
                Tr.event(this._dtc.getTraceComponent(), this.toString());
                break;
            }
            case 4: {
                Tr.debug(this._dtc.getTraceComponent(), this.toString());
                break;
            }
            case 5: {
                Tr.dump(this._dtc.getTraceComponent(), this.toString());
                break;
            }
            case 6: {
                Tr.entry(this._dtc.getTraceComponent(), this.toString());
                break;
            }
            case 7: {
                Tr.exit(this._dtc.getTraceComponent(), this.toString());
                break;
            }
            case 1: {
                UnusualStateEvent unusualStateEvent = new UnusualStateEvent(this._dtc, this.toString());
                unusualStateEvent.invokeNLSTrace();
                break;
            }
            case 2: {
                IllegalStateEvent illegalStateEvent = new IllegalStateEvent(this._dtc, this.toString(), this._cause);
                illegalStateEvent.invokeNLSTrace();
                break;
            }
        }
    }

    public static final boolean isFocustEventEnabled(TraceComponent traceComponent) {
        return traceComponent.isEventEnabled();
    }

    public static final boolean isInternalInfoEnabled(TraceComponent traceComponent) {
        return true;
    }

    public static final boolean isInternalWarningEnabled(TraceComponent traceComponent) {
        return true;
    }

    public static final boolean isEventEnabled(TraceComponent traceComponent) {
        return traceComponent.isEventEnabled();
    }

    public static final boolean isDebugEnabled(TraceComponent traceComponent) {
        return traceComponent.isDebugEnabled();
    }

    public static final boolean isDumpEnabled(TraceComponent traceComponent) {
        return traceComponent.isDumpEnabled();
    }

    public static final boolean isEntryEnabled(TraceComponent traceComponent) {
        return traceComponent.isEntryEnabled();
    }

    public static final boolean isExitEnabled(TraceComponent traceComponent) {
        return traceComponent.isEntryEnabled();
    }

    public static DCSTraceBuffer propertyList() {
        DCSTraceContextImpl dCSTraceContextImpl = new DCSTraceContextImpl(TC, null, null, null);
        return new DCSTraceBuffer(null, dCSTraceContextImpl, -1, null, null, null);
    }

    public static DCSTraceBuffer propertyList(String string) {
        DCSTraceBuffer dCSTraceBuffer = DCSTraceBuffer.propertyList();
        dCSTraceBuffer.setTraceName(string);
        return dCSTraceBuffer;
    }

    public static DCSTraceBuffer focusEvent(DCSTraceContext dCSTraceContext, String string, String string2, String string3) {
        return new DCSTraceBuffer(null, dCSTraceContext, 0, string, string3, new String[]{string2});
    }

    public DCSTraceBuffer toFocusEvent(DCSTraceContext dCSTraceContext, String string, String string2, String string3) {
        return new DCSTraceBuffer(this, dCSTraceContext, 0, string, string3, new String[]{string2});
    }

    public static DCSTraceBuffer focusEvent(DCSTraceContext dCSTraceContext, String string, String string2, String string3, String string4) {
        return new DCSTraceBuffer(null, dCSTraceContext, 0, string, string4, new String[]{string2, string3});
    }

    public DCSTraceBuffer toFocusEvent(DCSTraceContext dCSTraceContext, String string, String string2, String string3, String string4) {
        return new DCSTraceBuffer(this, dCSTraceContext, 0, string, string4, new String[]{string2, string3});
    }

    public static DCSTraceBuffer focusEvent(DCSTraceContext dCSTraceContext, String string, String string2, String string3, String string4, String string5) {
        return new DCSTraceBuffer(null, dCSTraceContext, 0, string, string5, new String[]{string2, string3, string4});
    }

    public DCSTraceBuffer toFocusEvent(DCSTraceContext dCSTraceContext, String string, String string2, String string3, String string4, String string5) {
        return new DCSTraceBuffer(this, dCSTraceContext, 0, string, string5, new String[]{string2, string3, string4});
    }

    public static DCSTraceBuffer event(DCSTraceContext dCSTraceContext, String string, String string2) {
        return new DCSTraceBuffer(null, dCSTraceContext, 3, string, string2, null);
    }

    public DCSTraceBuffer toEvent(DCSTraceContext dCSTraceContext, String string, String string2) {
        return new DCSTraceBuffer(this, dCSTraceContext, 3, string, string2, null);
    }

    public static DCSTraceBuffer debug(DCSTraceContext dCSTraceContext, String string, String string2) {
        return new DCSTraceBuffer(null, dCSTraceContext, 4, string, string2, null);
    }

    public DCSTraceBuffer toDebug(DCSTraceContext dCSTraceContext, String string, String string2) {
        return new DCSTraceBuffer(this, dCSTraceContext, 4, string, string2, null);
    }

    public static DCSTraceBuffer dump(DCSTraceContext dCSTraceContext, String string, String string2) {
        return new DCSTraceBuffer(null, dCSTraceContext, 5, string, string2, null);
    }

    public DCSTraceBuffer toDump(DCSTraceContext dCSTraceContext, String string, String string2) {
        return new DCSTraceBuffer(this, dCSTraceContext, 5, string, string2, null);
    }

    public static DCSTraceBuffer entry(DCSTraceContext dCSTraceContext, String string, String string2) {
        return new DCSTraceBuffer(null, dCSTraceContext, 6, string, string2, null);
    }

    public DCSTraceBuffer toEntry(DCSTraceContext dCSTraceContext, String string, String string2) {
        return new DCSTraceBuffer(this, dCSTraceContext, 6, string, string2, null);
    }

    public static DCSTraceBuffer exit(DCSTraceContext dCSTraceContext, String string, String string2) {
        return new DCSTraceBuffer(null, dCSTraceContext, 7, string, string2, null);
    }

    public DCSTraceBuffer toExit(DCSTraceContext dCSTraceContext, String string, String string2) {
        return new DCSTraceBuffer(this, dCSTraceContext, 7, string, string2, null);
    }

    public static DCSTraceBuffer internalInfo(DCSTraceContext dCSTraceContext, String string) {
        return new DCSTraceBuffer(null, dCSTraceContext, 1, null, string, null);
    }

    public DCSTraceBuffer toInternalInfo(DCSTraceContext dCSTraceContext, String string) {
        return new DCSTraceBuffer(this, dCSTraceContext, 1, null, string, null);
    }

    public static DCSTraceBuffer internalWarning(DCSTraceContext dCSTraceContext, String string, Throwable throwable) {
        DCSTraceBuffer dCSTraceBuffer = new DCSTraceBuffer(null, dCSTraceContext, 2, null, string, null);
        dCSTraceBuffer._cause = throwable;
        return dCSTraceBuffer;
    }

    public static DCSTraceBuffer internalWarning(DCSTraceContext dCSTraceContext, String string, String string2, Throwable throwable) {
        DCSTraceBuffer dCSTraceBuffer = new DCSTraceBuffer(null, dCSTraceContext, 2, string2, string, null);
        dCSTraceBuffer.addProperty("Method", string2);
        dCSTraceBuffer._cause = throwable;
        return dCSTraceBuffer;
    }

    public DCSTraceBuffer toInternalWarning(DCSTraceContext dCSTraceContext, String string, Throwable throwable) {
        DCSTraceBuffer dCSTraceBuffer = new DCSTraceBuffer(this, dCSTraceContext, 2, null, string, null);
        dCSTraceBuffer._cause = throwable;
        return dCSTraceBuffer;
    }

    public String getTraceName() {
        return this._traceName;
    }

    public void setTraceName(String string) {
        this._traceName = string == null ? TRACE_NAME : string;
    }

    public TraceComponent getTraceComponent() {
        return this._dtc.getTraceComponent();
    }

    public String getStackName() {
        return this._dtc.getStackName();
    }

    public String getMemberName() {
        return this._dtc.getMemberName();
    }

    public String getLayerName() {
        return this._dtc.getLayerName();
    }

    public String getDescription() {
        return this._description;
    }

    public String getMethodName() {
        return this._methodName;
    }

    public LinkedHashMap getProperties() {
        return this._properties;
    }

    static {
        Arrays.fill(BLANK_COLUMN, ' ');
        PROPERTY_SEP_LENGTH = ", ".length();
        _eventTypes = new String[8];
        DCSTraceBuffer._eventTypes[0] = "FOCUS";
        DCSTraceBuffer._eventTypes[1] = "WARNING";
        DCSTraceBuffer._eventTypes[2] = "ERROR";
        DCSTraceBuffer._eventTypes[3] = "EVENT";
        DCSTraceBuffer._eventTypes[4] = "DEBUG";
        DCSTraceBuffer._eventTypes[5] = "DEBUG";
        DCSTraceBuffer._eventTypes[6] = "ENTRY";
        DCSTraceBuffer._eventTypes[7] = "EXIT";
    }
}

