/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common.util;

import com.ibm.ws.dcs.common.DCSTraceable;
import com.ibm.ws.dcs.vri.common.Globals;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceInvokable;
import java.util.Date;
import java.util.LinkedList;
import java.util.ListIterator;

public class DCSTraceHistory
implements DCSTraceInvokable,
DCSTraceable {
    static final int DEFAULT_MAXIMAL_SIZE = 100;
    private LinkedList _l = new LinkedList();
    private int _maximalSize;
    public static final String TRACE_NAME = "DCSTraceHistory";
    static final String HISTORY_TIMESTAMP = "HistoryTimestamp";

    public DCSTraceHistory() {
        this(100);
    }

    public DCSTraceHistory(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Maximal size must be greater than zero.");
        }
        this._maximalSize = n;
    }

    public DCSTraceInvokable add(DCSTraceInvokable dCSTraceInvokable) {
        if (dCSTraceInvokable == null) {
            throw new IllegalArgumentException("DCSTraceBuffer argument must not be null.");
        }
        this._l.addFirst(dCSTraceInvokable);
        if (this._l.size() > this._maximalSize) {
            return (DCSTraceInvokable)this._l.removeLast();
        }
        return null;
    }

    public DCSTraceInvokable add(DCSTraceBuffer dCSTraceBuffer) {
        if (dCSTraceBuffer == null) {
            throw new IllegalArgumentException("DCSTraceBuffer argument must not be null.");
        }
        dCSTraceBuffer.addProperty(HISTORY_TIMESTAMP, Globals.formatter.format(new Date()));
        this._l.addFirst(dCSTraceBuffer);
        if (this._l.size() > this._maximalSize) {
            return (DCSTraceInvokable)this._l.removeLast();
        }
        return null;
    }

    public ListIterator listIterator() {
        return this._l.listIterator();
    }

    public void clear() {
        this._l.clear();
    }

    public int getHistorySize() {
        return this._l.size();
    }

    public int getMaximalSize() {
        return this._maximalSize;
    }

    public int setMaximalSize(int n) {
        if (n < 1) {
            throw new IllegalArgumentException("Maximal size must be greater than zero.");
        }
        int n2 = this._l.size();
        if (n2 > n) {
            this._l.subList(n, n2).clear();
        }
        this._maximalSize = n;
        return this._maximalSize;
    }

    public void invoke() {
        ListIterator listIterator = this._l.listIterator(this._l.size());
        while (listIterator.hasPrevious()) {
            DCSTraceInvokable dCSTraceInvokable = (DCSTraceInvokable)listIterator.previous();
            if (dCSTraceInvokable != null) {
                dCSTraceInvokable.invoke();
                continue;
            }
            throw new NullPointerException("Null DCSTraceHistory entry.");
        }
    }

    public void invoke(int n) {
        ListIterator listIterator = this._l.listIterator(this._l.size());
        while (listIterator.hasPrevious()) {
            DCSTraceInvokable dCSTraceInvokable = (DCSTraceInvokable)listIterator.previous();
            if (dCSTraceInvokable != null) {
                dCSTraceInvokable.invoke(n);
                continue;
            }
            throw new NullPointerException("Null DCSTraceHistory entry.");
        }
    }

    public String toString() {
        return this._l.toString();
    }

    public String getTraceName() {
        return TRACE_NAME;
    }
}

