/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.common.util;

public class ThresholdCounter {
    private final int threshold;
    private int count;
    private long maxCount;
    private int retry;
    private final int maxRetry;

    public boolean increment() {
        if (this.retry > this.maxRetry) {
            return false;
        }
        ++this.count;
        if ((long)this.count >= this.maxCount) {
            ++this.retry;
            if (this.retry <= this.maxRetry) {
                this.maxCount *= 2L;
            }
            this.count = 0;
            return true;
        }
        return false;
    }

    public void reset() {
        this.count = 0;
        this.maxCount = this.threshold;
        this.retry = 0;
    }

    public ThresholdCounter(int n, int n2) {
        if (n2 < 1) {
            n2 = 1;
        }
        if (n2 > 15) {
            n2 = 15;
        }
        this.threshold = n;
        this.maxCount = this.threshold;
        this.maxRetry = n2;
    }
}

