/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership;

import com.ibm.ws.dcs.vri.common.Globals;
import com.ibm.ws.dcs.vri.common.MemberInfo;
import com.ibm.ws.dcs.vri.common.event.RequestChangeDefinedEvent;
import com.ibm.ws.dcs.vri.common.event.VRIEvent;
import com.ibm.ws.dcs.vri.common.event.VRIEventHandler;
import com.ibm.ws.dcs.vri.common.nls.TerminationEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.membership.CoreGroupMembershipLayer;
import com.ibm.ws.dcs.vri.membership.MBRUp;
import com.ibm.ws.dcs.vri.membership.util.MBRLogger;

public final class CGMBRUp
extends MBRUp {
    public CGMBRUp(Globals globals) {
        super(globals, new CoreGroupMembershipLayer(globals));
        this.eventHandlers.setVRIEventHandler(RequestChangeDefinedEvent.class, new RequestChangeDefinedEventHandler());
    }

    void requestChangeDefined(MemberInfo[] memberInfoArray, String[] stringArray, int n) {
        try {
            boolean bl = false;
            MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "requestChangeDefined()", DCSTraceBuffer.propertyList().addProperty("AddedMembers", MemberInfo.getNames(memberInfoArray)).addProperty("RemovedMembers", stringArray).addProperty("Context", n), null);
            MBRLogger.dcsAssert(Thread.holdsLock(this.g.getMutex()), "We have dont mutex", "CGMBRUp", "requestChangeDefined()", this.stackName);
            this.changeDefinedRequest.setChangeDefinedRequest(memberInfoArray, stringArray, n);
            stringArray = this.changeDefinedRequest.getRequestChangeDefinedRemovals();
            memberInfoArray = this.changeDefinedRequest.getRequestChangeDefinedAdds();
            if (stringArray != null && stringArray.length > 0) {
                this.adminDenyRemovedMembers(stringArray, "Request ViewChange");
                bl = true;
            }
            if (memberInfoArray != null && memberInfoArray.length > 0) {
                this.adminUndenyAddedMembers(memberInfoArray);
            }
            if (this.determineIfIAmRequestLeader() && !this.isDefSetBlocked()) {
                MBRLogger.dcsLogMUPActionEvent(this, "super.requestChangeDefined() denials= " + bl);
                super.requestChangeDefined(memberInfoArray, stringArray, n);
                return;
            }
            MBRLogger.dcsLogMUPActionEvent(this, "Do Nothing I am not requestLeader denials= " + bl);
        }
        catch (Throwable throwable) {
            this.up.requestTermination(new TerminationEvent((DCSTraceContext)this, "requestChangeDefined()", throwable));
        }
    }

    boolean determineIfIAmRequestLeader() {
        return this.membersMgr.pickActiveLeader(null).getName().equals(this.myName);
    }

    private final class RequestChangeDefinedEventHandler
    implements VRIEventHandler {
        private RequestChangeDefinedEventHandler() {
        }

        public int handle(VRIEvent vRIEvent) {
            RequestChangeDefinedEvent requestChangeDefinedEvent = (RequestChangeDefinedEvent)vRIEvent;
            CGMBRUp.this.requestChangeDefined(requestChangeDefinedEvent.getMembersToAdd(), requestChangeDefinedEvent.getMembersToRemove(), requestChangeDefinedEvent.getContext());
            return 3;
        }

        public String getTraceName() {
            return "RequestChangeDefinedEventHandler";
        }
    }
}

