/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership;

import com.ibm.ws.dcs.common.ViewId;
import com.ibm.ws.dcs.common.event.DCSSuspectEvent;
import com.ibm.ws.dcs.common.exception.DCSException;
import com.ibm.ws.dcs.common.exception.DCSMemberIsNotDefinedException;
import com.ibm.ws.dcs.vri.common.Globals;
import com.ibm.ws.dcs.vri.common.MemberInfo;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.event.PartialViewApprovedEvent;
import com.ibm.ws.dcs.vri.common.event.RequestViewChangeEvent;
import com.ibm.ws.dcs.vri.common.event.VRIEvent;
import com.ibm.ws.dcs.vri.common.event.VRIEventHandler;
import com.ibm.ws.dcs.vri.common.nls.MBRSuspectAdministratively;
import com.ibm.ws.dcs.vri.common.nls.TerminationEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.membership.DSMBRDo;
import com.ibm.ws.dcs.vri.membership.DSMUPState;
import com.ibm.ws.dcs.vri.membership.DataStackMembershipLayer;
import com.ibm.ws.dcs.vri.membership.MBRDo;
import com.ibm.ws.dcs.vri.membership.MBRUp;
import com.ibm.ws.dcs.vri.membership.MUPAlarm;
import com.ibm.ws.dcs.vri.membership.messages.MBRRequestTrivalViewChangeEvent;
import com.ibm.ws.dcs.vri.membership.messages.MergeNewViewMsg;
import com.ibm.ws.dcs.vri.membership.messages.NewViewMsg;
import com.ibm.ws.dcs.vri.membership.messages.ResetVLWaitAlarmMsg;
import com.ibm.ws.dcs.vri.membership.messages.ViewMsg;
import com.ibm.ws.dcs.vri.membership.util.MBRDenialReason;
import com.ibm.ws.dcs.vri.membership.util.MBRLogger;
import java.util.Map;

public class DSMBRUp
extends MBRUp {
    private final DSMUPState state;
    private ViewId lastInstalledViewId;

    public DSMBRUp(Globals globals) {
        super(globals, new DataStackMembershipLayer(globals));
        this.eventHandlers.setVRIEventHandler(RequestViewChangeEvent.class, new RequestViewChangeEventHandler());
        this.eventHandlers.setVRIEventHandler(PartialViewApprovedEvent.class, new PartialViewApprovedEventHandler());
        this.state = new DSMUPState(globals.getVRIMembersMgr(), this.alarm);
    }

    public void partialViewApproved(Comparable comparable, int n, boolean bl) {
        MBRDo mBRDo;
        MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "partialViewApproved()", DCSTraceBuffer.propertyList().addProperty("ViewID", comparable).addProperty("Context", n).addProperty("IsExternal", bl), null);
        MBRLogger.dcsAssert(Thread.holdsLock(this.g.getMutex()), "We have dont mutex", "MBRUp", "partialViewApproved()", this.stackName);
        this.alarm.cancelAttemptRequestTimer();
        ViewMsg viewMsg = this.state.getPendingViewMsg((ViewId)comparable);
        if (viewMsg != null) {
            if (!bl) {
                if (viewMsg instanceof NewViewMsg && !((NewViewMsg)viewMsg).viewsAreEqual(this.state.getRequestedViewMembers())) {
                    ((NewViewMsg)viewMsg).setInternal();
                }
                if (viewMsg instanceof MergeNewViewMsg && !((MergeNewViewMsg)viewMsg).viewsAreEqual(this.state.getRequestedViewMembers())) {
                    ((MergeNewViewMsg)viewMsg).setInternal();
                }
            }
            mBRDo = new MBRDo(this, viewMsg);
        } else {
            String string = "Invalid viewId on approval got= " + comparable + " expected= " + this.state.getPendingViewId();
            MBRLogger.dcsWarning((DCSTraceContext)this, "partialViewApproved()", string);
            mBRDo = new MBRDo(string);
        }
        this.doit(mBRDo);
    }

    public void requestViewChange(String[] stringArray, int n, Comparable comparable) {
        String[] stringArray2 = this.state.getRequestedViewMembers();
        Utils.DiffSet diffSet = new Utils.DiffSet(stringArray2, stringArray);
        Object[] objectArray = diffSet.newMinusOld;
        Object[] objectArray2 = diffSet.oldMinusNew;
        MBRLogger.dcsLogMUPEvent((DCSTraceContext)this, "requestViewChange()", DCSTraceBuffer.propertyList().addProperty("viewMembers", stringArray).addProperty("AddedMembers", objectArray).addProperty("RemovedMembers", objectArray2).addProperty("Context", n).addProperty("ViewID", comparable), null);
        MBRLogger.dcsAssert(Thread.holdsLock(this.g.getMutex()), "We have dont mutex", "DSMBRUp", "requestViewChange()", this.stackName);
        if (!this.lastInstalledViewId.equals(comparable)) {
            MBRLogger.dcsWarning((DCSTraceContext)this, "requestViewChange", new DCSException("Do Nothing ViewId not current"));
            return;
        }
        try {
            if (this.amIinRemoveSet((String[])objectArray2)) {
                String string = "Received requestChangeView() which this member was not part of";
                String[] stringArray3 = new String[stringArray.length];
                int n2 = 0;
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!this.membersMgr.isDefined(stringArray[i])) continue;
                    this.membersMgr.denyMember(stringArray[i], MBRDenialReason.createAdminRemovalDR(string));
                    stringArray3[n2] = stringArray[i];
                    ++n2;
                }
                String[] stringArray4 = new String[n2];
                System.arraycopy(stringArray3, 0, stringArray4, 0, n2);
                MBRSuspectAdministratively mBRSuspectAdministratively = new MBRSuspectAdministratively((DCSTraceContext)this, stringArray4, string);
                mBRSuspectAdministratively.invokeNLSTrace();
                this.up.suspectMembers(new DCSSuspectEvent[]{mBRSuspectAdministratively});
                return;
            }
            MemberInfo[] memberInfoArray = MemberInfo.getMemberInfo((String[])objectArray, this.g.getMemberInfoManager());
            if (!this.empty((String[])objectArray2)) {
                this.adminDenyRemovedMembers((String[])objectArray2, "Request ViewChange");
            }
            this.adminUndenyAddedMembers(stringArray);
            this.state.setRequestedViewMembers(stringArray, (String[])objectArray, (String[])objectArray2, (ViewId)comparable, n);
            this.changeDefinedRequest.setChangeDefinedRequest(memberInfoArray, (String[])objectArray2, n);
            if (this.state.determineIfRequestLeader() && !this.isDefSetBlocked()) {
                this.setRequestAttemptTimer();
                if (!this.empty(memberInfoArray) || !this.empty((String[])objectArray2)) {
                    MBRLogger.dcsLogMUPActionEvent(this, "super.requestChangeDefined()");
                    MemberInfo[] memberInfoArray2 = this.changeDefinedRequest.getRequestChangeDefinedAdds();
                    String[] stringArray5 = this.changeDefinedRequest.getRequestChangeDefinedRemovals();
                    super.requestChangeDefined(memberInfoArray2, stringArray5, n);
                } else {
                    MBRLogger.dcsLogMUPActionEvent(this, "Do Nothing (eligible process list) EPL is same as requested view");
                }
                return;
            }
            MBRLogger.dcsLogMUPActionEvent(this, "Do Nothing: I am requestLeader = " + this.state.determineIfRequestLeader() + ", definedSet is locked = " + this.isDefSetBlocked());
        }
        catch (DCSMemberIsNotDefinedException dCSMemberIsNotDefinedException) {
            MBRLogger.dcsLogMUPActionEvent((DCSTraceContext)this, "Do Nothing caught exception  =", DCSTraceBuffer.propertyList().addProperty(dCSMemberIsNotDefinedException).addProperty("Method", "requestChangeDefined()"));
        }
    }

    protected void setRequestAttemptTimer() {
        this.alarm.cancelAttemptRequestTimer();
        this.alarm.setRequestAttemptTimer();
    }

    private boolean empty(String[] stringArray) {
        return stringArray == null || stringArray.length == 0;
    }

    private boolean empty(MemberInfo[] memberInfoArray) {
        return memberInfoArray == null || memberInfoArray.length == 0;
    }

    boolean determineIfNewViewNeeded() {
        ViewId viewId = this.state.getLastRequestedViewId();
        return this.lastInstalledViewId.equals(viewId);
    }

    public MBRDo handleResetVLWaitAlarmAlarm() {
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "handleResetVLWaitAlarmAlarm()", null).invoke();
        }
        try {
            MBRLogger.dcsLogMUPEvent(this, "handleResetVLWaitAlarmAlarm", "");
            this.state.setRESETVLTimer();
            return new MBRDo(this, new ResetVLWaitAlarmMsg(this.membersMgr.getThisMember().getName(), this.membersMgr));
        }
        catch (Exception exception) {
            MBRLogger.dcsLogMUPActionEvent(this, "up.requestTermination(e)");
            this.up.requestTermination(new TerminationEvent((DCSTraceContext)this, "handleResetVLWaitAlarmAlarm", exception));
            return new MBRDo("Terminating");
        }
    }

    public void handleAttemptRequestAlarm() {
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "handleAttemptRequestAlarm()", null).invoke();
        }
        try {
            MBRLogger.dcsLogMUPEvent(this, "attemptRequestAlarm()", "");
            if (this.determineIfNewViewNeeded()) {
                MBRLogger.dcsLogMUPActionEvent(this, "up.onVRIUpEvent(trivialViewChange");
                this.up.onVRIUpEvent(new MBRRequestTrivalViewChangeEvent(this.stackName, this.myName));
            }
        }
        catch (Exception exception) {
            MBRLogger.dcsLogMUPActionEvent(this, "up.requestTermination(e)");
            this.up.requestTermination(new TerminationEvent((DCSTraceContext)this, "handleAttemptRequestAlarm()", exception));
        }
    }

    public void newViewOK(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, Map map) {
        this.alarm.cancelAttemptRequestTimer();
        if (viewIdImpl.isInternalView()) {
            this.alarm.setRequestAttemptTimer();
        }
        super.newViewOK(vRIMemberDescriptionArray, viewIdImpl, map);
    }

    public void handleAlarm(Object object) {
        if (object == MUPAlarm.ATTEMPT_CHANGEVIEWREQUEST_ALARM_CONTEXT) {
            this.handleAttemptRequestAlarm();
            return;
        }
        if (object == MUPAlarm.RESETVLWAIT_ALARM_CONTEXT) {
            MBRLogger.dcsLogMUPEvent(this, "handleResetVLWaitAlarmAlarm", "");
            this.handleResetVLWaitAlarmAlarm();
            return;
        }
        super.handleAlarm(object);
    }

    public String getAlarmContextDescription(Object object) {
        if (object == MUPAlarm.ATTEMPT_CHANGEVIEWREQUEST_ALARM_CONTEXT) {
            return "DSMUP.AttemptRequestViewChange ";
        }
        if (object == MUPAlarm.RESETVLWAIT_ALARM_CONTEXT) {
            MBRLogger.dcsLogMUPEvent(this, "handleResetVLWaitAlarmAlarm", "");
            return "DSMUP.ResetVLWait ";
        }
        return super.getAlarmContextDescription(object);
    }

    public void passActionDown(MBRDo mBRDo) {
        boolean bl = false;
        if (mBRDo.isStartAction()) {
            ViewId viewId;
            bl = true;
            this.lastInstalledViewId = viewId = mBRDo.getViewId();
            this.state.setRequestedViewMembers(VRIMemberUtils.getMemberNames(this.membersMgr.getDefinedMembers(true)), null, null, viewId, 0);
            this.doit(mBRDo);
            return;
        }
        if (mBRDo.isNewViewAction()) {
            bl = true;
            this.lastInstalledViewId = mBRDo.getViewId();
            this.doit(mBRDo);
            return;
        }
        if (mBRDo.isNewViewMsgAction()) {
            bl = true;
            NewViewMsg newViewMsg = (NewViewMsg)mBRDo.getMsg();
            if (newViewMsg.viewsAreEqual(this.state.getRequestedViewMembers())) {
                this.alarm.cancelRESETVLTimer();
                this.alarm.cancelAttemptRequestTimer();
                mBRDo = new MBRDo(this, newViewMsg);
                this.doit(mBRDo);
                return;
            }
            if (this.state.isInternalView(newViewMsg.getSyncedList())) {
                newViewMsg.setInternal();
                mBRDo = new MBRDo(this, newViewMsg);
                this.doit(mBRDo);
                return;
            }
            if (this.g.viewsNeedApproval()) {
                this.state.setPendingViewMsg(newViewMsg.getNewViewId(), newViewMsg);
                mBRDo = new DSMBRDo(newViewMsg, this.state.getViewChangeContext(), this.getStackName());
                this.doit(mBRDo);
            } else {
                this.alarm.cancelRESETVLTimer();
                this.alarm.cancelAttemptRequestTimer();
                mBRDo = new MBRDo(this, newViewMsg);
                this.doit(mBRDo);
            }
            return;
        }
        if (mBRDo.isMergeNewViewMsgAction()) {
            bl = true;
            MergeNewViewMsg mergeNewViewMsg = (MergeNewViewMsg)mBRDo.getMsg();
            if (mergeNewViewMsg.viewsAreEqual(this.state.getRequestedViewMembers())) {
                mBRDo = new MBRDo(this, mergeNewViewMsg);
                this.alarm.cancelRESETVLTimer();
                this.alarm.cancelAttemptRequestTimer();
                this.doit(mBRDo);
                return;
            }
            if (this.g.viewsNeedApproval()) {
                this.state.setPendingViewMsg(mergeNewViewMsg.getNewViewId(), mergeNewViewMsg);
                mBRDo = new DSMBRDo(mergeNewViewMsg, this.state.getViewChangeContext(), this.getStackName());
                this.doit(mBRDo);
            } else {
                mBRDo = new MBRDo(this, mergeNewViewMsg);
                this.alarm.cancelRESETVLTimer();
                this.alarm.cancelAttemptRequestTimer();
                this.doit(mBRDo);
            }
            return;
        }
        if (bl) {
            this.doit(mBRDo);
        } else {
            super.passActionDown(mBRDo);
        }
    }

    private final class RequestViewChangeEventHandler
    implements VRIEventHandler {
        private RequestViewChangeEventHandler() {
        }

        public int handle(VRIEvent vRIEvent) {
            RequestViewChangeEvent requestViewChangeEvent = (RequestViewChangeEvent)vRIEvent;
            DSMBRUp.this.requestViewChange(requestViewChangeEvent.getViewMembers(), requestViewChangeEvent.getContext(), requestViewChangeEvent.getCurrentViewId());
            return 3;
        }

        public String getTraceName() {
            return "RequestViewChangeEventHandler";
        }
    }

    private final class PartialViewApprovedEventHandler
    implements VRIEventHandler {
        private PartialViewApprovedEventHandler() {
        }

        public int handle(VRIEvent vRIEvent) {
            PartialViewApprovedEvent partialViewApprovedEvent = (PartialViewApprovedEvent)vRIEvent;
            DSMBRUp.this.partialViewApproved(partialViewApprovedEvent.getViewId(), partialViewApprovedEvent.getContext(), true);
            return 3;
        }

        public String getTraceName() {
            return "PartialViewApprovedEventHandler";
        }
    }
}

