/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership;

import com.ibm.ws.dcs.common.ViewId;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMembersMGR;
import com.ibm.ws.dcs.vri.membership.MUPAlarm;
import com.ibm.ws.dcs.vri.membership.messages.ViewMsg;

class DSMUPState {
    private final MUPAlarm alarm;
    private String[] removeMembers = null;
    private String[] addMembers = null;
    private ViewId viewIdContext = null;
    private int requestedContext = 0;
    private String[] requestedViewMembers = null;
    private ViewId pendingViewId = null;
    private ViewMsg pendingViewMsg = null;
    private final VRIMembersMGR membersMgr;
    private final String myName;

    public DSMUPState(VRIMembersMGR vRIMembersMGR, MUPAlarm mUPAlarm) {
        this.membersMgr = vRIMembersMGR;
        this.myName = vRIMembersMGR.getThisMember().getName();
        this.alarm = mUPAlarm;
    }

    public ViewMsg getPendingViewMsg(ViewId viewId) {
        this.getAlarm().cancelRESETVLTimer();
        ViewMsg viewMsg = null;
        if (viewId != null && viewId.equals(this.pendingViewId)) {
            viewMsg = this.pendingViewMsg;
            this.pendingViewMsg = null;
            this.pendingViewId = null;
        }
        return viewMsg;
    }

    private MUPAlarm getAlarm() {
        return this.alarm;
    }

    public void setPendingViewMsg(ViewId viewId, ViewMsg viewMsg) {
        this.pendingViewId = viewId;
        this.pendingViewMsg = viewMsg;
        this.getAlarm().setRESETVLTimer();
    }

    public ViewId getPendingViewId() {
        return this.pendingViewId;
    }

    String[] getRequestedViewMembers() {
        return this.requestedViewMembers;
    }

    void setRequestedViewMembers(String[] stringArray, String[] stringArray2, String[] stringArray3, ViewId viewId, int n) {
        this.requestedViewMembers = stringArray;
        this.viewIdContext = viewId;
        this.requestedContext = n;
        this.addMembers = stringArray2;
        this.removeMembers = stringArray3;
    }

    public int getViewChangeContext() {
        return this.requestedContext;
    }

    public boolean determineIfRequestLeader() {
        boolean bl = false;
        if (this.requestedViewMembers != null && this.requestedViewMembers.length != 0) {
            bl = this.membersMgr.pickActiveLeader(null).getName().equals(this.myName);
        }
        return bl;
    }

    public ViewId getLastRequestedViewId() {
        return this.viewIdContext;
    }

    public boolean isInternalView(VRIMemberDescription[] vRIMemberDescriptionArray) {
        VRIMemberDescription[] vRIMemberDescriptionArray2;
        if (this.addMembers == null || this.addMembers.length == 0) {
            return false;
        }
        if (this.removeMembers == null || this.removeMembers.length == 0) {
            return false;
        }
        Object[] objectArray = this.membersMgr.getDefinedMembers(this.removeMembers);
        return VRIMemberUtils.intersection((VRIMemberDescription[])(objectArray = (VRIMemberDescription[])Utils.removeNulls(objectArray)), vRIMemberDescriptionArray2 = VRIMemberUtils.minus(this.membersMgr.getViewMembers(), vRIMemberDescriptionArray)).length == objectArray.length;
    }

    public void setRESETVLTimer() {
        this.getAlarm().setRESETVLTimer();
    }
}

