/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.dcs.vri.membership;

import com.ibm.ws.dcs.common.StateVersion;
import com.ibm.ws.dcs.common.event.DCSSuspectEvent;
import com.ibm.ws.dcs.common.event.DCSTerminationEvent;
import com.ibm.ws.dcs.common.exception.DCSAssertException;
import com.ibm.ws.dcs.common.exception.DCSException;
import com.ibm.ws.dcs.common.exception.DCSMemberIsNotDefinedException;
import com.ibm.ws.dcs.common.exception.DCSRuntimeException;
import com.ibm.ws.dcs.vri.common.CCVersion;
import com.ibm.ws.dcs.vri.common.Globals;
import com.ibm.ws.dcs.vri.common.MemberInfo;
import com.ibm.ws.dcs.vri.common.Utils;
import com.ibm.ws.dcs.vri.common.VRICheckFailedException;
import com.ibm.ws.dcs.vri.common.VRIMemberDescription;
import com.ibm.ws.dcs.vri.common.VRIMemberUtils;
import com.ibm.ws.dcs.vri.common.VRIMessage;
import com.ibm.ws.dcs.vri.common.ViewIdImpl;
import com.ibm.ws.dcs.vri.common.event.CongestionControlEvent;
import com.ibm.ws.dcs.vri.common.event.RequestChangeDefinedEvent;
import com.ibm.ws.dcs.vri.common.event.RequestChangeProtocolEvent;
import com.ibm.ws.dcs.vri.common.event.RequestDumpEvent;
import com.ibm.ws.dcs.vri.common.event.RequestStateChangeEvent;
import com.ibm.ws.dcs.vri.common.event.VRIEvent;
import com.ibm.ws.dcs.vri.common.event.VRIEventHandler;
import com.ibm.ws.dcs.vri.common.event.VRIUpEvent;
import com.ibm.ws.dcs.vri.common.nls.GeneralLogEvent;
import com.ibm.ws.dcs.vri.common.nls.MBRNewView;
import com.ibm.ws.dcs.vri.common.nls.TerminationEvent;
import com.ibm.ws.dcs.vri.common.util.DCSTraceBuffer;
import com.ibm.ws.dcs.vri.common.util.DCSTraceContext;
import com.ibm.ws.dcs.vri.common.util.FFDCDumpable;
import com.ibm.ws.dcs.vri.common.util.FFDCDumper;
import com.ibm.ws.dcs.vri.membership.MBRAbstractLayer;
import com.ibm.ws.dcs.vri.membership.MBRAlarm;
import com.ibm.ws.dcs.vri.membership.MBRDo;
import com.ibm.ws.dcs.vri.membership.MBRDowncalls;
import com.ibm.ws.dcs.vri.membership.MBRState;
import com.ibm.ws.dcs.vri.membership.MBRStateConstants;
import com.ibm.ws.dcs.vri.membership.MBRUpcalls;
import com.ibm.ws.dcs.vri.membership.Role;
import com.ibm.ws.dcs.vri.membership.RoleBank;
import com.ibm.ws.dcs.vri.membership.messages.AddMembersMsg;
import com.ibm.ws.dcs.vri.membership.messages.ChangeDefinedMsg;
import com.ibm.ws.dcs.vri.membership.messages.CompleteCurrentMsg;
import com.ibm.ws.dcs.vri.membership.messages.CurrentOKMsg;
import com.ibm.ws.dcs.vri.membership.messages.DumpAllMsg;
import com.ibm.ws.dcs.vri.membership.messages.MBRMessageFactory;
import com.ibm.ws.dcs.vri.membership.messages.MBRMessageProcessor;
import com.ibm.ws.dcs.vri.membership.messages.MBRRequestTrivalViewChangeEvent;
import com.ibm.ws.dcs.vri.membership.messages.SuspectMsg;
import com.ibm.ws.dcs.vri.membership.util.MBRDenialReason;
import com.ibm.ws.dcs.vri.membership.util.MBRLogger;
import java.util.Date;
import java.util.Map;

public abstract class GroupMembershipLayer
extends MBRAbstractLayer
implements MBRUpcalls {
    MBRDowncalls down = null;
    protected final MBRState state;
    final RoleBank rolebank;
    private static final int NONPMI_VIEWSTATE = -1;

    protected GroupMembershipLayer(Globals globals, MBRState mBRState) {
        super(globals, "MBR");
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "GroupMembershipLayer", null).invoke();
        }
        this.state = mBRState;
        MBRMessageFactory.registerFactory(this.stackName, globals);
        mBRState.setAlarm(new MBRAlarm(globals, this));
        this.eventHandlers.setVRIEventHandler(RequestChangeDefinedEvent.class, new RequestChangeDefinedEventHandler());
        this.eventHandlers.setVRIEventHandler(RequestStateChangeEvent.class, new RequestStateChangeEventHandler());
        this.eventHandlers.setVRIEventHandler(MBRRequestTrivalViewChangeEvent.class, new RequestTrivalViewChangeEventHandler());
        this.eventHandlers.setVRIEventHandler(RequestChangeProtocolEvent.class, new RequestChangeProtocolEventHandler());
        this.eventHandlers.setVRIEventHandler(RequestDumpEvent.class, new RequestDumpEventHandler());
        this.rolebank = new RoleBank(this.state);
        if (DCSTraceBuffer.isExitEnabled(this.TC)) {
            DCSTraceBuffer.exit(this, "GroupMembershipLayer", null).invoke();
        }
    }

    public void setDownLayer(MBRDowncalls mBRDowncalls) {
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "setDownLayer()", null).invoke();
        }
        this.down = mBRDowncalls;
        if (mBRDowncalls == null) {
            throw new DCSRuntimeException("Null Down layer in Membership");
        }
        if (DCSTraceBuffer.isExitEnabled(this.TC)) {
            DCSTraceBuffer.exit(this, "setDownLayer()", null).invoke();
        }
    }

    public VRICheckFailedException check() {
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "check()", null).invoke();
        }
        this.membersMgr.check();
        this.state.check();
        if (DCSTraceBuffer.isExitEnabled(this.TC)) {
            DCSTraceBuffer.exit(this, "check()", null).invoke();
        }
        return null;
    }

    public void connectMembers(VRIMemberDescription[] vRIMemberDescriptionArray) {
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "connectMembers()", null).addProperty("connectedMembers", vRIMemberDescriptionArray).invoke();
        }
        Object[] objectArray = vRIMemberDescriptionArray;
        vRIMemberDescriptionArray = this.membersMgr.getConnectedMembers(true);
        vRIMemberDescriptionArray = VRIMemberUtils.minus(vRIMemberDescriptionArray, this.membersMgr.getDeniedMembers(true));
        MBRLogger.dcsLogMBREvent(this, this.state.toString(), "connectedMembers()", null, DCSTraceBuffer.propertyList().addProperty("Old", "AddedMembers", objectArray).addProperty("New", "AddedMembers", vRIMemberDescriptionArray), null);
        MBRDo mBRDo = null;
        if (objectArray == null) {
            vRIMemberDescriptionArray = this.membersMgr.getViewMinusDenied();
            mBRDo = this.connectMembers(vRIMemberDescriptionArray, true);
        } else {
            mBRDo = this.connectMembers(vRIMemberDescriptionArray, false);
        }
        this.doit(mBRDo);
        if (DCSTraceBuffer.isExitEnabled(this.TC)) {
            DCSTraceBuffer.exit(this, "connectMembers()", null).invoke();
        }
    }

    private MBRDo connectMembers(VRIMemberDescription[] vRIMemberDescriptionArray, boolean bl) {
        MBRDo mBRDo = null;
        if (bl || !VRIMemberUtils.contains(this.membersMgr.getViewMembers(), vRIMemberDescriptionArray)) {
            if (this.state.isProtocol(MBRStateConstants.MESSAGING) && this.state.determineIfMergeLeader(vRIMemberDescriptionArray)) {
                this.state.changeRole(MBRStateConstants.MERGELEADER, MBRStateConstants.MERGE);
                VRIMemberDescription[] vRIMemberDescriptionArray2 = this.membersMgr.getDefinedMembers(true);
                String[] stringArray = VRIMemberUtils.getMemberNames(vRIMemberDescriptionArray2);
                MemberInfo[] memberInfoArray = null;
                try {
                    memberInfoArray = MemberInfo.getMemberInfo(stringArray, this.g.getMemberInfoManager());
                }
                catch (DCSMemberIsNotDefinedException dCSMemberIsNotDefinedException) {
                    mBRDo = new MBRDo((DCSTraceContext)this, dCSMemberIsNotDefinedException, "connectMembers()", "Undefined Member in connected list");
                    if (DCSTraceBuffer.isExitEnabled(this.TC)) {
                        DCSTraceBuffer.exit(this, "connectMembers()", null).invoke();
                    }
                    return mBRDo;
                }
                AddMembersMsg addMembersMsg = new AddMembersMsg(vRIMemberDescriptionArray, memberInfoArray, this.state.getStateExchanger().getNewStateVersion(), this.state.createSentMergeLeaderContext(), this.myName, this.membersMgr, this.membersMgr.getProtocolVersion());
                this.state.updateMajorState(MBRStateConstants.MERGELEADER, MBRStateConstants.SYNCING);
                mBRDo = MBRDo.setAction(mBRDo, new MBRDo(this, addMembersMsg));
            } else {
                mBRDo = MBRDo.setAction(mBRDo, new MBRDo("Not in  proper state to do Merge or not MergeLeader"));
            }
        } else {
            mBRDo = MBRDo.setAction(mBRDo, new MBRDo("All newly connected already contained in present view"));
        }
        return mBRDo;
    }

    public void suspectMembers(DCSSuspectEvent[] dCSSuspectEventArray) {
        Object[] objectArray = VRIMemberUtils.getUniqSuspectedMembers(dCSSuspectEventArray);
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "suspectMembers()", null).addProperty("SuspectedMembers", objectArray).invoke();
        }
        MBRLogger.dcsLogMBREvent(this, this.state.toString(), "suspectedMembers()", Utils.toString(objectArray));
        Object[] objectArray2 = VRIMemberUtils.getSuspectedMembersDescription(this.membersMgr, dCSSuspectEventArray, true);
        objectArray2 = (VRIMemberDescription[])Utils.removeNulls(objectArray2);
        objectArray2 = VRIMemberUtils.unification((VRIMemberDescription[])objectArray2, this.membersMgr.getDeniedMembers(true));
        SuspectMsg suspectMsg = new SuspectMsg((VRIMemberDescription[])objectArray2, MBRDenialReason.convert(this.membersMgr.getDenialReasons((VRIMemberDescription[])objectArray2, (byte)10)), this.myName, this.membersMgr);
        if (dCSSuspectEventArray != null && dCSSuspectEventArray[0].getRecommendedAction() != 8) {
            for (int i = 0; i < dCSSuspectEventArray.length; ++i) {
                this.doit(new MBRDo(dCSSuspectEventArray[i]));
            }
        }
        this.doit(new MBRDo(this, suspectMsg));
        if (DCSTraceBuffer.isExitEnabled(this.TC)) {
            DCSTraceBuffer.exit(this, "suspectMembers()", null).invoke();
        }
    }

    public void currentOK(CCVersion cCVersion) {
        MBRDo mBRDo = null;
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "currentOK()", null).addProperty("Context", cCVersion).invoke();
        }
        MBRLogger.dcsLogMBREvent(this, this.state.toString(), "currentOK()", cCVersion.toString());
        if (this.state.isState(MBRStateConstants.MEMBER, MBRStateConstants.SYNCING)) {
            CurrentOKMsg currentOKMsg = new CurrentOKMsg(this.membersMgr.getViewMinusDenied(), this.membersMgr.getDeniedMembers(true), cCVersion, this.state.getViewLeader(), this.myName, this.membersMgr);
            if (this.state.getReceivedCCV().compareTo(cCVersion) == 0) {
                this.state.updateMajorState(MBRStateConstants.MEMBER, MBRStateConstants.SYNCED);
            } else if (this.state.getReceivedCCV().compareTo(cCVersion) < 0) {
                DCSException dCSException = new DCSException("currentOk from the future ExpectedCCV= " + this.state.getReceivedCCV() + " returned CCV= " + cCVersion);
                TerminationEvent terminationEvent = new TerminationEvent((DCSTraceContext)this, "currentOK()", dCSException);
                terminationEvent.invokeNLSTrace();
                this.requestTermination(terminationEvent);
                return;
            }
            this.state.getAlarm().setMBTimer(this.state.isProtocol(MBRStateConstants.SPLIT));
            if (this.determineIfViewLeader()) {
                this.state.getAlarm().setVLCCTimer();
            }
            mBRDo = MBRDo.setAction(mBRDo, new MBRDo(this, currentOKMsg));
        } else {
            mBRDo = MBRDo.setAction(mBRDo, new MBRDo((DCSTraceContext)this, "unexpectedState during currentOK" + cCVersion + " state= " + this.state.toString(), "currentOK()", 0));
        }
        this.doit(mBRDo);
        if (DCSTraceBuffer.isExitEnabled(this.TC)) {
            DCSTraceBuffer.exit(this, "currentOK()", null).invoke();
        }
    }

    public void newViewOK(VRIMemberDescription[] vRIMemberDescriptionArray, ViewIdImpl viewIdImpl, Map map) {
        int n;
        int n2;
        MBRDo mBRDo = null;
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "newViewOK()", null).addProperty("viewMembers", vRIMemberDescriptionArray).invoke();
        }
        MBRLogger.dcsLogMBREvent(this, this.state.toString(), "newViewOK()", VRIMemberUtils.toString(vRIMemberDescriptionArray));
        if (this.state.isState(MBRStateConstants.MEMBER, MBRStateConstants.INSTALLING)) {
            if (this.g.statsModule != null) {
                n2 = this.state.computeViewChangeTime();
                n = this.getViewChangeType();
                if (n != -1) {
                    this.g.statsModule.onViewChange(n, n2, vRIMemberDescriptionArray.length);
                }
            }
        } else {
            mBRDo = MBRDo.setAction(mBRDo, new MBRDo((DCSTraceContext)this, "newViewOK()", "FYI: got newViewOK not in proper state", 0));
            this.doit(mBRDo);
            if (DCSTraceBuffer.isExitEnabled(this.TC)) {
                DCSTraceBuffer.exit(this, "newViewOK()", null).invoke();
            }
            return;
        }
        this.state.changeRole(MBRStateConstants.MEMBER, MBRStateConstants.MESSAGING);
        mBRDo = MBRDo.setAction(mBRDo, new MBRDo("Back to Messaging Protocol "));
        n2 = this.membersMgr.getViewMembersSize();
        n = this.membersMgr.getConnectedMembersSize();
        Object object = VRIMemberUtils.minus(this.membersMgr.getConnectedMembers(true), this.membersMgr.getDeniedMembers(true));
        int n3 = ((VRIMemberDescription[])object).length;
        int n4 = this.membersMgr.getDefinedMembersSize();
        String string = "(AV=" + String.valueOf(n2) + ", CD=" + String.valueOf(n3) + ", CN=" + String.valueOf(n) + ", DF=" + String.valueOf(n4) + ")";
        new MBRNewView(this, viewIdImpl, vRIMemberDescriptionArray.length, string).invokeNLSTrace();
        this.doit(mBRDo);
        CompleteCurrentMsg completeCurrentMsg = null;
        while ((completeCurrentMsg = this.state.dequeueMessage()) != null) {
            MBRLogger.dcsLogMBREvent(this, this.state.toString(), "QueuedCCMsg-FromNVOK()", completeCurrentMsg.toString());
            mBRDo = MBRMessageProcessor.reprocessMsgOrEvent(this.getRole(), completeCurrentMsg, this.state.toString(), this.stackName);
            this.doit(mBRDo);
        }
        if (map != null) {
            n = this.protocolVersion;
            this.protocolVersion = (Integer)map.get("DCSProtocolVersion");
            object = (StateVersion)map.get("DCS_PROTOCOL_VERSION_CONTEXT");
            this.g.setProtocolVersion(this.protocolVersion, (StateVersion)object);
            new GeneralLogEvent((DCSTraceContext)this, "Changed DCS Protocol Version new= " + this.protocolVersion + " context= " + object + " old= " + n).invokeNLSTrace();
        }
        if (DCSTraceBuffer.isExitEnabled(this.TC)) {
            DCSTraceBuffer.exit(this, "newViewOK()", null).invoke();
        }
    }

    private int getViewChangeType() {
        int n = -1;
        if (this.state.isProtocol(MBRStateConstants.MERGE)) {
            n = 2;
        }
        if (this.state.isProtocol(MBRStateConstants.SPLIT)) {
            n = 1;
        }
        return n;
    }

    private Role getRole() {
        return this.rolebank.getRole(this.state.getRoleName(), this.state.getProtocol());
    }

    public void deliver(VRIMessage vRIMessage) {
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "deliver()", null).addProperty("Message", vRIMessage).invoke();
        }
        Role role2 = this.getRole();
        MBRDo mBRDo = null;
        mBRDo = MBRMessageProcessor.processMessage(role2, vRIMessage, this.state.toString(), this.stackName, this.membersMgr);
        this.doit(mBRDo);
        if (DCSTraceBuffer.isExitEnabled(this.TC)) {
            DCSTraceBuffer.exit(this, "deliver()", null).invoke();
        }
    }

    public void requestTermination(DCSTerminationEvent dCSTerminationEvent) {
        MBRDo mBRDo;
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "requestTermination()", null).addProperty("Reason", dCSTerminationEvent).invoke();
        }
        if (dCSTerminationEvent != null) {
            MBRLogger.dcsLogMBREvent(this, this.state.toString(), "requestTermination", dCSTerminationEvent.getClass().getName() + "- " + dCSTerminationEvent.getTerminationReason());
        } else if (this.state != null) {
            MBRLogger.dcsLogMBREvent(this, this.state.toString(), "requestTermination", "null");
        }
        if (this.state.isProtocol(MBRStateConstants.TERMINATION)) {
            mBRDo = new MBRDo("Already terminated");
        } else {
            if (dCSTerminationEvent != null && !dCSTerminationEvent.isAdministrative()) {
                Throwable throwable = dCSTerminationEvent.getTerminationReason();
                if (throwable == null) {
                    String string = dCSTerminationEvent.getClass().getName();
                    this.doit(new MBRDo(new RequestDumpEvent(this.stackName, this.myName, "Termination Request by " + string, 0)));
                } else {
                    this.doit(new MBRDo(new RequestDumpEvent(this.stackName, this.myName, throwable, 0)));
                }
            }
            this.state.changeRole(MBRStateConstants.MEMBER, MBRStateConstants.TERMINATION);
            mBRDo = new MBRDo(false, dCSTerminationEvent);
        }
        MBRLogger.dcsLogMBRActionEvent(this, this.state.toString(), "terminate()");
        this.down.passActionDown(mBRDo);
    }

    public void proposeAgreement(VRIMessage vRIMessage) throws DCSAssertException {
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "proposeAgreement()", null).invoke();
        }
        MBRLogger.dcsAssert(false, "Not Yet Implemented", this.getClass().getName(), "proposeAgreement", this.stackName);
    }

    public void deliverAgreed(VRIMessage vRIMessage) throws DCSAssertException {
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "deliverAgreed()", null).invoke();
        }
        MBRLogger.dcsAssert(false, "Not Yet Implemented", this.getClass().getName(), "deliverAgree", this.stackName);
    }

    protected void doit(MBRDo mBRDo) {
        Object object;
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "doit()", null).invoke();
        }
        if (this.state.isProtocol(MBRStateConstants.TERMINATION) && !mBRDo.isTerminateAction()) {
            return;
        }
        if (mBRDo != null && mBRDo.isMultipleAction()) {
            MBRLogger.dcsLogMBRActionEvent(this, this.state.toString(), mBRDo.toString());
            for (int i = 0; i < 2; ++i) {
                this.doit(mBRDo.getNextAction(i));
            }
            return;
        }
        if (mBRDo != null && mBRDo.isReprocessAction()) {
            object = mBRDo.reprocessRole(this.state);
            MBRLogger.dcsLogMBRActionEvent(this, this.state.toString(), mBRDo.toString());
            mBRDo = MBRMessageProcessor.reprocessMsgOrEvent(this.getRole(), mBRDo.getReprocessObject(), this.state.toString(), this.stackName);
            if (MBRDo.isaDoNothingAction(mBRDo)) {
                ((MBRState.ExtendedRole)object).changeRole(this.state);
            }
            if (mBRDo != null && mBRDo.isReprocessAction()) {
                mBRDo = new MBRDo("WARNING Recursive  Reprocessed Message  " + mBRDo.getReprocessObject() + " processed by " + this.getRole().toString());
            }
        }
        if (mBRDo != null && mBRDo.isNewUpEvent()) {
            object = mBRDo.getUpEvent();
            MBRLogger.dcsLogMBRActionEvent(this, this.state.toString(), "MBRDo = onVRIUpEvent event=" + String.valueOf(object));
            this.onVRIUpEvent(mBRDo.getUpEvent());
            mBRDo = null;
            return;
        }
        if (mBRDo == null) {
            MBRLogger.dcsLogMBRActionEvent(this, this.state.toString(), "MBRDo = null");
        } else {
            MBRLogger.dcsLogMBRActionEvent(this, this.state.toString(), mBRDo.toString());
            this.down.passActionDown(mBRDo);
        }
    }

    public void handleAlarm(Object object) {
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "handleAlarm()", null).addProperty("AlarmContext", object).invoke();
        }
        if (this.state.isProtocol(MBRStateConstants.TERMINATION)) {
            return;
        }
        try {
            boolean bl = false;
            MBRDo mBRDo = null;
            int n = this.state.getAlarm().getWaitTimes(object);
            if (object == MBRAlarm.VLWAIT4ML_ALARM_CONTEXT) {
                MBRLogger.dcsLogMBREvent(this, this.state.toString(), "handleVLWaitForMLNVAlarm()", null, DCSTraceBuffer.propertyList().addProperty("Timeout", n), null);
                bl = true;
                mBRDo = MBRDo.setAction(mBRDo, this.getRole().handleVLWaitForMLNVAlarm(n));
            }
            if (object == MBRAlarm.MBWAIT4VL_ALARM_CONTEXT) {
                bl = true;
                MBRLogger.dcsLogMBREvent(this, this.state.toString(), "handleMBWaitForVLNVAlarm", null, DCSTraceBuffer.propertyList().addProperty("Timeout", n), null);
                mBRDo = MBRDo.setAction(mBRDo, this.getRole().handleMBWaitForVLNVAlarm(n));
            }
            if (object == MBRAlarm.VLWAIT4MB_ALARM_CONTEXT) {
                MBRLogger.dcsLogMBREvent(this, this.state.toString(), "handleVLWaitForMBCCAlarm()", null, DCSTraceBuffer.propertyList().addProperty("Timeout", n), null);
                bl = true;
                mBRDo = MBRDo.setAction(mBRDo, this.getRole().handleVLWaitForMBCCAlarm(n));
            }
            if (object == MBRAlarm.MLWAIT4VL_ALARM_CONTEXT) {
                MBRLogger.dcsLogMBREvent(this, this.state.toString(), "handleMLWaitForVLCCAlarm()", null, DCSTraceBuffer.propertyList().addProperty("Timeout", n), null);
                bl = true;
                mBRDo = MBRDo.setAction(mBRDo, this.getRole().handleMLWaitForVLCCAlarm(n));
            }
            if (object == MBRAlarm.MBWAIT4OTHERS_ALARM_CONTEXT) {
                bl = true;
                MBRLogger.dcsLogMBREvent(this, this.state.toString(), "handleMBWaitForOthers", null, DCSTraceBuffer.propertyList().addProperty("Timeout", n), null);
                mBRDo = MBRDo.setAction(mBRDo, this.handleMBWaitForOthersAlarm(n));
            }
            if (!bl) {
                DCSException dCSException = new DCSException("Unknown alarmContext " + object);
                MBRLogger.dcsWarning((DCSTraceContext)this, "GroupMembershipLayer.handleAlarm()", dCSException);
                return;
            }
            if (this.g.statsModule != null) {
                this.g.statsModule.onMbrTimeout();
            }
            this.doit(mBRDo);
            if (DCSTraceBuffer.isExitEnabled(this.TC)) {
                DCSTraceBuffer.exit(this, "handleAlarm()", null).invoke();
            }
        }
        catch (Throwable throwable) {
            this.requestTermination(new TerminationEvent((DCSTraceContext)this, "handleAlarm()", throwable));
        }
    }

    protected MBRDo handleMBWaitForOthersAlarm(long l) {
        MBRLogger.dcsWarning((DCSTraceContext)this, "handleMBWaitForOthersAlarm()", "Alarm is sounded MBWait4OTHERS not in CoreGroup Stack");
        return new MBRDo("ERROR- should not occur handleMBWaitForOthersAlarm in non CoreGroupStack");
    }

    public String getAlarmContextDescription(Object object) {
        if (object == MBRAlarm.VLWAIT4ML_ALARM_CONTEXT) {
            return "VLWaitForMLNV ";
        }
        if (object == MBRAlarm.MBWAIT4VL_ALARM_CONTEXT) {
            return "MBWaitForMLNV ";
        }
        if (object == MBRAlarm.VLWAIT4MB_ALARM_CONTEXT) {
            return "VLWaitForMBCC ";
        }
        if (object == MBRAlarm.MLWAIT4VL_ALARM_CONTEXT) {
            return "MLWaitForVLNV ";
        }
        if (object == MBRAlarm.MBWAIT4OTHERS_ALARM_CONTEXT) {
            return "MBWaitForOthers ";
        }
        if (object == null) {
            return "null ";
        }
        return "Unknown " + String.valueOf(object);
    }

    public ViewIdImpl requestStart() {
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "requestStart()", null).invoke();
        }
        MBRLogger.dcsAssert(this.thisMember != null, "thisMember is null", "CoreStackImpl", "start()", this.stackName);
        MBRLogger.dcsAssert(this.myName != null, "myName is null", "CoreStackImpl", "start()", this.stackName);
        ViewIdImpl viewIdImpl = ViewIdImpl.createFirstViewID(this.myName);
        if (this.g.isCoreStack()) {
            viewIdImpl.internalView(true);
        }
        this.state.newView(new VRIMemberDescription[]{this.thisMember}, viewIdImpl, this.thisMember);
        this.state.changeRole(MBRStateConstants.MEMBER, MBRStateConstants.INITIALIZING);
        this.membersMgr.start(viewIdImpl);
        this.state.changeRole(MBRStateConstants.MEMBER, MBRStateConstants.MESSAGING);
        this.doit(new MBRDo(viewIdImpl));
        return viewIdImpl;
    }

    void requestChangeDefined(MemberInfo[] memberInfoArray, String[] stringArray, int n) {
        if (DCSTraceBuffer.isEntryEnabled(this.TC)) {
            DCSTraceBuffer.entry(this, "requestChangeDefined()", null).invoke();
        }
        if (memberInfoArray == null) {
            memberInfoArray = new MemberInfo[]{};
        }
        if (stringArray == null) {
            stringArray = new String[]{};
        }
        ChangeDefinedMsg changeDefinedMsg = new ChangeDefinedMsg(memberInfoArray, stringArray, n, this.myName, this.membersMgr, this.g.isCoreStack());
        this.doit(new MBRDo(this, changeDefinedMsg));
    }

    public void onCongestionControlEvent(CongestionControlEvent congestionControlEvent) {
    }

    public void onVRIUpEvent(VRIUpEvent vRIUpEvent) {
        vRIUpEvent.handle("MBR", this.eventHandlers, null);
    }

    public void dumpAll(FFDCDumper fFDCDumper) {
        fFDCDumper.writeLine("Timeouts ", this.state.getAlarm().getInfo());
        this.state.dump(fFDCDumper);
        MBRDo mBRDo = new MBRDo(fFDCDumper);
        this.doit(mBRDo);
    }

    private final class RequestTrivalViewChangeEventHandler
    implements VRIEventHandler {
        private RequestTrivalViewChangeEventHandler() {
        }

        public int handle(VRIEvent vRIEvent) {
            MBRRequestTrivalViewChangeEvent mBRRequestTrivalViewChangeEvent = (MBRRequestTrivalViewChangeEvent)vRIEvent;
            MBRLogger.dcsLogMBREvent(GroupMembershipLayer.this, GroupMembershipLayer.this.state.toString(), "handle()", "trivial Request View");
            GroupMembershipLayer.this.doit(GroupMembershipLayer.this.getRole().proceesTrivialViewChangeEvent(mBRRequestTrivalViewChangeEvent));
            return 3;
        }

        public String getTraceName() {
            return "RequestTrivialViewChangeEventHandler";
        }
    }

    private final class RequestDumpEventHandler
    implements VRIEventHandler {
        private RequestDumpEventHandler() {
        }

        public int handle(VRIEvent vRIEvent) {
            String string;
            Throwable throwable;
            RequestDumpEvent requestDumpEvent = (RequestDumpEvent)vRIEvent;
            if (requestDumpEvent.hasException()) {
                throwable = requestDumpEvent.getException();
                string = throwable.getMessage();
            } else {
                throwable = null;
                string = requestDumpEvent.getReason();
            }
            String string2 = new Date().toString();
            boolean bl = requestDumpEvent.shouldDistribute();
            MBRLogger.dcsLogMBREvent(GroupMembershipLayer.this, GroupMembershipLayer.this.state.toString(), "requestDumpEvent()", " shouldDump= " + GroupMembershipLayer.this.state.shouldIDump() + " Reason= " + string + " timestamp= " + string2 + " distributed= " + bl);
            string = string + " Timestamp= " + string2 + "Distrubted= " + String.valueOf(bl);
            if (!GroupMembershipLayer.this.state.shouldIDump()) {
                return 3;
            }
            if (requestDumpEvent.hasException()) {
                Globals.causeDump((FFDCDumpable)GroupMembershipLayer.this, throwable);
            } else {
                Globals.causeDump((FFDCDumpable)GroupMembershipLayer.this, string);
            }
            if (bl) {
                GroupMembershipLayer.this.doit(new MBRDo(GroupMembershipLayer.this, new DumpAllMsg(GroupMembershipLayer.this.thisMember.getName(), GroupMembershipLayer.this.membersMgr, string, requestDumpEvent.getScope())));
            }
            return 3;
        }

        public String getTraceName() {
            return "RequestDumpEventHandler";
        }
    }

    private final class RequestChangeProtocolEventHandler
    implements VRIEventHandler {
        private RequestChangeProtocolEventHandler() {
        }

        public int handle(VRIEvent vRIEvent) {
            RequestChangeProtocolEvent requestChangeProtocolEvent = (RequestChangeProtocolEvent)vRIEvent;
            MBRLogger.dcsLogMBREvent(GroupMembershipLayer.this, GroupMembershipLayer.this.state.toString(), "requestChangeProtocolEventHandler()", " protocol= " + requestChangeProtocolEvent.getProtocol() + " version= " + requestChangeProtocolEvent.getVersion());
            String string = GroupMembershipLayer.this.state.checkProtocolVersion(requestChangeProtocolEvent.getProtocol(), requestChangeProtocolEvent.getVersion());
            GroupMembershipLayer.this.doit(new MBRDo(string));
            if (GroupMembershipLayer.this.state.changedPV() && GroupMembershipLayer.this.state.determineIfMergeLeader(GroupMembershipLayer.this.membersMgr.getViewMinusDenied())) {
                GroupMembershipLayer.this.doit(new MBRDo(new MBRRequestTrivalViewChangeEvent(GroupMembershipLayer.this.stackName, GroupMembershipLayer.this.myName)));
            }
            return 3;
        }

        public String getTraceName() {
            return "RequestChangeProtocolEventHandler";
        }
    }

    private final class RequestChangeDefinedEventHandler
    implements VRIEventHandler {
        private RequestChangeDefinedEventHandler() {
        }

        public int handle(VRIEvent vRIEvent) {
            RequestChangeDefinedEvent requestChangeDefinedEvent = (RequestChangeDefinedEvent)vRIEvent;
            MBRLogger.dcsLogMBREvent(GroupMembershipLayer.this, GroupMembershipLayer.this.state.toString(), "requestChangeDefined()", "add= " + Utils.toString(MemberInfo.getNames(requestChangeDefinedEvent.getMembersToAdd())) + "remove= " + Utils.toString(requestChangeDefinedEvent.getMembersToRemove()) + "context= " + requestChangeDefinedEvent.getContext());
            GroupMembershipLayer.this.requestChangeDefined(requestChangeDefinedEvent.getMembersToAdd(), requestChangeDefinedEvent.getMembersToRemove(), requestChangeDefinedEvent.getContext());
            return 3;
        }

        public String getTraceName() {
            return "RequestChangeDefinedEventHandler";
        }
    }

    public class RequestStateChangeEventHandler
    implements VRIEventHandler {
        public int handle(VRIEvent vRIEvent) {
            RequestStateChangeEvent requestStateChangeEvent = (RequestStateChangeEvent)vRIEvent;
            boolean bl = GroupMembershipLayer.this.state.getStateExchanger().handleRequestStateChangeEvent(requestStateChangeEvent);
            if (bl) {
                if (GroupMembershipLayer.this.determineIfViewLeader()) {
                    MBRLogger.dcsLogMBRActionEvent(GroupMembershipLayer.this, GroupMembershipLayer.this.state.toString(), "onVRIUpEvent(trivialViewRequest)");
                    GroupMembershipLayer.this.onVRIUpEvent(new MBRRequestTrivalViewChangeEvent(GroupMembershipLayer.this.stackName, GroupMembershipLayer.this.myName));
                } else {
                    MBRLogger.dcsLogMBRActionEvent(GroupMembershipLayer.this, GroupMembershipLayer.this.state.toString(), "DoNothing  - not view leader");
                }
            } else {
                MBRLogger.dcsLogMBRActionEvent(GroupMembershipLayer.this, GroupMembershipLayer.this.state.toString(), "DoNothing  - State or State Version problems see Log");
            }
            return 3;
        }

        public String getTraceName() {
            return "requestStateChangeEvent";
        }
    }
}

